/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.List;

public class BluetoothPowerCalculator
extends PowerCalculator {
    private static final String TAG = "BluetoothPowerCalc";
    private static final boolean DEBUG = false;
    private final double mIdleMa;
    private final double mRxMa;
    private final double mTxMa;
    private final boolean mHasBluetoothPowerController;

    public BluetoothPowerCalculator(PowerProfile profile) {
        this.mIdleMa = profile.getAveragePower("bluetooth.controller.idle");
        this.mRxMa = profile.getAveragePower("bluetooth.controller.rx");
        this.mTxMa = profile.getAveragePower("bluetooth.controller.tx");
        this.mHasBluetoothPowerController = this.mIdleMa != 0.0 && this.mRxMa != 0.0 && this.mTxMa != 0.0;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        if (!batteryStats.hasBluetoothActivityReporting()) {
            return;
        }
        PowerAndDuration total = new PowerAndDuration();
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            this.calculateApp(app, total, query);
        }
        long measuredChargeUC = batteryStats.getBluetoothMeasuredBatteryConsumptionUC();
        int powerModel = BluetoothPowerCalculator.getPowerModel(measuredChargeUC, query);
        BatteryStats.ControllerActivityCounter activityCounter = batteryStats.getBluetoothControllerActivity();
        long systemDurationMs = this.calculateDuration(activityCounter);
        double systemPowerMah = this.calculatePowerMah(powerModel, measuredChargeUC, activityCounter, query.shouldForceUsePowerProfileModel());
        long systemComponentDurationMs = Math.max(0L, systemDurationMs - total.durationMs);
        ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(2, systemDurationMs)).setConsumedPower(2, Math.max(systemPowerMah, total.powerMah), powerModel);
        ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(1).setUsageDurationMillis(2, total.durationMs)).setConsumedPower(2, total.powerMah, powerModel);
    }

    private void calculateApp(UidBatteryConsumer.Builder app, PowerAndDuration total, BatteryUsageStatsQuery query) {
        long measuredChargeUC = app.getBatteryStatsUid().getBluetoothMeasuredBatteryConsumptionUC();
        int powerModel = BluetoothPowerCalculator.getPowerModel(measuredChargeUC, query);
        BatteryStats.ControllerActivityCounter activityCounter = app.getBatteryStatsUid().getBluetoothControllerActivity();
        long durationMs = this.calculateDuration(activityCounter);
        double powerMah = this.calculatePowerMah(powerModel, measuredChargeUC, activityCounter, query.shouldForceUsePowerProfileModel());
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(2, durationMs)).setConsumedPower(2, powerMah, powerModel);
        total.durationMs += durationMs;
        total.powerMah += powerMah;
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        if (!this.mHasBluetoothPowerController || !batteryStats.hasBluetoothActivityReporting()) {
            return;
        }
        PowerAndDuration total = new PowerAndDuration();
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper app = sippers.get(i);
            if (app.drainType != BatterySipper.DrainType.APP) continue;
            this.calculateApp(app, app.uidObj, statsType, total);
        }
        BatterySipper bs = new BatterySipper(BatterySipper.DrainType.BLUETOOTH, null, 0.0);
        long measuredChargeUC = batteryStats.getBluetoothMeasuredBatteryConsumptionUC();
        int powerModel = BluetoothPowerCalculator.getPowerModel(measuredChargeUC);
        BatteryStats.ControllerActivityCounter activityCounter = batteryStats.getBluetoothControllerActivity();
        long systemDurationMs = this.calculateDuration(activityCounter);
        double systemPowerMah = this.calculatePowerMah(powerModel, measuredChargeUC, activityCounter, false);
        double powerMah = Math.max(0.0, systemPowerMah - total.powerMah);
        long durationMs = Math.max(0L, systemDurationMs - total.durationMs);
        bs.bluetoothPowerMah = powerMah;
        bs.bluetoothRunningTimeMs = durationMs;
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper app = sippers.get(i);
            if (app.getUid() != 1002) continue;
            app.isAggregated = true;
            bs.add(app);
        }
        if (bs.sumPower() > 0.0) {
            sippers.add(bs);
        }
    }

    private void calculateApp(BatterySipper app, BatteryStats.Uid u, int statsType, PowerAndDuration total) {
        long measuredChargeUC = u.getBluetoothMeasuredBatteryConsumptionUC();
        int powerModel = BluetoothPowerCalculator.getPowerModel(measuredChargeUC);
        BatteryStats.ControllerActivityCounter activityCounter = u.getBluetoothControllerActivity();
        long durationMs = this.calculateDuration(activityCounter);
        double powerMah = this.calculatePowerMah(powerModel, measuredChargeUC, activityCounter, false);
        app.bluetoothRunningTimeMs = durationMs;
        app.bluetoothPowerMah = powerMah;
        app.btRxBytes = u.getNetworkActivityBytes(4, statsType);
        app.btTxBytes = u.getNetworkActivityBytes(5, statsType);
        total.durationMs += durationMs;
        total.powerMah += powerMah;
    }

    private long calculateDuration(BatteryStats.ControllerActivityCounter counter) {
        if (counter == null) {
            return 0L;
        }
        return counter.getIdleTimeCounter().getCountLocked(0) + counter.getRxTimeCounter().getCountLocked(0) + counter.getTxTimeCounters()[0].getCountLocked(0);
    }

    private double calculatePowerMah(int powerModel, long measuredChargeUC, BatteryStats.ControllerActivityCounter counter, boolean ignoreReportedPower) {
        double powerMah;
        if (powerModel == 2) {
            return BluetoothPowerCalculator.uCtoMah(measuredChargeUC);
        }
        if (counter == null) {
            return 0.0;
        }
        if (!ignoreReportedPower && (powerMah = (double)counter.getPowerCounter().getCountLocked(0) / 3600000.0) != 0.0) {
            return powerMah;
        }
        if (!this.mHasBluetoothPowerController) {
            return 0.0;
        }
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(0);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(0);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(0);
        return this.calculatePowerMah(rxTimeMs, txTimeMs, idleTimeMs);
    }

    public double calculatePowerMah(long rxTimeMs, long txTimeMs, long idleTimeMs) {
        return ((double)idleTimeMs * this.mIdleMa + (double)rxTimeMs * this.mRxMa + (double)txTimeMs * this.mTxMa) / 3600000.0;
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double powerMah;

        private PowerAndDuration() {
        }
    }
}

