/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.telephony.CellSignalStrength;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.List;

public class MobileRadioPowerCalculator
extends PowerCalculator {
    private static final String TAG = "MobRadioPowerCalculator";
    private static final boolean DEBUG = false;
    private static final int NUM_SIGNAL_STRENGTH_LEVELS = CellSignalStrength.getNumSignalStrengthLevels();
    private final UsageBasedPowerEstimator mActivePowerEstimator;
    private final UsageBasedPowerEstimator[] mIdlePowerEstimators = new UsageBasedPowerEstimator[NUM_SIGNAL_STRENGTH_LEVELS];
    private final UsageBasedPowerEstimator mScanPowerEstimator;

    public MobileRadioPowerCalculator(PowerProfile profile) {
        int i;
        double powerRadioActiveMa = profile.getAveragePowerOrDefault("radio.active", -1.0);
        if (powerRadioActiveMa == -1.0) {
            double sum = 0.0;
            sum += profile.getAveragePower("modem.controller.rx");
            for (i = 0; i < NUM_SIGNAL_STRENGTH_LEVELS; ++i) {
                sum += profile.getAveragePower("modem.controller.tx", i);
            }
            powerRadioActiveMa = sum / (double)(NUM_SIGNAL_STRENGTH_LEVELS + 1);
        }
        this.mActivePowerEstimator = new UsageBasedPowerEstimator(powerRadioActiveMa);
        if (profile.getAveragePowerOrDefault("radio.on", -1.0) != -1.0) {
            for (int i2 = 0; i2 < NUM_SIGNAL_STRENGTH_LEVELS; ++i2) {
                this.mIdlePowerEstimators[i2] = new UsageBasedPowerEstimator(profile.getAveragePower("radio.on", i2));
            }
        } else {
            double idle = profile.getAveragePower("modem.controller.idle");
            this.mIdlePowerEstimators[0] = new UsageBasedPowerEstimator(idle * 25.0 / 180.0);
            for (i = 1; i < NUM_SIGNAL_STRENGTH_LEVELS; ++i) {
                this.mIdlePowerEstimators[i] = new UsageBasedPowerEstimator(Math.max(1.0, idle / 256.0));
            }
        }
        this.mScanPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePowerOrDefault("radio.scanning", 0.0));
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        PowerAndDuration total = new PowerAndDuration();
        double powerPerPacketMah = this.getMobilePowerPerPacket(batteryStats, rawRealtimeUs, 0);
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            BatteryStats.Uid uid = app.getBatteryStatsUid();
            this.calculateApp(app, uid, powerPerPacketMah, total, query);
        }
        long consumptionUC = batteryStats.getMobileRadioMeasuredBatteryConsumptionUC();
        int powerModel = MobileRadioPowerCalculator.getPowerModel(consumptionUC, query);
        this.calculateRemaining(total, powerModel, batteryStats, rawRealtimeUs, consumptionUC);
        if (total.remainingPowerMah != 0.0 || total.totalAppPowerMah != 0.0) {
            ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(8, total.durationMs)).setConsumedPower(8, total.remainingPowerMah + total.totalAppPowerMah, powerModel);
            ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(1).setUsageDurationMillis(8, total.durationMs)).setConsumedPower(8, total.totalAppPowerMah, powerModel);
        }
    }

    private void calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, double powerPerPacketMah, PowerAndDuration total, BatteryUsageStatsQuery query) {
        long radioActiveDurationMs = this.calculateDuration(u, 0);
        total.totalAppDurationMs += radioActiveDurationMs;
        long consumptionUC = u.getMobileRadioMeasuredBatteryConsumptionUC();
        int powerModel = MobileRadioPowerCalculator.getPowerModel(consumptionUC, query);
        double powerMah = this.calculatePower(u, powerModel, powerPerPacketMah, radioActiveDurationMs, consumptionUC);
        total.totalAppPowerMah += powerMah;
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(8, radioActiveDurationMs)).setConsumedPower(8, powerMah, powerModel);
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        double mobilePowerPerPacket = this.getMobilePowerPerPacket(batteryStats, rawRealtimeUs, statsType);
        PowerAndDuration total = new PowerAndDuration();
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper app = sippers.get(i);
            if (app.drainType != BatterySipper.DrainType.APP) continue;
            BatteryStats.Uid u = app.uidObj;
            this.calculateApp(app, u, statsType, mobilePowerPerPacket, total);
        }
        BatterySipper radio = new BatterySipper(BatterySipper.DrainType.CELL, null, 0.0);
        long consumptionUC = batteryStats.getMobileRadioMeasuredBatteryConsumptionUC();
        int powerModel = MobileRadioPowerCalculator.getPowerModel(consumptionUC);
        this.calculateRemaining(total, powerModel, batteryStats, rawRealtimeUs, consumptionUC);
        if (total.remainingPowerMah != 0.0) {
            if (total.signalDurationMs != 0L) {
                radio.noCoveragePercent = (double)total.noCoverageDurationMs * 100.0 / (double)total.signalDurationMs;
            }
            radio.mobileActive = total.durationMs;
            radio.mobileActiveCount = batteryStats.getMobileRadioActiveUnknownCount(statsType);
            radio.mobileRadioPowerMah = total.remainingPowerMah;
            radio.sumPower();
        }
        if (radio.totalPowerMah > 0.0) {
            sippers.add(radio);
        }
    }

    private void calculateApp(BatterySipper app, BatteryStats.Uid u, int statsType, double powerPerPacketMah, PowerAndDuration total) {
        app.mobileActive = this.calculateDuration(u, statsType);
        long consumptionUC = u.getMobileRadioMeasuredBatteryConsumptionUC();
        int powerModel = MobileRadioPowerCalculator.getPowerModel(consumptionUC);
        app.mobileRadioPowerMah = this.calculatePower(u, powerModel, powerPerPacketMah, app.mobileActive, consumptionUC);
        total.totalAppDurationMs += app.mobileActive;
        app.mobileRxPackets = u.getNetworkActivityPackets(0, statsType);
        app.mobileTxPackets = u.getNetworkActivityPackets(1, statsType);
        app.mobileActiveCount = u.getMobileRadioActiveCount(statsType);
        app.mobileRxBytes = u.getNetworkActivityBytes(0, statsType);
        app.mobileTxBytes = u.getNetworkActivityBytes(1, statsType);
    }

    private long calculateDuration(BatteryStats.Uid u, int statsType) {
        return u.getMobileRadioActiveTime(statsType) / 1000L;
    }

    private double calculatePower(BatteryStats.Uid u, int powerModel, double powerPerPacketMah, long radioActiveDurationMs, long measuredChargeUC) {
        if (powerModel == 2) {
            return MobileRadioPowerCalculator.uCtoMah(measuredChargeUC);
        }
        if (radioActiveDurationMs > 0L) {
            return this.calcPowerFromRadioActiveDurationMah(radioActiveDurationMs);
        }
        long mobileRxPackets = u.getNetworkActivityPackets(0, 0);
        long mobileTxPackets = u.getNetworkActivityPackets(1, 0);
        return (double)(mobileRxPackets + mobileTxPackets) * powerPerPacketMah;
    }

    private void calculateRemaining(PowerAndDuration total, int powerModel, BatteryStats batteryStats, long rawRealtimeUs, long consumptionUC) {
        long signalTimeMs = 0L;
        double powerMah = 0.0;
        if (powerModel == 2) {
            powerMah = MobileRadioPowerCalculator.uCtoMah(consumptionUC);
        }
        for (int i = 0; i < NUM_SIGNAL_STRENGTH_LEVELS; ++i) {
            long strengthTimeMs = batteryStats.getPhoneSignalStrengthTime(i, rawRealtimeUs, 0) / 1000L;
            if (powerModel == 1) {
                double p = this.calcIdlePowerAtSignalStrengthMah(strengthTimeMs, i);
                powerMah += p;
            }
            signalTimeMs += strengthTimeMs;
            if (i != 0) continue;
            total.noCoverageDurationMs = strengthTimeMs;
        }
        long scanningTimeMs = batteryStats.getPhoneSignalScanningTime(rawRealtimeUs, 0) / 1000L;
        long radioActiveTimeMs = batteryStats.getMobileRadioActiveTime(rawRealtimeUs, 0) / 1000L;
        long remainingActiveTimeMs = radioActiveTimeMs - total.totalAppDurationMs;
        if (powerModel == 1) {
            double p = this.calcScanTimePowerMah(scanningTimeMs);
            powerMah += p;
            if (remainingActiveTimeMs > 0L) {
                powerMah += this.calcPowerFromRadioActiveDurationMah(remainingActiveTimeMs);
            }
        }
        total.durationMs = radioActiveTimeMs;
        total.remainingPowerMah = powerMah;
        total.signalDurationMs = signalTimeMs;
    }

    public double calcPowerFromRadioActiveDurationMah(long radioActiveDurationMs) {
        return this.mActivePowerEstimator.calculatePower(radioActiveDurationMs);
    }

    public double calcIdlePowerAtSignalStrengthMah(long strengthTimeMs, int strengthLevel) {
        return this.mIdlePowerEstimators[strengthLevel].calculatePower(strengthTimeMs);
    }

    public double calcScanTimePowerMah(long scanningTimeMs) {
        return this.mScanPowerEstimator.calculatePower(scanningTimeMs);
    }

    private double getMobilePowerPerPacket(BatteryStats stats, long rawRealtimeUs, int statsType) {
        long mobileTx;
        long radioDataUptimeMs = stats.getMobileRadioActiveTime(rawRealtimeUs, statsType) / 1000L;
        double mobilePower = this.calcPowerFromRadioActiveDurationMah(radioDataUptimeMs);
        long mobileRx = stats.getNetworkActivityPackets(0, statsType);
        long mobilePackets = mobileRx + (mobileTx = stats.getNetworkActivityPackets(1, statsType));
        return mobilePackets != 0L ? mobilePower / (double)mobilePackets : 0.0;
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double remainingPowerMah;
        public long totalAppDurationMs;
        public double totalAppPowerMah;
        public long signalDurationMs;
        public long noCoverageDurationMs;

        private PowerAndDuration() {
        }
    }
}

