/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.SystemClock;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import java.io.PrintWriter;

public class ProviderAccessStats {
    private final Object mLock = new Object();
    private final long mStartUptime = SystemClock.uptimeMillis();
    private final SparseBooleanArray mAllCallingUids = new SparseBooleanArray();
    private final SparseLongArray mQueryStats = new SparseLongArray(16);
    private final SparseLongArray mBatchStats = new SparseLongArray(0);
    private final SparseLongArray mInsertStats = new SparseLongArray(0);
    private final SparseLongArray mUpdateStats = new SparseLongArray(0);
    private final SparseLongArray mDeleteStats = new SparseLongArray(0);
    private final SparseLongArray mInsertInBatchStats = new SparseLongArray(0);
    private final SparseLongArray mUpdateInBatchStats = new SparseLongArray(0);
    private final SparseLongArray mDeleteInBatchStats = new SparseLongArray(0);
    private final SparseLongArray mOperationDurationMillis = new SparseLongArray(16);
    private final ThreadLocal<PerThreadData> mThreadLocal = ThreadLocal.withInitial(() -> new PerThreadData());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementStats(int callingUid, SparseLongArray stats) {
        Object object = this.mLock;
        synchronized (object) {
            stats.put(callingUid, stats.get(callingUid) + 1L);
            this.mAllCallingUids.put(callingUid, true);
        }
        PerThreadData data = this.mThreadLocal.get();
        ++data.nestCount;
        if (data.nestCount == 1) {
            data.startUptimeMillis = SystemClock.uptimeMillis();
        }
    }

    private void incrementStats(int callingUid, boolean inBatch, SparseLongArray statsNonBatch, SparseLongArray statsInBatch) {
        this.incrementStats(callingUid, inBatch ? statsInBatch : statsNonBatch);
    }

    public void incrementInsertStats(int callingUid, boolean inBatch) {
        this.incrementStats(callingUid, inBatch, this.mInsertStats, this.mInsertInBatchStats);
    }

    public void incrementUpdateStats(int callingUid, boolean inBatch) {
        this.incrementStats(callingUid, inBatch, this.mUpdateStats, this.mUpdateInBatchStats);
    }

    public void incrementDeleteStats(int callingUid, boolean inBatch) {
        this.incrementStats(callingUid, inBatch, this.mDeleteStats, this.mDeleteInBatchStats);
    }

    public void incrementQueryStats(int callingUid) {
        this.incrementStats(callingUid, this.mQueryStats);
    }

    public void incrementBatchStats(int callingUid) {
        this.incrementStats(callingUid, this.mBatchStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishOperation(int callingUid) {
        PerThreadData data = this.mThreadLocal.get();
        --data.nestCount;
        if (data.nestCount == 0) {
            long duration = Math.max(1L, SystemClock.uptimeMillis() - data.startUptimeMillis);
            Object object = this.mLock;
            synchronized (object) {
                this.mOperationDurationMillis.put(callingUid, this.mOperationDurationMillis.get(callingUid) + duration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print("  Process uptime: ");
            pw.print((SystemClock.uptimeMillis() - this.mStartUptime) / 60000L);
            pw.println(" minutes");
            pw.println();
            pw.print(prefix);
            pw.println("Client activities:");
            pw.print(prefix);
            pw.println("  UID        Query  Insert Update Delete   Batch Insert Update Delete          Sec");
            for (int i = 0; i < this.mAllCallingUids.size(); ++i) {
                int uid = this.mAllCallingUids.keyAt(i);
                pw.print(prefix);
                pw.println(String.format("  %-9d %6d  %6d %6d %6d  %6d %6d %6d %6d %12.3f", uid, this.mQueryStats.get(uid), this.mInsertStats.get(uid), this.mUpdateStats.get(uid), this.mDeleteStats.get(uid), this.mBatchStats.get(uid), this.mInsertInBatchStats.get(uid), this.mUpdateInBatchStats.get(uid), this.mDeleteInBatchStats.get(uid), (double)this.mOperationDurationMillis.get(uid) / 1000.0));
            }
            pw.println();
        }
    }

    private static class PerThreadData {
        public int nestCount;
        public long startUptimeMillis;

        private PerThreadData() {
        }
    }
}

