/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.HardwareRenderer;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.os.CancellationSignal;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ScrollCaptureCallback;
import android.view.ScrollCaptureSession;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.lang.System_Delegate;
import com.android.internal.view.ScrollCaptureViewHelper;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public class ScrollCaptureViewSupport<V extends View>
implements ScrollCaptureCallback {
    private static final String TAG = "ScrollCaptureViewSupport";
    private static final String SETTING_CAPTURE_DELAY = "screenshot.scroll_capture_delay";
    private static final long SETTING_CAPTURE_DELAY_DEFAULT = 60L;
    private final WeakReference<V> mWeakView;
    private final ScrollCaptureViewHelper<V> mViewHelper;
    private final ViewRenderer mRenderer;
    private final long mPostScrollDelayMillis;
    private boolean mStarted;
    private boolean mEnded;

    ScrollCaptureViewSupport(V containingView, ScrollCaptureViewHelper<V> viewHelper) {
        this.mWeakView = new WeakReference<V>(containingView);
        this.mRenderer = new ViewRenderer();
        this.mViewHelper = viewHelper;
        Context context = ((View)containingView).getContext();
        ContentResolver contentResolver = context.getContentResolver();
        this.mPostScrollDelayMillis = Settings.Global.getLong(contentResolver, SETTING_CAPTURE_DELAY, 60L);
    }

    private static int getColorMode(View containingView) {
        Context context = containingView.getContext();
        int colorMode = containingView.getViewRootImpl().mWindowAttributes.getColorMode();
        if (!context.getResources().getConfiguration().isScreenWideColorGamut()) {
            colorMode = 0;
        }
        return colorMode;
    }

    public static Rect transformFromRequestToContainer(int scrollY, Rect requestBounds, Rect requestRect) {
        Rect requestedContainerBounds = new Rect(requestRect);
        requestedContainerBounds.offset(0, -scrollY);
        requestedContainerBounds.offset(requestBounds.left, requestBounds.top);
        return requestedContainerBounds;
    }

    public static Rect transformFromContainerToRequest(int scrollY, Rect requestBounds, Rect containerRect) {
        Rect requestRect = new Rect(containerRect);
        requestRect.offset(-requestBounds.left, -requestBounds.top);
        requestRect.offset(0, scrollY);
        return requestRect;
    }

    public static int computeScrollAmount(Rect parentVisibleBounds, Rect requested) {
        int height = parentVisibleBounds.height();
        int top = parentVisibleBounds.top;
        int bottom = parentVisibleBounds.bottom;
        int scrollYDelta = 0;
        if (requested.bottom > bottom && requested.top > top) {
            scrollYDelta = requested.height() > height ? (scrollYDelta += requested.top - top) : (scrollYDelta += requested.bottom - bottom);
        } else if (requested.top < top && requested.bottom < bottom) {
            scrollYDelta = requested.height() > height ? (scrollYDelta -= bottom - requested.bottom) : (scrollYDelta -= top - requested.top);
        }
        return scrollYDelta;
    }

    public static View findScrollingReferenceView(ViewGroup parent, int expectedScrollDistance) {
        View selected = null;
        Rect parentLocalVisible = new Rect();
        parent.getLocalVisibleRect(parentLocalVisible);
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (selected == null) {
                selected = child;
                continue;
            }
            if (expectedScrollDistance < 0) {
                if (child.getTop() >= selected.getTop()) continue;
                selected = child;
                continue;
            }
            if (child.getBottom() <= selected.getBottom()) continue;
            selected = child;
        }
        return selected;
    }

    @Override
    public void onScrollCaptureSearch(CancellationSignal signal, Consumer<Rect> onReady) {
        if (signal.isCanceled()) {
            return;
        }
        View view = (View)this.mWeakView.get();
        this.mStarted = false;
        this.mEnded = false;
        if (view != null && view.isVisibleToUser() && this.mViewHelper.onAcceptSession(view)) {
            onReady.accept(this.mViewHelper.onComputeScrollBounds(view));
            return;
        }
        onReady.accept(null);
    }

    @Override
    public void onScrollCaptureStart(ScrollCaptureSession session, CancellationSignal signal, Runnable onReady) {
        if (signal.isCanceled()) {
            return;
        }
        View view = (View)this.mWeakView.get();
        this.mEnded = false;
        this.mStarted = true;
        if (view != null && view.isVisibleToUser()) {
            this.mRenderer.setSurface(session.getSurface());
            this.mViewHelper.onPrepareForStart(view, session.getScrollBounds());
        }
        onReady.run();
    }

    @Override
    public void onScrollCaptureImageRequest(ScrollCaptureSession session, CancellationSignal signal, Rect requestRect, Consumer<Rect> onComplete) {
        if (signal.isCanceled()) {
            Log.w(TAG, "onScrollCaptureImageRequest: cancelled!");
            return;
        }
        View view = (View)this.mWeakView.get();
        if (view == null || !view.isVisibleToUser()) {
            onComplete.accept(new Rect());
            return;
        }
        ScrollCaptureViewHelper.ScrollResult scrollResult = this.mViewHelper.onScrollRequested(view, session.getScrollBounds(), requestRect);
        if (scrollResult.availableArea.isEmpty()) {
            onComplete.accept(scrollResult.availableArea);
            return;
        }
        Rect viewCaptureArea = new Rect(scrollResult.availableArea);
        viewCaptureArea.offset(0, -scrollResult.scrollDelta);
        Runnable captureAction = () -> {
            if (signal.isCanceled()) {
                Log.w(TAG, "onScrollCaptureImageRequest: cancelled! skipping render.");
            } else {
                this.mRenderer.renderView(view, viewCaptureArea);
                onComplete.accept(new Rect(scrollResult.availableArea));
            }
        };
        view.postOnAnimationDelayed(captureAction, this.mPostScrollDelayMillis);
    }

    @Override
    public void onScrollCaptureEnd(Runnable onReady) {
        View view = (View)this.mWeakView.get();
        if (this.mStarted && !this.mEnded) {
            if (view != null) {
                this.mViewHelper.onPrepareForEnd(view);
                view.invalidate();
            }
            this.mEnded = true;
            this.mRenderer.destroy();
        }
        onReady.run();
    }

    public String toString() {
        return "ScrollCaptureViewSupport{view=" + this.mWeakView.get() + ", helper=" + this.mViewHelper + '}';
    }

    static class ViewRenderer {
        private static final float AMBIENT_SHADOW_ALPHA = 0.039f;
        private static final float SPOT_SHADOW_ALPHA = 0.039f;
        private static final float LIGHT_Z_DP = 400.0f;
        private static final float LIGHT_RADIUS_DP = 800.0f;
        private static final String TAG = "ViewRenderer";
        private final HardwareRenderer mRenderer;
        private final RenderNode mCaptureRenderNode;
        private final Rect mTempRect = new Rect();
        private final int[] mTempLocation = new int[2];
        private long mLastRenderedSourceDrawingId = -1L;
        private Surface mSurface;

        ViewRenderer() {
            this.mRenderer = new HardwareRenderer();
            this.mRenderer.setName("ScrollCapture");
            this.mCaptureRenderNode = new RenderNode("ScrollCaptureRoot");
            this.mRenderer.setContentRoot(this.mCaptureRenderNode);
            this.mRenderer.setOpaque(false);
        }

        public void setSurface(Surface surface) {
            this.mSurface = surface;
            this.mRenderer.setSurface(surface);
        }

        private boolean updateForView(View source) {
            if (this.mLastRenderedSourceDrawingId == source.getUniqueDrawingId()) {
                return false;
            }
            this.mLastRenderedSourceDrawingId = source.getUniqueDrawingId();
            return true;
        }

        private void setupLighting(View mSource) {
            this.mLastRenderedSourceDrawingId = mSource.getUniqueDrawingId();
            DisplayMetrics metrics = mSource.getResources().getDisplayMetrics();
            mSource.getLocationOnScreen(this.mTempLocation);
            float lightX = (float)metrics.widthPixels / 2.0f - (float)this.mTempLocation[0];
            float lightY = metrics.heightPixels - this.mTempLocation[1];
            int lightZ = (int)(400.0f * metrics.density);
            int lightRadius = (int)(800.0f * metrics.density);
            this.mRenderer.setLightSourceGeometry(lightX, lightY, lightZ, lightRadius);
            this.mRenderer.setLightSourceAlpha(0.039f, 0.039f);
        }

        private void updateRootNode(View source, Rect localSourceRect) {
            View rootView = source.getRootView();
            this.transformToRoot(source, localSourceRect, this.mTempRect);
            this.mCaptureRenderNode.setPosition(0, 0, this.mTempRect.width(), this.mTempRect.height());
            RecordingCanvas canvas = this.mCaptureRenderNode.beginRecording();
            canvas.enableZ();
            canvas.translate(-this.mTempRect.left, -this.mTempRect.top);
            RenderNode rootViewRenderNode = rootView.updateDisplayListIfDirty();
            if (rootViewRenderNode.hasDisplayList()) {
                canvas.drawRenderNode(rootViewRenderNode);
            }
            this.mCaptureRenderNode.endRecording();
        }

        public void renderView(View view, Rect sourceRect) {
            if (this.updateForView(view)) {
                this.setupLighting(view);
            }
            view.invalidate();
            this.updateRootNode(view, sourceRect);
            HardwareRenderer.FrameRenderRequest request = this.mRenderer.createRenderRequest();
            long timestamp = System_Delegate.nanoTime();
            request.setVsyncTime(timestamp);
            long frameNumber = this.mSurface.getNextFrameNumber();
            request.setWaitForPresent(true);
            switch (request.syncAndDraw()) {
                case 0: 
                case 1: {
                    return;
                }
                case 8: {
                    Log.e(TAG, "syncAndDraw(): SYNC_FRAME_DROPPED !");
                    break;
                }
                case 2: {
                    Log.e(TAG, "syncAndDraw(): SYNC_LOST_SURFACE !");
                    break;
                }
                case 4: {
                    Log.e(TAG, "syncAndDraw(): SYNC_CONTEXT_IS_STOPPED !");
                }
            }
        }

        public void trimMemory() {
            this.mRenderer.clearContent();
        }

        public void destroy() {
            this.mSurface = null;
            this.mRenderer.destroy();
        }

        private void transformToRoot(View local, Rect localRect, Rect outRect) {
            local.getLocationInWindow(this.mTempLocation);
            outRect.set(localRect);
            outRect.offset(this.mTempLocation[0], this.mTempLocation[1]);
        }

        public void setColorMode(int colorMode) {
            this.mRenderer.setColorMode(colorMode);
        }
    }
}

