/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import android.os.SystemClock_Delegate;
import android.view.Choreographer;
import com.android.ide.common.rendering.api.ILayoutLog;
import java.util.ArrayList;

public class ChoreographerCallbacks {
    private final RangeList<Callback> mCallbacks = new RangeList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object action, Object token, long delayMillis) {
        RangeList<Callback> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            int idx;
            long now = SystemClock_Delegate.uptimeMillis();
            long dueTime = now + delayMillis;
            for (idx = 0; idx < this.mCallbacks.size() && ((Callback)this.mCallbacks.get(idx)).mDueTime <= dueTime; ++idx) {
            }
            this.mCallbacks.add(idx, new Callback(action, token, dueTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object action, Object token) {
        RangeList<Callback> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            this.mCallbacks.removeIf(el -> !(action != null && ((Callback)el).mAction != action || token != null && ((Callback)el).mToken != token));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(long currentTimeMs, ILayoutLog logger) {
        ArrayList toExecute;
        long currentTimeNanos = currentTimeMs * 1000000L;
        RangeList<Callback> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            int idx;
            for (idx = 0; idx < this.mCallbacks.size() && ((Callback)this.mCallbacks.get(idx)).mDueTime <= currentTimeMs; ++idx) {
            }
            toExecute = new ArrayList(this.mCallbacks.subList(0, idx));
            ((RangeList)this.mCallbacks).removeFrontElements(idx);
        }
        toExecute.forEach(p -> ChoreographerCallbacks.executeSafely(((Callback)p).mAction, currentTimeNanos, logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        RangeList<Callback> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            this.mCallbacks.clear();
        }
    }

    private static void executeSafely(Object action, long frameTimeNanos, ILayoutLog logger) {
        try {
            if (action instanceof Choreographer.FrameCallback) {
                Choreographer.FrameCallback callback = (Choreographer.FrameCallback)action;
                callback.doFrame(frameTimeNanos);
            } else if (action instanceof Runnable) {
                Runnable runnable = (Runnable)action;
                runnable.run();
            } else {
                logger.error("broken", "Unexpected action as Choreographer callback", null, null);
            }
        }
        catch (Throwable t) {
            logger.error("broken", "Failed executing Choreographer callback", t, null, null);
        }
    }

    private static class Callback {
        private final Object mAction;
        private final Object mToken;
        private final long mDueTime;

        private Callback(Object action, Object token, long dueTime) {
            this.mAction = action;
            this.mToken = token;
            this.mDueTime = dueTime;
        }
    }

    private static class RangeList<T>
    extends ArrayList<T> {
        private RangeList() {
        }

        private void removeFrontElements(int n) {
            this.removeRange(0, n);
        }
    }
}

