/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityEventCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AnnouncementEventCheck;
import com.google.android.apps.common.testing.accessibility.framework.ClickableSpanViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateClickableBoundsViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateSpeakableTextViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.EditableContentDescViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.RedundantContentDescViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.SpeakableTextPresentViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.TextContrastViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.TouchTargetSizeViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.ImageContrastCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.LinkPurposeUnclearCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TextSizeCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TraversalOrderCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.UnexposedTextCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityCheckPresetAndroid {
    @Deprecated
    public static ImmutableSet<AccessibilityViewHierarchyCheck> getViewChecksForPreset(AccessibilityCheckPreset preset) {
        ImmutableSet.Builder checks = ImmutableSet.builder();
        if (preset == AccessibilityCheckPreset.NO_CHECKS) {
            return checks.build();
        }
        checks.add((Object)new TouchTargetSizeViewCheck());
        checks.add((Object)new TextContrastViewCheck());
        checks.add((Object)new DuplicateSpeakableTextViewHierarchyCheck());
        checks.add((Object)new SpeakableTextPresentViewCheck());
        checks.add((Object)new EditableContentDescViewCheck());
        if (preset == AccessibilityCheckPreset.VERSION_1_0_CHECKS) {
            return checks.build();
        }
        checks.add((Object)new ClickableSpanViewCheck());
        checks.add((Object)new RedundantContentDescViewCheck());
        checks.add((Object)new DuplicateClickableBoundsViewCheck());
        if (preset == AccessibilityCheckPreset.VERSION_2_0_CHECKS) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.VERSION_3_0_CHECKS) {
            return checks.build();
        }
        checks.add((Object)new DelegatedViewHierarchyCheck((AccessibilityHierarchyCheck)Preconditions.checkNotNull((Object)AccessibilityCheckPreset.getHierarchyCheckForClass(TraversalOrderCheck.class))));
        checks.add((Object)new DelegatedViewHierarchyCheck((AccessibilityHierarchyCheck)Preconditions.checkNotNull((Object)AccessibilityCheckPreset.getHierarchyCheckForClass(ImageContrastCheck.class))));
        checks.add((Object)new DelegatedViewHierarchyCheck((AccessibilityHierarchyCheck)Preconditions.checkNotNull((Object)AccessibilityCheckPreset.getHierarchyCheckForClass(LinkPurposeUnclearCheck.class))));
        if (preset == AccessibilityCheckPreset.VERSION_3_1_CHECKS) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.LATEST) {
            return checks.build();
        }
        checks.add((Object)new DelegatedViewHierarchyCheck((AccessibilityHierarchyCheck)Preconditions.checkNotNull((Object)AccessibilityCheckPreset.getHierarchyCheckForClass(TextSizeCheck.class))));
        checks.add((Object)new DelegatedViewHierarchyCheck((AccessibilityHierarchyCheck)Preconditions.checkNotNull((Object)AccessibilityCheckPreset.getHierarchyCheckForClass(UnexposedTextCheck.class))));
        if (preset == AccessibilityCheckPreset.PRERELEASE) {
            return checks.build();
        }
        throw new IllegalArgumentException();
    }

    public static ImmutableSet<AccessibilityEventCheck> getEventChecksForPreset(AccessibilityCheckPreset preset) {
        ImmutableSet.Builder checks = ImmutableSet.builder();
        if (preset == AccessibilityCheckPreset.NO_CHECKS || preset == AccessibilityCheckPreset.VERSION_1_0_CHECKS) {
            return checks.build();
        }
        checks.add((Object)new AnnouncementEventCheck());
        if (preset == AccessibilityCheckPreset.VERSION_2_0_CHECKS) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.VERSION_3_0_CHECKS) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.VERSION_3_1_CHECKS) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.LATEST) {
            return checks.build();
        }
        if (preset == AccessibilityCheckPreset.PRERELEASE) {
            return checks.build();
        }
        throw new IllegalArgumentException();
    }

    private AccessibilityCheckPresetAndroid() {
    }

    @VisibleForTesting
    static class DelegatedViewHierarchyCheck
    extends AccessibilityViewHierarchyCheck {
        @VisibleForTesting
        final AccessibilityHierarchyCheck toCheck;

        DelegatedViewHierarchyCheck(AccessibilityHierarchyCheck toCheck) {
            this.toCheck = toCheck;
        }

        @Override
        public List<AccessibilityViewCheckResult> runCheckOnViewHierarchy(View root, @Nullable Parameters parameters) {
            return super.runDelegationCheckOnView(root, this.toCheck, this.toCheck, parameters);
        }
    }
}

