/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.ActivityManagerInternal;
import android.app.ActivityTaskManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.ApplicationExitInfo;
import android.app.GrantedUriPermission;
import android.app.HomeVisibilityListener;
import android.app.IActivityManager;
import android.app.IActivityTaskManager;
import android.app.IAppTask;
import android.app.IUidObserver;
import android.app.PendingIntent;
import android.app.TaskInfo;
import android.app.UriGrantsManager;
import android.app.WindowConfiguration;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Icon;
import android.hardware.HardwareBuffer;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.WorkSource;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Singleton;
import android.util.Size;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.window.TaskSnapshot;
import com.android.internal.app.LocalePicker;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.MemInfoReader;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;

public class ActivityManager {
    private static String TAG = "ActivityManager";
    @UnsupportedAppUsage
    private final Context mContext;
    private static volatile boolean sSystemReady = false;
    private static final int FIRST_START_FATAL_ERROR_CODE = -100;
    private static final int LAST_START_FATAL_ERROR_CODE = -1;
    private static final int FIRST_START_SUCCESS_CODE = 0;
    private static final int LAST_START_SUCCESS_CODE = 99;
    private static final int FIRST_START_NON_FATAL_ERROR_CODE = 100;
    private static final int LAST_START_NON_FATAL_ERROR_CODE = 199;
    public static final int INSTR_FLAG_DISABLE_HIDDEN_API_CHECKS = 1;
    public static final int INSTR_FLAG_DISABLE_ISOLATED_STORAGE = 2;
    public static final int INSTR_FLAG_DISABLE_TEST_API_CHECKS = 4;
    public static final int INSTR_FLAG_NO_RESTART = 8;
    public static final int INSTR_FLAG_ALWAYS_CHECK_SIGNATURE = 16;
    public static final int INSTR_FLAG_INSTRUMENT_SDK_SANDBOX = 32;
    final ArrayMap<OnUidImportanceListener, UidObserver> mImportanceListeners = new ArrayMap();
    public static final String META_HOME_ALTERNATE = "android.app.home.alternate";
    public static final int START_VOICE_HIDDEN_SESSION = -100;
    public static final int START_VOICE_NOT_ACTIVE_SESSION = -99;
    public static final int START_NOT_CURRENT_USER_ACTIVITY = -98;
    public static final int START_NOT_VOICE_COMPATIBLE = -97;
    public static final int START_CANCELED = -96;
    public static final int START_NOT_ACTIVITY = -95;
    public static final int START_PERMISSION_DENIED = -94;
    public static final int START_FORWARD_AND_REQUEST_CONFLICT = -93;
    public static final int START_CLASS_NOT_FOUND = -92;
    public static final int START_INTENT_NOT_RESOLVED = -91;
    public static final int START_ASSISTANT_HIDDEN_SESSION = -90;
    public static final int START_ASSISTANT_NOT_ACTIVE_SESSION = -89;
    public static final int START_SUCCESS = 0;
    public static final int START_RETURN_INTENT_TO_CALLER = 1;
    public static final int START_TASK_TO_FRONT = 2;
    public static final int START_DELIVERED_TO_TOP = 3;
    public static final int START_SWITCHES_CANCELED = 100;
    public static final int START_RETURN_LOCK_TASK_MODE_VIOLATION = 101;
    public static final int START_ABORTED = 102;
    public static final int START_FLAG_ONLY_IF_NEEDED = 1;
    public static final int START_FLAG_DEBUG = 2;
    public static final int START_FLAG_TRACK_ALLOCATION = 4;
    public static final int START_FLAG_NATIVE_DEBUGGING = 8;
    public static final int BROADCAST_SUCCESS = 0;
    public static final int BROADCAST_STICKY_CANT_HAVE_PERMISSION = -1;
    public static final int BROADCAST_FAILED_USER_STOPPED = -2;
    public static final int INTENT_SENDER_UNKNOWN = 0;
    public static final int INTENT_SENDER_BROADCAST = 1;
    @UnsupportedAppUsage
    public static final int INTENT_SENDER_ACTIVITY = 2;
    public static final int INTENT_SENDER_ACTIVITY_RESULT = 3;
    public static final int INTENT_SENDER_SERVICE = 4;
    public static final int INTENT_SENDER_FOREGROUND_SERVICE = 5;
    public static final int USER_OP_SUCCESS = 0;
    public static final int USER_OP_UNKNOWN_USER = -1;
    public static final int USER_OP_IS_CURRENT = -2;
    public static final int USER_OP_ERROR_IS_SYSTEM = -3;
    public static final int USER_OP_ERROR_RELATED_USERS_CANNOT_STOP = -4;
    public static final int PROCESS_STATE_UNKNOWN = -1;
    public static final int PROCESS_STATE_PERSISTENT = 0;
    public static final int PROCESS_STATE_PERSISTENT_UI = 1;
    @UnsupportedAppUsage
    public static final int PROCESS_STATE_TOP = 2;
    public static final int PROCESS_STATE_BOUND_TOP = 3;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PROCESS_STATE_FOREGROUND_SERVICE = 4;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 5;
    public static final int PROCESS_STATE_IMPORTANT_FOREGROUND = 6;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PROCESS_STATE_IMPORTANT_BACKGROUND = 7;
    public static final int PROCESS_STATE_TRANSIENT_BACKGROUND = 8;
    public static final int PROCESS_STATE_BACKUP = 9;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PROCESS_STATE_SERVICE = 10;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PROCESS_STATE_RECEIVER = 11;
    public static final int PROCESS_STATE_TOP_SLEEPING = 12;
    public static final int PROCESS_STATE_HEAVY_WEIGHT = 13;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PROCESS_STATE_HOME = 14;
    public static final int PROCESS_STATE_LAST_ACTIVITY = 15;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PROCESS_STATE_CACHED_ACTIVITY = 16;
    public static final int PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 17;
    public static final int PROCESS_STATE_CACHED_RECENT = 18;
    public static final int PROCESS_STATE_CACHED_EMPTY = 19;
    public static final int PROCESS_STATE_NONEXISTENT = 20;
    public static final int PROCESS_CAPABILITY_NONE = 0;
    public static final int PROCESS_CAPABILITY_FOREGROUND_LOCATION = 1;
    public static final int PROCESS_CAPABILITY_FOREGROUND_CAMERA = 2;
    public static final int PROCESS_CAPABILITY_FOREGROUND_MICROPHONE = 4;
    public static final int PROCESS_CAPABILITY_NETWORK = 8;
    public static final int PROCESS_CAPABILITY_ALL = 15;
    public static final int PROCESS_CAPABILITY_ALL_EXPLICIT = 1;
    public static final int PROCESS_CAPABILITY_ALL_IMPLICIT = 6;
    public static final int MIN_PROCESS_STATE = 0;
    public static final int MAX_PROCESS_STATE = 20;
    public static final int ASSIST_CONTEXT_BASIC = 0;
    public static final int ASSIST_CONTEXT_FULL = 1;
    public static final int ASSIST_CONTEXT_AUTOFILL = 2;
    public static final int ASSIST_CONTEXT_CONTENT = 3;
    public static final int UID_OBSERVER_PROCSTATE = 1;
    public static final int UID_OBSERVER_GONE = 2;
    public static final int UID_OBSERVER_IDLE = 4;
    public static final int UID_OBSERVER_ACTIVE = 8;
    public static final int UID_OBSERVER_CACHED = 16;
    public static final int UID_OBSERVER_CAPABILITY = 32;
    public static final int UID_OBSERVER_PROC_OOM_ADJ = 64;
    public static final int APP_START_MODE_NORMAL = 0;
    public static final int APP_START_MODE_DELAYED = 1;
    public static final int APP_START_MODE_DELAYED_RIGID = 2;
    public static final int APP_START_MODE_DISABLED = 3;
    public static final int LOCK_TASK_MODE_NONE = 0;
    public static final int LOCK_TASK_MODE_LOCKED = 1;
    public static final int LOCK_TASK_MODE_PINNED = 2;
    Point mAppTaskThumbnailSize;
    public static final int COMPAT_MODE_ALWAYS = -1;
    public static final int COMPAT_MODE_NEVER = -2;
    public static final int COMPAT_MODE_UNKNOWN = -3;
    public static final int COMPAT_MODE_DISABLED = 0;
    public static final int COMPAT_MODE_ENABLED = 1;
    public static final int COMPAT_MODE_TOGGLE = 2;
    private static final boolean DEVELOPMENT_FORCE_LOW_RAM = SystemProperties.getBoolean("debug.force_low_ram", false);
    public static final long DROP_CLOSE_SYSTEM_DIALOGS = 174664120L;
    public static final long LOCK_DOWN_CLOSE_SYSTEM_DIALOGS = 174664365L;
    public static final int RESTRICTION_LEVEL_UNKNOWN = 0;
    public static final int RESTRICTION_LEVEL_UNRESTRICTED = 10;
    public static final int RESTRICTION_LEVEL_EXEMPTED = 20;
    public static final int RESTRICTION_LEVEL_ADAPTIVE_BUCKET = 30;
    public static final int RESTRICTION_LEVEL_RESTRICTED_BUCKET = 40;
    public static final int RESTRICTION_LEVEL_BACKGROUND_RESTRICTED = 50;
    public static final int RESTRICTION_LEVEL_HIBERNATION = 60;
    public static final int RESTRICTION_LEVEL_MAX = 100;
    public static final int RECENT_WITH_EXCLUDED = 1;
    public static final int RECENT_IGNORE_UNAVAILABLE = 2;
    public static final int MOVE_TASK_WITH_HOME = 1;
    public static final int MOVE_TASK_NO_USER_ACTION = 2;
    public static final int STOP_USER_ON_SWITCH_DEFAULT = -1;
    public static final int STOP_USER_ON_SWITCH_TRUE = 1;
    public static final int STOP_USER_ON_SWITCH_FALSE = 0;
    public static final int FLAG_OR_STOPPED = 1;
    public static final int FLAG_AND_LOCKED = 2;
    public static final int FLAG_AND_UNLOCKED = 4;
    public static final int FLAG_AND_UNLOCKING_OR_UNLOCKED = 8;
    @UnsupportedAppUsage
    private static final Singleton<IActivityManager> IActivityManagerSingleton = new Singleton<IActivityManager>(){

        @Override
        protected IActivityManager create() {
            IBinder b = ServiceManager.getService("activity");
            IActivityManager am = IActivityManager.Stub.asInterface(b);
            return am;
        }
    };
    public static final String ACTION_REPORT_HEAP_LIMIT = "android.app.action.REPORT_HEAP_LIMIT";

    public static void printCapabilitiesSummary(PrintWriter pw, int caps) {
        pw.print((caps & 1) != 0 ? (char)'L' : '-');
        pw.print((caps & 2) != 0 ? (char)'C' : '-');
        pw.print((caps & 4) != 0 ? (char)'M' : '-');
        pw.print((caps & 8) != 0 ? (char)'N' : '-');
    }

    public static void printCapabilitiesSummary(StringBuilder sb, int caps) {
        sb.append((caps & 1) != 0 ? (char)'L' : '-');
        sb.append((caps & 2) != 0 ? (char)'C' : '-');
        sb.append((caps & 4) != 0 ? (char)'M' : '-');
        sb.append((caps & 8) != 0 ? (char)'N' : '-');
    }

    public static void printCapabilitiesFull(PrintWriter pw, int caps) {
        ActivityManager.printCapabilitiesSummary(pw, caps);
        int remain = caps & 0xFFFFFFF0;
        if (remain != 0) {
            pw.print('+');
            pw.print(remain);
        }
    }

    public static String getCapabilitiesSummary(int caps) {
        StringBuilder sb = new StringBuilder();
        ActivityManager.printCapabilitiesSummary(sb, caps);
        return sb.toString();
    }

    public static int processStateAmToProto(int amInt) {
        switch (amInt) {
            case -1: {
                return 999;
            }
            case 0: {
                return 1000;
            }
            case 1: {
                return 1001;
            }
            case 2: {
                return 1002;
            }
            case 3: {
                return 1020;
            }
            case 4: {
                return 1003;
            }
            case 5: {
                return 1004;
            }
            case 6: {
                return 1005;
            }
            case 7: {
                return 1006;
            }
            case 8: {
                return 1007;
            }
            case 9: {
                return 1008;
            }
            case 10: {
                return 1009;
            }
            case 11: {
                return 1010;
            }
            case 12: {
                return 1011;
            }
            case 13: {
                return 1012;
            }
            case 14: {
                return 1013;
            }
            case 15: {
                return 1014;
            }
            case 16: {
                return 1015;
            }
            case 17: {
                return 1016;
            }
            case 18: {
                return 1017;
            }
            case 19: {
                return 1018;
            }
            case 20: {
                return 1019;
            }
        }
        return 998;
    }

    public static boolean isProcStateBackground(int procState) {
        return procState >= 8;
    }

    public static boolean isProcStateCached(int procState) {
        return procState >= 16;
    }

    public static boolean isForegroundService(int procState) {
        return procState == 4;
    }

    @UnsupportedAppUsage
    ActivityManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public static boolean isStartResultSuccessful(int result) {
        return 0 <= result && result <= 99;
    }

    public static boolean isStartResultFatalError(int result) {
        return -100 <= result && result <= -1;
    }

    public static String restrictionLevelToName(int level) {
        switch (level) {
            case 0: {
                return "unknown";
            }
            case 10: {
                return "unrestricted";
            }
            case 20: {
                return "exempted";
            }
            case 30: {
                return "adaptive_bucket";
            }
            case 40: {
                return "restricted_bucket";
            }
            case 50: {
                return "background_restricted";
            }
            case 60: {
                return "hibernation";
            }
            case 100: {
                return "max";
            }
        }
        return "";
    }

    public int getFrontActivityScreenCompatMode() {
        try {
            return ActivityManager.getTaskService().getFrontActivityScreenCompatMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setFrontActivityScreenCompatMode(int mode) {
        try {
            ActivityManager.getTaskService().setFrontActivityScreenCompatMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getPackageScreenCompatMode(String packageName) {
        try {
            return ActivityManager.getTaskService().getPackageScreenCompatMode(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setPackageScreenCompatMode(String packageName, int mode) {
        try {
            ActivityManager.getTaskService().setPackageScreenCompatMode(packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean getPackageAskScreenCompat(String packageName) {
        try {
            return ActivityManager.getTaskService().getPackageAskScreenCompat(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setPackageAskScreenCompat(String packageName, boolean ask) {
        try {
            ActivityManager.getTaskService().setPackageAskScreenCompat(packageName, ask);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getMemoryClass() {
        return ActivityManager.staticGetMemoryClass();
    }

    @UnsupportedAppUsage
    public static int staticGetMemoryClass() {
        String vmHeapSize = SystemProperties.get("dalvik.vm.heapgrowthlimit", "");
        if (vmHeapSize != null && !"".equals(vmHeapSize)) {
            return Integer.parseInt(vmHeapSize.substring(0, vmHeapSize.length() - 1));
        }
        return ActivityManager.staticGetLargeMemoryClass();
    }

    public int getLargeMemoryClass() {
        return ActivityManager.staticGetLargeMemoryClass();
    }

    public static int staticGetLargeMemoryClass() {
        String vmHeapSize = SystemProperties.get("dalvik.vm.heapsize", "16m");
        return Integer.parseInt(vmHeapSize.substring(0, vmHeapSize.length() - 1));
    }

    public boolean isLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    @UnsupportedAppUsage
    public static boolean isLowRamDeviceStatic() {
        return RoSystemProperties.CONFIG_LOW_RAM || _Original_Build.IS_DEBUGGABLE && DEVELOPMENT_FORCE_LOW_RAM;
    }

    public static boolean isSmallBatteryDevice() {
        return RoSystemProperties.CONFIG_SMALL_BATTERY;
    }

    public static boolean isHighEndGfx() {
        return !ActivityManager.isLowRamDeviceStatic() && !RoSystemProperties.CONFIG_AVOID_GFX_ACCEL && !Resources.getSystem().getBoolean(17891380);
    }

    public long getTotalRam() {
        MemInfoReader memreader = new MemInfoReader();
        memreader.readMemInfo();
        return memreader.getTotalSize();
    }

    @Deprecated
    @UnsupportedAppUsage
    public static int getMaxRecentTasksStatic() {
        return ActivityTaskManager.getMaxRecentTasksStatic();
    }

    @Deprecated
    public List<RecentTaskInfo> getRecentTasks(int maxNum, int flags) throws SecurityException {
        if (maxNum < 0) {
            throw new IllegalArgumentException("The requested number of tasks should be >= 0");
        }
        return ActivityTaskManager.getInstance().getRecentTasks(maxNum, flags, this.mContext.getUserId());
    }

    public List<AppTask> getAppTasks() {
        List<IBinder> appTasks;
        ArrayList<AppTask> tasks = new ArrayList<AppTask>();
        try {
            appTasks = ActivityManager.getTaskService().getAppTasks(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        int numAppTasks = appTasks.size();
        for (int i = 0; i < numAppTasks; ++i) {
            tasks.add(new AppTask(IAppTask.Stub.asInterface(appTasks.get(i))));
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Size getAppTaskThumbnailSize() {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.ensureAppTaskThumbnailSizeLocked();
            return new Size(this.mAppTaskThumbnailSize.x, this.mAppTaskThumbnailSize.y);
        }
    }

    private void ensureAppTaskThumbnailSizeLocked() {
        if (this.mAppTaskThumbnailSize == null) {
            try {
                this.mAppTaskThumbnailSize = ActivityManager.getTaskService().getAppTaskThumbnailSize();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAppTask(Activity activity, Intent intent, TaskDescription description, Bitmap thumbnail) {
        Point size;
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.ensureAppTaskThumbnailSizeLocked();
            size = this.mAppTaskThumbnailSize;
        }
        int tw = thumbnail.getWidth();
        int th = thumbnail.getHeight();
        if (tw != size.x || th != size.y) {
            float scale;
            Bitmap bm = Bitmap.createBitmap(size.x, size.y, thumbnail.getConfig());
            float dx = 0.0f;
            float dy = 0.0f;
            if (tw * size.x > size.y * th) {
                scale = (float)size.x / (float)th;
                dx = ((float)size.y - (float)tw * scale) * 0.5f;
            } else {
                scale = (float)size.y / (float)tw;
                dy = ((float)size.x - (float)th * scale) * 0.5f;
            }
            Matrix matrix = new Matrix();
            matrix.setScale(scale, scale);
            matrix.postTranslate((int)(dx + 0.5f), 0.0f);
            Canvas canvas = new Canvas(bm);
            canvas.drawBitmap(thumbnail, matrix, null);
            canvas.setBitmap(null);
            thumbnail = bm;
        }
        if (description == null) {
            description = new TaskDescription();
        }
        try {
            return ActivityManager.getTaskService().addAppTask(activity.getActivityToken(), intent, description, thumbnail);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public List<RunningTaskInfo> getRunningTasks(int maxNum) throws SecurityException {
        return ActivityTaskManager.getInstance().getTasks(maxNum);
    }

    @RequiresPermission(value="android.permission.REORDER_TASKS")
    public void moveTaskToFront(int taskId, int flags) {
        this.moveTaskToFront(taskId, flags, null);
    }

    @RequiresPermission(value="android.permission.REORDER_TASKS")
    public void moveTaskToFront(int taskId, int flags, Bundle options) {
        try {
            ActivityThread thread = ActivityThread.currentActivityThread();
            ActivityThread.ApplicationThread appThread = thread.getApplicationThread();
            String packageName = this.mContext.getOpPackageName();
            ActivityManager.getTaskService().moveTaskToFront(appThread, packageName, taskId, flags, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isActivityStartAllowedOnDisplay(Context context, int displayId, Intent intent) {
        try {
            return ActivityManager.getTaskService().isActivityStartAllowedOnDisplay(displayId, intent, intent.resolveTypeIfNeeded(context.getContentResolver()), context.getUserId());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @Deprecated
    public List<RunningServiceInfo> getRunningServices(int maxNum) throws SecurityException {
        try {
            return ActivityManager.getService().getServices(maxNum, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PendingIntent getRunningServiceControlPanel(ComponentName service) throws SecurityException {
        try {
            return ActivityManager.getService().getRunningServiceControlPanel(service);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getMemoryInfo(MemoryInfo outInfo) {
        try {
            ActivityManager.getService().getMemoryInfo(outInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.CLEAR_APP_USER_DATA", "android.permission.ACCESS_INSTANT_APPS"})
    @UnsupportedAppUsage
    public boolean clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        try {
            return ActivityManager.getService().clearApplicationUserData(packageName, false, observer, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean clearApplicationUserData() {
        return this.clearApplicationUserData(this.mContext.getPackageName(), null);
    }

    @Deprecated
    public ParceledListSlice<GrantedUriPermission> getGrantedUriPermissions(String packageName) {
        return ((UriGrantsManager)this.mContext.getSystemService("uri_grants")).getGrantedUriPermissions(packageName);
    }

    @Deprecated
    public void clearGrantedUriPermissions(String packageName) {
        ((UriGrantsManager)this.mContext.getSystemService("uri_grants")).clearGrantedUriPermissions(packageName);
    }

    public List<ProcessErrorStateInfo> getProcessesInErrorState() {
        try {
            return ActivityManager.getService().getProcessesInErrorState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<ApplicationInfo> getRunningExternalApplications() {
        try {
            return ActivityManager.getService().getRunningExternalApplications();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isBackgroundRestricted() {
        try {
            return ActivityManager.getService().isBackgroundRestricted(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean setProcessMemoryTrimLevel(String process, int userId, int level) {
        try {
            return ActivityManager.getService().setProcessMemoryTrimLevel(process, userId, level);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<RunningAppProcessInfo> getRunningAppProcesses() {
        try {
            return ActivityManager.getService().getRunningAppProcesses();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<ApplicationExitInfo> getHistoricalProcessExitReasons(String packageName, int pid, int maxNum) {
        try {
            ParceledListSlice<ApplicationExitInfo> r = ActivityManager.getService().getHistoricalProcessExitReasons(packageName, pid, maxNum, this.mContext.getUserId());
            return r == null ? Collections.emptyList() : r.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setProcessStateSummary(byte[] state) {
        try {
            ActivityManager.getService().setProcessStateSummary(state);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean isLowMemoryKillReportSupported() {
        return SystemProperties.getBoolean("persist.sys.lmk.reportkills", false);
    }

    @RequiresPermission(allOf={"android.permission.PACKAGE_USAGE_STATS", "android.permission.INTERACT_ACROSS_USERS_FULL"}, conditional=true)
    public int getUidProcessState(int uid) {
        try {
            return ActivityManager.getService().getUidProcessState(uid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.PACKAGE_USAGE_STATS", "android.permission.INTERACT_ACROSS_USERS_FULL"}, conditional=true)
    public int getUidProcessCapabilities(int uid) {
        try {
            return ActivityManager.getService().getUidProcessCapabilities(uid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public int getPackageImportance(String packageName) {
        try {
            int procState = ActivityManager.getService().getPackageProcessState(packageName, this.mContext.getOpPackageName());
            return RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public int getUidImportance(int uid) {
        try {
            int procState = ActivityManager.getService().getUidProcessState(uid, this.mContext.getOpPackageName());
            return RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public void addOnUidImportanceListener(OnUidImportanceListener listener, int importanceCutpoint) {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            if (this.mImportanceListeners.containsKey(listener)) {
                throw new IllegalArgumentException("Listener already registered: " + listener);
            }
            UidObserver observer = new UidObserver(listener, this.mContext);
            try {
                ActivityManager.getService().registerUidObserver(observer, 3, RunningAppProcessInfo.importanceToProcState(importanceCutpoint), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mImportanceListeners.put(listener, observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.PACKAGE_USAGE_STATS")
    public void removeOnUidImportanceListener(OnUidImportanceListener listener) {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            UidObserver observer = this.mImportanceListeners.remove(listener);
            if (observer == null) {
                throw new IllegalArgumentException("Listener not registered: " + listener);
            }
            try {
                ActivityManager.getService().unregisterUidObserver(observer);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static void getMyMemoryState(RunningAppProcessInfo outState) {
        try {
            ActivityManager.getService().getMyMemoryState(outState);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] pids) {
        try {
            return ActivityManager.getService().getProcessMemoryInfo(pids);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void restartPackage(String packageName) {
        this.killBackgroundProcesses(packageName);
    }

    @RequiresPermission(value="android.permission.KILL_BACKGROUND_PROCESSES")
    public void killBackgroundProcesses(String packageName) {
        try {
            ActivityManager.getService().killBackgroundProcesses(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.KILL_UID")
    public void killUid(int uid, String reason) {
        try {
            ActivityManager.getService().killUid(UserHandle.getAppId(uid), UserHandle.getUserId(uid), reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void forceStopPackageAsUser(String packageName, int userId) {
        try {
            ActivityManager.getService().forceStopPackage(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.FORCE_STOP_PACKAGES")
    public void forceStopPackage(String packageName) {
        this.forceStopPackageAsUser(packageName, this.mContext.getUserId());
    }

    @SystemApi
    public void setDeviceLocales(LocaleList locales) {
        LocalePicker.updateLocales(locales);
    }

    @SystemApi
    public Collection<Locale> getSupportedLocales() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String localeTag : LocalePicker.getSupportedLocales(this.mContext)) {
            locales.add(Locale.forLanguageTag(localeTag));
        }
        return locales;
    }

    public ConfigurationInfo getDeviceConfigurationInfo() {
        try {
            return ActivityManager.getTaskService().getDeviceConfigurationInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLauncherLargeIconDensity() {
        Resources res = this.mContext.getResources();
        int density = res.getDisplayMetrics().densityDpi;
        int sw = res.getConfiguration().smallestScreenWidthDp;
        if (sw < 600) {
            return density;
        }
        switch (density) {
            case 120: {
                return 160;
            }
            case 160: {
                return 240;
            }
            case 213: {
                return 320;
            }
            case 240: {
                return 320;
            }
            case 320: {
                return 480;
            }
            case 480: {
                return 640;
            }
        }
        return (int)((float)density * 1.5f + 0.5f);
    }

    public int getLauncherLargeIconSize() {
        return ActivityManager.getLauncherLargeIconSizeInner(this.mContext);
    }

    static int getLauncherLargeIconSizeInner(Context context) {
        Resources res = context.getResources();
        int size = res.getDimensionPixelSize(0x1050000);
        int sw = res.getConfiguration().smallestScreenWidthDp;
        if (sw < 600) {
            return size;
        }
        int density = res.getDisplayMetrics().densityDpi;
        switch (density) {
            case 120: {
                return size * 160 / 120;
            }
            case 160: {
                return size * 240 / 160;
            }
            case 213: {
                return size * 320 / 240;
            }
            case 240: {
                return size * 320 / 240;
            }
            case 320: {
                return size * 480 / 320;
            }
            case 480: {
                return size * 320 * 2 / 480;
            }
        }
        return (int)((float)size * 1.5f + 0.5f);
    }

    public static boolean isUserAMonkey() {
        try {
            return ActivityManager.getService().isUserAMonkey();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public static boolean isRunningInTestHarness() {
        return SystemProperties.getBoolean("ro.test_harness", false);
    }

    public static boolean isRunningInUserTestHarness() {
        return SystemProperties.getBoolean("persist.sys.test_harness", false);
    }

    public void alwaysShowUnsupportedCompileSdkWarning(ComponentName activity) {
        try {
            ActivityManager.getTaskService().alwaysShowUnsupportedCompileSdkWarning(activity);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public static int checkComponentPermission(String permission2, int uid, int owningUid, boolean exported) {
        int appId = UserHandle.getAppId(uid);
        if (appId == 0 || appId == 1000) {
            return 0;
        }
        if (UserHandle.isIsolated(uid)) {
            return -1;
        }
        if (owningUid >= 0 && UserHandle.isSameApp(uid, owningUid)) {
            return 0;
        }
        if (!exported) {
            return -1;
        }
        if (permission2 == null) {
            return 0;
        }
        try {
            return AppGlobals.getPackageManager().checkUidPermission(permission2, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int checkUidPermission(String permission2, int uid) {
        try {
            return AppGlobals.getPackageManager().checkUidPermission(permission2, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, boolean requireFull, String name, String callerPackage) {
        if (UserHandle.getUserId(callingUid) == userId) {
            return userId;
        }
        try {
            return ActivityManager.getService().handleIncomingUser(callingPid, callingUid, userId, allowAll, requireFull, name, callerPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public static int getCurrentUser() {
        try {
            return ActivityManager.getService().getCurrentUserId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean switchUser(int userid) {
        try {
            return ActivityManager.getService().switchUser(userid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean switchUser(UserHandle user) {
        if (user == null) {
            throw new IllegalArgumentException("UserHandle cannot be null.");
        }
        return this.switchUser(user.getIdentifier());
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getSwitchingFromUserMessage() {
        try {
            return ActivityManager.getService().getSwitchingFromUserMessage();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getSwitchingToUserMessage() {
        try {
            return ActivityManager.getService().getSwitchingToUserMessage();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    public void setStopUserOnSwitch(@StopUserOnSwitch int value) {
        try {
            ActivityManager.getService().setStopUserOnSwitch(value);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public boolean startProfile(UserHandle userHandle) {
        try {
            return ActivityManager.getService().startProfile(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public boolean stopProfile(UserHandle userHandle) {
        try {
            return ActivityManager.getService().stopProfile(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.CHANGE_CONFIGURATION")
    public boolean updateMccMncConfiguration(String mcc, String mnc) {
        if (mcc == null || mnc == null) {
            throw new IllegalArgumentException("mcc or mnc cannot be null.");
        }
        try {
            return ActivityManager.getService().updateMccMncConfiguration(mcc, mnc);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public boolean stopUser(int userId, boolean force) {
        if (userId == 0) {
            return false;
        }
        try {
            return 0 == ActivityManager.getService().stopUser(userId, force, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public boolean isUserRunning(int userId) {
        try {
            return ActivityManager.getService().isUserRunning(userId, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isVrModePackageEnabled(ComponentName component) {
        try {
            return ActivityManager.getService().isVrModePackageEnabled(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DUMP")
    public void dumpPackageState(FileDescriptor fd, String packageName) {
        ActivityManager.dumpPackageStateStatic(fd, packageName);
    }

    public static void dumpPackageStateStatic(FileDescriptor fd, String packageName) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        ActivityManager.dumpService(pw, fd, "package", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "activity", new String[]{"-a", "package", packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "meminfo", new String[]{"--local", "--package", packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "procstats", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "usagestats", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "batterystats", new String[]{packageName});
        ((PrintWriter)pw).flush();
    }

    public static boolean isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityThread.isSystem() ? LocalServices.getService(ActivityManagerInternal.class).isSystemReady() : true;
        }
        return sSystemReady;
    }

    public static void broadcastStickyIntent(Intent intent, int userId) {
        ActivityManager.broadcastStickyIntent(intent, -1, userId);
    }

    public static void broadcastStickyIntent(Intent intent, int appOp, int userId) {
        try {
            ActivityManager.getService().broadcastIntentWithFeature(null, null, intent, null, null, -1, null, null, null, null, null, appOp, null, false, true, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static void resumeAppSwitches() throws RemoteException {
        ActivityManager.getService().resumeAppSwitches();
    }

    public static void noteWakeupAlarm(PendingIntent ps, WorkSource workSource, int sourceUid, String sourcePkg, String tag) {
        try {
            ActivityManager.getService().noteWakeupAlarm(ps != null ? ps.getTarget() : null, workSource, sourceUid, sourcePkg, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static void noteAlarmStart(PendingIntent ps, WorkSource workSource, int sourceUid, String tag) {
        try {
            ActivityManager.getService().noteAlarmStart(ps != null ? ps.getTarget() : null, workSource, sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static void noteAlarmFinish(PendingIntent ps, WorkSource workSource, int sourceUid, String tag) {
        try {
            ActivityManager.getService().noteAlarmFinish(ps != null ? ps.getTarget() : null, workSource, sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public static IActivityManager getService() {
        return IActivityManagerSingleton.get();
    }

    private static IActivityTaskManager getTaskService() {
        return ActivityTaskManager.getService();
    }

    private static void dumpService(PrintWriter pw, FileDescriptor fd, String name, String[] args) {
        pw.print("DUMP OF SERVICE ");
        pw.print(name);
        pw.println(":");
        IBinder service = ServiceManager.checkService(name);
        if (service == null) {
            pw.println("  (Service not found)");
            pw.flush();
            return;
        }
        pw.flush();
        if (service instanceof Binder) {
            try {
                service.dump(fd, args);
            }
            catch (Throwable e) {
                pw.println("Failure dumping service:");
                e.printStackTrace(pw);
                pw.flush();
            }
        } else {
            TransferPipe tp = null;
            try {
                pw.flush();
                tp = new TransferPipe();
                tp.setBufferPrefix("  ");
                service.dumpAsync(tp.getWriteFd().getFileDescriptor(), args);
                tp.go(fd, 10000L);
            }
            catch (Throwable e) {
                if (tp != null) {
                    tp.kill();
                }
                pw.println("Failure dumping service:");
                e.printStackTrace(pw);
            }
        }
    }

    public void setWatchHeapLimit(long pssSize) {
        try {
            ActivityManager.getService().setDumpHeapDebugLimit(null, 0, pssSize, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearWatchHeapLimit() {
        try {
            ActivityManager.getService().setDumpHeapDebugLimit(null, 0, 0L, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    public int getLockTaskModeState() {
        try {
            return ActivityManager.getTaskService().getLockTaskModeState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void setVrThread(int tid) {
        try {
            ActivityManager.getTaskService().setVrThread(tid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.RESTRICTED_VR_ACCESS")
    public static void setPersistentVrThread(int tid) {
        try {
            ActivityManager.getService().setPersistentVrThread(tid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_CONFIGURATION")
    public void scheduleApplicationInfoChanged(List<String> packages, int userId) {
        try {
            ActivityManager.getService().scheduleApplicationInfoChanged(packages, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isProfileForeground(UserHandle userHandle) {
        UserManager userManager = this.mContext.getSystemService(UserManager.class);
        if (userManager != null) {
            for (UserInfo userInfo : userManager.getProfiles(ActivityManager.getCurrentUser())) {
                if (userInfo.id != userHandle.getIdentifier()) continue;
                return true;
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.FORCE_STOP_PACKAGES")
    public void killProcessesWhenImperceptible(int[] pids, String reason) {
        try {
            ActivityManager.getService().killProcessesWhenImperceptible(pids, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean isProcStateConsideredInteraction(int procState) {
        return procState <= 2 || procState == 3;
    }

    public static String procStateToString(int procState) {
        String procStateStr;
        switch (procState) {
            case 0: {
                procStateStr = "PER ";
                break;
            }
            case 1: {
                procStateStr = "PERU";
                break;
            }
            case 2: {
                procStateStr = "TOP ";
                break;
            }
            case 3: {
                procStateStr = "BTOP";
                break;
            }
            case 4: {
                procStateStr = "FGS ";
                break;
            }
            case 5: {
                procStateStr = "BFGS";
                break;
            }
            case 6: {
                procStateStr = "IMPF";
                break;
            }
            case 7: {
                procStateStr = "IMPB";
                break;
            }
            case 8: {
                procStateStr = "TRNB";
                break;
            }
            case 9: {
                procStateStr = "BKUP";
                break;
            }
            case 10: {
                procStateStr = "SVC ";
                break;
            }
            case 11: {
                procStateStr = "RCVR";
                break;
            }
            case 12: {
                procStateStr = "TPSL";
                break;
            }
            case 13: {
                procStateStr = "HVY ";
                break;
            }
            case 14: {
                procStateStr = "HOME";
                break;
            }
            case 15: {
                procStateStr = "LAST";
                break;
            }
            case 16: {
                procStateStr = "CAC ";
                break;
            }
            case 17: {
                procStateStr = "CACC";
                break;
            }
            case 18: {
                procStateStr = "CRE ";
                break;
            }
            case 19: {
                procStateStr = "CEM ";
                break;
            }
            case 20: {
                procStateStr = "NONE";
                break;
            }
            default: {
                procStateStr = "??";
            }
        }
        return procStateStr;
    }

    public List<String> getBugreportWhitelistedPackages() {
        try {
            return ActivityManager.getService().getBugreportWhitelistedPackages();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void appNotResponding(String reason) {
        try {
            ActivityManager.getService().appNotResponding(reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.SET_ACTIVITY_WATCHER")
    public void addHomeVisibilityListener(Executor executor, HomeVisibilityListener listener) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        try {
            listener.init(this.mContext, executor, this);
            ActivityManager.getService().registerProcessObserver(listener.mObserver);
            executor.execute(() -> listener.onHomeVisibilityChanged(listener.mIsHomeActivityVisible));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.SET_ACTIVITY_WATCHER")
    public void removeHomeVisibilityListener(HomeVisibilityListener listener) {
        Preconditions.checkNotNull(listener);
        try {
            ActivityManager.getService().unregisterProcessObserver(listener.mObserver);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.RESET_APP_ERRORS")
    public void resetAppErrors() {
        try {
            ActivityManager.getService().resetAppErrors();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void holdLock(IBinder token, int durationMs) {
        try {
            ActivityManager.getService().holdLock(token, durationMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DUMP")
    public void waitForBroadcastIdle() {
        try {
            ActivityManager.getService().waitForBroadcastIdle();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.DEVICE_POWER")
    public int getBackgroundRestrictionExemptionReason(int uid) {
        try {
            return ActivityManager.getService().getBackgroundRestrictionExemptionReason(uid);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return -1;
        }
    }

    public static class PendingIntentInfo
    implements Parcelable {
        private final String mCreatorPackage;
        private final int mCreatorUid;
        private final boolean mImmutable;
        private final int mIntentSenderType;
        public static final Parcelable.Creator<PendingIntentInfo> CREATOR = new Parcelable.Creator<PendingIntentInfo>(){

            @Override
            public PendingIntentInfo createFromParcel(Parcel in) {
                return new PendingIntentInfo(in.readString(), in.readInt(), in.readBoolean(), in.readInt());
            }

            public PendingIntentInfo[] newArray(int size) {
                return new PendingIntentInfo[size];
            }
        };

        public PendingIntentInfo(String creatorPackage, int creatorUid, boolean immutable, int intentSenderType) {
            this.mCreatorPackage = creatorPackage;
            this.mCreatorUid = creatorUid;
            this.mImmutable = immutable;
            this.mIntentSenderType = intentSenderType;
        }

        public String getCreatorPackage() {
            return this.mCreatorPackage;
        }

        public int getCreatorUid() {
            return this.mCreatorUid;
        }

        public boolean isImmutable() {
            return this.mImmutable;
        }

        public int getIntentSenderType() {
            return this.mIntentSenderType;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeString(this.mCreatorPackage);
            parcel.writeInt(this.mCreatorUid);
            parcel.writeBoolean(this.mImmutable);
            parcel.writeInt(this.mIntentSenderType);
        }
    }

    public static class AppTask {
        private IAppTask mAppTaskImpl;

        public AppTask(IAppTask task) {
            this.mAppTaskImpl = task;
        }

        public void finishAndRemoveTask() {
            try {
                this.mAppTaskImpl.finishAndRemoveTask();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public RecentTaskInfo getTaskInfo() {
            try {
                return this.mAppTaskImpl.getTaskInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void moveToFront() {
            try {
                ActivityThread thread = ActivityThread.currentActivityThread();
                ActivityThread.ApplicationThread appThread = thread.getApplicationThread();
                String packageName = ActivityThread.currentPackageName();
                this.mAppTaskImpl.moveToFront(appThread, packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void startActivity(Context context, Intent intent, Bundle options) {
            ActivityThread thread = ActivityThread.currentActivityThread();
            thread.getInstrumentation().execStartActivityFromAppTask(context, thread.getApplicationThread(), this.mAppTaskImpl, intent, options);
        }

        public void setExcludeFromRecents(boolean exclude) {
            try {
                this.mAppTaskImpl.setExcludeFromRecents(exclude);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static @interface StopUserOnSwitch {
    }

    @SystemApi
    public static interface OnUidImportanceListener {
        public void onUidImportance(int var1, int var2);
    }

    public static class RunningAppProcessInfo
    implements Parcelable {
        public String processName;
        public int pid;
        public int uid;
        public String[] pkgList;
        public static final int FLAG_CANT_SAVE_STATE = 1;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int FLAG_PERSISTENT = 2;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int FLAG_HAS_ACTIVITIES = 4;
        @UnsupportedAppUsage
        public int flags;
        public int lastTrimLevel;
        public static final int IMPORTANCE_FOREGROUND = 100;
        public static final int IMPORTANCE_FOREGROUND_SERVICE = 125;
        @Deprecated
        public static final int IMPORTANCE_TOP_SLEEPING_PRE_28 = 150;
        public static final int IMPORTANCE_VISIBLE = 200;
        public static final int IMPORTANCE_PERCEPTIBLE_PRE_26 = 130;
        public static final int IMPORTANCE_PERCEPTIBLE = 230;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static final int IMPORTANCE_CANT_SAVE_STATE_PRE_26 = 170;
        public static final int IMPORTANCE_SERVICE = 300;
        public static final int IMPORTANCE_TOP_SLEEPING = 325;
        public static final int IMPORTANCE_CANT_SAVE_STATE = 350;
        public static final int IMPORTANCE_CACHED = 400;
        public static final int IMPORTANCE_BACKGROUND = 400;
        @Deprecated
        public static final int IMPORTANCE_EMPTY = 500;
        public static final int IMPORTANCE_GONE = 1000;
        public int importance;
        public int lru;
        public static final int REASON_UNKNOWN = 0;
        public static final int REASON_PROVIDER_IN_USE = 1;
        public static final int REASON_SERVICE_IN_USE = 2;
        public int importanceReasonCode;
        public int importanceReasonPid;
        public ComponentName importanceReasonComponent;
        public int importanceReasonImportance;
        @UnsupportedAppUsage
        public int processState;
        public boolean isFocused;
        public long lastActivityTime;
        public static final Parcelable.Creator<RunningAppProcessInfo> CREATOR = new Parcelable.Creator<RunningAppProcessInfo>(){

            @Override
            public RunningAppProcessInfo createFromParcel(Parcel source) {
                return new RunningAppProcessInfo(source);
            }

            public RunningAppProcessInfo[] newArray(int size) {
                return new RunningAppProcessInfo[size];
            }
        };

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public static int procStateToImportance(int procState) {
            if (procState == 20) {
                return 1000;
            }
            if (procState >= 14) {
                return 400;
            }
            if (procState == 13) {
                return 350;
            }
            if (procState >= 12) {
                return 325;
            }
            if (procState >= 10) {
                return 300;
            }
            if (procState >= 8) {
                return 230;
            }
            if (procState >= 6) {
                return 200;
            }
            if (procState >= 4) {
                return 125;
            }
            return 100;
        }

        public static int procStateToImportanceForClient(int procState, Context clientContext) {
            return RunningAppProcessInfo.procStateToImportanceForTargetSdk(procState, clientContext.getApplicationInfo().targetSdkVersion);
        }

        public static int procStateToImportanceForTargetSdk(int procState, int targetSdkVersion) {
            int importance = RunningAppProcessInfo.procStateToImportance(procState);
            if (targetSdkVersion < 26) {
                switch (importance) {
                    case 230: {
                        return 130;
                    }
                    case 325: {
                        return 150;
                    }
                    case 350: {
                        return 170;
                    }
                }
            }
            return importance;
        }

        public static int importanceToProcState(int importance) {
            if (importance == 1000) {
                return 20;
            }
            if (importance >= 400) {
                return 14;
            }
            if (importance >= 350) {
                return 13;
            }
            if (importance >= 325) {
                return 12;
            }
            if (importance >= 300) {
                return 10;
            }
            if (importance >= 230) {
                return 8;
            }
            if (importance >= 200) {
                return 6;
            }
            if (importance >= 150) {
                return 6;
            }
            if (importance >= 125) {
                return 4;
            }
            return 2;
        }

        public RunningAppProcessInfo() {
            this.importance = 100;
            this.importanceReasonCode = 0;
            this.processState = 6;
            this.isFocused = false;
            this.lastActivityTime = 0L;
        }

        public RunningAppProcessInfo(String pProcessName, int pPid, String[] pArr) {
            this.processName = pProcessName;
            this.pid = pPid;
            this.pkgList = pArr;
            this.isFocused = false;
            this.lastActivityTime = 0L;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.processName);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeStringArray(this.pkgList);
            dest.writeInt(this.flags);
            dest.writeInt(this.lastTrimLevel);
            dest.writeInt(this.importance);
            dest.writeInt(this.lru);
            dest.writeInt(this.importanceReasonCode);
            dest.writeInt(this.importanceReasonPid);
            ComponentName.writeToParcel(this.importanceReasonComponent, dest);
            dest.writeInt(this.importanceReasonImportance);
            dest.writeInt(this.processState);
            dest.writeInt(this.isFocused ? 1 : 0);
            dest.writeLong(this.lastActivityTime);
        }

        public void readFromParcel(Parcel source) {
            this.processName = source.readString();
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.pkgList = source.readStringArray();
            this.flags = source.readInt();
            this.lastTrimLevel = source.readInt();
            this.importance = source.readInt();
            this.lru = source.readInt();
            this.importanceReasonCode = source.readInt();
            this.importanceReasonPid = source.readInt();
            this.importanceReasonComponent = ComponentName.readFromParcel(source);
            this.importanceReasonImportance = source.readInt();
            this.processState = source.readInt();
            this.isFocused = source.readInt() != 0;
            this.lastActivityTime = source.readLong();
        }

        private RunningAppProcessInfo(Parcel source) {
            this.readFromParcel(source);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Importance {
        }
    }

    public static class ProcessErrorStateInfo
    implements Parcelable {
        public static final int NO_ERROR = 0;
        public static final int CRASHED = 1;
        public static final int NOT_RESPONDING = 2;
        public int condition;
        public String processName;
        public int pid;
        public int uid;
        public String tag;
        public String shortMsg;
        public String longMsg;
        public String stackTrace;
        public byte[] crashData = null;
        public static final Parcelable.Creator<ProcessErrorStateInfo> CREATOR = new Parcelable.Creator<ProcessErrorStateInfo>(){

            @Override
            public ProcessErrorStateInfo createFromParcel(Parcel source) {
                return new ProcessErrorStateInfo(source);
            }

            public ProcessErrorStateInfo[] newArray(int size) {
                return new ProcessErrorStateInfo[size];
            }
        };

        public ProcessErrorStateInfo() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.condition);
            dest.writeString(this.processName);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeString(this.tag);
            dest.writeString(this.shortMsg);
            dest.writeString(this.longMsg);
            dest.writeString(this.stackTrace);
        }

        public void readFromParcel(Parcel source) {
            this.condition = source.readInt();
            this.processName = source.readString();
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.tag = source.readString();
            this.shortMsg = source.readString();
            this.longMsg = source.readString();
            this.stackTrace = source.readString();
        }

        private ProcessErrorStateInfo(Parcel source) {
            this.readFromParcel(source);
        }
    }

    public static class MemoryInfo
    implements Parcelable {
        public long availMem;
        public long totalMem;
        public long threshold;
        public boolean lowMemory;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long hiddenAppThreshold;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long secondaryServerThreshold;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long visibleAppThreshold;
        @UnsupportedAppUsage
        public long foregroundAppThreshold;
        public static final Parcelable.Creator<MemoryInfo> CREATOR = new Parcelable.Creator<MemoryInfo>(){

            @Override
            public MemoryInfo createFromParcel(Parcel source) {
                return new MemoryInfo(source);
            }

            public MemoryInfo[] newArray(int size) {
                return new MemoryInfo[size];
            }
        };

        public MemoryInfo() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.availMem);
            dest.writeLong(this.totalMem);
            dest.writeLong(this.threshold);
            dest.writeInt(this.lowMemory ? 1 : 0);
            dest.writeLong(this.hiddenAppThreshold);
            dest.writeLong(this.secondaryServerThreshold);
            dest.writeLong(this.visibleAppThreshold);
            dest.writeLong(this.foregroundAppThreshold);
        }

        public void readFromParcel(Parcel source) {
            this.availMem = source.readLong();
            this.totalMem = source.readLong();
            this.threshold = source.readLong();
            this.lowMemory = source.readInt() != 0;
            this.hiddenAppThreshold = source.readLong();
            this.secondaryServerThreshold = source.readLong();
            this.visibleAppThreshold = source.readLong();
            this.foregroundAppThreshold = source.readLong();
        }

        private MemoryInfo(Parcel source) {
            this.readFromParcel(source);
        }
    }

    public static class RunningServiceInfo
    implements Parcelable {
        public ComponentName service;
        public int pid;
        public int uid;
        public String process;
        public boolean foreground;
        public long activeSince;
        public boolean started;
        public int clientCount;
        public int crashCount;
        public long lastActivityTime;
        public long restarting;
        public static final int FLAG_STARTED = 1;
        public static final int FLAG_FOREGROUND = 2;
        public static final int FLAG_SYSTEM_PROCESS = 4;
        public static final int FLAG_PERSISTENT_PROCESS = 8;
        public int flags;
        public String clientPackage;
        public int clientLabel;
        public static final Parcelable.Creator<RunningServiceInfo> CREATOR = new Parcelable.Creator<RunningServiceInfo>(){

            @Override
            public RunningServiceInfo createFromParcel(Parcel source) {
                return new RunningServiceInfo(source);
            }

            public RunningServiceInfo[] newArray(int size) {
                return new RunningServiceInfo[size];
            }
        };

        public RunningServiceInfo() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            ComponentName.writeToParcel(this.service, dest);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeString(this.process);
            dest.writeInt(this.foreground ? 1 : 0);
            dest.writeLong(this.activeSince);
            dest.writeInt(this.started ? 1 : 0);
            dest.writeInt(this.clientCount);
            dest.writeInt(this.crashCount);
            dest.writeLong(this.lastActivityTime);
            dest.writeLong(this.restarting);
            dest.writeInt(this.flags);
            dest.writeString(this.clientPackage);
            dest.writeInt(this.clientLabel);
        }

        public void readFromParcel(Parcel source) {
            this.service = ComponentName.readFromParcel(source);
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.process = source.readString();
            this.foreground = source.readInt() != 0;
            this.activeSince = source.readLong();
            this.started = source.readInt() != 0;
            this.clientCount = source.readInt();
            this.crashCount = source.readInt();
            this.lastActivityTime = source.readLong();
            this.restarting = source.readLong();
            this.flags = source.readInt();
            this.clientPackage = source.readString();
            this.clientLabel = source.readInt();
        }

        private RunningServiceInfo(Parcel source) {
            this.readFromParcel(source);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MoveTaskFlags {
    }

    public static class RunningTaskInfo
    extends TaskInfo
    implements Parcelable {
        @Deprecated
        public int id;
        @Deprecated
        public Bitmap thumbnail;
        @Deprecated
        public CharSequence description;
        @Deprecated
        public int numRunning;
        public static final Parcelable.Creator<RunningTaskInfo> CREATOR = new Parcelable.Creator<RunningTaskInfo>(){

            @Override
            public RunningTaskInfo createFromParcel(Parcel source) {
                return new RunningTaskInfo(source);
            }

            public RunningTaskInfo[] newArray(int size) {
                return new RunningTaskInfo[size];
            }
        };

        public RunningTaskInfo() {
        }

        private RunningTaskInfo(Parcel source) {
            this.readFromParcel(source);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void readFromParcel(Parcel source) {
            this.id = source.readInt();
            super.readFromParcel(source);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            super.writeToParcel(dest, flags);
        }
    }

    public static class RecentTaskInfo
    extends TaskInfo
    implements Parcelable {
        @Deprecated
        public int id;
        @Deprecated
        public int persistentId;
        @Deprecated
        public CharSequence description;
        @Deprecated
        public int affiliatedTaskId;
        public ArrayList<RecentTaskInfo> childrenTaskInfos = new ArrayList();
        public PersistedTaskSnapshotData lastSnapshotData = new PersistedTaskSnapshotData();
        public static final Parcelable.Creator<RecentTaskInfo> CREATOR = new Parcelable.Creator<RecentTaskInfo>(){

            @Override
            public RecentTaskInfo createFromParcel(Parcel source) {
                return new RecentTaskInfo(source);
            }

            public RecentTaskInfo[] newArray(int size) {
                return new RecentTaskInfo[size];
            }
        };

        public RecentTaskInfo() {
        }

        private RecentTaskInfo(Parcel source) {
            this.readFromParcel(source);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void readFromParcel(Parcel source) {
            this.id = source.readInt();
            this.persistentId = source.readInt();
            this.childrenTaskInfos = source.readArrayList(RecentTaskInfo.class.getClassLoader(), RecentTaskInfo.class);
            this.lastSnapshotData.taskSize = source.readTypedObject(Point.CREATOR);
            this.lastSnapshotData.contentInsets = source.readTypedObject(Rect.CREATOR);
            this.lastSnapshotData.bufferSize = source.readTypedObject(Point.CREATOR);
            super.readFromParcel(source);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeInt(this.persistentId);
            dest.writeList(this.childrenTaskInfos);
            dest.writeTypedObject(this.lastSnapshotData.taskSize, flags);
            dest.writeTypedObject(this.lastSnapshotData.contentInsets, flags);
            dest.writeTypedObject(this.lastSnapshotData.bufferSize, flags);
            super.writeToParcel(dest, flags);
        }

        public void dump(PrintWriter pw, String indent) {
            pw.println();
            pw.print("   ");
            pw.print(" id=");
            pw.print(this.persistentId);
            pw.print(" userId=");
            pw.print(this.userId);
            pw.print(" hasTask=");
            pw.print(this.id != -1);
            pw.print(" lastActiveTime=");
            pw.println(this.lastActiveTime);
            pw.print("   ");
            pw.print(" baseIntent=");
            pw.println(this.baseIntent);
            if (this.baseActivity != null) {
                pw.print("   ");
                pw.print(" baseActivity=");
                pw.println(this.baseActivity.toShortString());
            }
            if (this.topActivity != null) {
                pw.print("   ");
                pw.print(" topActivity=");
                pw.println(this.topActivity.toShortString());
            }
            if (this.origActivity != null) {
                pw.print("   ");
                pw.print(" origActivity=");
                pw.println(this.origActivity.toShortString());
            }
            if (this.realActivity != null) {
                pw.print("   ");
                pw.print(" realActivity=");
                pw.println(this.realActivity.toShortString());
            }
            pw.print("   ");
            pw.print(" isExcluded=");
            pw.print((this.baseIntent.getFlags() & 0x800000) != 0);
            pw.print(" activityType=");
            pw.print(WindowConfiguration.activityTypeToString(this.getActivityType()));
            pw.print(" windowingMode=");
            pw.print(WindowConfiguration.windowingModeToString(this.getWindowingMode()));
            pw.print(" supportsSplitScreenMultiWindow=");
            pw.print(this.supportsSplitScreenMultiWindow);
            pw.print(" supportsMultiWindow=");
            pw.println(this.supportsMultiWindow);
            if (this.taskDescription != null) {
                pw.print("   ");
                TaskDescription td = this.taskDescription;
                pw.print(" taskDescription {");
                pw.print(" colorBackground=#");
                pw.print(Integer.toHexString(td.getBackgroundColor()));
                pw.print(" colorPrimary=#");
                pw.print(Integer.toHexString(td.getPrimaryColor()));
                pw.print(" iconRes=");
                pw.print(td.getIconResourcePackage() + "/" + td.getIconResource());
                pw.print(" iconBitmap=");
                pw.print(td.getIconFilename() != null || td.getInMemoryIcon() != null);
                pw.print(" resizeMode=");
                pw.print(ActivityInfo.resizeModeToString(td.getResizeMode()));
                pw.print(" minWidth=");
                pw.print(td.getMinWidth());
                pw.print(" minHeight=");
                pw.print(td.getMinHeight());
                pw.print(" colorBackgroundFloating=#");
                pw.print(Integer.toHexString(td.getBackgroundColorFloating()));
                pw.println(" }");
            }
            pw.print("   ");
            pw.print(" lastSnapshotData {");
            pw.print(" taskSize=" + this.lastSnapshotData.taskSize);
            pw.print(" contentInsets=" + this.lastSnapshotData.contentInsets);
            pw.print(" bufferSize=" + this.lastSnapshotData.bufferSize);
            pw.println(" }");
        }

        public static class PersistedTaskSnapshotData {
            public Point taskSize;
            public Rect contentInsets;
            public Point bufferSize;

            public void set(PersistedTaskSnapshotData other) {
                this.taskSize = other.taskSize;
                this.contentInsets = other.contentInsets;
                this.bufferSize = other.bufferSize;
            }

            public void set(TaskSnapshot snapshot) {
                if (snapshot == null) {
                    this.taskSize = null;
                    this.contentInsets = null;
                    this.bufferSize = null;
                    return;
                }
                HardwareBuffer buffer = snapshot.getHardwareBuffer();
                this.taskSize = new Point(snapshot.getTaskSize());
                this.contentInsets = new Rect(snapshot.getContentInsets());
                this.bufferSize = buffer != null ? new Point(buffer.getWidth(), buffer.getHeight()) : null;
            }
        }
    }

    public static class TaskDescription
    implements Parcelable {
        public static final String ATTR_TASKDESCRIPTION_PREFIX = "task_description_";
        private static final String ATTR_TASKDESCRIPTIONLABEL = "task_description_label";
        private static final String ATTR_TASKDESCRIPTIONCOLOR_PRIMARY = "task_description_color";
        private static final String ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND = "task_description_color_background";
        private static final String ATTR_TASKDESCRIPTIONICON_FILENAME = "task_description_icon_filename";
        private static final String ATTR_TASKDESCRIPTIONICON_RESOURCE = "task_description_icon_resource";
        private static final String ATTR_TASKDESCRIPTIONICON_RESOURCE_PACKAGE = "task_description_icon_package";
        private static final String ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND_FLOATING = "task_description_color_background_floating";
        private String mLabel;
        private Icon mIcon;
        private String mIconFilename;
        private int mColorPrimary;
        private int mColorBackground;
        private int mColorBackgroundFloating;
        private int mStatusBarColor;
        private int mNavigationBarColor;
        private boolean mEnsureStatusBarContrastWhenTransparent;
        private boolean mEnsureNavigationBarContrastWhenTransparent;
        private int mResizeMode;
        private int mMinWidth;
        private int mMinHeight;
        public static final Parcelable.Creator<TaskDescription> CREATOR = new Parcelable.Creator<TaskDescription>(){

            @Override
            public TaskDescription createFromParcel(Parcel source) {
                return new TaskDescription(source);
            }

            public TaskDescription[] newArray(int size) {
                return new TaskDescription[size];
            }
        };

        @Deprecated
        public TaskDescription(String label, int iconRes, int colorPrimary) {
            this(label, Icon.createWithResource(ActivityThread.currentPackageName(), iconRes), colorPrimary, 0, 0, 0, false, false, 2, -1, -1, 0);
            if (colorPrimary != 0 && Color.alpha(colorPrimary) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
        }

        @Deprecated
        public TaskDescription(String label, int iconRes) {
            this(label, Icon.createWithResource(ActivityThread.currentPackageName(), iconRes), 0, 0, 0, 0, false, false, 2, -1, -1, 0);
        }

        @Deprecated
        public TaskDescription(String label) {
            this(label, null, 0, 0, 0, 0, false, false, 2, -1, -1, 0);
        }

        @Deprecated
        public TaskDescription() {
            this(null, null, 0, 0, 0, 0, false, false, 2, -1, -1, 0);
        }

        @Deprecated
        public TaskDescription(String label, Bitmap icon, int colorPrimary) {
            this(label, icon != null ? Icon.createWithBitmap(icon) : null, colorPrimary, 0, 0, 0, false, false, 2, -1, -1, 0);
            if (colorPrimary != 0 && Color.alpha(colorPrimary) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
        }

        @Deprecated
        public TaskDescription(String label, Bitmap icon) {
            this(label, icon != null ? Icon.createWithBitmap(icon) : null, 0, 0, 0, 0, false, false, 2, -1, -1, 0);
        }

        public TaskDescription(String label, Icon icon, int colorPrimary, int colorBackground, int statusBarColor, int navigationBarColor, boolean ensureStatusBarContrastWhenTransparent, boolean ensureNavigationBarContrastWhenTransparent, int resizeMode, int minWidth, int minHeight, int colorBackgroundFloating) {
            this.mLabel = label;
            this.mIcon = icon;
            this.mColorPrimary = colorPrimary;
            this.mColorBackground = colorBackground;
            this.mStatusBarColor = statusBarColor;
            this.mNavigationBarColor = navigationBarColor;
            this.mEnsureStatusBarContrastWhenTransparent = ensureStatusBarContrastWhenTransparent;
            this.mEnsureNavigationBarContrastWhenTransparent = ensureNavigationBarContrastWhenTransparent;
            this.mResizeMode = resizeMode;
            this.mMinWidth = minWidth;
            this.mMinHeight = minHeight;
            this.mColorBackgroundFloating = colorBackgroundFloating;
        }

        public TaskDescription(TaskDescription td) {
            this.copyFrom(td);
        }

        public void copyFrom(TaskDescription other) {
            this.mLabel = other.mLabel;
            this.mIcon = other.mIcon;
            this.mIconFilename = other.mIconFilename;
            this.mColorPrimary = other.mColorPrimary;
            this.mColorBackground = other.mColorBackground;
            this.mStatusBarColor = other.mStatusBarColor;
            this.mNavigationBarColor = other.mNavigationBarColor;
            this.mEnsureStatusBarContrastWhenTransparent = other.mEnsureStatusBarContrastWhenTransparent;
            this.mEnsureNavigationBarContrastWhenTransparent = other.mEnsureNavigationBarContrastWhenTransparent;
            this.mResizeMode = other.mResizeMode;
            this.mMinWidth = other.mMinWidth;
            this.mMinHeight = other.mMinHeight;
            this.mColorBackgroundFloating = other.mColorBackgroundFloating;
        }

        public void copyFromPreserveHiddenFields(TaskDescription other) {
            this.mLabel = other.mLabel;
            this.mIcon = other.mIcon;
            this.mIconFilename = other.mIconFilename;
            this.mColorPrimary = other.mColorPrimary;
            if (other.mColorBackground != 0) {
                this.mColorBackground = other.mColorBackground;
            }
            if (other.mStatusBarColor != 0) {
                this.mStatusBarColor = other.mStatusBarColor;
            }
            if (other.mNavigationBarColor != 0) {
                this.mNavigationBarColor = other.mNavigationBarColor;
            }
            this.mEnsureStatusBarContrastWhenTransparent = other.mEnsureStatusBarContrastWhenTransparent;
            this.mEnsureNavigationBarContrastWhenTransparent = other.mEnsureNavigationBarContrastWhenTransparent;
            if (other.mResizeMode != 2) {
                this.mResizeMode = other.mResizeMode;
            }
            if (other.mMinWidth != -1) {
                this.mMinWidth = other.mMinWidth;
            }
            if (other.mMinHeight != -1) {
                this.mMinHeight = other.mMinHeight;
            }
            if (other.mColorBackgroundFloating != 0) {
                this.mColorBackgroundFloating = other.mColorBackgroundFloating;
            }
        }

        private TaskDescription(Parcel source) {
            this.readFromParcel(source);
        }

        public void setLabel(String label) {
            this.mLabel = label;
        }

        public void setPrimaryColor(int primaryColor) {
            if (primaryColor != 0 && Color.alpha(primaryColor) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
            this.mColorPrimary = primaryColor;
        }

        public void setBackgroundColor(int backgroundColor) {
            if (backgroundColor != 0 && Color.alpha(backgroundColor) != 255) {
                throw new RuntimeException("A TaskDescription's background color should be opaque");
            }
            this.mColorBackground = backgroundColor;
        }

        public void setBackgroundColorFloating(int backgroundColor) {
            if (backgroundColor != 0 && Color.alpha(backgroundColor) != 255) {
                throw new RuntimeException("A TaskDescription's background color floating should be opaque");
            }
            this.mColorBackgroundFloating = backgroundColor;
        }

        public void setStatusBarColor(int statusBarColor) {
            this.mStatusBarColor = statusBarColor;
        }

        public void setNavigationBarColor(int navigationBarColor) {
            this.mNavigationBarColor = navigationBarColor;
        }

        public void setIcon(Icon icon) {
            this.mIcon = icon;
        }

        public void setIconFilename(String iconFilename) {
            this.mIconFilename = iconFilename;
            if (iconFilename != null) {
                this.mIcon = null;
            }
        }

        public void setResizeMode(int resizeMode) {
            this.mResizeMode = resizeMode;
        }

        public void setMinWidth(int minWidth) {
            this.mMinWidth = minWidth;
        }

        public void setMinHeight(int minHeight) {
            this.mMinHeight = minHeight;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public Icon loadIcon() {
            if (this.mIcon != null) {
                return this.mIcon;
            }
            Bitmap loadedIcon = TaskDescription.loadTaskDescriptionIcon(this.mIconFilename, UserHandle.myUserId());
            if (loadedIcon != null) {
                return Icon.createWithBitmap(loadedIcon);
            }
            return null;
        }

        @Deprecated
        public Bitmap getIcon() {
            Bitmap icon = this.getInMemoryIcon();
            if (icon != null) {
                return icon;
            }
            return TaskDescription.loadTaskDescriptionIcon(this.mIconFilename, UserHandle.myUserId());
        }

        public Icon getRawIcon() {
            return this.mIcon;
        }

        public String getIconResourcePackage() {
            if (this.mIcon != null && this.mIcon.getType() == 2) {
                return this.mIcon.getResPackage();
            }
            return "";
        }

        public int getIconResource() {
            if (this.mIcon != null && this.mIcon.getType() == 2) {
                return this.mIcon.getResId();
            }
            return 0;
        }

        public String getIconFilename() {
            return this.mIconFilename;
        }

        @UnsupportedAppUsage
        public Bitmap getInMemoryIcon() {
            if (this.mIcon != null && this.mIcon.getType() == 1) {
                return this.mIcon.getBitmap();
            }
            return null;
        }

        @UnsupportedAppUsage
        public static Bitmap loadTaskDescriptionIcon(String iconFilename, int userId) {
            if (iconFilename != null) {
                try {
                    return ActivityManager.getTaskService().getTaskDescriptionIcon(iconFilename, userId);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return null;
        }

        public int getPrimaryColor() {
            return this.mColorPrimary;
        }

        public int getBackgroundColor() {
            return this.mColorBackground;
        }

        public int getBackgroundColorFloating() {
            return this.mColorBackgroundFloating;
        }

        public int getStatusBarColor() {
            return this.mStatusBarColor;
        }

        public int getNavigationBarColor() {
            return this.mNavigationBarColor;
        }

        public boolean getEnsureStatusBarContrastWhenTransparent() {
            return this.mEnsureStatusBarContrastWhenTransparent;
        }

        public void setEnsureStatusBarContrastWhenTransparent(boolean ensureStatusBarContrastWhenTransparent) {
            this.mEnsureStatusBarContrastWhenTransparent = ensureStatusBarContrastWhenTransparent;
        }

        public boolean getEnsureNavigationBarContrastWhenTransparent() {
            return this.mEnsureNavigationBarContrastWhenTransparent;
        }

        public void setEnsureNavigationBarContrastWhenTransparent(boolean ensureNavigationBarContrastWhenTransparent) {
            this.mEnsureNavigationBarContrastWhenTransparent = ensureNavigationBarContrastWhenTransparent;
        }

        public int getResizeMode() {
            return this.mResizeMode;
        }

        public int getMinWidth() {
            return this.mMinWidth;
        }

        public int getMinHeight() {
            return this.mMinHeight;
        }

        public void saveToXml(TypedXmlSerializer out) throws IOException {
            if (this.mLabel != null) {
                out.attribute(null, ATTR_TASKDESCRIPTIONLABEL, this.mLabel);
            }
            if (this.mColorPrimary != 0) {
                out.attributeIntHex(null, ATTR_TASKDESCRIPTIONCOLOR_PRIMARY, this.mColorPrimary);
            }
            if (this.mColorBackground != 0) {
                out.attributeIntHex(null, ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND, this.mColorBackground);
            }
            if (this.mColorBackgroundFloating != 0) {
                out.attributeIntHex(null, ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND_FLOATING, this.mColorBackgroundFloating);
            }
            if (this.mIconFilename != null) {
                out.attribute(null, ATTR_TASKDESCRIPTIONICON_FILENAME, this.mIconFilename);
            }
            if (this.mIcon != null && this.mIcon.getType() == 2) {
                out.attributeInt(null, ATTR_TASKDESCRIPTIONICON_RESOURCE, this.mIcon.getResId());
                out.attribute(null, ATTR_TASKDESCRIPTIONICON_RESOURCE_PACKAGE, this.mIcon.getResPackage());
            }
        }

        public void restoreFromXml(TypedXmlPullParser in) {
            String iconFilename;
            int colorBackgroundFloating;
            int colorBackground;
            int colorPrimary;
            String label = in.getAttributeValue(null, ATTR_TASKDESCRIPTIONLABEL);
            if (label != null) {
                this.setLabel(label);
            }
            if ((colorPrimary = in.getAttributeIntHex(null, ATTR_TASKDESCRIPTIONCOLOR_PRIMARY, 0)) != 0) {
                this.setPrimaryColor(colorPrimary);
            }
            if ((colorBackground = in.getAttributeIntHex(null, ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND, 0)) != 0) {
                this.setBackgroundColor(colorBackground);
            }
            if ((colorBackgroundFloating = in.getAttributeIntHex(null, ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND_FLOATING, 0)) != 0) {
                this.setBackgroundColorFloating(colorBackgroundFloating);
            }
            if ((iconFilename = in.getAttributeValue(null, ATTR_TASKDESCRIPTIONICON_FILENAME)) != null) {
                this.setIconFilename(iconFilename);
            }
            int iconResourceId = in.getAttributeInt(null, ATTR_TASKDESCRIPTIONICON_RESOURCE, 0);
            String iconResourcePackage = in.getAttributeValue(null, ATTR_TASKDESCRIPTIONICON_RESOURCE_PACKAGE);
            if (iconResourceId != 0 && iconResourcePackage != null) {
                this.setIcon(Icon.createWithResource(iconResourcePackage, iconResourceId));
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mLabel == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(this.mLabel);
            }
            Bitmap bitmapIcon = this.getInMemoryIcon();
            if (this.mIcon == null || bitmapIcon != null && bitmapIcon.isRecycled()) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                this.mIcon.writeToParcel(dest, 0);
            }
            dest.writeInt(this.mColorPrimary);
            dest.writeInt(this.mColorBackground);
            dest.writeInt(this.mStatusBarColor);
            dest.writeInt(this.mNavigationBarColor);
            dest.writeBoolean(this.mEnsureStatusBarContrastWhenTransparent);
            dest.writeBoolean(this.mEnsureNavigationBarContrastWhenTransparent);
            dest.writeInt(this.mResizeMode);
            dest.writeInt(this.mMinWidth);
            dest.writeInt(this.mMinHeight);
            if (this.mIconFilename == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(this.mIconFilename);
            }
            dest.writeInt(this.mColorBackgroundFloating);
        }

        public void readFromParcel(Parcel source) {
            String string2 = this.mLabel = source.readInt() > 0 ? source.readString() : null;
            if (source.readInt() > 0) {
                this.mIcon = Icon.CREATOR.createFromParcel(source);
            }
            this.mColorPrimary = source.readInt();
            this.mColorBackground = source.readInt();
            this.mStatusBarColor = source.readInt();
            this.mNavigationBarColor = source.readInt();
            this.mEnsureStatusBarContrastWhenTransparent = source.readBoolean();
            this.mEnsureNavigationBarContrastWhenTransparent = source.readBoolean();
            this.mResizeMode = source.readInt();
            this.mMinWidth = source.readInt();
            this.mMinHeight = source.readInt();
            this.mIconFilename = source.readInt() > 0 ? source.readString() : null;
            this.mColorBackgroundFloating = source.readInt();
        }

        public String toString() {
            return "TaskDescription Label: " + this.mLabel + " Icon: " + this.mIcon + " IconFilename: " + this.mIconFilename + " colorPrimary: " + this.mColorPrimary + " colorBackground: " + this.mColorBackground + " statusBarColor: " + this.mStatusBarColor + (this.mEnsureStatusBarContrastWhenTransparent ? " (contrast when transparent)" : "") + " navigationBarColor: " + this.mNavigationBarColor + (this.mEnsureNavigationBarContrastWhenTransparent ? " (contrast when transparent)" : "") + " resizeMode: " + ActivityInfo.resizeModeToString(this.mResizeMode) + " minWidth: " + this.mMinWidth + " minHeight: " + this.mMinHeight + " colorBackgrounFloating: " + this.mColorBackgroundFloating;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskDescription)) {
                return false;
            }
            TaskDescription other = (TaskDescription)obj;
            return TextUtils.equals(this.mLabel, other.mLabel) && TextUtils.equals(this.mIconFilename, other.mIconFilename) && this.mIcon == other.mIcon && this.mColorPrimary == other.mColorPrimary && this.mColorBackground == other.mColorBackground && this.mStatusBarColor == other.mStatusBarColor && this.mNavigationBarColor == other.mNavigationBarColor && this.mEnsureStatusBarContrastWhenTransparent == other.mEnsureStatusBarContrastWhenTransparent && this.mEnsureNavigationBarContrastWhenTransparent == other.mEnsureNavigationBarContrastWhenTransparent && this.mResizeMode == other.mResizeMode && this.mMinWidth == other.mMinWidth && this.mMinHeight == other.mMinHeight && this.mColorBackgroundFloating == other.mColorBackgroundFloating;
        }

        public static boolean equals(TaskDescription td1, TaskDescription td2) {
            if (td1 == null && td2 == null) {
                return true;
            }
            if (td1 != null && td2 != null) {
                return td1.equals(td2);
            }
            return false;
        }

        public static class Builder {
            private String mLabel = null;
            private int mIconRes = 0;
            private int mPrimaryColor = 0;
            private int mBackgroundColor = 0;
            private int mStatusBarColor = 0;
            private int mNavigationBarColor = 0;

            public Builder setLabel(String label) {
                this.mLabel = label;
                return this;
            }

            public Builder setIcon(int iconRes) {
                this.mIconRes = iconRes;
                return this;
            }

            public Builder setPrimaryColor(int color2) {
                this.mPrimaryColor = color2;
                return this;
            }

            public Builder setBackgroundColor(int color2) {
                this.mBackgroundColor = color2;
                return this;
            }

            public Builder setStatusBarColor(int color2) {
                this.mStatusBarColor = color2;
                return this;
            }

            public Builder setNavigationBarColor(int color2) {
                this.mNavigationBarColor = color2;
                return this;
            }

            public TaskDescription build() {
                Icon icon = this.mIconRes == 0 ? null : Icon.createWithResource(ActivityThread.currentPackageName(), this.mIconRes);
                return new TaskDescription(this.mLabel, icon, this.mPrimaryColor, this.mBackgroundColor, this.mStatusBarColor, this.mNavigationBarColor, false, false, 2, -1, -1, 0);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RestrictionLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProcessCapability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProcessState {
    }

    static class UidObserver
    extends IUidObserver.Stub {
        final OnUidImportanceListener mListener;
        final Context mContext;

        UidObserver(OnUidImportanceListener listener, Context clientContext) {
            this.mListener = listener;
            this.mContext = clientContext;
        }

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq, int capability) {
            this.mListener.onUidImportance(uid, RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext));
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            this.mListener.onUidImportance(uid, 1000);
        }

        @Override
        public void onUidActive(int uid) {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }

        @Override
        public void onUidProcAdjChanged(int uid) {
        }
    }
}

