/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.SharedElementCallback;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionSet;
import android.transition.Visibility;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.view.GhostView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ImageView;
import com.android.internal.view.OneShotPreDrawListener;
import java.util.ArrayList;
import java.util.Collection;

abstract class ActivityTransitionCoordinator
extends ResultReceiver {
    private static final String TAG = "ActivityTransitionCoordinator";
    static final String KEY_REMOTE_RECEIVER = "android:remoteReceiver";
    protected static final String KEY_SCREEN_LEFT = "shared_element:screenLeft";
    protected static final String KEY_SCREEN_TOP = "shared_element:screenTop";
    protected static final String KEY_SCREEN_RIGHT = "shared_element:screenRight";
    protected static final String KEY_SCREEN_BOTTOM = "shared_element:screenBottom";
    protected static final String KEY_TRANSLATION_Z = "shared_element:translationZ";
    protected static final String KEY_SNAPSHOT = "shared_element:bitmap";
    protected static final String KEY_SCALE_TYPE = "shared_element:scaleType";
    protected static final String KEY_IMAGE_MATRIX = "shared_element:imageMatrix";
    protected static final String KEY_ELEVATION = "shared_element:elevation";
    protected static final ImageView.ScaleType[] SCALE_TYPE_VALUES = ImageView.ScaleType.values();
    public static final int MSG_SET_REMOTE_RECEIVER = 100;
    public static final int MSG_HIDE_SHARED_ELEMENTS = 101;
    public static final int MSG_TAKE_SHARED_ELEMENTS = 103;
    public static final int MSG_EXIT_TRANSITION_COMPLETE = 104;
    public static final int MSG_START_EXIT_TRANSITION = 105;
    public static final int MSG_CANCEL = 106;
    public static final int MSG_SHARED_ELEMENT_DESTINATION = 107;
    public static final int MSG_ALLOW_RETURN_TRANSITION = 108;
    private Window mWindow;
    protected final ArrayList<String> mAllSharedElementNames;
    protected final ArrayList<View> mSharedElements = new ArrayList();
    protected final ArrayList<String> mSharedElementNames = new ArrayList();
    protected ArrayList<View> mTransitioningViews = new ArrayList();
    protected SharedElementCallback mListener;
    protected ResultReceiver mResultReceiver;
    private final FixedEpicenterCallback mEpicenterCallback = new FixedEpicenterCallback();
    protected final boolean mIsReturning;
    private Runnable mPendingTransition;
    private boolean mIsStartingTransition;
    private ArrayList<GhostViewListeners> mGhostViewListeners = new ArrayList();
    private ArrayMap<View, Float> mOriginalAlphas = new ArrayMap();
    private ArrayList<Matrix> mSharedElementParentMatrices;
    private boolean mSharedElementTransitionComplete;
    private boolean mViewsTransitionComplete;
    private boolean mBackgroundAnimatorComplete;
    private ArrayList<View> mStrippedTransitioningViews = new ArrayList();

    public ActivityTransitionCoordinator(Window window, ArrayList<String> allSharedElementNames, SharedElementCallback listener, boolean isReturning) {
        super(new Handler());
        this.mWindow = window;
        this.mListener = listener;
        this.mAllSharedElementNames = allSharedElementNames;
        this.mIsReturning = isReturning;
    }

    protected void viewsReady(ArrayMap<String, View> sharedElements) {
        sharedElements.retainAll(this.mAllSharedElementNames);
        if (this.mListener != null) {
            this.mListener.onMapSharedElements(this.mAllSharedElementNames, sharedElements);
        }
        this.setSharedElements(sharedElements);
        if (this.getViewsTransition() != null && this.mTransitioningViews != null) {
            ViewGroup decorView = this.getDecor();
            if (decorView != null) {
                decorView.captureTransitioningViews(this.mTransitioningViews);
            }
            this.mTransitioningViews.removeAll(this.mSharedElements);
        }
        this.setEpicenter();
    }

    private void setSharedElements(ArrayMap<String, View> sharedElements) {
        boolean isFirstRun = true;
        while (!sharedElements.isEmpty()) {
            int numSharedElements = sharedElements.size();
            for (int i = numSharedElements - 1; i >= 0; --i) {
                View view = sharedElements.valueAt(i);
                String name = sharedElements.keyAt(i);
                if (isFirstRun && (view == null || !view.isAttachedToWindow() || name == null)) {
                    sharedElements.removeAt(i);
                    continue;
                }
                if (ActivityTransitionCoordinator.isNested(view, sharedElements)) continue;
                this.mSharedElementNames.add(name);
                this.mSharedElements.add(view);
                sharedElements.removeAt(i);
            }
            isFirstRun = false;
        }
    }

    private static boolean isNested(View view, ArrayMap<String, View> sharedElements) {
        ViewParent parent = view.getParent();
        boolean isNested = false;
        while (parent instanceof View) {
            View parentView = (View)((Object)parent);
            if (sharedElements.containsValue(parentView)) {
                isNested = true;
                break;
            }
            parent = parentView.getParent();
        }
        return isNested;
    }

    protected void stripOffscreenViews() {
        if (this.mTransitioningViews == null) {
            return;
        }
        Rect r = new Rect();
        for (int i = this.mTransitioningViews.size() - 1; i >= 0; --i) {
            View view = this.mTransitioningViews.get(i);
            if (view.getGlobalVisibleRect(r)) continue;
            this.mTransitioningViews.remove(i);
            this.mStrippedTransitioningViews.add(view);
        }
    }

    protected Window getWindow() {
        return this.mWindow;
    }

    public ViewGroup getDecor() {
        return this.mWindow == null ? null : (ViewGroup)this.mWindow.getDecorView();
    }

    protected void setEpicenter() {
        int index;
        View epicenter = null;
        if (!this.mAllSharedElementNames.isEmpty() && !this.mSharedElementNames.isEmpty() && (index = this.mSharedElementNames.indexOf(this.mAllSharedElementNames.get(0))) >= 0) {
            epicenter = this.mSharedElements.get(index);
        }
        this.setEpicenter(epicenter);
    }

    private void setEpicenter(View view) {
        if (view == null) {
            this.mEpicenterCallback.setEpicenter(null);
        } else {
            Rect epicenter = new Rect();
            view.getBoundsOnScreen(epicenter);
            this.mEpicenterCallback.setEpicenter(epicenter);
        }
    }

    public ArrayList<String> getAcceptedNames() {
        return this.mSharedElementNames;
    }

    public ArrayList<String> getMappedNames() {
        ArrayList<String> names = new ArrayList<String>(this.mSharedElements.size());
        for (int i = 0; i < this.mSharedElements.size(); ++i) {
            names.add(this.mSharedElements.get(i).getTransitionName());
        }
        return names;
    }

    public ArrayList<View> copyMappedViews() {
        return new ArrayList<View>(this.mSharedElements);
    }

    protected Transition setTargets(Transition transition2, boolean add) {
        View view;
        int i;
        if (transition2 == null || add && (this.mTransitioningViews == null || this.mTransitioningViews.isEmpty())) {
            return null;
        }
        TransitionSet set = new TransitionSet();
        if (this.mTransitioningViews != null) {
            for (i = this.mTransitioningViews.size() - 1; i >= 0; --i) {
                view = this.mTransitioningViews.get(i);
                if (add) {
                    set.addTarget(view);
                    continue;
                }
                set.excludeTarget(view, true);
            }
        }
        if (this.mStrippedTransitioningViews != null) {
            for (i = this.mStrippedTransitioningViews.size() - 1; i >= 0; --i) {
                view = this.mStrippedTransitioningViews.get(i);
                set.excludeTarget(view, true);
            }
        }
        set.addTransition(transition2);
        if (!add && this.mTransitioningViews != null && !this.mTransitioningViews.isEmpty()) {
            set = new TransitionSet().addTransition(set);
        }
        return set;
    }

    protected Transition configureTransition(Transition transition2, boolean includeTransitioningViews) {
        if (transition2 != null) {
            transition2 = transition2.clone();
            transition2.setEpicenterCallback(this.mEpicenterCallback);
            transition2 = this.setTargets(transition2, includeTransitioningViews);
        }
        ActivityTransitionCoordinator.noLayoutSuppressionForVisibilityTransitions(transition2);
        return transition2;
    }

    protected static void removeExcludedViews(Transition transition2, ArrayList<View> views) {
        ArraySet<View> included = new ArraySet<View>();
        ActivityTransitionCoordinator.findIncludedViews(transition2, views, included);
        views.clear();
        views.addAll(included);
    }

    private static void findIncludedViews(Transition transition2, ArrayList<View> views, ArraySet<View> included) {
        if (transition2 instanceof TransitionSet) {
            TransitionSet set = (TransitionSet)transition2;
            ArrayList<View> includedViews = new ArrayList<View>();
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                View view = views.get(i);
                if (!transition2.isValidTarget(view)) continue;
                includedViews.add(view);
            }
            int count = set.getTransitionCount();
            for (int i = 0; i < count; ++i) {
                ActivityTransitionCoordinator.findIncludedViews(set.getTransitionAt(i), includedViews, included);
            }
        } else {
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                View view = views.get(i);
                if (!transition2.isValidTarget(view)) continue;
                included.add(view);
            }
        }
    }

    protected static Transition mergeTransitions(Transition transition1, Transition transition2) {
        if (transition1 == null) {
            return transition2;
        }
        if (transition2 == null) {
            return transition1;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition1);
        transitionSet.addTransition(transition2);
        return transitionSet;
    }

    protected ArrayMap<String, View> mapSharedElements(ArrayList<String> accepted, ArrayList<View> localViews) {
        ArrayMap<String, View> sharedElements = new ArrayMap<String, View>();
        if (accepted != null) {
            for (int i = 0; i < accepted.size(); ++i) {
                sharedElements.put(accepted.get(i), localViews.get(i));
            }
        } else {
            ViewGroup decorView = this.getDecor();
            if (decorView != null) {
                decorView.findNamedViews(sharedElements);
            }
        }
        return sharedElements;
    }

    protected void setResultReceiver(ResultReceiver resultReceiver) {
        this.mResultReceiver = resultReceiver;
    }

    protected abstract Transition getViewsTransition();

    private void setSharedElementState(View view, String name, Bundle transitionArgs, Matrix tempMatrix, RectF tempRect, int[] decorLoc) {
        int scaleTypeInt;
        Bundle sharedElementBundle = transitionArgs.getBundle(name);
        if (sharedElementBundle == null) {
            return;
        }
        if (view instanceof ImageView && (scaleTypeInt = sharedElementBundle.getInt(KEY_SCALE_TYPE, -1)) >= 0) {
            ImageView imageView = (ImageView)view;
            ImageView.ScaleType scaleType = SCALE_TYPE_VALUES[scaleTypeInt];
            imageView.setScaleType(scaleType);
            if (scaleType == ImageView.ScaleType.MATRIX) {
                float[] matrixValues = sharedElementBundle.getFloatArray(KEY_IMAGE_MATRIX);
                tempMatrix.setValues(matrixValues);
                imageView.setImageMatrix(tempMatrix);
            }
        }
        float z = sharedElementBundle.getFloat(KEY_TRANSLATION_Z);
        view.setTranslationZ(z);
        float elevation = sharedElementBundle.getFloat(KEY_ELEVATION);
        view.setElevation(elevation);
        float left = sharedElementBundle.getFloat(KEY_SCREEN_LEFT);
        float top = sharedElementBundle.getFloat(KEY_SCREEN_TOP);
        float right = sharedElementBundle.getFloat(KEY_SCREEN_RIGHT);
        float bottom = sharedElementBundle.getFloat(KEY_SCREEN_BOTTOM);
        if (decorLoc != null) {
            left -= (float)decorLoc[0];
            top -= (float)decorLoc[1];
            right -= (float)decorLoc[0];
            bottom -= (float)decorLoc[1];
        } else {
            this.getSharedElementParentMatrix(view, tempMatrix);
            tempRect.set(left, top, right, bottom);
            tempMatrix.mapRect(tempRect);
            float leftInParent = tempRect.left;
            float topInParent = tempRect.top;
            view.getInverseMatrix().mapRect(tempRect);
            float width = tempRect.width();
            float height = tempRect.height();
            view.setLeft(0);
            view.setTop(0);
            view.setRight(Math.round(width));
            view.setBottom(Math.round(height));
            tempRect.set(0.0f, 0.0f, width, height);
            view.getMatrix().mapRect(tempRect);
            left = leftInParent - tempRect.left;
            top = topInParent - tempRect.top;
            right = left + width;
            bottom = top + height;
        }
        int x = Math.round(left);
        int y = Math.round(top);
        int width = Math.round(right) - x;
        int height = Math.round(bottom) - y;
        int widthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
        view.measure(widthSpec, heightSpec);
        view.layout(x, y, x + width, y + height);
    }

    private void setSharedElementMatrices() {
        int numSharedElements = this.mSharedElements.size();
        if (numSharedElements > 0) {
            this.mSharedElementParentMatrices = new ArrayList(numSharedElements);
        }
        for (int i = 0; i < numSharedElements; ++i) {
            View view = this.mSharedElements.get(i);
            ViewGroup parent = (ViewGroup)view.getParent();
            Matrix matrix = new Matrix();
            if (parent != null) {
                parent.transformMatrixToLocal(matrix);
                matrix.postTranslate(parent.getScrollX(), parent.getScrollY());
            }
            this.mSharedElementParentMatrices.add(matrix);
        }
    }

    private void getSharedElementParentMatrix(View view, Matrix matrix) {
        int index;
        int n = index = this.mSharedElementParentMatrices == null ? -1 : this.mSharedElements.indexOf(view);
        if (index < 0) {
            matrix.reset();
            ViewParent viewParent = view.getParent();
            if (viewParent instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)viewParent;
                parent.transformMatrixToLocal(matrix);
                matrix.postTranslate(parent.getScrollX(), parent.getScrollY());
            }
        } else {
            Matrix parentMatrix = this.mSharedElementParentMatrices.get(index);
            matrix.set(parentMatrix);
        }
    }

    protected ArrayList<SharedElementOriginalState> setSharedElementState(Bundle sharedElementState, ArrayList<View> snapshots) {
        ArrayList<SharedElementOriginalState> originalImageState = new ArrayList<SharedElementOriginalState>();
        if (sharedElementState != null) {
            Matrix tempMatrix = new Matrix();
            RectF tempRect = new RectF();
            int numSharedElements = this.mSharedElements.size();
            for (int i = 0; i < numSharedElements; ++i) {
                View sharedElement = this.mSharedElements.get(i);
                String name = this.mSharedElementNames.get(i);
                SharedElementOriginalState originalState = ActivityTransitionCoordinator.getOldSharedElementState(sharedElement, name, sharedElementState);
                originalImageState.add(originalState);
                this.setSharedElementState(sharedElement, name, sharedElementState, tempMatrix, tempRect, null);
            }
        }
        if (this.mListener != null) {
            this.mListener.onSharedElementStart(this.mSharedElementNames, this.mSharedElements, snapshots);
        }
        return originalImageState;
    }

    protected void notifySharedElementEnd(ArrayList<View> snapshots) {
        if (this.mListener != null) {
            this.mListener.onSharedElementEnd(this.mSharedElementNames, this.mSharedElements, snapshots);
        }
    }

    protected void scheduleSetSharedElementEnd(ArrayList<View> snapshots) {
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            OneShotPreDrawListener.add(decorView, () -> this.notifySharedElementEnd(snapshots));
        }
    }

    private static SharedElementOriginalState getOldSharedElementState(View view, String name, Bundle transitionArgs) {
        SharedElementOriginalState state = new SharedElementOriginalState();
        state.mLeft = view.getLeft();
        state.mTop = view.getTop();
        state.mRight = view.getRight();
        state.mBottom = view.getBottom();
        state.mMeasuredWidth = view.getMeasuredWidth();
        state.mMeasuredHeight = view.getMeasuredHeight();
        state.mTranslationZ = view.getTranslationZ();
        state.mElevation = view.getElevation();
        if (!(view instanceof ImageView)) {
            return state;
        }
        Bundle bundle = transitionArgs.getBundle(name);
        if (bundle == null) {
            return state;
        }
        int scaleTypeInt = bundle.getInt(KEY_SCALE_TYPE, -1);
        if (scaleTypeInt < 0) {
            return state;
        }
        ImageView imageView = (ImageView)view;
        state.mScaleType = imageView.getScaleType();
        if (state.mScaleType == ImageView.ScaleType.MATRIX) {
            state.mMatrix = new Matrix(imageView.getImageMatrix());
        }
        return state;
    }

    protected ArrayList<View> createSnapshots(Bundle state, Collection<String> names) {
        int numSharedElements = names.size();
        ArrayList<View> snapshots = new ArrayList<View>(numSharedElements);
        if (numSharedElements == 0) {
            return snapshots;
        }
        Context context = this.getWindow().getContext();
        int[] decorLoc = new int[2];
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            decorView.getLocationOnScreen(decorLoc);
        }
        Matrix tempMatrix = new Matrix();
        for (String name : names) {
            Bundle sharedElementBundle = state.getBundle(name);
            View snapshot = null;
            if (sharedElementBundle != null) {
                Object parcelable = sharedElementBundle.getParcelable(KEY_SNAPSHOT);
                if (parcelable != null && this.mListener != null) {
                    snapshot = this.mListener.onCreateSnapshotView(context, (Parcelable)parcelable);
                }
                if (snapshot != null) {
                    this.setSharedElementState(snapshot, name, state, tempMatrix, null, decorLoc);
                }
            }
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    protected static void setOriginalSharedElementState(ArrayList<View> sharedElements, ArrayList<SharedElementOriginalState> originalState) {
        for (int i = 0; i < originalState.size(); ++i) {
            View view = sharedElements.get(i);
            SharedElementOriginalState state = originalState.get(i);
            if (view instanceof ImageView && state.mScaleType != null) {
                ImageView imageView = (ImageView)view;
                imageView.setScaleType(state.mScaleType);
                if (state.mScaleType == ImageView.ScaleType.MATRIX) {
                    imageView.setImageMatrix(state.mMatrix);
                }
            }
            view.setElevation(state.mElevation);
            view.setTranslationZ(state.mTranslationZ);
            int widthSpec = View.MeasureSpec.makeMeasureSpec(state.mMeasuredWidth, 0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec(state.mMeasuredHeight, 0x40000000);
            view.measure(widthSpec, heightSpec);
            view.layout(state.mLeft, state.mTop, state.mRight, state.mBottom);
        }
    }

    protected Bundle captureSharedElementState() {
        Bundle bundle = new Bundle();
        RectF tempBounds = new RectF();
        Matrix tempMatrix = new Matrix();
        for (int i = 0; i < this.mSharedElements.size(); ++i) {
            View sharedElement = this.mSharedElements.get(i);
            String name = this.mSharedElementNames.get(i);
            this.captureSharedElementState(sharedElement, name, bundle, tempMatrix, tempBounds);
        }
        return bundle;
    }

    protected void clearState() {
        this.mWindow = null;
        this.mSharedElements.clear();
        this.mTransitioningViews = null;
        this.mStrippedTransitioningViews = null;
        this.mOriginalAlphas.clear();
        this.mResultReceiver = null;
        this.mPendingTransition = null;
        this.mListener = null;
        this.mSharedElementParentMatrices = null;
    }

    protected long getFadeDuration() {
        return this.getWindow().getTransitionBackgroundFadeDuration();
    }

    protected void hideViews(ArrayList<View> views) {
        int count = views.size();
        for (int i = 0; i < count; ++i) {
            View view = views.get(i);
            if (!this.mOriginalAlphas.containsKey(view)) {
                this.mOriginalAlphas.put(view, Float.valueOf(view.getAlpha()));
            }
            view.setAlpha(0.0f);
        }
    }

    protected void showViews(ArrayList<View> views, boolean setTransitionAlpha) {
        int count = views.size();
        for (int i = 0; i < count; ++i) {
            this.showView(views.get(i), setTransitionAlpha);
        }
    }

    private void showView(View view, boolean setTransitionAlpha) {
        Float alpha = this.mOriginalAlphas.remove(view);
        if (alpha != null) {
            view.setAlpha(alpha.floatValue());
        }
        if (setTransitionAlpha) {
            view.setTransitionAlpha(1.0f);
        }
    }

    protected void captureSharedElementState(View view, String name, Bundle transitionArgs, Matrix tempMatrix, RectF tempBounds) {
        Bundle sharedElementBundle = new Bundle();
        tempMatrix.reset();
        view.transformMatrixToGlobal(tempMatrix);
        tempBounds.set(0.0f, 0.0f, view.getWidth(), view.getHeight());
        tempMatrix.mapRect(tempBounds);
        sharedElementBundle.putFloat(KEY_SCREEN_LEFT, tempBounds.left);
        sharedElementBundle.putFloat(KEY_SCREEN_RIGHT, tempBounds.right);
        sharedElementBundle.putFloat(KEY_SCREEN_TOP, tempBounds.top);
        sharedElementBundle.putFloat(KEY_SCREEN_BOTTOM, tempBounds.bottom);
        sharedElementBundle.putFloat(KEY_TRANSLATION_Z, view.getTranslationZ());
        sharedElementBundle.putFloat(KEY_ELEVATION, view.getElevation());
        Parcelable bitmap = null;
        if (this.mListener != null) {
            bitmap = this.mListener.onCaptureSharedElementSnapshot(view, tempMatrix, tempBounds);
        }
        if (bitmap != null) {
            sharedElementBundle.putParcelable(KEY_SNAPSHOT, bitmap);
        }
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            int scaleTypeInt = ActivityTransitionCoordinator.scaleTypeToInt(imageView.getScaleType());
            sharedElementBundle.putInt(KEY_SCALE_TYPE, scaleTypeInt);
            if (imageView.getScaleType() == ImageView.ScaleType.MATRIX) {
                float[] matrix = new float[9];
                imageView.getImageMatrix().getValues(matrix);
                sharedElementBundle.putFloatArray(KEY_IMAGE_MATRIX, matrix);
            }
        }
        transitionArgs.putBundle(name, sharedElementBundle);
    }

    protected void startTransition(Runnable runnable) {
        if (this.mIsStartingTransition) {
            this.mPendingTransition = runnable;
        } else {
            this.mIsStartingTransition = true;
            runnable.run();
        }
    }

    protected void transitionStarted() {
        this.mIsStartingTransition = false;
    }

    protected boolean cancelPendingTransitions() {
        this.mPendingTransition = null;
        return this.mIsStartingTransition;
    }

    protected void moveSharedElementsToOverlay() {
        if (this.mWindow == null || !this.mWindow.getSharedElementsUseOverlay()) {
            return;
        }
        this.setSharedElementMatrices();
        int numSharedElements = this.mSharedElements.size();
        ViewGroup decor = this.getDecor();
        if (decor != null) {
            boolean moveWithParent = this.moveSharedElementWithParent();
            Matrix tempMatrix = new Matrix();
            for (int i = 0; i < numSharedElements; ++i) {
                View view = this.mSharedElements.get(i);
                if (!view.isAttachedToWindow()) continue;
                tempMatrix.reset();
                this.mSharedElementParentMatrices.get(i).invert(tempMatrix);
                decor.transformMatrixToLocal(tempMatrix);
                GhostView.addGhost(view, decor, tempMatrix);
                ViewGroup parent = (ViewGroup)view.getParent();
                if (!moveWithParent || ActivityTransitionCoordinator.isInTransitionGroup(parent, decor)) continue;
                GhostViewListeners listener = new GhostViewListeners(view, parent, decor);
                parent.getViewTreeObserver().addOnPreDrawListener(listener);
                parent.addOnAttachStateChangeListener(listener);
                this.mGhostViewListeners.add(listener);
            }
        }
    }

    protected boolean moveSharedElementWithParent() {
        return true;
    }

    public static boolean isInTransitionGroup(ViewParent viewParent, ViewGroup decor) {
        if (viewParent == decor || !(viewParent instanceof ViewGroup)) {
            return false;
        }
        ViewGroup parent = (ViewGroup)viewParent;
        if (parent.isTransitionGroup()) {
            return true;
        }
        return ActivityTransitionCoordinator.isInTransitionGroup(parent.getParent(), decor);
    }

    protected void moveSharedElementsFromOverlay() {
        int numListeners = this.mGhostViewListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            GhostViewListeners listener = this.mGhostViewListeners.get(i);
            listener.removeListener();
        }
        this.mGhostViewListeners.clear();
        if (this.mWindow == null || !this.mWindow.getSharedElementsUseOverlay()) {
            return;
        }
        ViewGroup decor = this.getDecor();
        if (decor != null) {
            ViewGroupOverlay overlay = decor.getOverlay();
            int count = this.mSharedElements.size();
            for (int i = 0; i < count; ++i) {
                View sharedElement = this.mSharedElements.get(i);
                GhostView.removeGhost(sharedElement);
            }
        }
    }

    protected void setGhostVisibility(int visibility) {
        int numSharedElements = this.mSharedElements.size();
        for (int i = 0; i < numSharedElements; ++i) {
            GhostView ghostView = GhostView.getGhost(this.mSharedElements.get(i));
            if (ghostView == null) continue;
            ghostView.setVisibility(visibility);
        }
    }

    protected void scheduleGhostVisibilityChange(int visibility) {
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            OneShotPreDrawListener.add(decorView, () -> this.setGhostVisibility(visibility));
        }
    }

    protected boolean isViewsTransitionComplete() {
        return this.mViewsTransitionComplete;
    }

    protected void viewsTransitionComplete() {
        this.mViewsTransitionComplete = true;
        this.startInputWhenTransitionsComplete();
    }

    protected void backgroundAnimatorComplete() {
        this.mBackgroundAnimatorComplete = true;
    }

    protected void sharedElementTransitionComplete() {
        this.mSharedElementTransitionComplete = true;
        this.startInputWhenTransitionsComplete();
    }

    private void startInputWhenTransitionsComplete() {
        if (this.mViewsTransitionComplete && this.mSharedElementTransitionComplete) {
            ViewRootImpl viewRoot;
            ViewGroup decor = this.getDecor();
            if (decor != null && (viewRoot = decor.getViewRootImpl()) != null) {
                viewRoot.setPausedForTransition(false);
            }
            this.onTransitionsComplete();
        }
    }

    protected void pauseInput() {
        ViewRootImpl viewRoot;
        ViewGroup decor = this.getDecor();
        ViewRootImpl viewRootImpl = viewRoot = decor == null ? null : decor.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.setPausedForTransition(true);
        }
    }

    protected void onTransitionsComplete() {
    }

    private static int scaleTypeToInt(ImageView.ScaleType scaleType) {
        for (int i = 0; i < SCALE_TYPE_VALUES.length; ++i) {
            if (scaleType != SCALE_TYPE_VALUES[i]) continue;
            return i;
        }
        return -1;
    }

    protected void setTransitioningViewsVisiblity(int visiblity, boolean invalidate) {
        int numElements = this.mTransitioningViews == null ? 0 : this.mTransitioningViews.size();
        for (int i = 0; i < numElements; ++i) {
            View view = this.mTransitioningViews.get(i);
            if (invalidate) {
                view.setVisibility(visiblity);
                continue;
            }
            view.setTransitionVisibility(visiblity);
        }
    }

    private static void noLayoutSuppressionForVisibilityTransitions(Transition transition2) {
        if (transition2 instanceof Visibility) {
            Visibility visibility = (Visibility)transition2;
            visibility.setSuppressLayout(false);
        } else if (transition2 instanceof TransitionSet) {
            TransitionSet set = (TransitionSet)transition2;
            int count = set.getTransitionCount();
            for (int i = 0; i < count; ++i) {
                ActivityTransitionCoordinator.noLayoutSuppressionForVisibilityTransitions(set.getTransitionAt(i));
            }
        }
    }

    public boolean isTransitionRunning() {
        return !this.mViewsTransitionComplete || !this.mSharedElementTransitionComplete || !this.mBackgroundAnimatorComplete;
    }

    static class SharedElementOriginalState {
        int mLeft;
        int mTop;
        int mRight;
        int mBottom;
        int mMeasuredWidth;
        int mMeasuredHeight;
        ImageView.ScaleType mScaleType;
        Matrix mMatrix;
        float mTranslationZ;
        float mElevation;

        SharedElementOriginalState() {
        }
    }

    private static class GhostViewListeners
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        private View mView;
        private ViewGroup mDecor;
        private View mParent;
        private Matrix mMatrix = new Matrix();
        private ViewTreeObserver mViewTreeObserver;

        public GhostViewListeners(View view, View parent, ViewGroup decor) {
            this.mView = view;
            this.mParent = parent;
            this.mDecor = decor;
            this.mViewTreeObserver = parent.getViewTreeObserver();
        }

        public View getView() {
            return this.mView;
        }

        @Override
        public boolean onPreDraw() {
            GhostView ghostView = GhostView.getGhost(this.mView);
            if (ghostView == null || !this.mView.isAttachedToWindow()) {
                this.removeListener();
            } else {
                GhostView.calculateMatrix(this.mView, this.mDecor, this.mMatrix);
                ghostView.setMatrix(this.mMatrix);
            }
            return true;
        }

        public void removeListener() {
            if (this.mViewTreeObserver.isAlive()) {
                this.mViewTreeObserver.removeOnPreDrawListener(this);
            } else {
                this.mParent.getViewTreeObserver().removeOnPreDrawListener(this);
            }
            this.mParent.removeOnAttachStateChangeListener(this);
        }

        @Override
        public void onViewAttachedToWindow(View v) {
            this.mViewTreeObserver = v.getViewTreeObserver();
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            this.removeListener();
        }
    }

    private static class FixedEpicenterCallback
    extends Transition.EpicenterCallback {
        private Rect mEpicenter;

        private FixedEpicenterCallback() {
        }

        public void setEpicenter(Rect epicenter) {
            this.mEpicenter = epicenter;
        }

        @Override
        public Rect onGetEpicenter(Transition transition2) {
            return this.mEpicenter;
        }
    }

    protected class ContinueTransitionListener
    extends TransitionListenerAdapter {
        protected ContinueTransitionListener() {
        }

        @Override
        public void onTransitionStart(Transition transition2) {
            ActivityTransitionCoordinator.this.mIsStartingTransition = false;
            Runnable pending = ActivityTransitionCoordinator.this.mPendingTransition;
            ActivityTransitionCoordinator.this.mPendingTransition = null;
            if (pending != null) {
                ActivityTransitionCoordinator.this.startTransition(pending);
            }
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            transition2.removeListener(this);
        }
    }
}

