/*
 * Decompiled with CFR 0.152.
 */
package android.app.cloudsearch;

import android.app.cloudsearch.ICloudSearchManagerCallback;
import android.app.cloudsearch.SearchRequest;
import android.app.cloudsearch.SearchResponse;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICloudSearchManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.cloudsearch.ICloudSearchManager";

    public void search(SearchRequest var1, ICloudSearchManagerCallback var2) throws RemoteException;

    public void returnResults(IBinder var1, String var2, SearchResponse var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICloudSearchManager {
        static final int TRANSACTION_search = 1;
        static final int TRANSACTION_returnResults = 2;

        public Stub() {
            this.attachInterface(this, ICloudSearchManager.DESCRIPTOR);
        }

        public static ICloudSearchManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICloudSearchManager.DESCRIPTOR);
            if (iin != null && iin instanceof ICloudSearchManager) {
                return (ICloudSearchManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "search";
                }
                case 2: {
                    return "returnResults";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICloudSearchManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SearchRequest _arg0 = data.readTypedObject(SearchRequest.CREATOR);
                    ICloudSearchManagerCallback _arg1 = ICloudSearchManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.search(_arg0, _arg1);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    SearchResponse _arg2 = data.readTypedObject(SearchResponse.CREATOR);
                    data.enforceNoDataAvail();
                    this.returnResults(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ICloudSearchManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICloudSearchManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void search(SearchRequest request, ICloudSearchManagerCallback callBack) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICloudSearchManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callBack);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void returnResults(IBinder token, String requestId, SearchResponse response) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICloudSearchManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(requestId);
                    _data.writeTypedObject(response, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICloudSearchManager {
        @Override
        public void search(SearchRequest request, ICloudSearchManagerCallback callBack) throws RemoteException {
        }

        @Override
        public void returnResults(IBinder token, String requestId, SearchResponse response) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

