/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControlViewHost;

public interface IRemoteSdkCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.sdksandbox.IRemoteSdkCallback";

    public void onLoadSdkSuccess(IBinder var1, Bundle var2) throws RemoteException;

    public void onLoadSdkFailure(int var1, String var2) throws RemoteException;

    public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage var1, int var2, Bundle var3) throws RemoteException;

    public void onSurfacePackageError(int var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteSdkCallback {
        static final int TRANSACTION_onLoadSdkSuccess = 1;
        static final int TRANSACTION_onLoadSdkFailure = 2;
        static final int TRANSACTION_onSurfacePackageReady = 3;
        static final int TRANSACTION_onSurfacePackageError = 4;

        public Stub() {
            this.attachInterface(this, IRemoteSdkCallback.DESCRIPTOR);
        }

        public static IRemoteSdkCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteSdkCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteSdkCallback) {
                return (IRemoteSdkCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteSdkCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLoadSdkSuccess(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onLoadSdkFailure(_arg0, _arg1);
                    break;
                }
                case 3: {
                    SurfaceControlViewHost.SurfacePackage _arg0 = data.readTypedObject(SurfaceControlViewHost.SurfacePackage.CREATOR);
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSurfacePackageReady(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onSurfacePackageError(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IRemoteSdkCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteSdkCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLoadSdkSuccess(IBinder sdkToken, Bundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteSdkCallback.DESCRIPTOR);
                    _data.writeStrongBinder(sdkToken);
                    _data.writeTypedObject(params, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLoadSdkFailure(int errorCode, String errorMsg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteSdkCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMsg);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage surfacePackage, int surfacePackageId, Bundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteSdkCallback.DESCRIPTOR);
                    _data.writeTypedObject(surfacePackage, 0);
                    _data.writeInt(surfacePackageId);
                    _data.writeTypedObject(params, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSurfacePackageError(int errorCode, String errorMsg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteSdkCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMsg);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteSdkCallback {
        @Override
        public void onLoadSdkSuccess(IBinder sdkToken, Bundle params) throws RemoteException {
        }

        @Override
        public void onLoadSdkFailure(int errorCode, String errorMsg) throws RemoteException {
        }

        @Override
        public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage surfacePackage, int surfacePackageId, Bundle params) throws RemoteException {
        }

        @Override
        public void onSurfacePackageError(int errorCode, String errorMsg) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

