/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace.uitemplatedata;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.smartspace.SmartspaceUtils;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
public class TapAction
implements Parcelable {
    private final CharSequence mId;
    private final Intent mIntent;
    private final PendingIntent mPendingIntent;
    private final UserHandle mUserHandle;
    private final Bundle mExtras;
    private final boolean mShouldShowOnLockscreen;
    public static final Parcelable.Creator<TapAction> CREATOR = new Parcelable.Creator<TapAction>(){

        @Override
        public TapAction createFromParcel(Parcel in) {
            return new TapAction(in);
        }

        public TapAction[] newArray(int size) {
            return new TapAction[size];
        }
    };

    TapAction(Parcel in) {
        this.mId = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mIntent = in.readTypedObject(Intent.CREATOR);
        this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
        this.mUserHandle = in.readTypedObject(UserHandle.CREATOR);
        this.mExtras = in.readBundle();
        this.mShouldShowOnLockscreen = in.readBoolean();
    }

    private TapAction(CharSequence id2, Intent intent, PendingIntent pendingIntent, UserHandle userHandle, Bundle extras, boolean shouldShowOnLockscreen) {
        this.mId = id2;
        this.mIntent = intent;
        this.mPendingIntent = pendingIntent;
        this.mUserHandle = userHandle;
        this.mExtras = extras;
        this.mShouldShowOnLockscreen = shouldShowOnLockscreen;
    }

    public CharSequence getId() {
        return this.mId;
    }

    @SuppressLint(value={"IntentBuilderName"})
    public Intent getIntent() {
        return this.mIntent;
    }

    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @SuppressLint(value={"NullableCollection"})
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean shouldShowOnLockscreen() {
        return this.mShouldShowOnLockscreen;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        TextUtils.writeToParcel(this.mId, out, flags);
        out.writeTypedObject(this.mIntent, flags);
        out.writeTypedObject(this.mPendingIntent, flags);
        out.writeTypedObject(this.mUserHandle, flags);
        out.writeBundle(this.mExtras);
        out.writeBoolean(this.mShouldShowOnLockscreen);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TapAction)) {
            return false;
        }
        TapAction that = (TapAction)o;
        return SmartspaceUtils.isEqual(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public String toString() {
        return "SmartspaceTapAction{mId=" + this.mId + "mIntent=" + this.mIntent + ", mPendingIntent=" + this.mPendingIntent + ", mUserHandle=" + this.mUserHandle + ", mExtras=" + this.mExtras + ", mShouldShowOnLockscreen=" + this.mShouldShowOnLockscreen + '}';
    }

    @SystemApi
    public static class Builder {
        private CharSequence mId;
        private Intent mIntent;
        private PendingIntent mPendingIntent;
        private UserHandle mUserHandle;
        private Bundle mExtras;
        private boolean mShouldShowOnLockScreen;

        public Builder(CharSequence id2) {
            this.mId = Objects.requireNonNull(id2);
            this.mShouldShowOnLockScreen = false;
        }

        public Builder setIntent(Intent intent) {
            this.mIntent = intent;
            return this;
        }

        public Builder setPendingIntent(PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        @SuppressLint(value={"UserHandleName"})
        public Builder setUserHandle(UserHandle userHandle) {
            this.mUserHandle = userHandle;
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public Builder setShouldShowOnLockscreen(boolean shouldShowOnLockScreen) {
            this.mShouldShowOnLockScreen = shouldShowOnLockScreen;
            return this;
        }

        public TapAction build() {
            if (this.mIntent == null && this.mPendingIntent == null && this.mExtras == null) {
                throw new IllegalStateException("Please assign at least 1 valid tap field");
            }
            return new TapAction(this.mId, this.mIntent, this.mPendingIntent, this.mUserHandle, this.mExtras, this.mShouldShowOnLockScreen);
        }
    }
}

