/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothCsipSetCoordinator;
import android.bluetooth.IBluetoothCsipSetCoordinatorLockCallback;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

public class BluetoothCsipSetCoordinator
implements BluetoothProfile,
AutoCloseable {
    private static final String TAG = "BluetoothCsipSetCoordinator";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private CloseGuard mCloseGuard;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CSIS_CONNECTION_STATE_CHANGED = "android.bluetooth.action.CSIS_CONNECTION_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public static final String ACTION_CSIS_DEVICE_AVAILABLE = "android.bluetooth.action.CSIS_DEVICE_AVAILABLE";
    @SystemApi
    public static final String EXTRA_CSIS_GROUP_ID = "android.bluetooth.extra.CSIS_GROUP_ID";
    public static final String EXTRA_CSIS_GROUP_SIZE = "android.bluetooth.extra.CSIS_GROUP_SIZE";
    public static final String EXTRA_CSIS_GROUP_TYPE_UUID = "android.bluetooth.extra.CSIS_GROUP_TYPE_UUID";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public static final String ACTION_CSIS_SET_MEMBER_AVAILABLE = "android.bluetooth.action.CSIS_SET_MEMBER_AVAILABLE";
    @SystemApi
    public static final int GROUP_ID_INVALID = -1;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothCsipSetCoordinator> mProfileConnector = new BluetoothProfileConnector(this, 25, "BluetoothCsipSetCoordinator", IBluetoothCsipSetCoordinator.class.getName()){

        public IBluetoothCsipSetCoordinator getServiceInterface(IBinder service) {
            return IBluetoothCsipSetCoordinator.Stub.asInterface(service);
        }
    };

    BluetoothCsipSetCoordinator(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @Override
    public void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothCsipSetCoordinator getService() {
        return this.mProfileConnector.getService();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public UUID lockGroup(int groupId, Executor executor, ClientLockCallback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        IBluetoothCsipSetCoordinator service = this.getService();
        UUID defaultValue = null;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            BluetoothCsipSetCoordinatorLockCallbackDelegate delegate = new BluetoothCsipSetCoordinatorLockCallbackDelegate(executor, callback);
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.lockGroup(groupId, delegate, this.mAttributionSource, recv);
                ParcelUuid ret = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                return ret == null ? defaultValue : ret.getUuid();
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean unlockGroup(UUID lockUuid) {
        Objects.requireNonNull(lockUuid, "lockUuid cannot be null");
        IBluetoothCsipSetCoordinator service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.unlockGroup(new ParcelUuid(lockUuid), this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                return true;
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public Map<Integer, ParcelUuid> getGroupUuidMapByDevice(BluetoothDevice device) {
        IBluetoothCsipSetCoordinator service = this.getService();
        HashMap<Integer, ParcelUuid> defaultValue = new HashMap<Integer, ParcelUuid>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getGroupUuidMapByDevice(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public List<Integer> getAllGroupIds(ParcelUuid uuid) {
        IBluetoothCsipSetCoordinator service = this.getService();
        ArrayList<Integer> defaultValue = new ArrayList<Integer>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getAllGroupIds(uuid, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothCsipSetCoordinator service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevices(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothCsipSetCoordinator service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothCsipSetCoordinator service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionState(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        IBluetoothCsipSetCoordinator service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && BluetoothCsipSetCoordinator.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothCsipSetCoordinator service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        } else if (this.isEnabled() && BluetoothCsipSetCoordinator.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private static class BluetoothCsipSetCoordinatorLockCallbackDelegate
    extends IBluetoothCsipSetCoordinatorLockCallback.Stub {
        private final ClientLockCallback mCallback;
        private final Executor mExecutor;

        BluetoothCsipSetCoordinatorLockCallbackDelegate(Executor executor, ClientLockCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onGroupLockSet(int groupId, int opStatus, boolean isLocked) {
            this.mExecutor.execute(() -> this.mCallback.onGroupLockSet(groupId, opStatus, isLocked));
        }
    }

    @SystemApi
    public static interface ClientLockCallback {
        @SystemApi
        public void onGroupLockSet(int var1, int var2, boolean var3);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Status {
        }
    }
}

