/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class DeviceProductInfo
implements Parcelable {
    public static final int CONNECTION_TO_SINK_UNKNOWN = 0;
    public static final int CONNECTION_TO_SINK_BUILT_IN = 1;
    public static final int CONNECTION_TO_SINK_DIRECT = 2;
    public static final int CONNECTION_TO_SINK_TRANSITIVE = 3;
    private final String mName;
    private final String mManufacturerPnpId;
    private final String mProductId;
    private final Integer mModelYear;
    private final ManufactureDate mManufactureDate;
    private final int mConnectionToSinkType;
    public static final Parcelable.Creator<DeviceProductInfo> CREATOR = new Parcelable.Creator<DeviceProductInfo>(){

        @Override
        public DeviceProductInfo createFromParcel(Parcel in) {
            return new DeviceProductInfo(in);
        }

        public DeviceProductInfo[] newArray(int size) {
            return new DeviceProductInfo[size];
        }
    };

    public DeviceProductInfo(String name, String manufacturerPnpId, String productId, Integer modelYear, ManufactureDate manufactureDate, int connectionToSinkType) {
        this.mName = name;
        this.mManufacturerPnpId = manufacturerPnpId;
        this.mProductId = productId;
        this.mModelYear = modelYear;
        this.mManufactureDate = manufactureDate;
        this.mConnectionToSinkType = connectionToSinkType;
    }

    public DeviceProductInfo(String name, String manufacturerPnpId, String productId, int modelYear, int connectionToSinkType) {
        this.mName = name;
        this.mManufacturerPnpId = Objects.requireNonNull(manufacturerPnpId);
        this.mProductId = Objects.requireNonNull(productId);
        this.mModelYear = modelYear;
        this.mManufactureDate = null;
        this.mConnectionToSinkType = connectionToSinkType;
    }

    private DeviceProductInfo(Parcel in) {
        this.mName = in.readString();
        this.mManufacturerPnpId = in.readString();
        this.mProductId = (String)in.readValue(null);
        this.mModelYear = (Integer)in.readValue(null);
        this.mManufactureDate = (ManufactureDate)in.readValue(null);
        this.mConnectionToSinkType = in.readInt();
    }

    public String getName() {
        return this.mName;
    }

    public String getManufacturerPnpId() {
        return this.mManufacturerPnpId;
    }

    public String getProductId() {
        return this.mProductId;
    }

    public int getModelYear() {
        return this.mModelYear != null ? this.mModelYear : -1;
    }

    public int getManufactureYear() {
        if (this.mManufactureDate == null) {
            return -1;
        }
        return this.mManufactureDate.mYear != null ? this.mManufactureDate.mYear : -1;
    }

    public int getManufactureWeek() {
        if (this.mManufactureDate == null) {
            return -1;
        }
        return this.mManufactureDate.mWeek != null ? this.mManufactureDate.mWeek : -1;
    }

    public ManufactureDate getManufactureDate() {
        return this.mManufactureDate;
    }

    public int getConnectionToSinkType() {
        return this.mConnectionToSinkType;
    }

    public String toString() {
        return "DeviceProductInfo{name=" + this.mName + ", manufacturerPnpId=" + this.mManufacturerPnpId + ", productId=" + this.mProductId + ", modelYear=" + this.mModelYear + ", manufactureDate=" + this.mManufactureDate + ", connectionToSinkType=" + this.mConnectionToSinkType + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceProductInfo that = (DeviceProductInfo)o;
        return Objects.equals(this.mName, that.mName) && Objects.equals(this.mManufacturerPnpId, that.mManufacturerPnpId) && Objects.equals(this.mProductId, that.mProductId) && Objects.equals(this.mModelYear, that.mModelYear) && Objects.equals(this.mManufactureDate, that.mManufactureDate) && this.mConnectionToSinkType == that.mConnectionToSinkType;
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mManufacturerPnpId, this.mProductId, this.mModelYear, this.mManufactureDate, this.mConnectionToSinkType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeString(this.mManufacturerPnpId);
        dest.writeValue(this.mProductId);
        dest.writeValue(this.mModelYear);
        dest.writeValue(this.mManufactureDate);
        dest.writeInt(this.mConnectionToSinkType);
    }

    public static class ManufactureDate
    implements Parcelable {
        private final Integer mWeek;
        private final Integer mYear;
        public static final Parcelable.Creator<ManufactureDate> CREATOR = new Parcelable.Creator<ManufactureDate>(){

            @Override
            public ManufactureDate createFromParcel(Parcel in) {
                return new ManufactureDate(in);
            }

            public ManufactureDate[] newArray(int size) {
                return new ManufactureDate[size];
            }
        };

        public ManufactureDate(Integer week, Integer year) {
            this.mWeek = week;
            this.mYear = year;
        }

        protected ManufactureDate(Parcel in) {
            this.mWeek = (Integer)in.readValue(null);
            this.mYear = (Integer)in.readValue(null);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeValue(this.mWeek);
            dest.writeValue(this.mYear);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Integer getYear() {
            return this.mYear;
        }

        public Integer getWeek() {
            return this.mWeek;
        }

        public String toString() {
            return "ManufactureDate{week=" + this.mWeek + ", year=" + this.mYear + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManufactureDate that = (ManufactureDate)o;
            return Objects.equals(this.mWeek, that.mWeek) && Objects.equals(this.mYear, that.mYear);
        }

        public int hashCode() {
            return Objects.hash(this.mWeek, this.mYear);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionToSinkType {
    }
}

