/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.content.Intent;
import android.inputmethodservice.IInputMethodWrapper;
import android.inputmethodservice.InputMethodServiceInternal;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.WindowManagerGlobal;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import android.window.WindowProviderService;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class AbstractInputMethodService
extends WindowProviderService
implements KeyEvent.Callback {
    private InputMethod mInputMethod;
    private InputMethodServiceInternal mInputMethodServiceInternal;
    final KeyEvent.DispatcherState mDispatcherState = new KeyEvent.DispatcherState();

    protected InputMethod getInputMethodInternal() {
        return this.mInputMethod;
    }

    public KeyEvent.DispatcherState getKeyDispatcherState() {
        return this.mDispatcherState;
    }

    public abstract AbstractInputMethodImpl onCreateInputMethodInterface();

    public abstract AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface();

    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (this.mInputMethod == null) {
            this.mInputMethod = this.onCreateInputMethodInterface();
        }
        if (this.mInputMethodServiceInternal == null) {
            this.mInputMethodServiceInternal = this.createInputMethodServiceInternal();
        }
        return new IInputMethodWrapper(this.mInputMethodServiceInternal, this.mInputMethod);
    }

    InputMethodServiceInternal createInputMethodServiceInternal() {
        return new InputMethodServiceInternal(){

            @Override
            public Context getContext() {
                return AbstractInputMethodService.this;
            }

            @Override
            public void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
                AbstractInputMethodService.this.dump(fd, fout, args);
            }
        };
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    @Override
    public int getWindowType() {
        return 2011;
    }

    @Override
    public Bundle getWindowContextOptions() {
        return super.getWindowContextOptions();
    }

    @Override
    public int getInitialDisplayId() {
        try {
            return WindowManagerGlobal.getWindowManagerService().getImeDisplayId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public abstract class AbstractInputMethodSessionImpl
    implements InputMethodSession {
        boolean mEnabled = true;
        boolean mRevoked;

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public boolean isRevoked() {
            return this.mRevoked;
        }

        public void setEnabled(boolean enabled) {
            if (!this.mRevoked) {
                this.mEnabled = enabled;
            }
        }

        public void revokeSelf() {
            this.mRevoked = true;
            this.mEnabled = false;
        }

        @Override
        public void dispatchKeyEvent(int seq, KeyEvent event, InputMethodSession.EventCallback callback) {
            boolean handled = event.dispatch(AbstractInputMethodService.this, AbstractInputMethodService.this.mDispatcherState, this);
            if (callback != null) {
                callback.finishedEvent(seq, handled);
            }
        }

        @Override
        public void dispatchTrackballEvent(int seq, MotionEvent event, InputMethodSession.EventCallback callback) {
            boolean handled = AbstractInputMethodService.this.onTrackballEvent(event);
            if (callback != null) {
                callback.finishedEvent(seq, handled);
            }
        }

        @Override
        public void dispatchGenericMotionEvent(int seq, MotionEvent event, InputMethodSession.EventCallback callback) {
            boolean handled = AbstractInputMethodService.this.onGenericMotionEvent(event);
            if (callback != null) {
                callback.finishedEvent(seq, handled);
            }
        }
    }

    public abstract class AbstractInputMethodImpl
    implements InputMethod {
        @Override
        public void createSession(InputMethod.SessionCallback callback) {
            callback.sessionCreated(AbstractInputMethodService.this.onCreateInputMethodSessionInterface());
        }

        @Override
        public void setSessionEnabled(InputMethodSession session, boolean enabled) {
            ((AbstractInputMethodSessionImpl)session).setEnabled(enabled);
        }

        @Override
        public void revokeSession(InputMethodSession session) {
            ((AbstractInputMethodSessionImpl)session).revokeSelf();
        }
    }
}

