/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.Locale;
import java.util.Objects;

public class GeocoderParams
implements Parcelable {
    private final int mUid;
    private final String mPackageName;
    private final String mAttributionTag;
    private final Locale mLocale;
    public static final Parcelable.Creator<GeocoderParams> CREATOR = new Parcelable.Creator<GeocoderParams>(){

        @Override
        public GeocoderParams createFromParcel(Parcel in) {
            int uid = in.readInt();
            String packageName = in.readString8();
            String attributionTag = in.readString8();
            String language = in.readString8();
            String country = in.readString8();
            String variant = in.readString8();
            return new GeocoderParams(uid, packageName, attributionTag, new Locale(language, country, variant));
        }

        public GeocoderParams[] newArray(int size) {
            return new GeocoderParams[size];
        }
    };

    public GeocoderParams(Context context) {
        this(context, AndroidLocale.getDefault());
    }

    public GeocoderParams(Context context, Locale locale) {
        this(Process.myUid(), context.getPackageName(), context.getAttributionTag(), locale);
    }

    private GeocoderParams(int uid, String packageName, String attributionTag, Locale locale) {
        this.mUid = uid;
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mAttributionTag = attributionTag;
        this.mLocale = Objects.requireNonNull(locale);
    }

    @UnsupportedAppUsage
    public int getClientUid() {
        return this.mUid;
    }

    @UnsupportedAppUsage
    public String getClientPackage() {
        return this.mPackageName;
    }

    @UnsupportedAppUsage
    public String getClientAttributionTag() {
        return this.mAttributionTag;
    }

    @UnsupportedAppUsage
    public Locale getLocale() {
        return this.mLocale;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mUid);
        parcel.writeString8(this.mPackageName);
        parcel.writeString8(this.mAttributionTag);
        parcel.writeString8(this.mLocale.getLanguage());
        parcel.writeString8(this.mLocale.getCountry());
        parcel.writeString8(this.mLocale.getVariant());
    }
}

