/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.NearbyDevice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface INearbyMediaDevicesUpdateCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.INearbyMediaDevicesUpdateCallback";

    public void onDevicesUpdated(List<NearbyDevice> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INearbyMediaDevicesUpdateCallback {
        static final int TRANSACTION_onDevicesUpdated = 1;

        public Stub() {
            this.attachInterface(this, INearbyMediaDevicesUpdateCallback.DESCRIPTOR);
        }

        public static INearbyMediaDevicesUpdateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INearbyMediaDevicesUpdateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INearbyMediaDevicesUpdateCallback) {
                return (INearbyMediaDevicesUpdateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDevicesUpdated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INearbyMediaDevicesUpdateCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ArrayList<NearbyDevice> _arg0 = data.createTypedArrayList(NearbyDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDevicesUpdated(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements INearbyMediaDevicesUpdateCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INearbyMediaDevicesUpdateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDevicesUpdated(List<NearbyDevice> nearbyDevices) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INearbyMediaDevicesUpdateCallback.DESCRIPTOR);
                    _data.writeTypedList(nearbyDevices);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INearbyMediaDevicesUpdateCallback {
        @Override
        public void onDevicesUpdated(List<NearbyDevice> nearbyDevices) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

