/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.nearby.NearbyDevice;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FastPairDevice
extends NearbyDevice
implements Parcelable {
    public static final Parcelable.Creator<FastPairDevice> CREATOR = new Parcelable.Creator<FastPairDevice>(){

        @Override
        public FastPairDevice createFromParcel(Parcel in) {
            Builder builder = new Builder();
            if (in.readInt() == 1) {
                builder.setName(in.readString());
            }
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                builder.addMedium(in.readInt());
            }
            builder.setRssi(in.readInt());
            builder.setTxPower(in.readInt());
            if (in.readInt() == 1) {
                builder.setModelId(in.readString());
            }
            builder.setBluetoothAddress(in.readString());
            if (in.readInt() == 1) {
                int dataLength = in.readInt();
                byte[] data = new byte[dataLength];
                in.readByteArray(data);
                builder.setData(data);
            }
            return builder.build();
        }

        public FastPairDevice[] newArray(int size) {
            return new FastPairDevice[size];
        }
    };
    private int mTxPower;
    private final String mModelId;
    private final String mBluetoothAddress;
    private final byte[] mData;

    public FastPairDevice(String name, List<Integer> mediums, int rssi, int txPower, String modelId, String bluetoothAddress, byte[] data) {
        super(name, mediums, rssi);
        this.mTxPower = txPower;
        this.mModelId = modelId;
        this.mBluetoothAddress = bluetoothAddress;
        this.mData = data;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    public String getModelId() {
        return this.mModelId;
    }

    public String getBluetoothAddress() {
        return this.mBluetoothAddress;
    }

    public byte[] getData() {
        return this.mData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FastPairDevice [");
        String name = this.getName();
        if (this.getName() != null && !name.isEmpty()) {
            stringBuilder.append("name=").append(name).append(", ");
        }
        stringBuilder.append("medium={");
        for (int medium : this.getMediums()) {
            stringBuilder.append(FastPairDevice.mediumToString(medium));
        }
        stringBuilder.append("} rssi=").append(this.getRssi());
        stringBuilder.append(" txPower=").append(this.mTxPower);
        stringBuilder.append(" modelId=").append(this.mModelId);
        stringBuilder.append(" bluetoothAddress=").append(this.mBluetoothAddress);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FastPairDevice) {
            FastPairDevice otherDevice = (FastPairDevice)other;
            if (!super.equals(other)) {
                return false;
            }
            return this.mTxPower == otherDevice.mTxPower && Objects.equals(this.mModelId, otherDevice.mModelId) && Objects.equals(this.mBluetoothAddress, otherDevice.mBluetoothAddress) && Arrays.equals(this.mData, otherDevice.mData);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getMediums(), this.getRssi(), this.mTxPower, this.mModelId, this.mBluetoothAddress, Arrays.hashCode(this.mData));
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        String name = this.getName();
        dest.writeInt(name == null ? 0 : 1);
        if (name != null) {
            dest.writeString(name);
        }
        List<Integer> mediums = this.getMediums();
        dest.writeInt(mediums.size());
        for (int medium : mediums) {
            dest.writeInt(medium);
        }
        dest.writeInt(this.getRssi());
        dest.writeInt(this.mTxPower);
        dest.writeInt(this.mModelId == null ? 0 : 1);
        if (this.mModelId != null) {
            dest.writeString(this.mModelId);
        }
        dest.writeString(this.mBluetoothAddress);
        dest.writeInt(this.mData == null ? 0 : 1);
        if (this.mData != null) {
            dest.writeInt(this.mData.length);
            dest.writeByteArray(this.mData);
        }
    }

    public static class Builder {
        private final List<Integer> mMediums = new ArrayList<Integer>();
        private String mName;
        private int mRssi;
        private int mTxPower;
        private String mModelId;
        private String mBluetoothAddress;
        private byte[] mData;

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addMedium(@NearbyDevice.Medium int medium) {
            this.mMediums.add(medium);
            return this;
        }

        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.mTxPower = txPower;
            return this;
        }

        public Builder setModelId(String modelId) {
            this.mModelId = modelId;
            return this;
        }

        public Builder setBluetoothAddress(String bluetoothAddress) {
            Objects.requireNonNull(bluetoothAddress);
            this.mBluetoothAddress = bluetoothAddress;
            return this;
        }

        public Builder setData(byte[] data) {
            this.mData = data;
            return this;
        }

        public FastPairDevice build() {
            return new FastPairDevice(this.mName, this.mMediums, this.mRssi, this.mTxPower, this.mModelId, this.mBluetoothAddress, this.mData);
        }
    }
}

