/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.TrafficStats;
import android.util.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class PrivateDnsConnectivityChecker {
    private static final String TAG = "NetworkUtils";
    private static final int PRIVATE_DNS_PORT = 853;
    private static final int CONNECTION_TIMEOUT_MS = 5000;

    private PrivateDnsConnectivityChecker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canConnectToPrivateDnsServer(String hostname) {
        SocketFactory factory = SSLSocketFactory.getDefault();
        TrafficStats.setThreadStatsTagApp();
        try (SSLSocket socket = (SSLSocket)factory.createSocket();){
            socket.setSoTimeout(5000);
            socket.connect(new InetSocketAddress(hostname, 853));
            if (!socket.isConnected()) {
                Log.w(TAG, String.format("Connection to %s failed.", hostname));
                boolean bl2 = false;
                return bl2;
            }
            socket.startHandshake();
            Log.w(TAG, String.format("TLS handshake to %s succeeded.", hostname));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.w(TAG, String.format("TLS handshake to %s failed.", hostname), e);
            return false;
        }
    }
}

