/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.InetAddresses;
import android.net.InvalidPacketException;
import android.net.KeepalivePacketData;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.util.Objects;

@SystemApi
public class TcpKeepalivePacketData
extends KeepalivePacketData
implements Parcelable {
    private static final String TAG = "TcpKeepalivePacketData";
    public final int tcpSeq;
    public final int tcpAck;
    public final int tcpWindow;
    public final int tcpWindowScale;
    public final int ipTos;
    public final int ipTtl;
    public static final Parcelable.Creator<TcpKeepalivePacketData> CREATOR = new Parcelable.Creator<TcpKeepalivePacketData>(){

        @Override
        public TcpKeepalivePacketData createFromParcel(Parcel in) {
            try {
                return TcpKeepalivePacketData.readFromParcel(in);
            }
            catch (InvalidPacketException e) {
                throw new IllegalArgumentException("Invalid TCP keepalive data: " + e.getError());
            }
        }

        public TcpKeepalivePacketData[] newArray(int size) {
            return new TcpKeepalivePacketData[size];
        }
    };

    public TcpKeepalivePacketData(InetAddress srcAddress, int srcPort, InetAddress dstAddress, int dstPort, byte[] data, int tcpSeq, int tcpAck, int tcpWindow, int tcpWindowScale, int ipTos, int ipTtl) throws InvalidPacketException {
        super(srcAddress, srcPort, dstAddress, dstPort, data);
        this.tcpSeq = tcpSeq;
        this.tcpAck = tcpAck;
        this.tcpWindow = tcpWindow;
        this.tcpWindowScale = tcpWindowScale;
        this.ipTos = ipTos;
        this.ipTtl = ipTtl;
    }

    public int getTcpSeq() {
        return this.tcpSeq;
    }

    public int getTcpAck() {
        return this.tcpAck;
    }

    public int getTcpWindow() {
        return this.tcpWindow;
    }

    public int getTcpWindowScale() {
        return this.tcpWindowScale;
    }

    public int getIpTos() {
        return this.ipTos;
    }

    public int getIpTtl() {
        return this.ipTtl;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TcpKeepalivePacketData)) {
            return false;
        }
        TcpKeepalivePacketData other = (TcpKeepalivePacketData)o;
        InetAddress srcAddress = this.getSrcAddress();
        InetAddress dstAddress = this.getDstAddress();
        return srcAddress.equals(other.getSrcAddress()) && dstAddress.equals(other.getDstAddress()) && this.getSrcPort() == other.getSrcPort() && this.getDstPort() == other.getDstPort() && this.tcpAck == other.tcpAck && this.tcpSeq == other.tcpSeq && this.tcpWindow == other.tcpWindow && this.tcpWindowScale == other.tcpWindowScale && this.ipTos == other.ipTos && this.ipTtl == other.ipTtl;
    }

    public int hashCode() {
        return Objects.hash(this.getSrcAddress(), this.getDstAddress(), this.getSrcPort(), this.getDstPort(), this.tcpAck, this.tcpSeq, this.tcpWindow, this.tcpWindowScale, this.ipTos, this.ipTtl);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.getSrcAddress().getHostAddress());
        out.writeString(this.getDstAddress().getHostAddress());
        out.writeInt(this.getSrcPort());
        out.writeInt(this.getDstPort());
        out.writeByteArray(this.getPacket());
        out.writeInt(this.tcpSeq);
        out.writeInt(this.tcpAck);
        out.writeInt(this.tcpWindow);
        out.writeInt(this.tcpWindowScale);
        out.writeInt(this.ipTos);
        out.writeInt(this.ipTtl);
    }

    private static TcpKeepalivePacketData readFromParcel(Parcel in) throws InvalidPacketException {
        InetAddress srcAddress = InetAddresses.parseNumericAddress(in.readString());
        InetAddress dstAddress = InetAddresses.parseNumericAddress(in.readString());
        int srcPort = in.readInt();
        int dstPort = in.readInt();
        byte[] packet = in.createByteArray();
        int tcpSeq = in.readInt();
        int tcpAck = in.readInt();
        int tcpWnd = in.readInt();
        int tcpWndScale = in.readInt();
        int ipTos = in.readInt();
        int ipTtl = in.readInt();
        return new TcpKeepalivePacketData(srcAddress, srcPort, dstAddress, dstPort, packet, tcpSeq, tcpAck, tcpWnd, tcpWndScale, ipTos, ipTtl);
    }

    @Override
    public String toString() {
        return "saddr: " + this.getSrcAddress() + " daddr: " + this.getDstAddress() + " sport: " + this.getSrcPort() + " dport: " + this.getDstPort() + " seq: " + this.tcpSeq + " ack: " + this.tcpAck + " window: " + this.tcpWindow + " windowScale: " + this.tcpWindowScale + " tos: " + this.ipTos + " ttl: " + this.ipTtl;
    }
}

