/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class UnderlyingNetworkInfo
implements Parcelable {
    private final int mOwnerUid;
    private final String mIface;
    private final List<String> mUnderlyingIfaces;
    public static final Parcelable.Creator<UnderlyingNetworkInfo> CREATOR = new Parcelable.Creator<UnderlyingNetworkInfo>(){

        @Override
        public UnderlyingNetworkInfo createFromParcel(Parcel in) {
            return new UnderlyingNetworkInfo(in);
        }

        public UnderlyingNetworkInfo[] newArray(int size) {
            return new UnderlyingNetworkInfo[size];
        }
    };

    public UnderlyingNetworkInfo(int ownerUid, String iface, List<String> underlyingIfaces) {
        Objects.requireNonNull(iface);
        Objects.requireNonNull(underlyingIfaces);
        this.mOwnerUid = ownerUid;
        this.mIface = iface;
        this.mUnderlyingIfaces = Collections.unmodifiableList(new ArrayList<String>(underlyingIfaces));
    }

    private UnderlyingNetworkInfo(Parcel in) {
        this.mOwnerUid = in.readInt();
        this.mIface = in.readString();
        ArrayList underlyingIfaces = new ArrayList();
        in.readList(underlyingIfaces, null, String.class);
        this.mUnderlyingIfaces = Collections.unmodifiableList(underlyingIfaces);
    }

    public int getOwnerUid() {
        return this.mOwnerUid;
    }

    public String getInterface() {
        return this.mIface;
    }

    public List<String> getUnderlyingInterfaces() {
        return this.mUnderlyingIfaces;
    }

    public String toString() {
        return "UnderlyingNetworkInfo{ownerUid=" + this.mOwnerUid + ", iface='" + this.mIface + '\'' + ", underlyingIfaces='" + this.mUnderlyingIfaces.toString() + '\'' + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mOwnerUid);
        dest.writeString(this.mIface);
        dest.writeList(this.mUnderlyingIfaces);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnderlyingNetworkInfo)) {
            return false;
        }
        UnderlyingNetworkInfo that = (UnderlyingNetworkInfo)o;
        return this.mOwnerUid == that.getOwnerUid() && Objects.equals(this.mIface, that.getInterface()) && Objects.equals(this.mUnderlyingIfaces, that.getUnderlyingInterfaces());
    }

    public int hashCode() {
        return Objects.hash(this.mOwnerUid, this.mIface, this.mUnderlyingIfaces);
    }
}

