/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiUsabilityStatsEntry;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IOnWifiUsabilityStatsListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IOnWifiUsabilityStatsListener";

    public void onWifiUsabilityStats(int var1, boolean var2, WifiUsabilityStatsEntry var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOnWifiUsabilityStatsListener {
        static final int TRANSACTION_onWifiUsabilityStats = 1;

        public Stub() {
            this.attachInterface(this, IOnWifiUsabilityStatsListener.DESCRIPTOR);
        }

        public static IOnWifiUsabilityStatsListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOnWifiUsabilityStatsListener.DESCRIPTOR);
            if (iin != null && iin instanceof IOnWifiUsabilityStatsListener) {
                return (IOnWifiUsabilityStatsListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOnWifiUsabilityStatsListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    WifiUsabilityStatsEntry _arg2 = data.readTypedObject(WifiUsabilityStatsEntry.CREATOR);
                    this.onWifiUsabilityStats(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IOnWifiUsabilityStatsListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOnWifiUsabilityStatsListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWifiUsabilityStats(int seqNum, boolean isSameBssidAndFreq, WifiUsabilityStatsEntry stats) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnWifiUsabilityStatsListener.DESCRIPTOR);
                    _data.writeInt(seqNum);
                    _data.writeBoolean(isSameBssidAndFreq);
                    _data.writeTypedObject(stats, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOnWifiUsabilityStatsListener {
        @Override
        public void onWifiUsabilityStats(int seqNum, boolean isSameBssidAndFreq, WifiUsabilityStatsEntry stats) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

