/*
 * Decompiled with CFR 0.152.
 */
package android.security.attestationverification;

import android.os.Parcel;
import android.os.Parcelable;
import android.security.attestationverification.AttestationVerificationManager;
import android.util.Log;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class AttestationProfile
implements Parcelable {
    private static final String TAG = "AVF";
    private final int mAttestationProfileId;
    private final String mPackageName;
    private final String mProfileName;
    public static final Parcelable.Creator<AttestationProfile> CREATOR = new Parcelable.Creator<AttestationProfile>(){

        public AttestationProfile[] newArray(int size) {
            return new AttestationProfile[size];
        }

        @Override
        public AttestationProfile createFromParcel(Parcel in) {
            return new AttestationProfile(in);
        }
    };

    private AttestationProfile(int attestationProfileId, String packageName, String profileName) {
        this.mAttestationProfileId = attestationProfileId;
        this.mPackageName = packageName;
        this.mProfileName = profileName;
    }

    public AttestationProfile(int attestationProfileId) {
        this(attestationProfileId, null, null);
        if (attestationProfileId == 1) {
            throw new IllegalArgumentException("App-defined profiles must be specified with the constructor AttestationProfile#constructor(String, String)");
        }
    }

    public AttestationProfile(String packageName, String profileName) {
        this(1, packageName, profileName);
        if (packageName == null || profileName == null) {
            throw new IllegalArgumentException("Both packageName and profileName must be non-null");
        }
    }

    public String toString() {
        String humanReadableProfileId;
        if (this.mAttestationProfileId == 1) {
            return "AttestationProfile(package=" + this.mPackageName + ", name=" + this.mProfileName + ")";
        }
        switch (this.mAttestationProfileId) {
            case 0: {
                humanReadableProfileId = "PROFILE_UNKNOWN";
                break;
            }
            default: {
                Log.e(TAG, "ERROR: Missing case in AttestationProfile#toString");
                humanReadableProfileId = "ERROR";
            }
        }
        return "AttestationProfile(" + humanReadableProfileId + "/" + this.mAttestationProfileId + ")";
    }

    public int getAttestationProfileId() {
        return this.mAttestationProfileId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getProfileName() {
        return this.mProfileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestationProfile that = (AttestationProfile)o;
        return this.mAttestationProfileId == that.mAttestationProfileId && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mProfileName, that.mProfileName);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mAttestationProfileId;
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mProfileName);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mPackageName != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mProfileName != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mAttestationProfileId);
        if (this.mPackageName != null) {
            dest.writeString(this.mPackageName);
        }
        if (this.mProfileName != null) {
            dest.writeString(this.mProfileName);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AttestationProfile(Parcel in) {
        byte flg = in.readByte();
        int attestationProfileId = in.readInt();
        String packageName = (flg & 2) == 0 ? null : in.readString();
        String profileName = (flg & 4) == 0 ? null : in.readString();
        this.mAttestationProfileId = attestationProfileId;
        AnnotationValidations.validate(AttestationVerificationManager.AttestationProfileId.class, null, this.mAttestationProfileId);
        this.mPackageName = packageName;
        this.mProfileName = profileName;
    }

    @Deprecated
    private void __metadata() {
    }
}

