/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.SntpClient;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.TrustedTime;
import com.android.internal.annotations.GuardedBy;
import java.io.PrintWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;

public class NtpTrustedTime
implements TrustedTime {
    private static final String TAG = "NtpTrustedTime";
    private static final boolean LOGD = false;
    private static NtpTrustedTime sSingleton;
    private final Context mContext;
    private final Supplier<ConnectivityManager> mConnectivityManagerSupplier = new Supplier<ConnectivityManager>(){
        private ConnectivityManager mConnectivityManager;

        @Override
        public synchronized ConnectivityManager get() {
            if (this.mConnectivityManager == null) {
                this.mConnectivityManager = NtpTrustedTime.this.mContext.getSystemService(ConnectivityManager.class);
            }
            return this.mConnectivityManager;
        }
    };
    private String mHostnameForTests;
    private Integer mPortForTests;
    private Duration mTimeoutForTests;
    private volatile TimeResult mTimeResult;

    private NtpTrustedTime(Context context) {
        this.mContext = Objects.requireNonNull(context);
    }

    @UnsupportedAppUsage
    public static synchronized NtpTrustedTime getInstance(Context context) {
        if (sSingleton == null) {
            Context appContext = context.getApplicationContext();
            sSingleton = new NtpTrustedTime(appContext);
        }
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerConfigForTests(String hostname, Integer port, Duration timeout) {
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            this.mHostnameForTests = hostname;
            this.mPortForTests = port;
            this.mTimeoutForTests = timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean forceRefresh() {
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            int timeoutMillis;
            int port;
            NtpConnectionInfo connectionInfo = this.getNtpConnectionInfo();
            if (connectionInfo == null) {
                return false;
            }
            ConnectivityManager connectivityManager = this.mConnectivityManagerSupplier.get();
            if (connectivityManager == null) {
                return false;
            }
            Network network = connectivityManager.getActiveNetwork();
            NetworkInfo ni = connectivityManager.getNetworkInfo(network);
            if (ni == null || !ni.isConnected()) {
                return false;
            }
            SntpClient client = new SntpClient();
            String serverName = connectionInfo.getServer();
            if (client.requestTime(serverName, port = connectionInfo.getPort(), timeoutMillis = connectionInfo.getTimeoutMillis(), network)) {
                long ntpCertainty = client.getRoundTripTime() / 2L;
                this.mTimeResult = new TimeResult(client.getNtpTime(), client.getNtpTimeReference(), ntpCertainty);
                return true;
            }
            return false;
        }
    }

    @Override
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean hasCache() {
        return this.mTimeResult != null;
    }

    @Override
    @Deprecated
    public long getCacheAge() {
        TimeResult timeResult = this.mTimeResult;
        if (timeResult != null) {
            return SystemClock.elapsedRealtime() - timeResult.getElapsedRealtimeMillis();
        }
        return Long.MAX_VALUE;
    }

    @Override
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long currentTimeMillis() {
        TimeResult timeResult = this.mTimeResult;
        if (timeResult == null) {
            throw new IllegalStateException("Missing authoritative time source");
        }
        return timeResult.currentTimeMillis();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getCachedNtpTime() {
        TimeResult timeResult = this.mTimeResult;
        return timeResult == null ? 0L : timeResult.getTimeMillis();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getCachedNtpTimeReference() {
        TimeResult timeResult = this.mTimeResult;
        return timeResult == null ? 0L : timeResult.getElapsedRealtimeMillis();
    }

    public TimeResult getCachedTimeResult() {
        return this.mTimeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedTimeResult() {
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            this.mTimeResult = null;
        }
    }

    @GuardedBy(value={"this"})
    private NtpConnectionInfo getNtpConnectionInfo() {
        int timeoutMillis;
        String serverGlobalSetting;
        ContentResolver resolver = this.mContext.getContentResolver();
        Resources res = this.mContext.getResources();
        String hostname = this.mHostnameForTests != null ? this.mHostnameForTests : ((serverGlobalSetting = Settings.Global.getString(resolver, "ntp_server")) != null ? serverGlobalSetting : res.getString(17040009));
        Integer port = this.mPortForTests != null ? this.mPortForTests : Integer.valueOf(123);
        if (this.mTimeoutForTests != null) {
            timeoutMillis = (int)this.mTimeoutForTests.toMillis();
        } else {
            int defaultTimeoutMillis = res.getInteger(17694903);
            timeoutMillis = Settings.Global.getInt(resolver, "ntp_timeout", defaultTimeoutMillis);
        }
        return TextUtils.isEmpty(hostname) ? null : new NtpConnectionInfo(hostname, port, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            pw.println("getNtpConnectionInfo()=" + this.getNtpConnectionInfo());
            pw.println("mTimeResult=" + this.mTimeResult);
            if (this.mTimeResult != null) {
                pw.println("mTimeResult.getAgeMillis()=" + Duration.ofMillis(this.mTimeResult.getAgeMillis()));
            }
        }
    }

    private static class NtpConnectionInfo {
        private final String mServer;
        private final int mPort;
        private final int mTimeoutMillis;

        NtpConnectionInfo(String server, int port, int timeoutMillis) {
            this.mServer = Objects.requireNonNull(server);
            this.mPort = port;
            this.mTimeoutMillis = timeoutMillis;
        }

        public String getServer() {
            return this.mServer;
        }

        public int getPort() {
            return this.mPort;
        }

        int getTimeoutMillis() {
            return this.mTimeoutMillis;
        }

        public String toString() {
            return "NtpConnectionInfo{mServer='" + this.mServer + '\'' + ", mPort='" + this.mPort + '\'' + ", mTimeoutMillis=" + this.mTimeoutMillis + '}';
        }
    }

    public static class TimeResult {
        private final long mTimeMillis;
        private final long mElapsedRealtimeMillis;
        private final long mCertaintyMillis;

        public TimeResult(long timeMillis, long elapsedRealtimeMillis, long certaintyMillis) {
            this.mTimeMillis = timeMillis;
            this.mElapsedRealtimeMillis = elapsedRealtimeMillis;
            this.mCertaintyMillis = certaintyMillis;
        }

        public long getTimeMillis() {
            return this.mTimeMillis;
        }

        public long getElapsedRealtimeMillis() {
            return this.mElapsedRealtimeMillis;
        }

        public long getCertaintyMillis() {
            return this.mCertaintyMillis;
        }

        public long currentTimeMillis() {
            return this.mTimeMillis + this.getAgeMillis();
        }

        public long getAgeMillis() {
            return this.getAgeMillis(SystemClock.elapsedRealtime());
        }

        public long getAgeMillis(long currentElapsedRealtimeMillis) {
            return currentElapsedRealtimeMillis - this.mElapsedRealtimeMillis;
        }

        public String toString() {
            return "TimeResult{mTimeMillis=" + Instant.ofEpochMilli(this.mTimeMillis) + ", mElapsedRealtimeMillis=" + Duration.ofMillis(this.mElapsedRealtimeMillis) + ", mCertaintyMillis=" + this.mCertaintyMillis + '}';
        }
    }
}

