/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.content.pm.Signature;
import android.content.pm.SigningDetails;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.os.Trace;
import android.os.incremental.V4Signature;
import android.util.Pair;
import android.util.apk.ApkSignatureSchemeV2Verifier;
import android.util.apk.ApkSignatureSchemeV3Verifier;
import android.util.apk.ApkSignatureSchemeV4Verifier;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureNotFoundException;
import android.util.jar.StrictJarFile;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import libcore.io.IoUtils;

public class ApkSignatureVerifier {
    private static final AtomicReference<byte[]> sBuffer = new AtomicReference();

    public static ParseResult<SigningDetails> verify(ParseInput input, String apkPath, @SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion) {
        return ApkSignatureVerifier.verifySignatures(input, apkPath, minSignatureSchemeVersion, true);
    }

    public static ParseResult<SigningDetails> unsafeGetCertsWithoutVerification(ParseInput input, String apkPath, int minSignatureSchemeVersion) {
        return ApkSignatureVerifier.verifySignatures(input, apkPath, minSignatureSchemeVersion, false);
    }

    private static ParseResult<SigningDetails> verifySignatures(ParseInput input, String apkPath, @SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion, boolean verifyFull) {
        ParseResult<SigningDetailsWithDigests> result = ApkSignatureVerifier.verifySignaturesInternal(input, apkPath, minSignatureSchemeVersion, verifyFull);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(result.getResult().signingDetails);
    }

    public static ParseResult<SigningDetailsWithDigests> verifySignaturesInternal(ParseInput input, String apkPath, @SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion, boolean verifyFull) {
        if (minSignatureSchemeVersion > 4) {
            return input.error(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
        }
        try {
            return ApkSignatureVerifier.verifyV4Signature(input, apkPath, minSignatureSchemeVersion, verifyFull);
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 4) {
                return input.error(-103, "No APK Signature Scheme v4 signature in package " + apkPath, e);
            }
            if (minSignatureSchemeVersion > 3) {
                return input.error(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
            }
            return ApkSignatureVerifier.verifyV3AndBelowSignatures(input, apkPath, minSignatureSchemeVersion, verifyFull);
        }
    }

    private static ParseResult<SigningDetailsWithDigests> verifyV3AndBelowSignatures(ParseInput input, String apkPath, @SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion, boolean verifyFull) {
        try {
            return ApkSignatureVerifier.verifyV3Signature(input, apkPath, verifyFull);
        }
        catch (SignatureNotFoundException e) {
            if (minSignatureSchemeVersion >= 3) {
                return input.error(-103, "No APK Signature Scheme v3 signature in package " + apkPath, e);
            }
            if (minSignatureSchemeVersion > 2) {
                return input.error(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
            }
            try {
                return ApkSignatureVerifier.verifyV2Signature(input, apkPath, verifyFull);
            }
            catch (SignatureNotFoundException e2) {
                if (minSignatureSchemeVersion >= 2) {
                    return input.error(-103, "No APK Signature Scheme v2 signature in package " + apkPath, e2);
                }
                if (minSignatureSchemeVersion > 1) {
                    return input.error(-103, "No signature found in package of version " + minSignatureSchemeVersion + " or newer for package " + apkPath);
                }
                return ApkSignatureVerifier.verifyV1Signature(input, apkPath, verifyFull);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<SigningDetailsWithDigests> verifyV4Signature(ParseInput input, String apkPath, @SigningDetails.SignatureSchemeVersion int minSignatureSchemeVersion, boolean verifyFull) throws SignatureNotFoundException {
        Trace.traceBegin(262144L, verifyFull ? "verifyV4" : "certsOnlyV4");
        try {
            Pair<V4Signature.HashingInfo, V4Signature.SigningInfos> v4Pair = ApkSignatureSchemeV4Verifier.extractSignature(apkPath);
            V4Signature.HashingInfo hashingInfo = (V4Signature.HashingInfo)v4Pair.first;
            V4Signature.SigningInfos signingInfos = (V4Signature.SigningInfos)v4Pair.second;
            Signature[] pastSignerSigs = null;
            Map<Integer, byte[]> nonstreamingDigests = null;
            Certificate[][] nonstreamingCerts = null;
            int v3BlockId = -1;
            if (verifyFull || signingInfos.signingInfoBlocks.length > 0) {
                try {
                    ApkSignatureSchemeV3Verifier.VerifiedSigner v3Signer = ApkSignatureSchemeV3Verifier.unsafeGetCertsWithoutVerification(apkPath);
                    nonstreamingDigests = v3Signer.contentDigests;
                    nonstreamingCerts = new Certificate[][]{v3Signer.certs};
                    if (v3Signer.por != null) {
                        pastSignerSigs = new Signature[v3Signer.por.certs.size()];
                        for (int i = 0; i < pastSignerSigs.length; ++i) {
                            pastSignerSigs[i] = new Signature(v3Signer.por.certs.get(i).getEncoded());
                            pastSignerSigs[i].setFlags(v3Signer.por.flagsList.get(i));
                        }
                    }
                    v3BlockId = v3Signer.blockId;
                }
                catch (SignatureNotFoundException e) {
                    try {
                        ApkSignatureSchemeV2Verifier.VerifiedSigner v2Signer = ApkSignatureSchemeV2Verifier.verify(apkPath, false);
                        nonstreamingDigests = v2Signer.contentDigests;
                        nonstreamingCerts = v2Signer.certs;
                    }
                    catch (SignatureNotFoundException ee) {
                        throw new SecurityException("V4 verification failed to collect V2/V3 certificates from : " + apkPath, ee);
                    }
                }
            }
            ApkSignatureSchemeV4Verifier.VerifiedSigner vSigner = ApkSignatureSchemeV4Verifier.verify(apkPath, hashingInfo, signingInfos, v3BlockId);
            Certificate[][] signerCerts = new Certificate[][]{vSigner.certs};
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            if (verifyFull) {
                Signature[] nonstreamingSigs = ApkSignatureVerifier.convertToSignatures(nonstreamingCerts);
                if (nonstreamingSigs.length != signerSigs.length) {
                    throw new SecurityException("Invalid number of certificates: " + nonstreamingSigs.length);
                }
                int size = signerSigs.length;
                for (int i = 0; i < size; ++i) {
                    if (nonstreamingSigs[i].equals(signerSigs[i])) continue;
                    throw new SecurityException("V4 signature certificate does not match V2/V3");
                }
                boolean found = false;
                for (byte[] nonstreamingDigest : nonstreamingDigests.values()) {
                    if (!ArrayUtils.equals(vSigner.apkDigest, nonstreamingDigest, vSigner.apkDigest.length)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new SecurityException("APK digest in V4 signature does not match V2/V3");
                }
            }
            ParseResult<SigningDetailsWithDigests> parseResult = input.success(new SigningDetailsWithDigests(new SigningDetails(signerSigs, 4, pastSignerSigs), vSigner.contentDigests));
            return parseResult;
        }
        catch (SignatureNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            ParseResult<SigningDetailsWithDigests> parseResult = input.error(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v4", e);
            return parseResult;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<SigningDetailsWithDigests> verifyV3Signature(ParseInput input, String apkPath, boolean verifyFull) throws SignatureNotFoundException {
        Trace.traceBegin(262144L, verifyFull ? "verifyV3" : "certsOnlyV3");
        try {
            ApkSignatureSchemeV3Verifier.VerifiedSigner vSigner = verifyFull ? ApkSignatureSchemeV3Verifier.verify(apkPath) : ApkSignatureSchemeV3Verifier.unsafeGetCertsWithoutVerification(apkPath);
            Certificate[][] signerCerts = new Certificate[][]{vSigner.certs};
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            Signature[] pastSignerSigs = null;
            if (vSigner.por != null) {
                pastSignerSigs = new Signature[vSigner.por.certs.size()];
                for (int i = 0; i < pastSignerSigs.length; ++i) {
                    pastSignerSigs[i] = new Signature(vSigner.por.certs.get(i).getEncoded());
                    pastSignerSigs[i].setFlags(vSigner.por.flagsList.get(i));
                }
            }
            ParseResult<SigningDetailsWithDigests> parseResult = input.success(new SigningDetailsWithDigests(new SigningDetails(signerSigs, 3, pastSignerSigs), vSigner.contentDigests));
            return parseResult;
        }
        catch (SignatureNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            ParseResult<SigningDetailsWithDigests> parseResult = input.error(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v3", e);
            return parseResult;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<SigningDetailsWithDigests> verifyV2Signature(ParseInput input, String apkPath, boolean verifyFull) throws SignatureNotFoundException {
        Trace.traceBegin(262144L, verifyFull ? "verifyV2" : "certsOnlyV2");
        try {
            ApkSignatureSchemeV2Verifier.VerifiedSigner vSigner = ApkSignatureSchemeV2Verifier.verify(apkPath, verifyFull);
            Certificate[][] signerCerts = vSigner.certs;
            Signature[] signerSigs = ApkSignatureVerifier.convertToSignatures(signerCerts);
            ParseResult<SigningDetailsWithDigests> parseResult = input.success(new SigningDetailsWithDigests(new SigningDetails(signerSigs, 2), vSigner.contentDigests));
            return parseResult;
        }
        catch (SignatureNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            ParseResult<SigningDetailsWithDigests> parseResult = input.error(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v2", e);
            return parseResult;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * Exception decompiling
     */
    private static ParseResult<SigningDetailsWithDigests> verifyV1Signature(ParseInput input, String apkPath, boolean verifyFull) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<Certificate[][]> loadCertificates(ParseInput input, StrictJarFile jarFile, ZipEntry entry) {
        InputStream is = null;
        try {
            is = jarFile.getInputStream(entry);
            ApkSignatureVerifier.readFullyIgnoringContents(is);
            ParseResult<Certificate[][]> parseResult = input.success(jarFile.getCertificateChains(entry));
            return parseResult;
        }
        catch (IOException | RuntimeException e) {
            ParseResult<Certificate[][]> parseResult = input.error(-102, "Failed reading " + entry.getName() + " in " + jarFile, e);
            return parseResult;
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private static void readFullyIgnoringContents(InputStream in) throws IOException {
        byte[] buffer = sBuffer.getAndSet(null);
        if (buffer == null) {
            buffer = new byte[4096];
        }
        int n = 0;
        int count = 0;
        while ((n = in.read(buffer, 0, buffer.length)) != -1) {
            count += n;
        }
        sBuffer.set(buffer);
    }

    private static Signature[] convertToSignatures(Certificate[][] certs) throws CertificateEncodingException {
        Signature[] res = new Signature[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            res[i] = new Signature(certs[i]);
        }
        return res;
    }

    private static void closeQuietly(StrictJarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getMinimumSignatureSchemeVersionForTargetSdk(int targetSdk) {
        if (targetSdk >= 30) {
            return 2;
        }
        return 1;
    }

    public static byte[] getVerityRootHash(String apkPath) throws IOException, SecurityException {
        try {
            return ApkSignatureSchemeV3Verifier.getVerityRootHash(apkPath);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            try {
                return ApkSignatureSchemeV2Verifier.getVerityRootHash(apkPath);
            }
            catch (SignatureNotFoundException e) {
                return null;
            }
        }
    }

    public static byte[] generateApkVerity(String apkPath, ByteBufferFactory bufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        try {
            return ApkSignatureSchemeV3Verifier.generateApkVerity(apkPath, bufferFactory);
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            return ApkSignatureSchemeV2Verifier.generateApkVerity(apkPath, bufferFactory);
        }
    }

    public static class SigningDetailsWithDigests {
        public final SigningDetails signingDetails;
        public final Map<Integer, byte[]> contentDigests;

        SigningDetailsWithDigests(SigningDetails signingDetails, Map<Integer, byte[]> contentDigests) {
            this.signingDetails = signingDetails;
            this.contentDigests = contentDigests;
        }
    }

    public static class Result {
        public final Certificate[][] certs;
        public final Signature[] sigs;
        public final int signatureSchemeVersion;

        public Result(Certificate[][] certs, Signature[] sigs, int signingVersion) {
            this.certs = certs;
            this.sigs = sigs;
            this.signatureSchemeVersion = signingVersion;
        }
    }
}

