/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.WindowContainerTransaction;

public interface IDisplayWindowRotationCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IDisplayWindowRotationCallback";

    public void continueRotateDisplay(int var1, WindowContainerTransaction var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayWindowRotationCallback {
        static final int TRANSACTION_continueRotateDisplay = 1;

        public Stub() {
            this.attachInterface(this, IDisplayWindowRotationCallback.DESCRIPTOR);
        }

        public static IDisplayWindowRotationCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDisplayWindowRotationCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayWindowRotationCallback) {
                return (IDisplayWindowRotationCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "continueRotateDisplay";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDisplayWindowRotationCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    WindowContainerTransaction _arg1 = data.readTypedObject(WindowContainerTransaction.CREATOR);
                    data.enforceNoDataAvail();
                    this.continueRotateDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IDisplayWindowRotationCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDisplayWindowRotationCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void continueRotateDisplay(int targetRotation, WindowContainerTransaction t) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDisplayWindowRotationCallback.DESCRIPTOR);
                    _data.writeInt(targetRotation);
                    _data.writeTypedObject(t, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayWindowRotationCallback {
        @Override
        public void continueRotateDisplay(int targetRotation, WindowContainerTransaction t) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

