/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.IBinder;
import android.os.Trace;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsController;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.inputmethod.InputMethodManager;
import java.util.function.Supplier;

public class ImeInsetsSourceConsumer
extends InsetsSourceConsumer {
    private boolean mIsRequestedVisibleAwaitingControl;
    private boolean mIsHideAnimationRunning;
    private boolean mIsShowRequestedDuringHideAnimation;

    public ImeInsetsSourceConsumer(InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        super(19, state, transactionSupplier, controller);
    }

    @Override
    public void onWindowFocusGained(boolean hasViewFocus) {
        super.onWindowFocusGained(hasViewFocus);
        this.getImm().registerImeConsumer(this);
        if (this.isRequestedVisible() && this.getControl() == null) {
            this.mIsRequestedVisibleAwaitingControl = true;
        }
    }

    @Override
    public void onWindowFocusLost() {
        super.onWindowFocusLost();
        this.getImm().unregisterImeConsumer(this);
        this.mIsRequestedVisibleAwaitingControl = false;
    }

    @Override
    public void show(boolean fromIme) {
        super.show(fromIme);
        this.onShowRequested();
    }

    @Override
    public void hide() {
        super.hide();
        this.mIsRequestedVisibleAwaitingControl = false;
    }

    @Override
    void hide(boolean animationFinished, int animationType) {
        this.hide();
        if (animationFinished && !this.mIsShowRequestedDuringHideAnimation) {
            this.notifyHidden();
            this.removeSurface();
        }
        this.mIsHideAnimationRunning = !animationFinished;
        this.mIsShowRequestedDuringHideAnimation = false;
    }

    @Override
    public int requestShow(boolean fromIme) {
        if (this.getControl() == null) {
            this.mIsRequestedVisibleAwaitingControl = true;
        }
        if (fromIme || this.mState.getSource(this.getType()).isVisible() && this.getControl() != null) {
            return 0;
        }
        return this.getImm().requestImeShow(this.mController.getHost().getWindowToken()) ? 1 : 2;
    }

    @Override
    void notifyHidden() {
        this.getImm().notifyImeHidden(this.mController.getHost().getWindowToken());
        Trace.asyncTraceEnd(8L, "IC.hideRequestFromApi", 0);
    }

    @Override
    public void removeSurface() {
        IBinder window = this.mController.getHost().getWindowToken();
        if (window != null) {
            this.getImm().removeImeSurface(window);
        }
    }

    @Override
    public boolean setControl(InsetsSourceControl control, int[] showTypes, int[] hideTypes) {
        if (!super.setControl(control, showTypes, hideTypes)) {
            return false;
        }
        if (control == null && !this.mIsRequestedVisibleAwaitingControl) {
            this.hide();
            this.removeSurface();
        }
        if (control != null) {
            this.mIsRequestedVisibleAwaitingControl = false;
        }
        return true;
    }

    @Override
    protected boolean isRequestedVisibleAwaitingControl() {
        return this.mIsRequestedVisibleAwaitingControl || this.isRequestedVisible();
    }

    @Override
    public void onPerceptible(boolean perceptible) {
        super.onPerceptible(perceptible);
        IBinder window = this.mController.getHost().getWindowToken();
        if (window != null) {
            this.getImm().reportPerceptible(window, perceptible);
        }
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.dumpDebug(proto, 0x10B00000001L);
        proto.write(1133871366147L, this.mIsRequestedVisibleAwaitingControl);
        proto.write(1133871366148L, this.mIsHideAnimationRunning);
        proto.write(1133871366149L, this.mIsShowRequestedDuringHideAnimation);
        proto.end(token);
    }

    public void onShowRequested() {
        if (this.mIsHideAnimationRunning) {
            this.mIsShowRequestedDuringHideAnimation = true;
        }
    }

    private InputMethodManager getImm() {
        return this.mController.getHost().getInputMethodManager();
    }
}

