/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.content.ClipData;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutofillWindowPresenter;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface IAutoFillManagerClient
extends IInterface {
    public void setState(int var1) throws RemoteException;

    public void autofill(int var1, List<AutofillId> var2, List<AutofillValue> var3, boolean var4) throws RemoteException;

    public void autofillContent(int var1, AutofillId var2, ClipData var3) throws RemoteException;

    public void authenticate(int var1, int var2, IntentSender var3, Intent var4, boolean var5) throws RemoteException;

    public void setTrackedViews(int var1, AutofillId[] var2, boolean var3, boolean var4, AutofillId[] var5, AutofillId var6) throws RemoteException;

    public void requestShowFillUi(int var1, AutofillId var2, int var3, int var4, Rect var5, IAutofillWindowPresenter var6) throws RemoteException;

    public void requestHideFillUi(int var1, AutofillId var2) throws RemoteException;

    public void notifyNoFillUi(int var1, AutofillId var2, int var3) throws RemoteException;

    public void notifyFillUiShown(int var1, AutofillId var2) throws RemoteException;

    public void notifyFillUiHidden(int var1, AutofillId var2) throws RemoteException;

    public void dispatchUnhandledKey(int var1, AutofillId var2, KeyEvent var3) throws RemoteException;

    public void startIntentSender(IntentSender var1, Intent var2) throws RemoteException;

    public void setSaveUiState(int var1, boolean var2) throws RemoteException;

    public void setSessionFinished(int var1, List<AutofillId> var2) throws RemoteException;

    public void getAugmentedAutofillClient(IResultReceiver var1) throws RemoteException;

    public void notifyDisableAutofill(long var1, ComponentName var3) throws RemoteException;

    public void requestShowSoftInput(AutofillId var1) throws RemoteException;

    public void notifyFillDialogTriggerIds(List<AutofillId> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAutoFillManagerClient {
        public static final String DESCRIPTOR = "android.view.autofill.IAutoFillManagerClient";
        static final int TRANSACTION_setState = 1;
        static final int TRANSACTION_autofill = 2;
        static final int TRANSACTION_autofillContent = 3;
        static final int TRANSACTION_authenticate = 4;
        static final int TRANSACTION_setTrackedViews = 5;
        static final int TRANSACTION_requestShowFillUi = 6;
        static final int TRANSACTION_requestHideFillUi = 7;
        static final int TRANSACTION_notifyNoFillUi = 8;
        static final int TRANSACTION_notifyFillUiShown = 9;
        static final int TRANSACTION_notifyFillUiHidden = 10;
        static final int TRANSACTION_dispatchUnhandledKey = 11;
        static final int TRANSACTION_startIntentSender = 12;
        static final int TRANSACTION_setSaveUiState = 13;
        static final int TRANSACTION_setSessionFinished = 14;
        static final int TRANSACTION_getAugmentedAutofillClient = 15;
        static final int TRANSACTION_notifyDisableAutofill = 16;
        static final int TRANSACTION_requestShowSoftInput = 17;
        static final int TRANSACTION_notifyFillDialogTriggerIds = 18;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAutoFillManagerClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAutoFillManagerClient) {
                return (IAutoFillManagerClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setState";
                }
                case 2: {
                    return "autofill";
                }
                case 3: {
                    return "autofillContent";
                }
                case 4: {
                    return "authenticate";
                }
                case 5: {
                    return "setTrackedViews";
                }
                case 6: {
                    return "requestShowFillUi";
                }
                case 7: {
                    return "requestHideFillUi";
                }
                case 8: {
                    return "notifyNoFillUi";
                }
                case 9: {
                    return "notifyFillUiShown";
                }
                case 10: {
                    return "notifyFillUiHidden";
                }
                case 11: {
                    return "dispatchUnhandledKey";
                }
                case 12: {
                    return "startIntentSender";
                }
                case 13: {
                    return "setSaveUiState";
                }
                case 14: {
                    return "setSessionFinished";
                }
                case 15: {
                    return "getAugmentedAutofillClient";
                }
                case 16: {
                    return "notifyDisableAutofill";
                }
                case 17: {
                    return "requestShowSoftInput";
                }
                case 18: {
                    return "notifyFillDialogTriggerIds";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setState(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    ArrayList<AutofillId> _arg1 = data.createTypedArrayList(AutofillId.CREATOR);
                    ArrayList<AutofillValue> _arg2 = data.createTypedArrayList(AutofillValue.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.autofill(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    ClipData _arg2 = data.readTypedObject(ClipData.CREATOR);
                    data.enforceNoDataAvail();
                    this.autofillContent(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IntentSender _arg2 = data.readTypedObject(IntentSender.CREATOR);
                    Intent _arg3 = data.readTypedObject(Intent.CREATOR);
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.authenticate(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    AutofillId[] _arg1 = data.createTypedArray(AutofillId.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    AutofillId[] _arg4 = data.createTypedArray(AutofillId.CREATOR);
                    AutofillId _arg5 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTrackedViews(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Rect _arg4 = data.readTypedObject(Rect.CREATOR);
                    IAutofillWindowPresenter _arg5 = IAutofillWindowPresenter.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestShowFillUi(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestHideFillUi(_arg0, _arg1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyNoFillUi(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyFillUiShown(_arg0, _arg1);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyFillUiHidden(_arg0, _arg1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    KeyEvent _arg2 = data.readTypedObject(KeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchUnhandledKey(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    IntentSender _arg0 = data.readTypedObject(IntentSender.CREATOR);
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    data.enforceNoDataAvail();
                    this.startIntentSender(_arg0, _arg1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSaveUiState(_arg0, _arg1);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    ArrayList<AutofillId> _arg1 = data.createTypedArrayList(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.setSessionFinished(_arg0, _arg1);
                    break;
                }
                case 15: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getAugmentedAutofillClient(_arg0);
                    break;
                }
                case 16: {
                    long _arg0 = data.readLong();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyDisableAutofill(_arg0, _arg1);
                    break;
                }
                case 17: {
                    AutofillId _arg0 = data.readTypedObject(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestShowSoftInput(_arg0);
                    break;
                }
                case 18: {
                    ArrayList<AutofillId> _arg0 = data.createTypedArrayList(AutofillId.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyFillDialogTriggerIds(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements IAutoFillManagerClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setState(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values, boolean hideHighlight) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedList(ids);
                    _data.writeTypedList(values);
                    _data.writeBoolean(hideHighlight);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void autofillContent(int sessionId, AutofillId id2, ClipData content) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    _data.writeTypedObject(content, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent, boolean authenticateInline) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(authenticationId);
                    _data.writeTypedObject(intent, 0);
                    _data.writeTypedObject(fillInIntent, 0);
                    _data.writeBoolean(authenticateInline);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTrackedViews(int sessionId, AutofillId[] savableIds, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedArray(savableIds, 0);
                    _data.writeBoolean(saveOnAllViewsInvisible);
                    _data.writeBoolean(saveOnFinish);
                    _data.writeTypedArray(fillableIds, 0);
                    _data.writeTypedObject(saveTriggerId, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeTypedObject(anchorBounds, 0);
                    _data.writeStrongInterface(presenter);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestHideFillUi(int sessionId, AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    _data.writeInt(sessionFinishedState);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyFillUiShown(int sessionId, AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyFillUiHidden(int sessionId, AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent keyEvent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    _data.writeTypedObject(keyEvent, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startIntentSender(IntentSender intentSender, Intent intent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intentSender, 0);
                    _data.writeTypedObject(intent, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSaveUiState(int sessionId, boolean shown) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeBoolean(shown);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionFinished(int newState, List<AutofillId> autofillableIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newState);
                    _data.writeTypedList(autofillableIds);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAugmentedAutofillClient(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDisableAutofill(long disableDuration, ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(disableDuration);
                    _data.writeTypedObject(componentName, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestShowSoftInput(AutofillId id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(id2, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyFillDialogTriggerIds(List<AutofillId> ids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(ids);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAutoFillManagerClient {
        @Override
        public void setState(int flags) throws RemoteException {
        }

        @Override
        public void autofill(int sessionId, List<AutofillId> ids, List<AutofillValue> values, boolean hideHighlight) throws RemoteException {
        }

        @Override
        public void autofillContent(int sessionId, AutofillId id2, ClipData content) throws RemoteException {
        }

        @Override
        public void authenticate(int sessionId, int authenticationId, IntentSender intent, Intent fillInIntent, boolean authenticateInline) throws RemoteException {
        }

        @Override
        public void setTrackedViews(int sessionId, AutofillId[] savableIds, boolean saveOnAllViewsInvisible, boolean saveOnFinish, AutofillId[] fillableIds, AutofillId saveTriggerId) throws RemoteException {
        }

        @Override
        public void requestShowFillUi(int sessionId, AutofillId id2, int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) throws RemoteException {
        }

        @Override
        public void requestHideFillUi(int sessionId, AutofillId id2) throws RemoteException {
        }

        @Override
        public void notifyNoFillUi(int sessionId, AutofillId id2, int sessionFinishedState) throws RemoteException {
        }

        @Override
        public void notifyFillUiShown(int sessionId, AutofillId id2) throws RemoteException {
        }

        @Override
        public void notifyFillUiHidden(int sessionId, AutofillId id2) throws RemoteException {
        }

        @Override
        public void dispatchUnhandledKey(int sessionId, AutofillId id2, KeyEvent keyEvent) throws RemoteException {
        }

        @Override
        public void startIntentSender(IntentSender intentSender, Intent intent) throws RemoteException {
        }

        @Override
        public void setSaveUiState(int sessionId, boolean shown) throws RemoteException {
        }

        @Override
        public void setSessionFinished(int newState, List<AutofillId> autofillableIds) throws RemoteException {
        }

        @Override
        public void getAugmentedAutofillClient(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void notifyDisableAutofill(long disableDuration, ComponentName componentName) throws RemoteException {
        }

        @Override
        public void requestShowSoftInput(AutofillId id2) throws RemoteException {
        }

        @Override
        public void notifyFillDialogTriggerIds(List<AutofillId> ids) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

