/*
 * Decompiled with CFR 0.152.
 */
package android.view.displayhash;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;

public class DisplayHash
implements Parcelable {
    private final long mTimeMillis;
    private final Rect mBoundsInWindow;
    private final String mHashAlgorithm;
    private final byte[] mImageHash;
    private final byte[] mHmac;
    public static final Parcelable.Creator<DisplayHash> CREATOR = new Parcelable.Creator<DisplayHash>(){

        public DisplayHash[] newArray(int size) {
            return new DisplayHash[size];
        }

        @Override
        public DisplayHash createFromParcel(Parcel in) {
            return new DisplayHash(in);
        }
    };

    @SystemApi
    public DisplayHash(long timeMillis, Rect boundsInWindow, String hashAlgorithm, byte[] imageHash, byte[] hmac) {
        this.mTimeMillis = timeMillis;
        this.mBoundsInWindow = boundsInWindow;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBoundsInWindow);
        this.mHashAlgorithm = hashAlgorithm;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHashAlgorithm);
        this.mImageHash = imageHash;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mImageHash);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
    }

    @SystemApi
    public long getTimeMillis() {
        return this.mTimeMillis;
    }

    @SystemApi
    public Rect getBoundsInWindow() {
        return this.mBoundsInWindow;
    }

    @SystemApi
    public String getHashAlgorithm() {
        return this.mHashAlgorithm;
    }

    @SystemApi
    public byte[] getImageHash() {
        return this.mImageHash;
    }

    @SystemApi
    public byte[] getHmac() {
        return this.mHmac;
    }

    public String toString() {
        return "DisplayHash { timeMillis = " + this.mTimeMillis + ", boundsInWindow = " + this.mBoundsInWindow + ", hashAlgorithm = " + this.mHashAlgorithm + ", imageHash = " + this.byteArrayToString(this.mImageHash) + ", hmac = " + this.byteArrayToString(this.mHmac) + " }";
    }

    private String byteArrayToString(byte[] byteArray) {
        if (byteArray == null) {
            return "null";
        }
        int iMax = byteArray.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            String formatted = String.format("%02X", byteArray[i] & 0xFF);
            b.append(formatted);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @Override
    @SystemApi
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeMillis);
        dest.writeTypedObject(this.mBoundsInWindow, flags);
        dest.writeString(this.mHashAlgorithm);
        dest.writeByteArray(this.mImageHash);
        dest.writeByteArray(this.mHmac);
    }

    @Override
    @SystemApi
    public int describeContents() {
        return 0;
    }

    private DisplayHash(Parcel in) {
        this.mTimeMillis = in.readLong();
        Rect boundsInWindow = in.readTypedObject(Rect.CREATOR);
        String hashAlgorithm = in.readString();
        byte[] imageHash = in.createByteArray();
        byte[] hmac = in.createByteArray();
        this.mBoundsInWindow = boundsInWindow;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBoundsInWindow);
        this.mHashAlgorithm = hashAlgorithm;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHashAlgorithm);
        this.mImageHash = imageHash;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mImageHash);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
    }
}

