/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AppOpsManager;
import android.app.AsyncNotedAppOp;
import android.app.RuntimeAppOpAccessMessage;
import android.app.SyncNotedAppOp;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.PackageTagsList;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;
import com.android.internal.app.IAppOpsActiveCallback;
import com.android.internal.app.IAppOpsAsyncNotedCallback;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsNotedCallback;
import com.android.internal.app.IAppOpsStartedCallback;
import com.android.internal.app.MessageSamplingConfig;
import java.util.ArrayList;
import java.util.List;

public interface IAppOpsService
extends IInterface {
    public int checkOperation(int var1, int var2, String var3) throws RemoteException;

    public SyncNotedAppOp noteOperation(int var1, int var2, String var3, String var4, boolean var5, String var6, boolean var7) throws RemoteException;

    public SyncNotedAppOp startOperation(IBinder var1, int var2, int var3, String var4, String var5, boolean var6, boolean var7, String var8, boolean var9, int var10, int var11) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IAppOpsService.aidl:46:1:46:25")
    public void finishOperation(IBinder var1, int var2, int var3, String var4, String var5) throws RemoteException;

    public void startWatchingMode(int var1, String var2, IAppOpsCallback var3) throws RemoteException;

    public void stopWatchingMode(IAppOpsCallback var1) throws RemoteException;

    public int permissionToOpCode(String var1) throws RemoteException;

    public int checkAudioOperation(int var1, int var2, int var3, String var4) throws RemoteException;

    public boolean shouldCollectNotes(int var1) throws RemoteException;

    public void setCameraAudioRestriction(int var1) throws RemoteException;

    public SyncNotedAppOp noteProxyOperation(int var1, AttributionSource var2, boolean var3, String var4, boolean var5, boolean var6) throws RemoteException;

    public SyncNotedAppOp startProxyOperation(int var1, AttributionSource var2, boolean var3, boolean var4, String var5, boolean var6, boolean var7, int var8, int var9, int var10) throws RemoteException;

    public void finishProxyOperation(int var1, AttributionSource var2, boolean var3) throws RemoteException;

    public int checkPackage(int var1, String var2) throws RemoteException;

    public RuntimeAppOpAccessMessage collectRuntimeAppOpAccessMessage() throws RemoteException;

    public MessageSamplingConfig reportRuntimeAppOpAccessMessageAndGetConfig(String var1, SyncNotedAppOp var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IAppOpsService.aidl:73:1:73:25")
    public List<AppOpsManager.PackageOps> getPackagesForOps(int[] var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IAppOpsService.aidl:75:1:75:25")
    public List<AppOpsManager.PackageOps> getOpsForPackage(int var1, String var2, int[] var3) throws RemoteException;

    public void getHistoricalOps(int var1, String var2, String var3, List<String> var4, int var5, int var6, long var7, long var9, int var11, RemoteCallback var12) throws RemoteException;

    public void getHistoricalOpsFromDiskRaw(int var1, String var2, String var3, List<String> var4, int var5, int var6, long var7, long var9, int var11, RemoteCallback var12) throws RemoteException;

    public void offsetHistory(long var1) throws RemoteException;

    public void setHistoryParameters(int var1, long var2, int var4) throws RemoteException;

    public void addHistoricalOps(AppOpsManager.HistoricalOps var1) throws RemoteException;

    public void resetHistoryParameters() throws RemoteException;

    public void resetPackageOpsNoHistory(String var1) throws RemoteException;

    public void clearHistory() throws RemoteException;

    public void rebootHistory(long var1) throws RemoteException;

    public List<AppOpsManager.PackageOps> getUidOps(int var1, int[] var2) throws RemoteException;

    public void setUidMode(int var1, int var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IAppOpsService.aidl:92:1:92:25")
    public void setMode(int var1, int var2, String var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IAppOpsService.aidl:94:1:94:69")
    public void resetAllModes(int var1, String var2) throws RemoteException;

    public void setAudioRestriction(int var1, int var2, int var3, int var4, String[] var5) throws RemoteException;

    public void setUserRestrictions(Bundle var1, IBinder var2, int var3) throws RemoteException;

    public void setUserRestriction(int var1, boolean var2, IBinder var3, int var4, PackageTagsList var5) throws RemoteException;

    public void removeUser(int var1) throws RemoteException;

    public void startWatchingActive(int[] var1, IAppOpsActiveCallback var2) throws RemoteException;

    public void stopWatchingActive(IAppOpsActiveCallback var1) throws RemoteException;

    public boolean isOperationActive(int var1, int var2, String var3) throws RemoteException;

    public boolean isProxying(int var1, String var2, String var3, int var4, String var5) throws RemoteException;

    public void startWatchingStarted(int[] var1, IAppOpsStartedCallback var2) throws RemoteException;

    public void stopWatchingStarted(IAppOpsStartedCallback var1) throws RemoteException;

    public void startWatchingModeWithFlags(int var1, String var2, int var3, IAppOpsCallback var4) throws RemoteException;

    public void startWatchingNoted(int[] var1, IAppOpsNotedCallback var2) throws RemoteException;

    public void stopWatchingNoted(IAppOpsNotedCallback var1) throws RemoteException;

    public void startWatchingAsyncNoted(String var1, IAppOpsAsyncNotedCallback var2) throws RemoteException;

    public void stopWatchingAsyncNoted(String var1, IAppOpsAsyncNotedCallback var2) throws RemoteException;

    public List<AsyncNotedAppOp> extractAsyncOps(String var1) throws RemoteException;

    public int checkOperationRaw(int var1, int var2, String var3, String var4) throws RemoteException;

    public void reloadNonHistoricalState() throws RemoteException;

    public void collectNoteOpCallsForValidation(String var1, int var2, String var3, long var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAppOpsService {
        public static final String DESCRIPTOR = "com.android.internal.app.IAppOpsService";
        static final int TRANSACTION_checkOperation = 1;
        static final int TRANSACTION_noteOperation = 2;
        static final int TRANSACTION_startOperation = 3;
        static final int TRANSACTION_finishOperation = 4;
        static final int TRANSACTION_startWatchingMode = 5;
        static final int TRANSACTION_stopWatchingMode = 6;
        static final int TRANSACTION_permissionToOpCode = 7;
        static final int TRANSACTION_checkAudioOperation = 8;
        static final int TRANSACTION_shouldCollectNotes = 9;
        static final int TRANSACTION_setCameraAudioRestriction = 10;
        static final int TRANSACTION_noteProxyOperation = 11;
        static final int TRANSACTION_startProxyOperation = 12;
        static final int TRANSACTION_finishProxyOperation = 13;
        static final int TRANSACTION_checkPackage = 14;
        static final int TRANSACTION_collectRuntimeAppOpAccessMessage = 15;
        static final int TRANSACTION_reportRuntimeAppOpAccessMessageAndGetConfig = 16;
        static final int TRANSACTION_getPackagesForOps = 17;
        static final int TRANSACTION_getOpsForPackage = 18;
        static final int TRANSACTION_getHistoricalOps = 19;
        static final int TRANSACTION_getHistoricalOpsFromDiskRaw = 20;
        static final int TRANSACTION_offsetHistory = 21;
        static final int TRANSACTION_setHistoryParameters = 22;
        static final int TRANSACTION_addHistoricalOps = 23;
        static final int TRANSACTION_resetHistoryParameters = 24;
        static final int TRANSACTION_resetPackageOpsNoHistory = 25;
        static final int TRANSACTION_clearHistory = 26;
        static final int TRANSACTION_rebootHistory = 27;
        static final int TRANSACTION_getUidOps = 28;
        static final int TRANSACTION_setUidMode = 29;
        static final int TRANSACTION_setMode = 30;
        static final int TRANSACTION_resetAllModes = 31;
        static final int TRANSACTION_setAudioRestriction = 32;
        static final int TRANSACTION_setUserRestrictions = 33;
        static final int TRANSACTION_setUserRestriction = 34;
        static final int TRANSACTION_removeUser = 35;
        static final int TRANSACTION_startWatchingActive = 36;
        static final int TRANSACTION_stopWatchingActive = 37;
        static final int TRANSACTION_isOperationActive = 38;
        static final int TRANSACTION_isProxying = 39;
        static final int TRANSACTION_startWatchingStarted = 40;
        static final int TRANSACTION_stopWatchingStarted = 41;
        static final int TRANSACTION_startWatchingModeWithFlags = 42;
        static final int TRANSACTION_startWatchingNoted = 43;
        static final int TRANSACTION_stopWatchingNoted = 44;
        static final int TRANSACTION_startWatchingAsyncNoted = 45;
        static final int TRANSACTION_stopWatchingAsyncNoted = 46;
        static final int TRANSACTION_extractAsyncOps = 47;
        static final int TRANSACTION_checkOperationRaw = 48;
        static final int TRANSACTION_reloadNonHistoricalState = 49;
        static final int TRANSACTION_collectNoteOpCallsForValidation = 50;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAppOpsService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAppOpsService) {
                return (IAppOpsService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "checkOperation";
                }
                case 2: {
                    return "noteOperation";
                }
                case 3: {
                    return "startOperation";
                }
                case 4: {
                    return "finishOperation";
                }
                case 5: {
                    return "startWatchingMode";
                }
                case 6: {
                    return "stopWatchingMode";
                }
                case 7: {
                    return "permissionToOpCode";
                }
                case 8: {
                    return "checkAudioOperation";
                }
                case 9: {
                    return "shouldCollectNotes";
                }
                case 10: {
                    return "setCameraAudioRestriction";
                }
                case 11: {
                    return "noteProxyOperation";
                }
                case 12: {
                    return "startProxyOperation";
                }
                case 13: {
                    return "finishProxyOperation";
                }
                case 14: {
                    return "checkPackage";
                }
                case 15: {
                    return "collectRuntimeAppOpAccessMessage";
                }
                case 16: {
                    return "reportRuntimeAppOpAccessMessageAndGetConfig";
                }
                case 17: {
                    return "getPackagesForOps";
                }
                case 18: {
                    return "getOpsForPackage";
                }
                case 19: {
                    return "getHistoricalOps";
                }
                case 20: {
                    return "getHistoricalOpsFromDiskRaw";
                }
                case 21: {
                    return "offsetHistory";
                }
                case 22: {
                    return "setHistoryParameters";
                }
                case 23: {
                    return "addHistoricalOps";
                }
                case 24: {
                    return "resetHistoryParameters";
                }
                case 25: {
                    return "resetPackageOpsNoHistory";
                }
                case 26: {
                    return "clearHistory";
                }
                case 27: {
                    return "rebootHistory";
                }
                case 28: {
                    return "getUidOps";
                }
                case 29: {
                    return "setUidMode";
                }
                case 30: {
                    return "setMode";
                }
                case 31: {
                    return "resetAllModes";
                }
                case 32: {
                    return "setAudioRestriction";
                }
                case 33: {
                    return "setUserRestrictions";
                }
                case 34: {
                    return "setUserRestriction";
                }
                case 35: {
                    return "removeUser";
                }
                case 36: {
                    return "startWatchingActive";
                }
                case 37: {
                    return "stopWatchingActive";
                }
                case 38: {
                    return "isOperationActive";
                }
                case 39: {
                    return "isProxying";
                }
                case 40: {
                    return "startWatchingStarted";
                }
                case 41: {
                    return "stopWatchingStarted";
                }
                case 42: {
                    return "startWatchingModeWithFlags";
                }
                case 43: {
                    return "startWatchingNoted";
                }
                case 44: {
                    return "stopWatchingNoted";
                }
                case 45: {
                    return "startWatchingAsyncNoted";
                }
                case 46: {
                    return "stopWatchingAsyncNoted";
                }
                case 47: {
                    return "extractAsyncOps";
                }
                case 48: {
                    return "checkOperationRaw";
                }
                case 49: {
                    return "reloadNonHistoricalState";
                }
                case 50: {
                    return "collectNoteOpCallsForValidation";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.checkOperation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _arg4 = data.readBoolean();
                    String _arg5 = data.readString();
                    boolean _arg6 = data.readBoolean();
                    data.enforceNoDataAvail();
                    SyncNotedAppOp _result = this.noteOperation(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    boolean _arg5 = data.readBoolean();
                    boolean _arg6 = data.readBoolean();
                    String _arg7 = data.readString();
                    boolean _arg8 = data.readBoolean();
                    int _arg9 = data.readInt();
                    int _arg10 = data.readInt();
                    data.enforceNoDataAvail();
                    SyncNotedAppOp _result = this.startOperation(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.finishOperation(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IAppOpsCallback _arg2 = IAppOpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startWatchingMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IAppOpsCallback _arg0 = IAppOpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stopWatchingMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.permissionToOpCode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.checkAudioOperation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldCollectNotes(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setCameraAudioRestriction(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    String _arg3 = data.readString();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    SyncNotedAppOp _result = this.noteProxyOperation(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    String _arg4 = data.readString();
                    boolean _arg5 = data.readBoolean();
                    boolean _arg6 = data.readBoolean();
                    int _arg7 = data.readInt();
                    int _arg8 = data.readInt();
                    int _arg9 = data.readInt();
                    data.enforceNoDataAvail();
                    SyncNotedAppOp _result = this.startProxyOperation(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.finishProxyOperation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.checkPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    RuntimeAppOpAccessMessage _result = this.collectRuntimeAppOpAccessMessage();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    SyncNotedAppOp _arg1 = data.readTypedObject(SyncNotedAppOp.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    MessageSamplingConfig _result = this.reportRuntimeAppOpAccessMessageAndGetConfig(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 17: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    List<AppOpsManager.PackageOps> _result = this.getPackagesForOps(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    List<AppOpsManager.PackageOps> _result = this.getOpsForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    ArrayList<String> _arg3 = data.createStringArrayList();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    long _arg6 = data.readLong();
                    long _arg7 = data.readLong();
                    int _arg8 = data.readInt();
                    RemoteCallback _arg9 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.getHistoricalOps(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    ArrayList<String> _arg3 = data.createStringArrayList();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    long _arg6 = data.readLong();
                    long _arg7 = data.readLong();
                    int _arg8 = data.readInt();
                    RemoteCallback _arg9 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.getHistoricalOpsFromDiskRaw(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.offsetHistory(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setHistoryParameters(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    AppOpsManager.HistoricalOps _arg0 = data.readTypedObject(AppOpsManager.HistoricalOps.CREATOR);
                    data.enforceNoDataAvail();
                    this.addHistoricalOps(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    this.resetHistoryParameters();
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.resetPackageOpsNoHistory(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    this.clearHistory();
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.rebootHistory(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    List<AppOpsManager.PackageOps> _result = this.getUidOps(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setUidMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setMode(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.resetAllModes(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    String[] _arg4 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.setAudioRestriction(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setUserRestrictions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    IBinder _arg2 = data.readStrongBinder();
                    int _arg3 = data.readInt();
                    PackageTagsList _arg4 = data.readTypedObject(PackageTagsList.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUserRestriction(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeUser(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int[] _arg0 = data.createIntArray();
                    IAppOpsActiveCallback _arg1 = IAppOpsActiveCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startWatchingActive(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    IAppOpsActiveCallback _arg0 = IAppOpsActiveCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stopWatchingActive(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isOperationActive(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isProxying(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    int[] _arg0 = data.createIntArray();
                    IAppOpsStartedCallback _arg1 = IAppOpsStartedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startWatchingStarted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    IAppOpsStartedCallback _arg0 = IAppOpsStartedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stopWatchingStarted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    IAppOpsCallback _arg3 = IAppOpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startWatchingModeWithFlags(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int[] _arg0 = data.createIntArray();
                    IAppOpsNotedCallback _arg1 = IAppOpsNotedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startWatchingNoted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    IAppOpsNotedCallback _arg0 = IAppOpsNotedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stopWatchingNoted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    String _arg0 = data.readString();
                    IAppOpsAsyncNotedCallback _arg1 = IAppOpsAsyncNotedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startWatchingAsyncNoted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    String _arg0 = data.readString();
                    IAppOpsAsyncNotedCallback _arg1 = IAppOpsAsyncNotedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stopWatchingAsyncNoted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<AsyncNotedAppOp> _result = this.extractAsyncOps(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.checkOperationRaw(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 49: {
                    this.reloadNonHistoricalState();
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.collectNoteOpCallsForValidation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 49;
        }

        private static class Proxy
        implements IAppOpsService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkOperation(int code, int uid, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncNotedAppOp noteOperation(int code, int uid, String packageName, String attributionTag, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage) throws RemoteException {
                SyncNotedAppOp _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeBoolean(shouldCollectAsyncNotedOp);
                    _data.writeString(message);
                    _data.writeBoolean(shouldCollectMessage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SyncNotedAppOp.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncNotedAppOp startOperation(IBinder clientId, int code, int uid, String packageName, String attributionTag, boolean startIfModeDefault, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage, int attributionFlags, int attributionChainId) throws RemoteException {
                SyncNotedAppOp _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientId);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeBoolean(startIfModeDefault);
                    _data.writeBoolean(shouldCollectAsyncNotedOp);
                    _data.writeString(message);
                    _data.writeBoolean(shouldCollectMessage);
                    _data.writeInt(attributionFlags);
                    _data.writeInt(attributionChainId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SyncNotedAppOp.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishOperation(IBinder clientId, int code, int uid, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientId);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchingMode(int op, String packageName, IAppOpsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(op);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchingMode(IAppOpsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int permissionToOpCode(String permission2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permission2);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkAudioOperation(int code, int usage, int uid, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(usage);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldCollectNotes(int opCode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(opCode);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCameraAudioRestriction(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncNotedAppOp noteProxyOperation(int code, AttributionSource attributionSource, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage, boolean skipProxyOperation) throws RemoteException {
                SyncNotedAppOp _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeBoolean(shouldCollectAsyncNotedOp);
                    _data.writeString(message);
                    _data.writeBoolean(shouldCollectMessage);
                    _data.writeBoolean(skipProxyOperation);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SyncNotedAppOp.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncNotedAppOp startProxyOperation(int code, AttributionSource attributionSource, boolean startIfModeDefault, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage, boolean skipProxyOperation, int proxyAttributionFlags, int proxiedAttributionFlags, int attributionChainId) throws RemoteException {
                SyncNotedAppOp _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeBoolean(startIfModeDefault);
                    _data.writeBoolean(shouldCollectAsyncNotedOp);
                    _data.writeString(message);
                    _data.writeBoolean(shouldCollectMessage);
                    _data.writeBoolean(skipProxyOperation);
                    _data.writeInt(proxyAttributionFlags);
                    _data.writeInt(proxiedAttributionFlags);
                    _data.writeInt(attributionChainId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SyncNotedAppOp.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishProxyOperation(int code, AttributionSource attributionSource, boolean skipProxyOperation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeBoolean(skipProxyOperation);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkPackage(int uid, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RuntimeAppOpAccessMessage collectRuntimeAppOpAccessMessage() throws RemoteException {
                RuntimeAppOpAccessMessage _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RuntimeAppOpAccessMessage.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MessageSamplingConfig reportRuntimeAppOpAccessMessageAndGetConfig(String packageName, SyncNotedAppOp appOp, String message) throws RemoteException {
                MessageSamplingConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(appOp, 0);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MessageSamplingConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AppOpsManager.PackageOps> getPackagesForOps(int[] ops) throws RemoteException {
                ArrayList<AppOpsManager.PackageOps> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(ops);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AppOpsManager.PackageOps.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) throws RemoteException {
                ArrayList<AppOpsManager.PackageOps> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeIntArray(ops);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AppOpsManager.PackageOps.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHistoricalOps(int uid, String packageName, String attributionTag, List<String> ops, int historyFlags, int filter, long beginTimeMillis, long endTimeMillis, int flags, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeStringList(ops);
                    _data.writeInt(historyFlags);
                    _data.writeInt(filter);
                    _data.writeLong(beginTimeMillis);
                    _data.writeLong(endTimeMillis);
                    _data.writeInt(flags);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHistoricalOpsFromDiskRaw(int uid, String packageName, String attributionTag, List<String> ops, int historyFlags, int filter, long beginTimeMillis, long endTimeMillis, int flags, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeStringList(ops);
                    _data.writeInt(historyFlags);
                    _data.writeInt(filter);
                    _data.writeLong(beginTimeMillis);
                    _data.writeLong(endTimeMillis);
                    _data.writeInt(flags);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void offsetHistory(long duration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(duration);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHistoryParameters(int mode, long baseSnapshotInterval, int compressionStep) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeLong(baseSnapshotInterval);
                    _data.writeInt(compressionStep);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addHistoricalOps(AppOpsManager.HistoricalOps ops) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ops, 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetHistoryParameters() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetPackageOpsNoHistory(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearHistory() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rebootHistory(long offlineDurationMillis) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(offlineDurationMillis);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AppOpsManager.PackageOps> getUidOps(int uid, int[] ops) throws RemoteException {
                ArrayList<AppOpsManager.PackageOps> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeIntArray(ops);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AppOpsManager.PackageOps.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUidMode(int code, int uid, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMode(int code, int uid, String packageName, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetAllModes(int reqUserId, String reqPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reqUserId);
                    _data.writeString(reqPackageName);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAudioRestriction(int code, int usage, int uid, int mode, String[] exceptionPackages) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(usage);
                    _data.writeInt(uid);
                    _data.writeInt(mode);
                    _data.writeStringArray(exceptionPackages);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserRestrictions(Bundle restrictions, IBinder token, int userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(restrictions, 0);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userHandle);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserRestriction(int code, boolean restricted, IBinder token, int userHandle, PackageTagsList excludedPackageTags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeBoolean(restricted);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userHandle);
                    _data.writeTypedObject(excludedPackageTags, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUser(int userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userHandle);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchingActive(int[] ops, IAppOpsActiveCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(ops);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchingActive(IAppOpsActiveCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isOperationActive(int code, int uid, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isProxying(int op, String proxyPackageName, String proxyAttributionTag, int proxiedUid, String proxiedPackageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(op);
                    _data.writeString(proxyPackageName);
                    _data.writeString(proxyAttributionTag);
                    _data.writeInt(proxiedUid);
                    _data.writeString(proxiedPackageName);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchingStarted(int[] ops, IAppOpsStartedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(ops);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchingStarted(IAppOpsStartedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchingModeWithFlags(int op, String packageName, int flags, IAppOpsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(op);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchingNoted(int[] ops, IAppOpsNotedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(ops);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchingNoted(IAppOpsNotedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchingAsyncNoted(String packageName, IAppOpsAsyncNotedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchingAsyncNoted(String packageName, IAppOpsAsyncNotedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AsyncNotedAppOp> extractAsyncOps(String packageName) throws RemoteException {
                ArrayList<AsyncNotedAppOp> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AsyncNotedAppOp.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkOperationRaw(int code, int uid, String packageName, String attributionTag) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(code);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reloadNonHistoricalState() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void collectNoteOpCallsForValidation(String stackTrace, int op, String packageName, long version) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(stackTrace);
                    _data.writeInt(op);
                    _data.writeString(packageName);
                    _data.writeLong(version);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAppOpsService {
        @Override
        public int checkOperation(int code, int uid, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public SyncNotedAppOp noteOperation(int code, int uid, String packageName, String attributionTag, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage) throws RemoteException {
            return null;
        }

        @Override
        public SyncNotedAppOp startOperation(IBinder clientId, int code, int uid, String packageName, String attributionTag, boolean startIfModeDefault, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage, int attributionFlags, int attributionChainId) throws RemoteException {
            return null;
        }

        @Override
        public void finishOperation(IBinder clientId, int code, int uid, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void startWatchingMode(int op, String packageName, IAppOpsCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchingMode(IAppOpsCallback callback) throws RemoteException {
        }

        @Override
        public int permissionToOpCode(String permission2) throws RemoteException {
            return 0;
        }

        @Override
        public int checkAudioOperation(int code, int usage, int uid, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public boolean shouldCollectNotes(int opCode) throws RemoteException {
            return false;
        }

        @Override
        public void setCameraAudioRestriction(int mode) throws RemoteException {
        }

        @Override
        public SyncNotedAppOp noteProxyOperation(int code, AttributionSource attributionSource, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage, boolean skipProxyOperation) throws RemoteException {
            return null;
        }

        @Override
        public SyncNotedAppOp startProxyOperation(int code, AttributionSource attributionSource, boolean startIfModeDefault, boolean shouldCollectAsyncNotedOp, String message, boolean shouldCollectMessage, boolean skipProxyOperation, int proxyAttributionFlags, int proxiedAttributionFlags, int attributionChainId) throws RemoteException {
            return null;
        }

        @Override
        public void finishProxyOperation(int code, AttributionSource attributionSource, boolean skipProxyOperation) throws RemoteException {
        }

        @Override
        public int checkPackage(int uid, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public RuntimeAppOpAccessMessage collectRuntimeAppOpAccessMessage() throws RemoteException {
            return null;
        }

        @Override
        public MessageSamplingConfig reportRuntimeAppOpAccessMessageAndGetConfig(String packageName, SyncNotedAppOp appOp, String message) throws RemoteException {
            return null;
        }

        @Override
        public List<AppOpsManager.PackageOps> getPackagesForOps(int[] ops) throws RemoteException {
            return null;
        }

        @Override
        public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) throws RemoteException {
            return null;
        }

        @Override
        public void getHistoricalOps(int uid, String packageName, String attributionTag, List<String> ops, int historyFlags, int filter, long beginTimeMillis, long endTimeMillis, int flags, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void getHistoricalOpsFromDiskRaw(int uid, String packageName, String attributionTag, List<String> ops, int historyFlags, int filter, long beginTimeMillis, long endTimeMillis, int flags, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void offsetHistory(long duration) throws RemoteException {
        }

        @Override
        public void setHistoryParameters(int mode, long baseSnapshotInterval, int compressionStep) throws RemoteException {
        }

        @Override
        public void addHistoricalOps(AppOpsManager.HistoricalOps ops) throws RemoteException {
        }

        @Override
        public void resetHistoryParameters() throws RemoteException {
        }

        @Override
        public void resetPackageOpsNoHistory(String packageName) throws RemoteException {
        }

        @Override
        public void clearHistory() throws RemoteException {
        }

        @Override
        public void rebootHistory(long offlineDurationMillis) throws RemoteException {
        }

        @Override
        public List<AppOpsManager.PackageOps> getUidOps(int uid, int[] ops) throws RemoteException {
            return null;
        }

        @Override
        public void setUidMode(int code, int uid, int mode) throws RemoteException {
        }

        @Override
        public void setMode(int code, int uid, String packageName, int mode) throws RemoteException {
        }

        @Override
        public void resetAllModes(int reqUserId, String reqPackageName) throws RemoteException {
        }

        @Override
        public void setAudioRestriction(int code, int usage, int uid, int mode, String[] exceptionPackages) throws RemoteException {
        }

        @Override
        public void setUserRestrictions(Bundle restrictions, IBinder token, int userHandle) throws RemoteException {
        }

        @Override
        public void setUserRestriction(int code, boolean restricted, IBinder token, int userHandle, PackageTagsList excludedPackageTags) throws RemoteException {
        }

        @Override
        public void removeUser(int userHandle) throws RemoteException {
        }

        @Override
        public void startWatchingActive(int[] ops, IAppOpsActiveCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchingActive(IAppOpsActiveCallback callback) throws RemoteException {
        }

        @Override
        public boolean isOperationActive(int code, int uid, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean isProxying(int op, String proxyPackageName, String proxyAttributionTag, int proxiedUid, String proxiedPackageName) throws RemoteException {
            return false;
        }

        @Override
        public void startWatchingStarted(int[] ops, IAppOpsStartedCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchingStarted(IAppOpsStartedCallback callback) throws RemoteException {
        }

        @Override
        public void startWatchingModeWithFlags(int op, String packageName, int flags, IAppOpsCallback callback) throws RemoteException {
        }

        @Override
        public void startWatchingNoted(int[] ops, IAppOpsNotedCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchingNoted(IAppOpsNotedCallback callback) throws RemoteException {
        }

        @Override
        public void startWatchingAsyncNoted(String packageName, IAppOpsAsyncNotedCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchingAsyncNoted(String packageName, IAppOpsAsyncNotedCallback callback) throws RemoteException {
        }

        @Override
        public List<AsyncNotedAppOp> extractAsyncOps(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public int checkOperationRaw(int code, int uid, String packageName, String attributionTag) throws RemoteException {
            return 0;
        }

        @Override
        public void reloadNonHistoricalState() throws RemoteException {
        }

        @Override
        public void collectNoteOpCallsForValidation(String stackTrace, int op, String packageName, long version) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

