/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.util.Log;
import android.util.Size;
import com.android.internal.annotations.VisibleForTesting;
import java.io.IOException;

public class LocalImageResolver {
    private static final String TAG = "LocalImageResolver";
    public static final int NO_MAX_SIZE = -1;
    @VisibleForTesting
    static final int DEFAULT_MAX_SAFE_ICON_SIZE_PX = 480;

    public static Drawable resolveImage(Uri uri, Context context) throws IOException {
        try {
            ImageDecoder.Source source = ImageDecoder.createSource(context.getContentResolver(), uri);
            return ImageDecoder.decodeDrawable(source, (decoder, info, s) -> LocalImageResolver.onHeaderDecoded(decoder, info, 480, 480));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Drawable resolveImage(Icon icon, Context context) throws IOException {
        return LocalImageResolver.resolveImage(icon, context, 480, 480);
    }

    public static Drawable resolveImage(Icon icon, Context context, int maxWidth, int maxHeight) {
        if (icon == null) {
            return null;
        }
        switch (icon.getType()) {
            case 4: 
            case 6: {
                Drawable result;
                Uri uri = LocalImageResolver.getResolvableUri(icon);
                if (uri == null || (result = LocalImageResolver.resolveImage(uri, context, maxWidth, maxHeight)) == null) break;
                return LocalImageResolver.tintDrawable(icon, result);
            }
            case 2: {
                Drawable result = LocalImageResolver.resolveImage(icon.getResId(), context, maxWidth, maxHeight);
                if (result == null) break;
                return LocalImageResolver.tintDrawable(icon, result);
            }
            case 1: 
            case 5: {
                return LocalImageResolver.resolveBitmapImage(icon, context, maxWidth, maxHeight);
            }
        }
        try {
            return icon.loadDrawable(context);
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
    }

    public static Drawable resolveImage(Uri uri, Context context, int maxWidth, int maxHeight) {
        ImageDecoder.Source source = ImageDecoder.createSource(context.getContentResolver(), uri);
        return LocalImageResolver.resolveImage(source, maxWidth, maxHeight);
    }

    public static Drawable resolveImage(int resId, Context context, int maxWidth, int maxHeight) {
        ImageDecoder.Source source = ImageDecoder.createSource(context.getResources(), resId);
        return LocalImageResolver.resolveImage(source, maxWidth, maxHeight);
    }

    private static Drawable resolveBitmapImage(Icon icon, Context context, int maxWidth, int maxHeight) {
        if (maxWidth > 0 && maxHeight > 0) {
            Bitmap bitmap = icon.getBitmap();
            if (bitmap == null) {
                return null;
            }
            if (bitmap.getWidth() > maxWidth || bitmap.getHeight() > maxHeight) {
                Icon smallerIcon = icon.getType() == 5 ? Icon.createWithAdaptiveBitmap(bitmap) : Icon.createWithBitmap(bitmap);
                smallerIcon.setTintList(icon.getTintList()).setTintBlendMode(icon.getTintBlendMode()).scaleDownIfNecessary(maxWidth, maxHeight);
                return smallerIcon.loadDrawable(context);
            }
        }
        return icon.loadDrawable(context);
    }

    private static Drawable tintDrawable(Icon icon, Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        if (icon.hasTint()) {
            drawable2.mutate();
            drawable2.setTintList(icon.getTintList());
            drawable2.setTintBlendMode(icon.getTintBlendMode());
        }
        return drawable2;
    }

    private static Drawable resolveImage(ImageDecoder.Source source, int maxWidth, int maxHeight) {
        try {
            return ImageDecoder.decodeDrawable(source, (decoder, info, unused) -> {
                if (maxWidth <= 0 || maxHeight <= 0) {
                    return;
                }
                Size size = info.getSize();
                if (size.getWidth() <= maxWidth && size.getHeight() <= maxHeight) {
                    return;
                }
                if (size.getWidth() > size.getHeight()) {
                    if (size.getWidth() > maxWidth) {
                        int targetHeight = size.getHeight() * maxWidth / size.getWidth();
                        decoder.setTargetSize(maxWidth, targetHeight);
                    }
                } else if (size.getHeight() > maxHeight) {
                    int targetWidth = size.getWidth() * maxHeight / size.getHeight();
                    decoder.setTargetSize(targetWidth, maxHeight);
                }
            });
        }
        catch (Resources.NotFoundException | IOException e) {
            Log.d(TAG, "Couldn't use ImageDecoder for drawable, falling back to non-resized load.");
            return null;
        }
    }

    private static int getPowerOfTwoForSampleRatio(double ratio) {
        int k = Integer.highestOneBit((int)Math.floor(ratio));
        return Math.max(1, k);
    }

    private static void onHeaderDecoded(ImageDecoder decoder, ImageDecoder.ImageInfo info, int maxWidth, int maxHeight) {
        int maxSize;
        Size size = info.getSize();
        int originalSize = Math.max(size.getHeight(), size.getWidth());
        double ratio = originalSize > (maxSize = Math.max(maxWidth, maxHeight)) ? (double)((float)originalSize * 1.0f / (float)maxSize) : 1.0;
        decoder.setTargetSampleSize(LocalImageResolver.getPowerOfTwoForSampleRatio(ratio));
    }

    private static Uri getResolvableUri(Icon icon) {
        if (icon == null || icon.getType() != 4 && icon.getType() != 6) {
            return null;
        }
        return icon.getUri();
    }
}

