/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import android.app.WallpaperColors;
import android.graphics.Color;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.cam.Cam;
import com.android.internal.graphics.cam.CamUtils;
import com.android.systemui.monet.ColorScheme;
import com.android.systemui.monet.Style;
import com.android.systemui.monet.TonalSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010'\u001a\u00020(H\u0016R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lcom/android/systemui/monet/ColorScheme;", "", "seed", "", "darkTheme", "", "(IZ)V", "wallpaperColors", "Landroid/app/WallpaperColors;", "style", "Lcom/android/systemui/monet/Style;", "(Landroid/app/WallpaperColors;ZLcom/android/systemui/monet/Style;)V", "(IZLcom/android/systemui/monet/Style;)V", "accent1", "", "getAccent1", "()Ljava/util/List;", "accent2", "getAccent2", "accent3", "getAccent3", "accentColor", "getAccentColor", "()I", "allAccentColors", "getAllAccentColors", "allNeutralColors", "getAllNeutralColors", "backgroundColor", "getBackgroundColor", "getDarkTheme", "()Z", "neutral1", "getNeutral1", "neutral2", "getNeutral2", "getSeed", "getStyle", "()Lcom/android/systemui/monet/Style;", "toString", "", "Companion", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
public class ColorScheme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int seed;
    private final boolean darkTheme;
    @NotNull
    private final Style style;
    @NotNull
    private final List<Integer> accent1;
    @NotNull
    private final List<Integer> accent2;
    @NotNull
    private final List<Integer> accent3;
    @NotNull
    private final List<Integer> neutral1;
    @NotNull
    private final List<Integer> neutral2;

    public ColorScheme(int seed, boolean darkTheme, @NotNull Style style2) {
        Intrinsics.checkNotNullParameter((Object)((Object)style2), (String)"style");
        this.seed = seed;
        this.darkTheme = darkTheme;
        this.style = style2;
        Cam proposedSeedCam = Cam.fromInt(this.seed);
        int seedArgb = this.seed == 0 ? -14979341 : (this.style != Style.CONTENT && proposedSeedCam.getChroma() < 5.0f ? -14979341 : this.seed);
        Cam camSeed = Cam.fromInt(seedArgb);
        TonalSpec tonalSpec = this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getA1();
        Intrinsics.checkNotNullExpressionValue((Object)camSeed, (String)"camSeed");
        this.accent1 = tonalSpec.shades(camSeed);
        this.accent2 = this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getA2().shades(camSeed);
        this.accent3 = this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getA3().shades(camSeed);
        this.neutral1 = this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getN1().shades(camSeed);
        this.neutral2 = this.style.getCoreSpec$frameworks__base__packages__SystemUI__monet__android_common__monet().getN2().shades(camSeed);
    }

    public /* synthetic */ ColorScheme(int n, boolean bl, Style style2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            style2 = Style.TONAL_SPOT;
        }
        this(n, bl, style2);
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean getDarkTheme() {
        return this.darkTheme;
    }

    @NotNull
    public Style getStyle() {
        return this.style;
    }

    @NotNull
    public List<Integer> getAccent1() {
        return this.accent1;
    }

    @NotNull
    public List<Integer> getAccent2() {
        return this.accent2;
    }

    @NotNull
    public List<Integer> getAccent3() {
        return this.accent3;
    }

    @NotNull
    public List<Integer> getNeutral1() {
        return this.neutral1;
    }

    @NotNull
    public List<Integer> getNeutral2() {
        return this.neutral2;
    }

    public ColorScheme(int seed, boolean darkTheme) {
        this(seed, darkTheme, Style.TONAL_SPOT);
    }

    @JvmOverloads
    public ColorScheme(@NotNull WallpaperColors wallpaperColors, boolean darkTheme, @NotNull Style style2) {
        Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
        Intrinsics.checkNotNullParameter((Object)((Object)style2), (String)"style");
        this(Companion.getSeedColor(wallpaperColors, style2 != Style.CONTENT), darkTheme, style2);
    }

    public /* synthetic */ ColorScheme(WallpaperColors wallpaperColors, boolean bl, Style style2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            style2 = Style.TONAL_SPOT;
        }
        this(wallpaperColors, bl, style2);
    }

    @NotNull
    public List<Integer> getAllAccentColors() {
        List allColors = new ArrayList();
        allColors.addAll((Collection)this.accent1);
        allColors.addAll((Collection)this.accent2);
        allColors.addAll((Collection)this.accent3);
        return allColors;
    }

    @NotNull
    public List<Integer> getAllNeutralColors() {
        List allColors = new ArrayList();
        allColors.addAll((Collection)this.neutral1);
        allColors.addAll((Collection)this.neutral2);
        return allColors;
    }

    public int getBackgroundColor() {
        return ColorUtils.setAlphaComponent(this.darkTheme ? ((Number)this.neutral1.get(8)).intValue() : ((Number)this.neutral1.get(0)).intValue(), 255);
    }

    public int getAccentColor() {
        return ColorUtils.setAlphaComponent(this.darkTheme ? ((Number)this.accent1.get(2)).intValue() : ((Number)this.accent1.get(6)).intValue(), 255);
    }

    @NotNull
    public String toString() {
        return "ColorScheme {\n  seed color: " + ColorScheme.Companion.stringForColor(this.seed) + "\n  style: " + (Object)((Object)this.style) + "\n  palettes: \n  " + ColorScheme.Companion.humanReadable("PRIMARY", this.accent1) + "\n  " + ColorScheme.Companion.humanReadable("SECONDARY", this.accent2) + "\n  " + ColorScheme.Companion.humanReadable("TERTIARY", this.accent3) + "\n  " + ColorScheme.Companion.humanReadable("NEUTRAL", this.neutral1) + "\n  " + ColorScheme.Companion.humanReadable("NEUTRAL VARIANT", this.neutral2) + "\n}";
    }

    @JvmOverloads
    public ColorScheme(@NotNull WallpaperColors wallpaperColors, boolean darkTheme) {
        Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
        this(wallpaperColors, darkTheme, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static int getSeedColor(@NotNull WallpaperColors wallpaperColors, boolean filter) {
        return Companion.getSeedColor(wallpaperColors, filter);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors, boolean filter) {
        return Companion.getSeedColors(wallpaperColors, filter);
    }

    @JvmStatic
    @JvmOverloads
    public static int getSeedColor(@NotNull WallpaperColors wallpaperColors) {
        return Companion.getSeedColor(wallpaperColors);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors) {
        return Companion.getSeedColors(wallpaperColors);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J@\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00122\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010\u00a8\u0006!"}, d2={"Lcom/android/systemui/monet/ColorScheme$Companion;", "", "()V", "getSeedColor", "", "wallpaperColors", "Landroid/app/WallpaperColors;", "filter", "", "getSeedColors", "", "hueDiff", "", "a", "b", "huePopulations", "", "camByColor", "", "Lcom/android/internal/graphics/cam/Cam;", "populationByColor", "humanReadable", "", "paletteName", "colors", "score", "cam", "proportion", "stringForColor", "color", "wrapDegrees", "degrees", "wrapDegreesDouble", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
    public static class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public int getSeedColor(@NotNull WallpaperColors wallpaperColors, boolean filter) {
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            return ((Number)CollectionsKt.first(this.getSeedColors(wallpaperColors, filter))).intValue();
        }

        public static /* synthetic */ int getSeedColor$default(Companion companion, WallpaperColors wallpaperColors, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getSeedColor(wallpaperColors, bl);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors, boolean filter) {
            int i;
            List intToScore;
            void $this$mapValuesTo$iv$iv;
            Map filteredIntToCam;
            Map map;
            Object cam;
            void $this$mapValuesTo$iv$iv2;
            Object object;
            Map<Integer, Integer> $this$mapValuesTo$iv$iv3;
            Object object2;
            Map it;
            Map map2;
            Object k;
            Iterator iterator;
            void $this$mapValuesTo$iv$iv4;
            Map<Integer, Integer> $this$filterTo$iv$iv;
            Object $this$filter$iv;
            Map destination$iv$iv;
            boolean totalPopulationMeaningless;
            Iterable b;
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            Iterable $this$reduce$iv = wallpaperColors.getAllColors().values();
            boolean $i$f$reduce = false;
            Object iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                Integer n = (Integer)iterator$iv.next();
                Integer a = (Integer)accumulator$iv;
                boolean bl = false;
                int n2 = a;
                Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
                accumulator$iv = n2 + (Integer)((Object)b);
            }
            double totalPopulation = ((Number)accumulator$iv).intValue();
            boolean bl = totalPopulationMeaningless = totalPopulation == 0.0;
            if (totalPopulationMeaningless) {
                Object $this$mapTo$iv$iv;
                iterator$iv = wallpaperColors.getMainColors();
                Intrinsics.checkNotNullExpressionValue((Object)iterator$iv, (String)"wallpaperColors.mainColors");
                Iterable $this$map$iv = (Iterable)iterator$iv;
                boolean $i$f$map = false;
                b = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it2;
                    Object item$iv$iv = iterator2.next();
                    Color color2 = (Color)item$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl2 = false;
                    map3.add(it2.toArgb());
                }
                $this$filter$iv = CollectionsKt.distinct((Iterable)((List)((Object)destination$iv$iv)));
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    int it3 = ((Number)element$iv$iv).intValue();
                    boolean bl3 = false;
                    boolean bl4 = !filter ? true : Cam.fromInt(it3).getChroma() >= 5.0f;
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List distinctColors = CollectionsKt.toList((Iterable)((List)((Object)destination$iv$iv)));
                if (distinctColors.isEmpty()) {
                    return CollectionsKt.listOf((Object)-14979341);
                }
                return distinctColors;
            }
            $this$filter$iv = wallpaperColors.getAllColors();
            Intrinsics.checkNotNullExpressionValue($this$filter$iv, (String)"wallpaperColors.allColors");
            Map<Integer, Integer> $this$mapValues$iv = $this$filter$iv;
            boolean $i$f$mapValues22 = false;
            $this$filterTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv4.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                iterator = destination$iv$iv;
                boolean bl5 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map2 = iterator;
                boolean bl6 = false;
                object2 = (double)((Number)it.getValue()).intValue() / totalPopulation;
                map2.put(k, (Integer)object2);
            }
            Map intToProportion = destination$iv$iv;
            Map $i$f$mapValues22 = wallpaperColors.getAllColors();
            Intrinsics.checkNotNullExpressionValue($i$f$mapValues22, (String)"wallpaperColors.allColors");
            Map $this$mapValues$iv2 = $i$f$mapValues22;
            boolean $i$f$mapValues = false;
            destination$iv$iv = $this$mapValues$iv2;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv3.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it4;
                Iterator it$iv$iv;
                iterator = (Map.Entry)element$iv$iv$iv;
                Map bl5 = destination$iv$iv2;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
                Map.Entry bl6 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map2 = bl5;
                boolean bl7 = false;
                object = it4.getKey();
                Intrinsics.checkNotNullExpressionValue(object, (String)"it.key");
                object2 = Cam.fromInt(((Number)object).intValue());
                map2.put(k, object2);
            }
            Map intToCam = destination$iv$iv2;
            List<Double> hueProportions = this.huePopulations(intToCam, intToProportion, filter);
            $this$mapValuesTo$iv$iv3 = wallpaperColors.getAllColors();
            Intrinsics.checkNotNullExpressionValue($this$mapValuesTo$iv$iv3, (String)"wallpaperColors.allColors");
            Map<Integer, Integer> $this$mapValues$iv3 = $this$mapValuesTo$iv$iv3;
            boolean $i$f$mapValues3 = false;
            Map<Integer, Integer> $i$f$mapValuesTo22 = $this$mapValues$iv3;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv3.size()));
            boolean $i$f$mapValuesTo3 = false;
            Iterable $this$associateByTo$iv$iv$iv3 = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo32 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv3) {
                void it5;
                void it$iv$iv;
                Map.Entry $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                it = destination$iv$iv3;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3 = false;
                object = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map2 = it;
                boolean bl8 = false;
                Object v = intToCam.get(it5.getKey());
                Intrinsics.checkNotNull(v);
                cam = (Cam)v;
                int hue = MathKt.roundToInt((float)((Cam)cam).getHue());
                double proportion2 = 0.0;
                int n = hue - 15;
                int n3 = hue + 15;
                if (n <= n3) {
                    int i2;
                    do {
                        i2 = n++;
                        proportion2 += ((Number)hueProportions.get(Companion.wrapDegrees(i2))).doubleValue();
                    } while (i2 != n3);
                }
                object2 = proportion2;
                map2.put(k, object2);
            }
            Map intToHueProportion = destination$iv$iv3;
            if (!filter) {
                map = intToCam;
            } else {
                void $this$filterTo$iv$iv2;
                Map $this$filter$iv2 = intToCam;
                boolean $i$f$filter = false;
                destination$iv$iv3 = $this$filter$iv2;
                Map destination$iv$iv4 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator $i$f$associateByTo32 = $this$filterTo$iv$iv2.entrySet().iterator();
                while ($i$f$associateByTo32.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it6 = element$iv$iv = $i$f$associateByTo32.next();
                    boolean bl9 = false;
                    Cam cam2 = (Cam)it6.getValue();
                    Object v = intToHueProportion.get(it6.getKey());
                    Intrinsics.checkNotNull(v);
                    double proportion = ((Number)v).doubleValue();
                    boolean bl10 = cam2.getChroma() >= 5.0f && (totalPopulationMeaningless || proportion > 0.01);
                    if (!bl10) continue;
                    destination$iv$iv4.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                map = destination$iv$iv4;
            }
            Map $this$mapValues$iv4 = filteredIntToCam = map;
            boolean $i$f$mapValues4 = false;
            Map destination$iv$iv4 = $this$mapValues$iv4;
            Map destination$iv$iv5 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv4.size()));
            boolean $i$f$mapValuesTo4 = false;
            Iterable $this$associateByTo$iv$iv$iv4 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo4 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv4) {
                void it7;
                void it$iv$iv;
                Map.Entry proportion = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv5;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv4 = false;
                cam = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map2 = map4;
                boolean bl11 = false;
                Object proportion2 = it7.getValue();
                Intrinsics.checkNotNullExpressionValue(proportion2, (String)"it.value");
                Cam cam3 = (Cam)proportion2;
                Object v = intToHueProportion.get(it7.getKey());
                Intrinsics.checkNotNull(v);
                object2 = Companion.score(cam3, ((Number)v).doubleValue());
                map2.put(k, object2);
            }
            Map intToScoreIntermediate = destination$iv$iv5;
            List $this$sortByDescending$iv = intToScore = CollectionsKt.toMutableList((Collection)intToScoreIntermediate.entrySet());
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                    public int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)b;
                        boolean bl = false;
                        Comparable comparable = (Double)it.getValue();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
                    }
                });
            }
            int minimumHueDistance = 15;
            List seeds = new ArrayList();
            int n = 90;
            block9: do {
                i = n--;
                seeds.clear();
                for (Map.Entry entry : intToScore) {
                    boolean existingSeedNearby;
                    Object v11;
                    Integer n4;
                    block20: {
                        n4 = (Integer)entry.getKey();
                        for (Object t : (Iterable)seeds) {
                            int it8 = ((Number)t).intValue();
                            boolean bl12 = false;
                            Object v = intToCam.get(n4);
                            Intrinsics.checkNotNull(v);
                            float hueA = ((Cam)v).getHue();
                            Object v2 = intToCam.get(it8);
                            Intrinsics.checkNotNull(v2);
                            float hueB = ((Cam)v2).getHue();
                            if (!(Companion.hueDiff(hueA, hueB) < (float)i)) continue;
                            v11 = t;
                            break block20;
                        }
                        v11 = null;
                    }
                    boolean bl13 = existingSeedNearby = v11 != null;
                    if (existingSeedNearby) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"int");
                    seeds.add(n4);
                    if (seeds.size() < 4) continue;
                    break block9;
                }
            } while (i != minimumHueDistance);
            if (seeds.isEmpty()) {
                seeds.add(-14979341);
            }
            return seeds;
        }

        public static /* synthetic */ List getSeedColors$default(Companion companion, WallpaperColors wallpaperColors, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.getSeedColors(wallpaperColors, bl);
        }

        private int wrapDegrees(int degrees) {
            return degrees < 0 ? degrees % 360 + 360 : (degrees >= 360 ? degrees % 360 : degrees);
        }

        public double wrapDegreesDouble(double degrees) {
            return degrees < 0.0 ? degrees % (double)360 + (double)360 : (degrees >= 360.0 ? degrees % (double)360 : degrees);
        }

        private float hueDiff(float a, float b) {
            return 180.0f - Math.abs(Math.abs(a - b) - 180.0f);
        }

        private String stringForColor(int color2) {
            int width = 4;
            Cam hct = Cam.fromInt(color2);
            String h = Intrinsics.stringPlus((String)"H", (Object)StringsKt.padEnd$default((String)String.valueOf(MathKt.roundToInt((float)hct.getHue())), (int)width, (char)'\u0000', (int)2, null));
            String c = Intrinsics.stringPlus((String)"C", (Object)StringsKt.padEnd$default((String)String.valueOf(MathKt.roundToInt((float)hct.getChroma())), (int)width, (char)'\u0000', (int)2, null));
            String t = Intrinsics.stringPlus((String)"T", (Object)StringsKt.padEnd$default((String)String.valueOf(MathKt.roundToInt((float)CamUtils.lstarFromInt(color2))), (int)width, (char)'\u0000', (int)2, null));
            String string2 = Integer.toHexString(color2 & 0xFFFFFF);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(color and 0xffffff)");
            String string3 = StringsKt.padStart((String)string2, (int)6, (char)'0').toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String hex = string3;
            return h + c + t + " = #" + hex;
        }

        /*
         * WARNING - void declaration
         */
        private String humanReadable(String paletteName, List<Integer> colors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = colors;
            StringBuilder stringBuilder = new StringBuilder().append(paletteName).append('\n');
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.stringForColor((int)it));
            }
            return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)humanReadable.2.INSTANCE, (int)30, null)).toString();
        }

        private double score(Cam cam, double proportion) {
            double proportionScore = 70.0 * proportion;
            double chromaScore = cam.getChroma() < 48.0f ? 0.1 * (double)(cam.getChroma() - 48.0f) : 0.3 * (double)(cam.getChroma() - 48.0f);
            return chromaScore + proportionScore;
        }

        private List<Double> huePopulations(Map<Integer, ? extends Cam> camByColor, Map<Integer, Double> populationByColor, boolean filter) {
            int n = 360;
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                int n5 = n4 = (n3 = n2++);
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(0.0);
            }
            List huePopulation = CollectionsKt.toMutableList((Collection)arrayList);
            for (Map.Entry<Integer, Double> entry : populationByColor.entrySet()) {
                Cam cam;
                Double d = populationByColor.get(entry.getKey());
                Intrinsics.checkNotNull((Object)d);
                double population = ((Number)d).doubleValue();
                Intrinsics.checkNotNull((Object)camByColor.get(entry.getKey()));
                int hue = MathKt.roundToInt((float)cam.getHue()) % 360;
                if (filter && cam.getChroma() <= 5.0f) continue;
                huePopulation.set(hue, ((Number)huePopulation.get(hue)).doubleValue() + population);
            }
            return huePopulation;
        }

        static /* synthetic */ List huePopulations$default(Companion companion, Map map, Map map2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.huePopulations(map, map2, bl);
        }

        @JvmStatic
        @JvmOverloads
        public int getSeedColor(@NotNull WallpaperColors wallpaperColors) {
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            return com.android.systemui.monet.ColorScheme$Companion.getSeedColor$default(this, wallpaperColors, false, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public List<Integer> getSeedColors(@NotNull WallpaperColors wallpaperColors) {
            Intrinsics.checkNotNullParameter((Object)wallpaperColors, (String)"wallpaperColors");
            return com.android.systemui.monet.ColorScheme$Companion.getSeedColors$default(this, wallpaperColors, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

