/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import com.android.internal.graphics.cam.Cam;
import com.android.systemui.monet.Chroma;
import com.android.systemui.monet.Hue;
import com.android.systemui.monet.HueSource;
import com.android.systemui.monet.Shades;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/android/systemui/monet/TonalSpec;", "", "hue", "Lcom/android/systemui/monet/Hue;", "chroma", "Lcom/android/systemui/monet/Chroma;", "(Lcom/android/systemui/monet/Hue;Lcom/android/systemui/monet/Chroma;)V", "getChroma", "()Lcom/android/systemui/monet/Chroma;", "getHue", "()Lcom/android/systemui/monet/Hue;", "shades", "", "", "sourceColor", "Lcom/android/internal/graphics/cam/Cam;", "frameworks__base__packages__SystemUI__monet__android_common__monet"})
public class TonalSpec {
    @NotNull
    private final Hue hue;
    @NotNull
    private final Chroma chroma;

    public TonalSpec(@NotNull Hue hue, @NotNull Chroma chroma) {
        Intrinsics.checkNotNullParameter((Object)hue, (String)"hue");
        Intrinsics.checkNotNullParameter((Object)chroma, (String)"chroma");
        this.hue = hue;
        this.chroma = chroma;
    }

    public /* synthetic */ TonalSpec(Hue hue, Chroma chroma, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            hue = new HueSource();
        }
        this(hue, chroma);
    }

    @NotNull
    public Hue getHue() {
        return this.hue;
    }

    @NotNull
    public Chroma getChroma() {
        return this.chroma;
    }

    @NotNull
    public List<Integer> shades(@NotNull Cam sourceColor) {
        Intrinsics.checkNotNullParameter((Object)sourceColor, (String)"sourceColor");
        double hue = this.hue.get(sourceColor);
        double chroma = this.chroma.get(sourceColor);
        int[] nArray = Shades.of((float)hue, (float)chroma);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"of(hue.toFloat(), chroma.toFloat())");
        return ArraysKt.toList((int[])nArray);
    }
}

