/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum MaterialDesignColor {
    RED("Red", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)0xFFEBEE).put((Object)((Object)Shade.PRIMARY_100), (Object)16764370).put((Object)((Object)Shade.PRIMARY_200), (Object)15702682).put((Object)((Object)Shade.PRIMARY_300), (Object)15037299).put((Object)((Object)Shade.PRIMARY_400), (Object)15684432).put((Object)((Object)Shade.PRIMARY_500), (Object)16007990).put((Object)((Object)Shade.PRIMARY_600), (Object)15022389).put((Object)((Object)Shade.PRIMARY_700), (Object)13840175).put((Object)((Object)Shade.PRIMARY_800), (Object)12986408).put((Object)((Object)Shade.PRIMARY_900), (Object)12000284).put((Object)((Object)Shade.ACCENT_100), (Object)16747136).put((Object)((Object)Shade.ACCENT_200), (Object)0xFF5252).put((Object)((Object)Shade.ACCENT_400), (Object)16717636).put((Object)((Object)Shade.ACCENT_700), (Object)0xD50000).buildOrThrow()),
    PINK("Pink", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)16573676).put((Object)((Object)Shade.PRIMARY_100), (Object)16301008).put((Object)((Object)Shade.PRIMARY_200), (Object)16027569).put((Object)((Object)Shade.PRIMARY_300), (Object)15753874).put((Object)((Object)Shade.PRIMARY_400), (Object)15483002).put((Object)((Object)Shade.PRIMARY_500), (Object)15277667).put((Object)((Object)Shade.PRIMARY_600), (Object)14162784).put((Object)((Object)Shade.PRIMARY_700), (Object)12720219).put((Object)((Object)Shade.PRIMARY_800), (Object)11342935).put((Object)((Object)Shade.PRIMARY_900), (Object)8916559).put((Object)((Object)Shade.ACCENT_100), (Object)16744619).put((Object)((Object)Shade.ACCENT_200), (Object)16728193).put((Object)((Object)Shade.ACCENT_400), (Object)16056407).put((Object)((Object)Shade.ACCENT_700), (Object)12915042).buildOrThrow()),
    PURPLE("Purple", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)15984117).put((Object)((Object)Shade.PRIMARY_100), (Object)14794471).put((Object)((Object)Shade.PRIMARY_200), (Object)13538264).put((Object)((Object)Shade.PRIMARY_300), (Object)12216520).put((Object)((Object)Shade.PRIMARY_400), (Object)11225020).put((Object)((Object)Shade.PRIMARY_500), (Object)10233776).put((Object)((Object)Shade.PRIMARY_600), (Object)9315498).put((Object)((Object)Shade.PRIMARY_700), (Object)8069026).put((Object)((Object)Shade.PRIMARY_800), (Object)6953882).put((Object)((Object)Shade.PRIMARY_900), (Object)4854924).put((Object)((Object)Shade.ACCENT_100), (Object)15368444).put((Object)((Object)Shade.ACCENT_200), (Object)14696699).put((Object)((Object)Shade.ACCENT_400), (Object)13959417).put((Object)((Object)Shade.ACCENT_700), (Object)0xAA00FF).buildOrThrow()),
    DEEP_PURPLE("Deep Purple", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)15591414).put((Object)((Object)Shade.PRIMARY_100), (Object)13747433).put((Object)((Object)Shade.PRIMARY_200), (Object)11771355).put((Object)((Object)Shade.PRIMARY_300), (Object)9795021).put((Object)((Object)Shade.PRIMARY_400), (Object)8280002).put((Object)((Object)Shade.PRIMARY_500), (Object)6765239).put((Object)((Object)Shade.PRIMARY_600), (Object)6174129).put((Object)((Object)Shade.PRIMARY_700), (Object)5320104).put((Object)((Object)Shade.PRIMARY_800), (Object)4532128).put((Object)((Object)Shade.PRIMARY_900), (Object)3218322).put((Object)((Object)Shade.ACCENT_100), (Object)11766015).put((Object)((Object)Shade.ACCENT_200), (Object)8146431).put((Object)((Object)Shade.ACCENT_400), (Object)6627327).put((Object)((Object)Shade.ACCENT_700), (Object)6422762).buildOrThrow()),
    INDIGO("Indigo", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)15264502).put((Object)((Object)Shade.PRIMARY_100), (Object)12962537).put((Object)((Object)Shade.PRIMARY_200), (Object)10463450).put((Object)((Object)Shade.PRIMARY_300), (Object)7964363).put((Object)((Object)Shade.PRIMARY_400), (Object)6056896).put((Object)((Object)Shade.PRIMARY_500), (Object)4149685).put((Object)((Object)Shade.PRIMARY_600), (Object)3754411).put((Object)((Object)Shade.PRIMARY_700), (Object)3162015).put((Object)((Object)Shade.PRIMARY_800), (Object)2635155).put((Object)((Object)Shade.PRIMARY_900), (Object)1713022).put((Object)((Object)Shade.ACCENT_100), (Object)9215743).put((Object)((Object)Shade.ACCENT_200), (Object)5467646).put((Object)((Object)Shade.ACCENT_400), (Object)4020990).put((Object)((Object)Shade.ACCENT_700), (Object)3166206).buildOrThrow()),
    BLUE("Blue", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)14938877).put((Object)((Object)Shade.PRIMARY_100), (Object)12312315).put((Object)((Object)Shade.PRIMARY_200), (Object)9489145).put((Object)((Object)Shade.PRIMARY_300), (Object)6600182).put((Object)((Object)Shade.PRIMARY_400), (Object)4367861).put((Object)((Object)Shade.PRIMARY_500), (Object)2201331).put((Object)((Object)Shade.PRIMARY_600), (Object)2001125).put((Object)((Object)Shade.PRIMARY_700), (Object)1668818).put((Object)((Object)Shade.PRIMARY_800), (Object)1402304).put((Object)((Object)Shade.PRIMARY_900), (Object)870305).put((Object)((Object)Shade.ACCENT_100), (Object)8565247).put((Object)((Object)Shade.ACCENT_200), (Object)4492031).put((Object)((Object)Shade.ACCENT_400), (Object)2718207).put((Object)((Object)Shade.ACCENT_700), (Object)2712319).buildOrThrow()),
    LIGHT_BLUE("Light Blue", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)14808574).put((Object)((Object)Shade.PRIMARY_100), (Object)11789820).put((Object)((Object)Shade.PRIMARY_200), (Object)8508666).put((Object)((Object)Shade.PRIMARY_300), (Object)5227511).put((Object)((Object)Shade.PRIMARY_400), (Object)2733814).put((Object)((Object)Shade.PRIMARY_500), (Object)240116).put((Object)((Object)Shade.PRIMARY_600), (Object)236517).put((Object)((Object)Shade.PRIMARY_700), (Object)166097).put((Object)((Object)Shade.PRIMARY_800), (Object)161725).put((Object)((Object)Shade.PRIMARY_900), (Object)87963).put((Object)((Object)Shade.ACCENT_100), (Object)8444159).put((Object)((Object)Shade.ACCENT_200), (Object)4244735).put((Object)((Object)Shade.ACCENT_400), (Object)45311).put((Object)((Object)Shade.ACCENT_700), (Object)37354).buildOrThrow()),
    CYAN("Cyan", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)14743546).put((Object)((Object)Shade.PRIMARY_100), (Object)11725810).put((Object)((Object)Shade.PRIMARY_200), (Object)8445674).put((Object)((Object)Shade.PRIMARY_300), (Object)5099745).put((Object)((Object)Shade.PRIMARY_400), (Object)2541274).put((Object)((Object)Shade.PRIMARY_500), (Object)48340).put((Object)((Object)Shade.PRIMARY_600), (Object)44225).put((Object)((Object)Shade.PRIMARY_700), (Object)38823).put((Object)((Object)Shade.PRIMARY_800), (Object)33679).put((Object)((Object)Shade.PRIMARY_900), (Object)24676).put((Object)((Object)Shade.ACCENT_100), (Object)0x84FFFF).put((Object)((Object)Shade.ACCENT_200), (Object)0x18FFFF).put((Object)((Object)Shade.ACCENT_400), (Object)58879).put((Object)((Object)Shade.ACCENT_700), (Object)47316).buildOrThrow()),
    TEAL("Teal", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)14742257).put((Object)((Object)Shade.PRIMARY_100), (Object)11722715).put((Object)((Object)Shade.PRIMARY_200), (Object)8440772).put((Object)((Object)Shade.PRIMARY_300), (Object)5093036).put((Object)((Object)Shade.PRIMARY_400), (Object)2533018).put((Object)((Object)Shade.PRIMARY_500), (Object)38536).put((Object)((Object)Shade.PRIMARY_600), (Object)35195).put((Object)((Object)Shade.PRIMARY_700), (Object)31083).put((Object)((Object)Shade.PRIMARY_800), (Object)26972).put((Object)((Object)Shade.PRIMARY_900), (Object)19776).put((Object)((Object)Shade.ACCENT_100), (Object)11010027).put((Object)((Object)Shade.ACCENT_200), (Object)6619098).put((Object)((Object)Shade.ACCENT_400), (Object)1960374).put((Object)((Object)Shade.ACCENT_700), (Object)49061).buildOrThrow()),
    GREEN("Green", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)15267305).put((Object)((Object)Shade.PRIMARY_100), (Object)13166281).put((Object)((Object)Shade.PRIMARY_200), (Object)10868391).put((Object)((Object)Shade.PRIMARY_300), (Object)8505220).put((Object)((Object)Shade.PRIMARY_400), (Object)0x66BB6A).put((Object)((Object)Shade.PRIMARY_500), (Object)5025616).put((Object)((Object)Shade.PRIMARY_600), (Object)4431943).put((Object)((Object)Shade.PRIMARY_700), (Object)3706428).put((Object)((Object)Shade.PRIMARY_800), (Object)3046706).put((Object)((Object)Shade.PRIMARY_900), (Object)1793568).put((Object)((Object)Shade.ACCENT_100), (Object)12187338).put((Object)((Object)Shade.ACCENT_200), (Object)6942894).put((Object)((Object)Shade.ACCENT_400), (Object)58998).put((Object)((Object)Shade.ACCENT_700), (Object)51283).buildOrThrow()),
    LIGHT_GREEN("Light Green", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)15857897).put((Object)((Object)Shade.PRIMARY_100), (Object)14478792).put((Object)((Object)Shade.PRIMARY_200), (Object)12968357).put((Object)((Object)Shade.PRIMARY_300), (Object)11457921).put((Object)((Object)Shade.PRIMARY_400), (Object)10275941).put((Object)((Object)Shade.PRIMARY_500), (Object)9159498).put((Object)((Object)Shade.PRIMARY_600), (Object)8172354).put((Object)((Object)Shade.PRIMARY_700), (Object)6856504).put((Object)((Object)Shade.PRIMARY_800), (Object)5606191).put((Object)((Object)Shade.PRIMARY_900), (Object)3369246).put((Object)((Object)Shade.ACCENT_100), (Object)13434768).put((Object)((Object)Shade.ACCENT_200), (Object)11730777).put((Object)((Object)Shade.ACCENT_400), (Object)7798531).put((Object)((Object)Shade.ACCENT_700), (Object)6610199).buildOrThrow()),
    LIME("Lime", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)16382951).put((Object)((Object)Shade.PRIMARY_100), (Object)15791299).put((Object)((Object)Shade.PRIMARY_200), (Object)15134364).put((Object)((Object)Shade.PRIMARY_300), (Object)14477173).put((Object)((Object)Shade.PRIMARY_400), (Object)13951319).put((Object)((Object)Shade.PRIMARY_500), (Object)13491257).put((Object)((Object)Shade.PRIMARY_600), (Object)12634675).put((Object)((Object)Shade.PRIMARY_700), (Object)11514923).put((Object)((Object)Shade.PRIMARY_800), (Object)10394916).put((Object)((Object)Shade.PRIMARY_900), (Object)8550167).put((Object)((Object)Shade.ACCENT_100), (Object)16056193).put((Object)((Object)Shade.ACCENT_200), (Object)15662913).put((Object)((Object)Shade.ACCENT_400), (Object)13041408).put((Object)((Object)Shade.ACCENT_700), (Object)0xAEEA00).buildOrThrow()),
    YELLOW("Yellow", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)16776679).put((Object)((Object)Shade.PRIMARY_100), (Object)16775620).put((Object)((Object)Shade.PRIMARY_200), (Object)16774557).put((Object)((Object)Shade.PRIMARY_300), (Object)16773494).put((Object)((Object)Shade.PRIMARY_400), (Object)16772696).put((Object)((Object)Shade.PRIMARY_500), (Object)16771899).put((Object)((Object)Shade.PRIMARY_600), (Object)16635957).put((Object)((Object)Shade.PRIMARY_700), (Object)16498733).put((Object)((Object)Shade.PRIMARY_800), (Object)16361509).put((Object)((Object)Shade.PRIMARY_900), (Object)16088855).put((Object)((Object)Shade.ACCENT_100), (Object)0xFFFF8D).put((Object)((Object)Shade.ACCENT_200), (Object)0xFFFF00).put((Object)((Object)Shade.ACCENT_400), (Object)16771584).put((Object)((Object)Shade.ACCENT_700), (Object)16766464).buildOrThrow()),
    AMBER("Amber", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)16775393).put((Object)((Object)Shade.PRIMARY_100), (Object)16772275).put((Object)((Object)Shade.PRIMARY_200), (Object)16769154).put((Object)((Object)Shade.PRIMARY_300), (Object)16766287).put((Object)((Object)Shade.PRIMARY_400), (Object)16763432).put((Object)((Object)Shade.PRIMARY_500), (Object)16761095).put((Object)((Object)Shade.PRIMARY_600), (Object)16757504).put((Object)((Object)Shade.PRIMARY_700), (Object)0xFFA000).put((Object)((Object)Shade.PRIMARY_800), (Object)0xFF8F00).put((Object)((Object)Shade.PRIMARY_900), (Object)0xFF6F00).put((Object)((Object)Shade.ACCENT_100), (Object)16770431).put((Object)((Object)Shade.ACCENT_200), (Object)16766784).put((Object)((Object)Shade.ACCENT_400), (Object)16761856).put((Object)((Object)Shade.ACCENT_700), (Object)16755456).buildOrThrow()),
    ORANGE("Orange", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)16774112).put((Object)((Object)Shade.PRIMARY_100), (Object)16769202).put((Object)((Object)Shade.PRIMARY_200), (Object)16764032).put((Object)((Object)Shade.PRIMARY_300), (Object)16758605).put((Object)((Object)Shade.PRIMARY_400), (Object)16754470).put((Object)((Object)Shade.PRIMARY_500), (Object)16750592).put((Object)((Object)Shade.PRIMARY_600), (Object)16485376).put((Object)((Object)Shade.PRIMARY_700), (Object)16088064).put((Object)((Object)Shade.PRIMARY_800), (Object)15690752).put((Object)((Object)Shade.PRIMARY_900), (Object)15094016).put((Object)((Object)Shade.ACCENT_100), (Object)16765312).put((Object)((Object)Shade.ACCENT_200), (Object)16755520).put((Object)((Object)Shade.ACCENT_400), (Object)16748800).put((Object)((Object)Shade.ACCENT_700), (Object)16739584).buildOrThrow()),
    DEEP_ORANGE("Deep Orange", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)16509415).put((Object)((Object)Shade.PRIMARY_100), (Object)0xFFCCBC).put((Object)((Object)Shade.PRIMARY_200), (Object)16755601).put((Object)((Object)Shade.PRIMARY_300), (Object)16747109).put((Object)((Object)Shade.PRIMARY_400), (Object)16740419).put((Object)((Object)Shade.PRIMARY_500), (Object)16733986).put((Object)((Object)Shade.PRIMARY_600), (Object)16011550).put((Object)((Object)Shade.PRIMARY_700), (Object)15092249).put((Object)((Object)Shade.PRIMARY_800), (Object)14172949).put((Object)((Object)Shade.PRIMARY_900), (Object)12531212).put((Object)((Object)Shade.ACCENT_100), (Object)16752256).put((Object)((Object)Shade.ACCENT_200), (Object)16739904).put((Object)((Object)Shade.ACCENT_400), (Object)16727296).put((Object)((Object)Shade.ACCENT_700), (Object)14494720).buildOrThrow()),
    BROWN("Brown", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)15723497).put((Object)((Object)Shade.PRIMARY_100), (Object)14142664).put((Object)((Object)Shade.PRIMARY_200), (Object)12364452).put((Object)((Object)Shade.PRIMARY_300), (Object)10586239).put((Object)((Object)Shade.PRIMARY_400), (Object)9268835).put((Object)((Object)Shade.PRIMARY_500), (Object)7951688).put((Object)((Object)Shade.PRIMARY_600), (Object)7162945).put((Object)((Object)Shade.PRIMARY_700), (Object)6111287).put((Object)((Object)Shade.PRIMARY_800), (Object)5125166).put((Object)((Object)Shade.PRIMARY_900), (Object)4073251).buildOrThrow()),
    GREY("Grey", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)0xFAFAFA).put((Object)((Object)Shade.PRIMARY_100), (Object)0xF5F5F5).put((Object)((Object)Shade.PRIMARY_200), (Object)0xEEEEEE).put((Object)((Object)Shade.PRIMARY_300), (Object)0xE0E0E0).put((Object)((Object)Shade.PRIMARY_400), (Object)0xBDBDBD).put((Object)((Object)Shade.PRIMARY_500), (Object)0x9E9E9E).put((Object)((Object)Shade.PRIMARY_600), (Object)0x757575).put((Object)((Object)Shade.PRIMARY_700), (Object)0x616161).put((Object)((Object)Shade.PRIMARY_800), (Object)0x424242).put((Object)((Object)Shade.PRIMARY_900), (Object)0x212121).buildOrThrow()),
    BLUE_GREY("Blue Grey", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.builder().put((Object)((Object)Shade.PRIMARY_050), (Object)15527921).put((Object)((Object)Shade.PRIMARY_100), (Object)13621468).put((Object)((Object)Shade.PRIMARY_200), (Object)11583173).put((Object)((Object)Shade.PRIMARY_300), (Object)9479342).put((Object)((Object)Shade.PRIMARY_400), (Object)7901340).put((Object)((Object)Shade.PRIMARY_500), (Object)6323595).put((Object)((Object)Shade.PRIMARY_600), (Object)5533306).put((Object)((Object)Shade.PRIMARY_700), (Object)4545124).put((Object)((Object)Shade.PRIMARY_800), (Object)3622735).put((Object)((Object)Shade.PRIMARY_900), (Object)2503224).buildOrThrow()),
    BLACK("Black", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.of((Object)((Object)Shade.PRIMARY_500), (Object)0)),
    WHITE("White", (ImmutableBiMap<Shade, Integer>)ImmutableBiMap.of((Object)((Object)Shade.PRIMARY_500), (Object)0xFFFFFF));

    private final String name;
    private final ImmutableBiMap<Shade, Integer> colorMap;

    private MaterialDesignColor(String name, ImmutableBiMap<Shade, Integer> colorMap) {
        this.name = name;
        this.colorMap = colorMap;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableBiMap<Shade, Integer> getColorMap() {
        return this.colorMap;
    }

    public static @Nullable MaterialDesignColor fromColor(int color2) {
        for (MaterialDesignColor materialDesignColor : MaterialDesignColor.values()) {
            if (!materialDesignColor.getColorMap().containsValue((Object)color2)) continue;
            return materialDesignColor;
        }
        return null;
    }

    public static boolean isMaterialDesignColor(int color2) {
        return MaterialDesignColor.fromColor(color2) != null;
    }

    public static MaterialDesignColor findClosestColor(int color2) {
        MaterialDesignColor materialDesignColor = MaterialDesignColor.fromColor(color2);
        if (materialDesignColor != null) {
            return materialDesignColor;
        }
        double minColorDistance = Double.MAX_VALUE;
        MaterialDesignColor closestColor = null;
        for (MaterialDesignColor designColor : MaterialDesignColor.values()) {
            UnmodifiableIterator unmodifiableIterator = designColor.getColorMap().values().iterator();
            while (unmodifiableIterator.hasNext()) {
                int testColor = (Integer)unmodifiableIterator.next();
                double colorDistance = ContrastUtils.colorDifference(testColor, color2);
                if (!(minColorDistance > colorDistance)) continue;
                minColorDistance = colorDistance;
                closestColor = designColor;
            }
        }
        return (MaterialDesignColor)((Object)Preconditions.checkNotNull(closestColor));
    }

    public static enum Shade {
        PRIMARY_050("50"),
        PRIMARY_100("100"),
        PRIMARY_200("200"),
        PRIMARY_300("300"),
        PRIMARY_400("400"),
        PRIMARY_500("500"),
        PRIMARY_600("600"),
        PRIMARY_700("700"),
        PRIMARY_800("800"),
        PRIMARY_900("900"),
        ACCENT_100("A100"),
        ACCENT_200("A200"),
        ACCENT_400("A400"),
        ACCENT_700("A700");

        public static ImmutableList<Shade> primaryShades;
        public static ImmutableList<Shade> accentShades;
        private final String code;

        public String getCode() {
            return this.code;
        }

        private Shade(String code) {
            this.code = code;
        }

        static {
            primaryShades = ImmutableList.of((Object)((Object)PRIMARY_050), (Object)((Object)PRIMARY_100), (Object)((Object)PRIMARY_200), (Object)((Object)PRIMARY_300), (Object)((Object)PRIMARY_400), (Object)((Object)PRIMARY_500), (Object)((Object)PRIMARY_600), (Object)((Object)PRIMARY_700), (Object)((Object)PRIMARY_800), (Object)((Object)PRIMARY_900));
            accentShades = ImmutableList.of((Object)((Object)ACCENT_100), (Object)((Object)ACCENT_200), (Object)((Object)ACCENT_400), (Object)((Object)ACCENT_700));
        }
    }
}

