/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.dalvik.ddmc;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.harmony.dalvik.ddmc.Chunk;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public abstract class ChunkHandler {
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static final ByteOrder CHUNK_ORDER = ByteOrder.BIG_ENDIAN;
    public static final int CHUNK_FAIL = ChunkHandler.type("FAIL");

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public ChunkHandler() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public abstract void onConnected();

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public abstract void onDisconnected();

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public abstract Chunk handleChunk(Chunk var1);

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static Chunk createFailChunk(int errorCode, String msg) {
        if (msg == null) {
            msg = "";
        }
        ByteBuffer out = ByteBuffer.allocate(8 + msg.length() * 2);
        out.order(CHUNK_ORDER);
        out.putInt(errorCode);
        out.putInt(msg.length());
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            out.putChar(msg.charAt(i));
        }
        return new Chunk(CHUNK_FAIL, out);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static ByteBuffer wrapChunk(Chunk request) {
        ByteBuffer in = ByteBuffer.wrap(request.data, request.offset, request.length);
        in.order(CHUNK_ORDER);
        return in;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static int type(String typeName) {
        if (typeName.length() != 4) {
            throw new IllegalArgumentException("Bad type name: " + typeName);
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = result << 8 | typeName.charAt(i) & 0xFF;
        }
        return result;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static String name(int type) {
        char[] ascii = new char[]{(char)(type >> 24 & 0xFF), (char)(type >> 16 & 0xFF), (char)(type >> 8 & 0xFF), (char)(type & 0xFF)};
        return new String(ascii);
    }
}

