/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.util.AccessibilityUtils;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.R;
import com.android.internal.compat.IPlatformCompat;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityServiceInfo
implements Parcelable {
    private static final String TAG_ACCESSIBILITY_SERVICE = "accessibility-service";
    public static final int CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT = 1;
    public static final int CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION = 2;
    public static final int CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 4;
    public static final int CAPABILITY_CAN_REQUEST_FILTER_KEY_EVENTS = 8;
    public static final int CAPABILITY_CAN_CONTROL_MAGNIFICATION = 16;
    public static final int CAPABILITY_CAN_PERFORM_GESTURES = 32;
    public static final int CAPABILITY_CAN_REQUEST_FINGERPRINT_GESTURES = 64;
    public static final int CAPABILITY_CAN_TAKE_SCREENSHOT = 128;
    private static SparseArray<CapabilityInfo> sAvailableCapabilityInfos;
    public static final int FEEDBACK_SPOKEN = 1;
    public static final int FEEDBACK_HAPTIC = 2;
    public static final int FEEDBACK_AUDIBLE = 4;
    public static final int FEEDBACK_VISUAL = 8;
    public static final int FEEDBACK_GENERIC = 16;
    public static final int FEEDBACK_BRAILLE = 32;
    public static final int FEEDBACK_ALL_MASK = -1;
    public static final int DEFAULT = 1;
    public static final int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 2;
    public static final int FLAG_REQUEST_TOUCH_EXPLORATION_MODE = 4;
    public static final int FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY = 8;
    public static final int FLAG_REPORT_VIEW_IDS = 16;
    public static final int FLAG_REQUEST_FILTER_KEY_EVENTS = 32;
    public static final int FLAG_RETRIEVE_INTERACTIVE_WINDOWS = 64;
    public static final int FLAG_ENABLE_ACCESSIBILITY_VOLUME = 128;
    public static final int FLAG_REQUEST_ACCESSIBILITY_BUTTON = 256;
    public static final int FLAG_REQUEST_FINGERPRINT_GESTURES = 512;
    public static final int FLAG_REQUEST_SHORTCUT_WARNING_DIALOG_SPOKEN_FEEDBACK = 1024;
    public static final int FLAG_SERVICE_HANDLES_DOUBLE_TAP = 2048;
    public static final int FLAG_REQUEST_MULTI_FINGER_GESTURES = 4096;
    public static final int FLAG_REQUEST_2_FINGER_PASSTHROUGH = 8192;
    public static final int FLAG_SEND_MOTION_EVENTS = 16384;
    public static final int FLAG_INPUT_METHOD_EDITOR = 32768;
    public static final int FLAG_FORCE_DIRECT_BOOT_AWARE = 65536;
    public int eventTypes;
    public String[] packageNames;
    public int feedbackType;
    public long notificationTimeout;
    public int flags;
    public boolean crashed;
    private int mNonInteractiveUiTimeout;
    private int mInteractiveUiTimeout;
    private ComponentName mComponentName;
    private ResolveInfo mResolveInfo;
    private String mSettingsActivityName;
    private String mTileServiceName;
    private int mCapabilities;
    private int mSummaryResId;
    private String mNonLocalizedSummary;
    private int mIntroResId;
    private int mDescriptionResId;
    private String mNonLocalizedDescription;
    private static final long REQUEST_ACCESSIBILITY_BUTTON_CHANGE = 136293963L;
    private int mAnimatedImageRes;
    private int mHtmlDescriptionRes;
    private boolean mIsAccessibilityTool = false;
    public static final Parcelable.Creator<AccessibilityServiceInfo> CREATOR;

    public AccessibilityServiceInfo() {
    }

    public AccessibilityServiceInfo(ResolveInfo resolveInfo, Context context) throws XmlPullParserException, IOException {
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        this.mComponentName = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        this.mResolveInfo = resolveInfo;
        try (XmlResourceParser parser = null;){
            TypedValue peekedValue;
            PackageManager packageManager = context.getPackageManager();
            parser = serviceInfo.loadXmlMetaData(packageManager, "android.accessibilityservice");
            if (parser == null) {
                return;
            }
            int type = 0;
            while (type != 1 && type != 2) {
                type = parser.next();
            }
            String nodeName = parser.getName();
            if (!TAG_ACCESSIBILITY_SERVICE.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start withaccessibility-service tag");
            }
            AttributeSet allAttributes = Xml.asAttributeSet(parser);
            Resources resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
            TypedArray asAttributes = resources.obtainAttributes(allAttributes, R.styleable.AccessibilityService);
            this.eventTypes = asAttributes.getInt(3, 0);
            String packageNamez = asAttributes.getString(4);
            if (packageNamez != null) {
                this.packageNames = packageNamez.split("(\\s)*,(\\s)*");
            }
            this.feedbackType = asAttributes.getInt(5, 0);
            this.notificationTimeout = asAttributes.getInt(6, 0);
            this.mNonInteractiveUiTimeout = asAttributes.getInt(15, 0);
            this.mInteractiveUiTimeout = asAttributes.getInt(16, 0);
            this.flags = asAttributes.getInt(7, 0);
            this.mSettingsActivityName = asAttributes.getString(2);
            if (asAttributes.getBoolean(8, false)) {
                this.mCapabilities |= 1;
            }
            if (asAttributes.getBoolean(9, false)) {
                this.mCapabilities |= 2;
            }
            if (asAttributes.getBoolean(11, false)) {
                this.mCapabilities |= 8;
            }
            if (asAttributes.getBoolean(12, false)) {
                this.mCapabilities |= 0x10;
            }
            if (asAttributes.getBoolean(13, false)) {
                this.mCapabilities |= 0x20;
            }
            if (asAttributes.getBoolean(14, false)) {
                this.mCapabilities |= 0x40;
            }
            if (asAttributes.getBoolean(19, false)) {
                this.mCapabilities |= 0x80;
            }
            if ((peekedValue = asAttributes.peekValue(0)) != null) {
                this.mDescriptionResId = peekedValue.resourceId;
                CharSequence nonLocalizedDescription = peekedValue.coerceToString();
                if (nonLocalizedDescription != null) {
                    this.mNonLocalizedDescription = nonLocalizedDescription.toString().trim();
                }
            }
            if ((peekedValue = asAttributes.peekValue(1)) != null) {
                this.mSummaryResId = peekedValue.resourceId;
                CharSequence nonLocalizedSummary = peekedValue.coerceToString();
                if (nonLocalizedSummary != null) {
                    this.mNonLocalizedSummary = nonLocalizedSummary.toString().trim();
                }
            }
            if ((peekedValue = asAttributes.peekValue(17)) != null) {
                this.mAnimatedImageRes = peekedValue.resourceId;
            }
            if ((peekedValue = asAttributes.peekValue(18)) != null) {
                this.mHtmlDescriptionRes = peekedValue.resourceId;
            }
            this.mIsAccessibilityTool = asAttributes.getBoolean(20, false);
            this.mTileServiceName = asAttributes.getString(21);
            peekedValue = asAttributes.peekValue(22);
            if (peekedValue != null) {
                this.mIntroResId = peekedValue.resourceId;
            }
            asAttributes.recycle();
        }
    }

    public void updateDynamicallyConfigurableProperties(IPlatformCompat platformCompat, AccessibilityServiceInfo other) {
        if (this.isRequestAccessibilityButtonChangeEnabled(platformCompat)) {
            other.flags &= 0xFFFFFEFF;
            other.flags |= this.flags & 0x100;
        }
        this.eventTypes = other.eventTypes;
        this.packageNames = other.packageNames;
        this.feedbackType = other.feedbackType;
        this.notificationTimeout = other.notificationTimeout;
        this.mNonInteractiveUiTimeout = other.mNonInteractiveUiTimeout;
        this.mInteractiveUiTimeout = other.mInteractiveUiTimeout;
        this.flags = other.flags;
    }

    private boolean isRequestAccessibilityButtonChangeEnabled(IPlatformCompat platformCompat) {
        if (this.mResolveInfo == null) {
            return true;
        }
        try {
            if (platformCompat != null) {
                return platformCompat.isChangeEnabled(136293963L, this.mResolveInfo.serviceInfo.applicationInfo);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.mResolveInfo.serviceInfo.applicationInfo.targetSdkVersion > 29;
    }

    public void setComponentName(ComponentName component) {
        this.mComponentName = component;
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public String getId() {
        return this.mComponentName.flattenToShortString();
    }

    public ResolveInfo getResolveInfo() {
        return this.mResolveInfo;
    }

    public String getSettingsActivityName() {
        return this.mSettingsActivityName;
    }

    public String getTileServiceName() {
        return this.mTileServiceName;
    }

    public int getAnimatedImageRes() {
        return this.mAnimatedImageRes;
    }

    public Drawable loadAnimatedImage(Context context) {
        if (this.mAnimatedImageRes == 0) {
            return null;
        }
        return AccessibilityUtils.loadSafeAnimatedImage(context, this.mResolveInfo.serviceInfo.applicationInfo, this.mAnimatedImageRes);
    }

    public boolean getCanRetrieveWindowContent() {
        return (this.mCapabilities & 1) != 0;
    }

    public int getCapabilities() {
        return this.mCapabilities;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setCapabilities(int capabilities) {
        this.mCapabilities = capabilities;
    }

    public CharSequence loadSummary(PackageManager packageManager) {
        if (this.mSummaryResId == 0) {
            return this.mNonLocalizedSummary;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence summary = packageManager.getText(serviceInfo.packageName, this.mSummaryResId, serviceInfo.applicationInfo);
        if (summary != null) {
            return summary.toString().trim();
        }
        return null;
    }

    public CharSequence loadIntro(PackageManager packageManager) {
        if (this.mIntroResId == 0) {
            return null;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence intro = packageManager.getText(serviceInfo.packageName, this.mIntroResId, serviceInfo.applicationInfo);
        if (intro != null) {
            return intro.toString().trim();
        }
        return null;
    }

    public String getDescription() {
        return this.mNonLocalizedDescription;
    }

    public String loadDescription(PackageManager packageManager) {
        if (this.mDescriptionResId == 0) {
            return this.mNonLocalizedDescription;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence description = packageManager.getText(serviceInfo.packageName, this.mDescriptionResId, serviceInfo.applicationInfo);
        if (description != null) {
            return description.toString().trim();
        }
        return null;
    }

    public String loadHtmlDescription(PackageManager packageManager) {
        if (this.mHtmlDescriptionRes == 0) {
            return null;
        }
        ServiceInfo serviceInfo = this.mResolveInfo.serviceInfo;
        CharSequence htmlDescription = packageManager.getText(serviceInfo.packageName, this.mHtmlDescriptionRes, serviceInfo.applicationInfo);
        if (htmlDescription != null) {
            return AccessibilityUtils.getFilteredHtmlText(htmlDescription.toString().trim());
        }
        return null;
    }

    public void setNonInteractiveUiTimeoutMillis(int timeout) {
        this.mNonInteractiveUiTimeout = timeout;
    }

    public int getNonInteractiveUiTimeoutMillis() {
        return this.mNonInteractiveUiTimeout;
    }

    public void setInteractiveUiTimeoutMillis(int timeout) {
        this.mInteractiveUiTimeout = timeout;
    }

    public int getInteractiveUiTimeoutMillis() {
        return this.mInteractiveUiTimeout;
    }

    public boolean isDirectBootAware() {
        return (this.flags & 0x10000) != 0 || this.mResolveInfo.serviceInfo.directBootAware;
    }

    public boolean isAccessibilityTool() {
        return this.mIsAccessibilityTool;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flagz) {
        parcel.writeInt(this.eventTypes);
        parcel.writeStringArray(this.packageNames);
        parcel.writeInt(this.feedbackType);
        parcel.writeLong(this.notificationTimeout);
        parcel.writeInt(this.mNonInteractiveUiTimeout);
        parcel.writeInt(this.mInteractiveUiTimeout);
        parcel.writeInt(this.flags);
        parcel.writeInt(this.crashed ? 1 : 0);
        parcel.writeParcelable(this.mComponentName, flagz);
        parcel.writeParcelable(this.mResolveInfo, 0);
        parcel.writeString(this.mSettingsActivityName);
        parcel.writeInt(this.mCapabilities);
        parcel.writeInt(this.mSummaryResId);
        parcel.writeString(this.mNonLocalizedSummary);
        parcel.writeInt(this.mDescriptionResId);
        parcel.writeInt(this.mAnimatedImageRes);
        parcel.writeInt(this.mHtmlDescriptionRes);
        parcel.writeString(this.mNonLocalizedDescription);
        parcel.writeBoolean(this.mIsAccessibilityTool);
        parcel.writeString(this.mTileServiceName);
        parcel.writeInt(this.mIntroResId);
    }

    private void initFromParcel(Parcel parcel) {
        this.eventTypes = parcel.readInt();
        this.packageNames = parcel.readStringArray();
        this.feedbackType = parcel.readInt();
        this.notificationTimeout = parcel.readLong();
        this.mNonInteractiveUiTimeout = parcel.readInt();
        this.mInteractiveUiTimeout = parcel.readInt();
        this.flags = parcel.readInt();
        this.crashed = parcel.readInt() != 0;
        this.mComponentName = parcel.readParcelable(this.getClass().getClassLoader(), ComponentName.class);
        this.mResolveInfo = parcel.readParcelable(null, ResolveInfo.class);
        this.mSettingsActivityName = parcel.readString();
        this.mCapabilities = parcel.readInt();
        this.mSummaryResId = parcel.readInt();
        this.mNonLocalizedSummary = parcel.readString();
        this.mDescriptionResId = parcel.readInt();
        this.mAnimatedImageRes = parcel.readInt();
        this.mHtmlDescriptionRes = parcel.readInt();
        this.mNonLocalizedDescription = parcel.readString();
        this.mIsAccessibilityTool = parcel.readBoolean();
        this.mTileServiceName = parcel.readString();
        this.mIntroResId = parcel.readInt();
    }

    public int hashCode() {
        return 31 + (this.mComponentName == null ? 0 : this.mComponentName.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityServiceInfo other = (AccessibilityServiceInfo)obj;
        return !(this.mComponentName == null ? other.mComponentName != null : !this.mComponentName.equals(other.mComponentName));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        AccessibilityServiceInfo.appendEventTypes(stringBuilder, this.eventTypes);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendPackageNames(stringBuilder, this.packageNames);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFeedbackTypes(stringBuilder, this.feedbackType);
        stringBuilder.append(", ");
        stringBuilder.append("notificationTimeout: ").append(this.notificationTimeout);
        stringBuilder.append(", ");
        stringBuilder.append("nonInteractiveUiTimeout: ").append(this.mNonInteractiveUiTimeout);
        stringBuilder.append(", ");
        stringBuilder.append("interactiveUiTimeout: ").append(this.mInteractiveUiTimeout);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendFlags(stringBuilder, this.flags);
        stringBuilder.append(", ");
        stringBuilder.append("id: ").append(this.getId());
        stringBuilder.append(", ");
        stringBuilder.append("resolveInfo: ").append(this.mResolveInfo);
        stringBuilder.append(", ");
        stringBuilder.append("settingsActivityName: ").append(this.mSettingsActivityName);
        stringBuilder.append(", ");
        stringBuilder.append("tileServiceName: ").append(this.mTileServiceName);
        stringBuilder.append(", ");
        stringBuilder.append("summary: ").append(this.mNonLocalizedSummary);
        stringBuilder.append(", ");
        stringBuilder.append("isAccessibilityTool: ").append(this.mIsAccessibilityTool);
        stringBuilder.append(", ");
        AccessibilityServiceInfo.appendCapabilities(stringBuilder, this.mCapabilities);
        return stringBuilder.toString();
    }

    private static void appendFeedbackTypes(StringBuilder stringBuilder, int feedbackTypes) {
        stringBuilder.append("feedbackTypes:");
        stringBuilder.append("[");
        while (feedbackTypes != 0) {
            int feedbackTypeBit = 1 << Integer.numberOfTrailingZeros(feedbackTypes);
            stringBuilder.append(AccessibilityServiceInfo.feedbackTypeToString(feedbackTypeBit));
            if ((feedbackTypes &= ~feedbackTypeBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendPackageNames(StringBuilder stringBuilder, String[] packageNames) {
        stringBuilder.append("packageNames:");
        stringBuilder.append("[");
        if (packageNames != null) {
            int packageNameCount = packageNames.length;
            for (int i = 0; i < packageNameCount; ++i) {
                stringBuilder.append(packageNames[i]);
                if (i >= packageNameCount - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("]");
    }

    private static void appendEventTypes(StringBuilder stringBuilder, int eventTypes) {
        stringBuilder.append("eventTypes:");
        stringBuilder.append("[");
        while (eventTypes != 0) {
            int eventTypeBit = 1 << Integer.numberOfTrailingZeros(eventTypes);
            stringBuilder.append(AccessibilityEvent.eventTypeToString(eventTypeBit));
            if ((eventTypes &= ~eventTypeBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendFlags(StringBuilder stringBuilder, int flags) {
        stringBuilder.append("flags:");
        stringBuilder.append("[");
        while (flags != 0) {
            int flagBit = 1 << Integer.numberOfTrailingZeros(flags);
            stringBuilder.append(AccessibilityServiceInfo.flagToString(flagBit));
            if ((flags &= ~flagBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private static void appendCapabilities(StringBuilder stringBuilder, int capabilities) {
        stringBuilder.append("capabilities:");
        stringBuilder.append("[");
        while (capabilities != 0) {
            int capabilityBit = 1 << Integer.numberOfTrailingZeros(capabilities);
            stringBuilder.append(AccessibilityServiceInfo.capabilityToString(capabilityBit));
            if ((capabilities &= ~capabilityBit) == 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    public static String feedbackTypeToString(int feedbackType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        while (feedbackType != 0) {
            int feedbackTypeFlag = 1 << Integer.numberOfTrailingZeros(feedbackType);
            feedbackType &= ~feedbackTypeFlag;
            switch (feedbackTypeFlag) {
                case 4: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_AUDIBLE");
                    break;
                }
                case 2: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_HAPTIC");
                    break;
                }
                case 16: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_GENERIC");
                    break;
                }
                case 1: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_SPOKEN");
                    break;
                }
                case 8: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_VISUAL");
                    break;
                }
                case 32: {
                    if (builder.length() > 1) {
                        builder.append(", ");
                    }
                    builder.append("FEEDBACK_BRAILLE");
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static String flagToString(int flag) {
        switch (flag) {
            case 1: {
                return "DEFAULT";
            }
            case 2: {
                return "FLAG_INCLUDE_NOT_IMPORTANT_VIEWS";
            }
            case 4: {
                return "FLAG_REQUEST_TOUCH_EXPLORATION_MODE";
            }
            case 2048: {
                return "FLAG_SERVICE_HANDLES_DOUBLE_TAP";
            }
            case 4096: {
                return "FLAG_REQUEST_MULTI_FINGER_GESTURES";
            }
            case 8192: {
                return "FLAG_REQUEST_2_FINGER_PASSTHROUGH";
            }
            case 16384: {
                return "FLAG_SEND_MOTION_EVENTS";
            }
            case 8: {
                return "FLAG_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 16: {
                return "FLAG_REPORT_VIEW_IDS";
            }
            case 32: {
                return "FLAG_REQUEST_FILTER_KEY_EVENTS";
            }
            case 64: {
                return "FLAG_RETRIEVE_INTERACTIVE_WINDOWS";
            }
            case 128: {
                return "FLAG_ENABLE_ACCESSIBILITY_VOLUME";
            }
            case 256: {
                return "FLAG_REQUEST_ACCESSIBILITY_BUTTON";
            }
            case 512: {
                return "FLAG_REQUEST_FINGERPRINT_GESTURES";
            }
            case 1024: {
                return "FLAG_REQUEST_SHORTCUT_WARNING_DIALOG_SPOKEN_FEEDBACK";
            }
            case 32768: {
                return "FLAG_INPUT_METHOD_EDITOR";
            }
        }
        return null;
    }

    public static String capabilityToString(int capability) {
        switch (capability) {
            case 1: {
                return "CAPABILITY_CAN_RETRIEVE_WINDOW_CONTENT";
            }
            case 2: {
                return "CAPABILITY_CAN_REQUEST_TOUCH_EXPLORATION";
            }
            case 4: {
                return "CAPABILITY_CAN_REQUEST_ENHANCED_WEB_ACCESSIBILITY";
            }
            case 8: {
                return "CAPABILITY_CAN_REQUEST_FILTER_KEY_EVENTS";
            }
            case 16: {
                return "CAPABILITY_CAN_CONTROL_MAGNIFICATION";
            }
            case 32: {
                return "CAPABILITY_CAN_PERFORM_GESTURES";
            }
            case 64: {
                return "CAPABILITY_CAN_REQUEST_FINGERPRINT_GESTURES";
            }
            case 128: {
                return "CAPABILITY_CAN_TAKE_SCREENSHOT";
            }
        }
        return "UNKNOWN";
    }

    public List<CapabilityInfo> getCapabilityInfos() {
        return this.getCapabilityInfos(null);
    }

    public List<CapabilityInfo> getCapabilityInfos(Context context) {
        int capabilityBit;
        if (this.mCapabilities == 0) {
            return Collections.emptyList();
        }
        ArrayList<CapabilityInfo> capabilityInfos = new ArrayList<CapabilityInfo>();
        SparseArray<CapabilityInfo> capabilityInfoSparseArray = AccessibilityServiceInfo.getCapabilityInfoSparseArray(context);
        for (int capabilities = this.mCapabilities; capabilities != 0; capabilities &= ~capabilityBit) {
            capabilityBit = 1 << Integer.numberOfTrailingZeros(capabilities);
            CapabilityInfo capabilityInfo = capabilityInfoSparseArray.get(capabilityBit);
            if (capabilityInfo == null) continue;
            capabilityInfos.add(capabilityInfo);
        }
        return capabilityInfos;
    }

    private static SparseArray<CapabilityInfo> getCapabilityInfoSparseArray(Context context) {
        if (sAvailableCapabilityInfos == null) {
            sAvailableCapabilityInfos = new SparseArray();
            sAvailableCapabilityInfos.put(1, new CapabilityInfo(1, 17039848, 17039841));
            sAvailableCapabilityInfos.put(2, new CapabilityInfo(2, 17039847, 17039840));
            sAvailableCapabilityInfos.put(8, new CapabilityInfo(8, 17039846, 17039839));
            sAvailableCapabilityInfos.put(16, new CapabilityInfo(16, 17039844, 17039837));
            sAvailableCapabilityInfos.put(32, new CapabilityInfo(32, 17039845, 17039838));
            sAvailableCapabilityInfos.put(128, new CapabilityInfo(128, 17039849, 17039842));
            if (context == null || AccessibilityServiceInfo.fingerprintAvailable(context)) {
                sAvailableCapabilityInfos.put(64, new CapabilityInfo(64, 17039843, 17039836));
            }
        }
        return sAvailableCapabilityInfos;
    }

    private static boolean fingerprintAvailable(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.fingerprint") && context.getSystemService(FingerprintManager.class).isHardwareDetected();
    }

    static {
        CREATOR = new Parcelable.Creator<AccessibilityServiceInfo>(){

            @Override
            public AccessibilityServiceInfo createFromParcel(Parcel parcel) {
                AccessibilityServiceInfo info = new AccessibilityServiceInfo();
                info.initFromParcel(parcel);
                return info;
            }

            public AccessibilityServiceInfo[] newArray(int size) {
                return new AccessibilityServiceInfo[size];
            }
        };
    }

    public static class CapabilityInfo {
        public final int capability;
        public final int titleResId;
        public final int descResId;

        public CapabilityInfo(int capability, int titleResId, int descResId) {
            this.capability = capability;
            this.titleResId = titleResId;
            this.descResId = descResId;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeedbackType {
    }
}

