/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.QueuedWork;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.SharedPreferences;
import android.os.FileUtils;
import android.os.Looper;
import android.system.ErrnoException;
import android.system.Os;
import android.system.StructStat;
import android.system.StructTimespec;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.ExponentiallyBucketedHistogram;
import com.android.internal.util.XmlUtils;
import dalvik.system.BlockGuard;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParserException;

class SharedPreferencesImpl
implements SharedPreferences {
    private static final String TAG = "SharedPreferencesImpl";
    private static final boolean DEBUG = false;
    private static final Object CONTENT = new Object();
    private static final long MAX_FSYNC_DURATION_MILLIS = 256L;
    private static final long CALLBACK_ON_CLEAR_CHANGE = 119147584L;
    @UnsupportedAppUsage
    private final File mFile;
    private final File mBackupFile;
    private final int mMode;
    private final Object mLock = new Object();
    private final Object mWritingToDiskLock = new Object();
    @GuardedBy(value={"mLock"})
    private Map<String, Object> mMap;
    @GuardedBy(value={"mLock"})
    private Throwable mThrowable;
    @GuardedBy(value={"mLock"})
    private int mDiskWritesInFlight = 0;
    @GuardedBy(value={"mLock"})
    private boolean mLoaded = false;
    @GuardedBy(value={"mLock"})
    private StructTimespec mStatTimestamp;
    @GuardedBy(value={"mLock"})
    private long mStatSize;
    @GuardedBy(value={"mLock"})
    private final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners = new WeakHashMap();
    @GuardedBy(value={"this"})
    private long mCurrentMemoryStateGeneration;
    @GuardedBy(value={"mWritingToDiskLock"})
    private long mDiskStateGeneration;
    @GuardedBy(value={"mWritingToDiskLock"})
    private final ExponentiallyBucketedHistogram mSyncTimes = new ExponentiallyBucketedHistogram(16);
    private int mNumSync = 0;

    @UnsupportedAppUsage
    SharedPreferencesImpl(File file, int mode) {
        this.mFile = file;
        this.mBackupFile = SharedPreferencesImpl.makeBackupFile(file);
        this.mMode = mode;
        this.mLoaded = false;
        this.mMap = null;
        this.mThrowable = null;
        this.startLoadFromDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void startLoadFromDisk() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLoaded = false;
        }
        new Thread("SharedPreferencesImpl-load"){

            @Override
            public void run() {
                SharedPreferencesImpl.this.loadFromDisk();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDisk() {
        Throwable thrown;
        StructStat stat;
        HashMap<String, ?> map;
        block24: {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mLoaded) {
                    return;
                }
                if (this.mBackupFile.exists()) {
                    this.mFile.delete();
                    this.mBackupFile.renameTo(this.mFile);
                }
            }
            if (this.mFile.exists() && !this.mFile.canRead()) {
                Log.w(TAG, "Attempt to read preferences file " + this.mFile + " without permission");
            }
            map = null;
            stat = null;
            thrown = null;
            try {
                stat = Os.stat(this.mFile.getPath());
                if (!this.mFile.canRead()) break block24;
                BufferedInputStream str = null;
                try {
                    str = new BufferedInputStream(new FileInputStream(this.mFile), 16384);
                    map = XmlUtils.readMapXml(str);
                }
                catch (Exception e) {
                    try {
                        Log.w(TAG, "Cannot read " + this.mFile.getAbsolutePath(), e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(str);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(str);
                    break block24;
                }
                IoUtils.closeQuietly(str);
            }
            catch (ErrnoException str) {
            }
            catch (Throwable t) {
                thrown = t;
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLoaded = true;
            this.mThrowable = thrown;
            try {
                if (thrown == null) {
                    if (map != null) {
                        this.mMap = map;
                        this.mStatTimestamp = stat.st_mtim;
                        this.mStatSize = stat.st_size;
                    } else {
                        this.mMap = new HashMap<String, Object>();
                    }
                }
            }
            catch (Throwable t) {
                this.mThrowable = t;
            }
            finally {
                this.mLock.notifyAll();
            }
        }
    }

    static File makeBackupFile(File prefsFile) {
        return new File(prefsFile.getPath() + ".bak");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void startReloadIfChangedUnexpectedly() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.hasFileChangedUnexpectedly()) {
                return;
            }
            this.startLoadFromDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFileChangedUnexpectedly() {
        StructStat stat;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDiskWritesInFlight > 0) {
                return false;
            }
        }
        try {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            stat = Os.stat(this.mFile.getPath());
        }
        catch (ErrnoException e) {
            return true;
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            return !stat.st_mtim.equals(this.mStatTimestamp) || this.mStatSize != stat.st_size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.put(listener, CONTENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.remove(listener);
        }
    }

    @GuardedBy(value={"mLock"})
    private void awaitLoadedLocked() {
        if (!this.mLoaded) {
            BlockGuard.getThreadPolicy().onReadFromDisk();
        }
        while (!this.mLoaded) {
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mThrowable != null) {
            throw new IllegalStateException(this.mThrowable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> getAll() {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            return new HashMap<String, Object>(this.mMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String key, String defValue) {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            String v = (String)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getStringSet(String key, Set<String> defValues) {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            Set<String> v = (Set<String>)this.mMap.get(key);
            return v != null ? v : defValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String key, int defValue) {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            Integer v = (Integer)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String key, long defValue) {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            Long v = (Long)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String key, float defValue) {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            Float v = (Float)this.mMap.get(key);
            return v != null ? v.floatValue() : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String key, boolean defValue) {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            Boolean v = (Boolean)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String key) {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
            return this.mMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedPreferences.Editor edit() {
        Object object = this.mLock;
        synchronized (object) {
            this.awaitLoadedLocked();
        }
        return new EditorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueDiskWrite(final MemoryCommitResult mcr, final Runnable postWriteRunnable) {
        final boolean isFromSyncCommit = postWriteRunnable == null;
        Runnable writeToDiskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SharedPreferencesImpl.this.mWritingToDiskLock;
                synchronized (object) {
                    SharedPreferencesImpl.this.writeToFile(mcr, isFromSyncCommit);
                }
                object = SharedPreferencesImpl.this.mLock;
                synchronized (object) {
                    --SharedPreferencesImpl.this.mDiskWritesInFlight;
                }
                if (postWriteRunnable != null) {
                    postWriteRunnable.run();
                }
            }
        };
        if (isFromSyncCommit) {
            boolean wasEmpty = false;
            Object object = this.mLock;
            synchronized (object) {
                wasEmpty = this.mDiskWritesInFlight == 1;
            }
            if (wasEmpty) {
                writeToDiskRunnable.run();
                return;
            }
        }
        QueuedWork.queue(writeToDiskRunnable, !isFromSyncCommit);
    }

    private static FileOutputStream createFileOutputStream(File file) {
        FileOutputStream str = null;
        try {
            str = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            File parent = file.getParentFile();
            if (!parent.mkdir()) {
                Log.e(TAG, "Couldn't create directory for SharedPreferences file " + file);
                return null;
            }
            FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
            try {
                str = new FileOutputStream(file);
            }
            catch (FileNotFoundException e2) {
                Log.e(TAG, "Couldn't create SharedPreferences file " + file, e2);
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mWritingToDiskLock"})
    private void writeToFile(MemoryCommitResult mcr, boolean isFromSyncCommit) {
        long startTime = 0L;
        long existsTime = 0L;
        long backupExistsTime = 0L;
        long outputStreamCreateTime = 0L;
        long writeTime = 0L;
        long fsyncTime = 0L;
        long setPermTime = 0L;
        long fstatTime = 0L;
        long deleteTime = 0L;
        boolean fileExists = this.mFile.exists();
        if (fileExists) {
            boolean needsWrite = false;
            if (this.mDiskStateGeneration < mcr.memoryStateGeneration) {
                if (isFromSyncCommit) {
                    needsWrite = true;
                } else {
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mCurrentMemoryStateGeneration == mcr.memoryStateGeneration) {
                            needsWrite = true;
                        }
                    }
                }
            }
            if (!needsWrite) {
                mcr.setDiskWriteResult(false, true);
                return;
            }
            boolean backupFileExists = this.mBackupFile.exists();
            if (!backupFileExists) {
                if (!this.mFile.renameTo(this.mBackupFile)) {
                    Log.e(TAG, "Couldn't rename file " + this.mFile + " to backup file " + this.mBackupFile);
                    mcr.setDiskWriteResult(false, false);
                    return;
                }
            } else {
                this.mFile.delete();
            }
        }
        try {
            FileOutputStream str = SharedPreferencesImpl.createFileOutputStream(this.mFile);
            if (str == null) {
                mcr.setDiskWriteResult(false, false);
                return;
            }
            XmlUtils.writeMapXml(mcr.mapToWriteToDisk, str);
            writeTime = System_Delegate.currentTimeMillis();
            FileUtils.sync(str);
            fsyncTime = System_Delegate.currentTimeMillis();
            str.close();
            ContextImpl.setFilePermissionsFromMode(this.mFile.getPath(), this.mMode, 0);
            try {
                StructStat stat = Os.stat(this.mFile.getPath());
                Object object = this.mLock;
                synchronized (object) {
                    this.mStatTimestamp = stat.st_mtim;
                    this.mStatSize = stat.st_size;
                }
            }
            catch (ErrnoException stat) {
                // empty catch block
            }
            this.mBackupFile.delete();
            this.mDiskStateGeneration = mcr.memoryStateGeneration;
            mcr.setDiskWriteResult(true, true);
            long fsyncDuration = fsyncTime - writeTime;
            this.mSyncTimes.add((int)fsyncDuration);
            ++this.mNumSync;
            if (this.mNumSync % 1024 == 0 || fsyncDuration > 256L) {
                this.mSyncTimes.log(TAG, "Time required to fsync " + this.mFile + ": ");
            }
            return;
        }
        catch (XmlPullParserException e) {
            Log.w(TAG, "writeToFile: Got exception:", e);
        }
        catch (IOException e) {
            Log.w(TAG, "writeToFile: Got exception:", e);
        }
        if (this.mFile.exists() && !this.mFile.delete()) {
            Log.e(TAG, "Couldn't clean up partially-written file " + this.mFile);
        }
        mcr.setDiskWriteResult(false, false);
    }

    public class EditorImpl
    implements SharedPreferences.Editor {
        private final Object mEditorLock = new Object();
        @GuardedBy(value={"mEditorLock"})
        private final Map<String, Object> mModified = new HashMap<String, Object>();
        @GuardedBy(value={"mEditorLock"})
        private boolean mClear = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putString(String key, String value) {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mModified.put(key, values == null ? null : new HashSet<String>(values));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putInt(String key, int value) {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putLong(String key, long value) {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putFloat(String key, float value) {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mModified.put(key, Float.valueOf(value));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor remove(String key) {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mModified.put(key, this);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor clear() {
            Object object = this.mEditorLock;
            synchronized (object) {
                this.mClear = true;
                return this;
            }
        }

        @Override
        public void apply() {
            final long startTime = System_Delegate.currentTimeMillis();
            final MemoryCommitResult mcr = this.commitToMemory();
            final Runnable awaitCommit = new Runnable(){

                @Override
                public void run() {
                    try {
                        mcr.writtenToDiskLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            QueuedWork.addFinisher(awaitCommit);
            Runnable postWriteRunnable = new Runnable(){

                @Override
                public void run() {
                    awaitCommit.run();
                    QueuedWork.removeFinisher(awaitCommit);
                }
            };
            SharedPreferencesImpl.this.enqueueDiskWrite(mcr, postWriteRunnable);
            this.notifyListeners(mcr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MemoryCommitResult commitToMemory() {
            long memoryStateGeneration;
            Map<String, Object> mapToWriteToDisk;
            boolean keysCleared = false;
            ArrayList<String> keysModified = null;
            HashSet<SharedPreferences.OnSharedPreferenceChangeListener> listeners = null;
            Object object = SharedPreferencesImpl.this.mLock;
            synchronized (object) {
                boolean hasListeners;
                if (SharedPreferencesImpl.this.mDiskWritesInFlight > 0) {
                    SharedPreferencesImpl.this.mMap = new HashMap<String, Object>(SharedPreferencesImpl.this.mMap);
                }
                mapToWriteToDisk = SharedPreferencesImpl.this.mMap;
                ++SharedPreferencesImpl.this.mDiskWritesInFlight;
                boolean bl = hasListeners = SharedPreferencesImpl.this.mListeners.size() > 0;
                if (hasListeners) {
                    keysModified = new ArrayList<String>();
                    listeners = new HashSet<SharedPreferences.OnSharedPreferenceChangeListener>(SharedPreferencesImpl.this.mListeners.keySet());
                }
                Object object2 = this.mEditorLock;
                synchronized (object2) {
                    boolean changesMade = false;
                    if (this.mClear) {
                        if (!mapToWriteToDisk.isEmpty()) {
                            changesMade = true;
                            mapToWriteToDisk.clear();
                        }
                        keysCleared = true;
                        this.mClear = false;
                    }
                    for (Map.Entry<String, Object> e : this.mModified.entrySet()) {
                        String k = e.getKey();
                        Object v = e.getValue();
                        if (v == this || v == null) {
                            if (!mapToWriteToDisk.containsKey(k)) continue;
                            mapToWriteToDisk.remove(k);
                        } else {
                            Object existingValue;
                            if (mapToWriteToDisk.containsKey(k) && (existingValue = mapToWriteToDisk.get(k)) != null && existingValue.equals(v)) continue;
                            mapToWriteToDisk.put(k, v);
                        }
                        changesMade = true;
                        if (!hasListeners) continue;
                        keysModified.add(k);
                    }
                    this.mModified.clear();
                    if (changesMade) {
                        ++SharedPreferencesImpl.this.mCurrentMemoryStateGeneration;
                    }
                    memoryStateGeneration = SharedPreferencesImpl.this.mCurrentMemoryStateGeneration;
                }
            }
            return new MemoryCommitResult(memoryStateGeneration, keysCleared, keysModified, listeners, mapToWriteToDisk);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean commit() {
            long startTime = 0L;
            MemoryCommitResult mcr = this.commitToMemory();
            SharedPreferencesImpl.this.enqueueDiskWrite(mcr, null);
            try {
                mcr.writtenToDiskLatch.await();
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            this.notifyListeners(mcr);
            return mcr.writeToDiskResult;
        }

        private void notifyListeners(MemoryCommitResult mcr) {
            if (mcr.listeners == null || mcr.keysModified == null && !mcr.keysCleared) {
                return;
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                if (mcr.keysCleared && Compatibility.isChangeEnabled(119147584L)) {
                    for (SharedPreferences.OnSharedPreferenceChangeListener listener : mcr.listeners) {
                        if (listener == null) continue;
                        listener.onSharedPreferenceChanged(SharedPreferencesImpl.this, null);
                    }
                }
                for (int i = mcr.keysModified.size() - 1; i >= 0; --i) {
                    String key = mcr.keysModified.get(i);
                    for (SharedPreferences.OnSharedPreferenceChangeListener listener : mcr.listeners) {
                        if (listener == null) continue;
                        listener.onSharedPreferenceChanged(SharedPreferencesImpl.this, key);
                    }
                }
            } else {
                ActivityThread.sMainThreadHandler.post(() -> this.notifyListeners(mcr));
            }
        }
    }

    private static class MemoryCommitResult {
        final long memoryStateGeneration;
        final boolean keysCleared;
        final List<String> keysModified;
        final Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
        final Map<String, Object> mapToWriteToDisk;
        final CountDownLatch writtenToDiskLatch = new CountDownLatch(1);
        @GuardedBy(value={"mWritingToDiskLock"})
        volatile boolean writeToDiskResult = false;
        boolean wasWritten = false;

        private MemoryCommitResult(long memoryStateGeneration, boolean keysCleared, List<String> keysModified, Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners, Map<String, Object> mapToWriteToDisk) {
            this.memoryStateGeneration = memoryStateGeneration;
            this.keysCleared = keysCleared;
            this.keysModified = keysModified;
            this.listeners = listeners;
            this.mapToWriteToDisk = mapToWriteToDisk;
        }

        void setDiskWriteResult(boolean wasWritten, boolean result) {
            this.wasWritten = wasWritten;
            this.writeToDiskResult = result;
            this.writtenToDiskLatch.countDown();
        }
    }
}

