/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Slog;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.function.Supplier;
import org.xmlpull.v1.XmlPullParserException;

public class ParcelableResource
implements Parcelable {
    private static String TAG = "DevicePolicyManager";
    private static final String ATTR_RESOURCE_ID = "resource-id";
    private static final String ATTR_PACKAGE_NAME = "package-name";
    private static final String ATTR_RESOURCE_NAME = "resource-name";
    private static final String ATTR_RESOURCE_TYPE = "resource-type";
    public static final int RESOURCE_TYPE_DRAWABLE = 1;
    public static final int RESOURCE_TYPE_STRING = 2;
    private final int mResourceId;
    private final String mPackageName;
    private final String mResourceName;
    private final int mResourceType;
    public static final Parcelable.Creator<ParcelableResource> CREATOR = new Parcelable.Creator<ParcelableResource>(){

        @Override
        public ParcelableResource createFromParcel(Parcel in) {
            int resourceId = in.readInt();
            String packageName = in.readString();
            String resourceName = in.readString();
            int resourceType = in.readInt();
            return new ParcelableResource(resourceId, packageName, resourceName, resourceType);
        }

        public ParcelableResource[] newArray(int size) {
            return new ParcelableResource[size];
        }
    };

    public ParcelableResource(Context context, int resourceId, int resourceType) throws IllegalStateException, IllegalArgumentException {
        Objects.requireNonNull(context, "context must be provided");
        ParcelableResource.verifyResourceExistsInCallingPackage(context, resourceId, resourceType);
        this.mResourceId = resourceId;
        this.mPackageName = context.getResources().getResourcePackageName(resourceId);
        this.mResourceName = context.getResources().getResourceName(resourceId);
        this.mResourceType = resourceType;
    }

    private ParcelableResource(int resourceId, String packageName, String resourceName, int resourceType) {
        this.mResourceId = resourceId;
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mResourceName = Objects.requireNonNull(resourceName);
        this.mResourceType = resourceType;
    }

    private static void verifyResourceExistsInCallingPackage(Context context, int resourceId, int resourceType) throws IllegalStateException, IllegalArgumentException {
        switch (resourceType) {
            case 1: {
                if (ParcelableResource.hasDrawableInCallingPackage(context, resourceId)) break;
                throw new IllegalStateException(String.format("Drawable with id %d doesn't exist in the calling package %s", resourceId, context.getPackageName()));
            }
            case 2: {
                if (ParcelableResource.hasStringInCallingPackage(context, resourceId)) break;
                throw new IllegalStateException(String.format("String with id %d doesn't exist in the calling package %s", resourceId, context.getPackageName()));
            }
            default: {
                throw new IllegalArgumentException("Unknown ResourceType: " + resourceType);
            }
        }
    }

    private static boolean hasDrawableInCallingPackage(Context context, int resourceId) {
        try {
            return "drawable".equals(context.getResources().getResourceTypeName(resourceId));
        }
        catch (Resources.NotFoundException e) {
            return false;
        }
    }

    private static boolean hasStringInCallingPackage(Context context, int resourceId) {
        try {
            return "string".equals(context.getResources().getResourceTypeName(resourceId));
        }
        catch (Resources.NotFoundException e) {
            return false;
        }
    }

    public int getResourceId() {
        return this.mResourceId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getResourceName() {
        return this.mResourceName;
    }

    public int getResourceType() {
        return this.mResourceType;
    }

    public Drawable getDrawable(Context context, int density, Supplier<Drawable> defaultDrawableLoader) {
        try {
            Resources resources = this.getAppResourcesWithCallersConfiguration(context);
            this.verifyResourceName(resources);
            return resources.getDrawableForDensity(this.mResourceId, density, context.getTheme());
        }
        catch (PackageManager.NameNotFoundException | RuntimeException e) {
            Slog.e(TAG, "Unable to load drawable resource " + this.mResourceName, e);
            return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
        }
    }

    public String getString(Context context, Supplier<String> defaultStringLoader) {
        try {
            Resources resources = this.getAppResourcesWithCallersConfiguration(context);
            this.verifyResourceName(resources);
            return resources.getString(this.mResourceId);
        }
        catch (PackageManager.NameNotFoundException | RuntimeException e) {
            Slog.e(TAG, "Unable to load string resource " + this.mResourceName, e);
            return ParcelableResource.loadDefaultString(defaultStringLoader);
        }
    }

    public String getString(Context context, Supplier<String> defaultStringLoader, Object ... formatArgs) {
        try {
            Resources resources = this.getAppResourcesWithCallersConfiguration(context);
            this.verifyResourceName(resources);
            String rawString = resources.getString(this.mResourceId);
            return String.format(context.getResources().getConfiguration().getLocales().get(0), rawString, formatArgs);
        }
        catch (PackageManager.NameNotFoundException | RuntimeException e) {
            Slog.e(TAG, "Unable to load string resource " + this.mResourceName, e);
            return ParcelableResource.loadDefaultString(defaultStringLoader);
        }
    }

    private Resources getAppResourcesWithCallersConfiguration(Context context) throws PackageManager.NameNotFoundException {
        PackageManager pm = context.getPackageManager();
        ApplicationInfo ai = pm.getApplicationInfo(this.mPackageName, 9216);
        return pm.getResourcesForApplication(ai, context.getResources().getConfiguration());
    }

    private void verifyResourceName(Resources resources) throws IllegalStateException {
        String name = resources.getResourceName(this.mResourceId);
        if (!this.mResourceName.equals(name)) {
            throw new IllegalStateException(String.format("Current resource name %s for resource id %d has changed from the previously stored resource name %s.", name, this.mResourceId, this.mResourceName));
        }
    }

    public static Drawable loadDefaultDrawable(Supplier<Drawable> defaultDrawableLoader) {
        Objects.requireNonNull(defaultDrawableLoader, "defaultDrawableLoader can't be null");
        return defaultDrawableLoader.get();
    }

    public static String loadDefaultString(Supplier<String> defaultStringLoader) {
        Objects.requireNonNull(defaultStringLoader, "defaultStringLoader can't be null");
        return defaultStringLoader.get();
    }

    public void writeToXmlFile(TypedXmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.attributeInt(null, ATTR_RESOURCE_ID, this.mResourceId);
        xmlSerializer.attribute(null, ATTR_PACKAGE_NAME, this.mPackageName);
        xmlSerializer.attribute(null, ATTR_RESOURCE_NAME, this.mResourceName);
        xmlSerializer.attributeInt(null, ATTR_RESOURCE_TYPE, this.mResourceType);
    }

    public static ParcelableResource createFromXml(TypedXmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int resourceId = xmlPullParser.getAttributeInt(null, ATTR_RESOURCE_ID);
        String packageName = xmlPullParser.getAttributeValue(null, ATTR_PACKAGE_NAME);
        String resourceName = xmlPullParser.getAttributeValue(null, ATTR_RESOURCE_NAME);
        int resourceType = xmlPullParser.getAttributeInt(null, ATTR_RESOURCE_TYPE);
        return new ParcelableResource(resourceId, packageName, resourceName, resourceType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelableResource other = (ParcelableResource)o;
        return this.mResourceId == other.mResourceId && this.mPackageName.equals(other.mPackageName) && this.mResourceName.equals(other.mResourceName) && this.mResourceType == other.mResourceType;
    }

    public int hashCode() {
        return Objects.hash(this.mResourceId, this.mPackageName, this.mResourceName, this.mResourceType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mResourceId);
        dest.writeString(this.mPackageName);
        dest.writeString(this.mResourceName);
        dest.writeInt(this.mResourceType);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResourceType {
    }
}

