/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.IndentingPrintWriter;
import android.util.Log;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.xmlpull.v1.XmlPullParserException;

public class PreferentialNetworkServiceConfig
implements Parcelable {
    final boolean mIsEnabled;
    final int mNetworkId;
    final boolean mAllowFallbackToDefaultConnection;
    final int[] mIncludedUids;
    final int[] mExcludedUids;
    private static final String LOG_TAG = "PreferentialNetworkServiceConfig";
    private static final String TAG_PREFERENTIAL_NETWORK_SERVICE_CONFIG = "preferential_network_service_config";
    private static final String TAG_CONFIG_ENABLED = "preferential_network_service_config_enabled";
    private static final String TAG_UID = "uid";
    private static final String TAG_NETWORK_ID = "preferential_network_service_network_id";
    private static final String TAG_ALLOW_FALLBACK_TO_DEFAULT_CONNECTION = "allow_fallback_to_default_connection";
    private static final String TAG_INCLUDED_UIDS = "included_uids";
    private static final String TAG_EXCLUDED_UIDS = "excluded_uids";
    private static final String ATTR_VALUE = "value";
    public static final PreferentialNetworkServiceConfig DEFAULT = new Builder().build();
    public static final int PREFERENTIAL_NETWORK_ID_1 = 1;
    public static final int PREFERENTIAL_NETWORK_ID_2 = 2;
    public static final int PREFERENTIAL_NETWORK_ID_3 = 3;
    public static final int PREFERENTIAL_NETWORK_ID_4 = 4;
    public static final int PREFERENTIAL_NETWORK_ID_5 = 5;
    public static final Parcelable.Creator<PreferentialNetworkServiceConfig> CREATOR = new Parcelable.Creator<PreferentialNetworkServiceConfig>(){

        public PreferentialNetworkServiceConfig[] newArray(int size) {
            return new PreferentialNetworkServiceConfig[size];
        }

        @Override
        public PreferentialNetworkServiceConfig createFromParcel(Parcel in) {
            return new PreferentialNetworkServiceConfig(in);
        }
    };

    private PreferentialNetworkServiceConfig(boolean isEnabled, boolean allowFallbackToDefaultConnection, int[] includedUids, int[] excludedUids, int networkId) {
        this.mIsEnabled = isEnabled;
        this.mAllowFallbackToDefaultConnection = allowFallbackToDefaultConnection;
        this.mIncludedUids = includedUids;
        this.mExcludedUids = excludedUids;
        this.mNetworkId = networkId;
    }

    private PreferentialNetworkServiceConfig(Parcel in) {
        this.mIsEnabled = in.readBoolean();
        this.mAllowFallbackToDefaultConnection = in.readBoolean();
        this.mNetworkId = in.readInt();
        this.mIncludedUids = in.createIntArray();
        this.mExcludedUids = in.createIntArray();
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public boolean isFallbackToDefaultConnectionAllowed() {
        return this.mAllowFallbackToDefaultConnection;
    }

    public int[] getIncludedUids() {
        return this.mIncludedUids;
    }

    public int[] getExcludedUids() {
        return this.mExcludedUids;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public String toString() {
        return "PreferentialNetworkServiceConfig{mIsEnabled=" + this.isEnabled() + "mAllowFallbackToDefaultConnection=" + this.isFallbackToDefaultConnectionAllowed() + "mIncludedUids=" + Arrays.toString(this.mIncludedUids) + "mExcludedUids=" + Arrays.toString(this.mExcludedUids) + "mNetworkId=" + this.mNetworkId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreferentialNetworkServiceConfig that = (PreferentialNetworkServiceConfig)o;
        return this.mIsEnabled == that.mIsEnabled && this.mAllowFallbackToDefaultConnection == that.mAllowFallbackToDefaultConnection && this.mNetworkId == that.mNetworkId && Objects.equals(this.mIncludedUids, that.mIncludedUids) && Objects.equals(this.mExcludedUids, that.mExcludedUids);
    }

    public int hashCode() {
        return Objects.hashCode(this.mIsEnabled) * 17 + Objects.hashCode(this.mAllowFallbackToDefaultConnection) * 19 + Objects.hashCode(this.mIncludedUids) * 23 + Objects.hashCode(this.mExcludedUids) * 29 + this.mNetworkId * 31;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mIsEnabled);
        dest.writeBoolean(this.mAllowFallbackToDefaultConnection);
        dest.writeInt(this.mNetworkId);
        dest.writeIntArray(this.mIncludedUids);
        dest.writeIntArray(this.mExcludedUids);
    }

    private void writeAttributeValueToXml(TypedXmlSerializer out, String tag, int value) throws IOException {
        out.startTag(null, tag);
        out.attributeInt(null, ATTR_VALUE, value);
        out.endTag(null, tag);
    }

    private void writeAttributeValueToXml(TypedXmlSerializer out, String tag, boolean value) throws IOException {
        out.startTag(null, tag);
        out.attributeBoolean(null, ATTR_VALUE, value);
        out.endTag(null, tag);
    }

    private void writeAttributeValuesToXml(TypedXmlSerializer out, String outerTag, String innerTag, Collection<String> values) throws IOException {
        out.startTag(null, outerTag);
        for (String value : values) {
            out.startTag(null, innerTag);
            out.attribute(null, ATTR_VALUE, value);
            out.endTag(null, innerTag);
        }
        out.endTag(null, outerTag);
    }

    private static void readAttributeValues(TypedXmlPullParser parser, String tag, Collection<String> result) throws XmlPullParserException, IOException {
        int typeDAM;
        result.clear();
        int outerDepthDAM = parser.getDepth();
        while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
            if (typeDAM == 3 || typeDAM == 4) continue;
            String tagDAM = parser.getName();
            if (tag.equals(tagDAM)) {
                result.add(parser.getAttributeValue(null, ATTR_VALUE));
                continue;
            }
            Log.e(LOG_TAG, "Expected tag " + tag + " but found " + tagDAM);
        }
    }

    private List<String> intArrayToStringList(int[] array2) {
        return Arrays.stream(array2).mapToObj(String::valueOf).collect(Collectors.toList());
    }

    private static int[] readStringListToIntArray(TypedXmlPullParser parser, String tag) throws XmlPullParserException, IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        PreferentialNetworkServiceConfig.readAttributeValues(parser, tag, stringList);
        int[] intArray = stringList.stream().map(s -> Integer.parseInt(s)).mapToInt(Integer::intValue).toArray();
        return intArray;
    }

    public static PreferentialNetworkServiceConfig getPreferentialNetworkServiceConfig(TypedXmlPullParser parser, String tag) throws XmlPullParserException, IOException {
        int typeDAM;
        int outerDepthDAM = parser.getDepth();
        Builder resultBuilder = new Builder();
        while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
            if (typeDAM == 3 || typeDAM == 4) continue;
            String tagDAM = parser.getName();
            if (TAG_CONFIG_ENABLED.equals(tagDAM)) {
                resultBuilder.setEnabled(parser.getAttributeBoolean(null, ATTR_VALUE, false));
                continue;
            }
            if (TAG_NETWORK_ID.equals(tagDAM)) {
                int val = parser.getAttributeInt(null, ATTR_VALUE, 0);
                if (val == 0) continue;
                resultBuilder.setNetworkId(val);
                continue;
            }
            if (TAG_ALLOW_FALLBACK_TO_DEFAULT_CONNECTION.equals(tagDAM)) {
                resultBuilder.setFallbackToDefaultConnectionAllowed(parser.getAttributeBoolean(null, ATTR_VALUE, true));
                continue;
            }
            if (TAG_INCLUDED_UIDS.equals(tagDAM)) {
                resultBuilder.setIncludedUids(PreferentialNetworkServiceConfig.readStringListToIntArray(parser, TAG_UID));
                continue;
            }
            if (TAG_EXCLUDED_UIDS.equals(tagDAM)) {
                resultBuilder.setExcludedUids(PreferentialNetworkServiceConfig.readStringListToIntArray(parser, TAG_UID));
                continue;
            }
            Log.w(LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
        }
        return resultBuilder.build();
    }

    public void writeToXml(TypedXmlSerializer out) throws IOException {
        out.startTag(null, TAG_PREFERENTIAL_NETWORK_SERVICE_CONFIG);
        this.writeAttributeValueToXml(out, TAG_CONFIG_ENABLED, this.isEnabled());
        this.writeAttributeValueToXml(out, TAG_NETWORK_ID, this.getNetworkId());
        this.writeAttributeValueToXml(out, TAG_ALLOW_FALLBACK_TO_DEFAULT_CONNECTION, this.isFallbackToDefaultConnectionAllowed());
        this.writeAttributeValuesToXml(out, TAG_INCLUDED_UIDS, TAG_UID, this.intArrayToStringList(this.getIncludedUids()));
        this.writeAttributeValuesToXml(out, TAG_EXCLUDED_UIDS, TAG_UID, this.intArrayToStringList(this.getExcludedUids()));
        out.endTag(null, TAG_PREFERENTIAL_NETWORK_SERVICE_CONFIG);
    }

    public void dump(IndentingPrintWriter pw) {
        pw.print("networkId=");
        pw.println(this.mNetworkId);
        pw.print("isEnabled=");
        pw.println(this.mIsEnabled);
        pw.print("allowFallbackToDefaultConnection=");
        pw.println(this.mAllowFallbackToDefaultConnection);
        pw.print("includedUids=");
        pw.println(this.mIncludedUids);
        pw.print("excludedUids=");
        pw.println(this.mExcludedUids);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        boolean mIsEnabled = false;
        int mNetworkId = 0;
        boolean mAllowFallbackToDefaultConnection = true;
        int[] mIncludedUids = new int[0];
        int[] mExcludedUids = new int[0];

        public Builder setEnabled(boolean isEnabled) {
            this.mIsEnabled = isEnabled;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setFallbackToDefaultConnectionAllowed(boolean allowFallbackToDefaultConnection) {
            this.mAllowFallbackToDefaultConnection = allowFallbackToDefaultConnection;
            return this;
        }

        public Builder setIncludedUids(int[] uids) {
            Objects.requireNonNull(uids);
            this.mIncludedUids = uids;
            return this;
        }

        public Builder setExcludedUids(int[] uids) {
            Objects.requireNonNull(uids);
            this.mExcludedUids = uids;
            return this;
        }

        public PreferentialNetworkServiceConfig build() {
            if (this.mIncludedUids.length > 0 && this.mExcludedUids.length > 0) {
                throw new IllegalStateException("Both includedUids and excludedUids cannot be nonempty");
            }
            return new PreferentialNetworkServiceConfig(this.mIsEnabled, this.mAllowFallbackToDefaultConnection, this.mIncludedUids, this.mExcludedUids, this.mNetworkId);
        }

        public Builder setNetworkId(int preferenceId) {
            if (preferenceId < 1 || preferenceId > 5) {
                throw new IllegalArgumentException("Invalid preference identifier");
            }
            this.mNetworkId = preferenceId;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreferentialNetworkPreferenceId {
    }
}

