/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.app.appsearch.GenericDocument;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentsParcel
implements Parcelable {
    private final List<GenericDocument> mDocuments;
    public static final Parcelable.Creator<DocumentsParcel> CREATOR = new Parcelable.Creator<DocumentsParcel>(){

        @Override
        public DocumentsParcel createFromParcel(Parcel in) {
            return new DocumentsParcel(in);
        }

        public DocumentsParcel[] newArray(int size) {
            return new DocumentsParcel[size];
        }
    };

    public DocumentsParcel(List<GenericDocument> documents) {
        this.mDocuments = Objects.requireNonNull(documents);
    }

    private DocumentsParcel(Parcel in) {
        this(in.readBlob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentsParcel(byte[] dataBlob) {
        Parcel unmarshallParcel = Parcel.obtain();
        try {
            unmarshallParcel.unmarshall(dataBlob, 0, dataBlob.length);
            unmarshallParcel.setDataPosition(0);
            int size = unmarshallParcel.readInt();
            this.mDocuments = new ArrayList<GenericDocument>(size);
            for (int i = 0; i < size; ++i) {
                this.mDocuments.add(new GenericDocument(unmarshallParcel.readBundle()));
            }
        }
        finally {
            unmarshallParcel.recycle();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBlob(this.serializeToByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeToByteArray() {
        byte[] bytes;
        Parcel data = Parcel.obtain();
        try {
            data.writeInt(this.mDocuments.size());
            for (int i = 0; i < this.mDocuments.size(); ++i) {
                data.writeBundle(this.mDocuments.get(i).getBundle());
            }
            bytes = data.marshall();
        }
        finally {
            data.recycle();
        }
        return bytes;
    }

    public List<GenericDocument> getDocuments() {
        return this.mDocuments;
    }
}

