/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezonedetector;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.ShellCommand;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ManualTimeZoneSuggestion
implements Parcelable {
    public static final Parcelable.Creator<ManualTimeZoneSuggestion> CREATOR = new Parcelable.Creator<ManualTimeZoneSuggestion>(){

        @Override
        public ManualTimeZoneSuggestion createFromParcel(Parcel in) {
            return ManualTimeZoneSuggestion.createFromParcel(in);
        }

        public ManualTimeZoneSuggestion[] newArray(int size) {
            return new ManualTimeZoneSuggestion[size];
        }
    };
    private final String mZoneId;
    private ArrayList<String> mDebugInfo;

    public ManualTimeZoneSuggestion(String zoneId) {
        this.mZoneId = Objects.requireNonNull(zoneId);
    }

    private static ManualTimeZoneSuggestion createFromParcel(Parcel in) {
        String zoneId = in.readString();
        ManualTimeZoneSuggestion suggestion = new ManualTimeZoneSuggestion(zoneId);
        ArrayList<String> debugInfo = in.readArrayList(null, String.class);
        suggestion.mDebugInfo = debugInfo;
        return suggestion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mZoneId);
        dest.writeList(this.mDebugInfo);
    }

    public String getZoneId() {
        return this.mZoneId;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String ... debugInfos) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.addAll(Arrays.asList(debugInfos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualTimeZoneSuggestion that = (ManualTimeZoneSuggestion)o;
        return Objects.equals(this.mZoneId, that.mZoneId);
    }

    public int hashCode() {
        return Objects.hash(this.mZoneId);
    }

    public String toString() {
        return "ManualTimeZoneSuggestion{mZoneId=" + this.mZoneId + ", mDebugInfo=" + this.mDebugInfo + '}';
    }

    public static ManualTimeZoneSuggestion parseCommandLineArg(ShellCommand cmd) {
        String opt;
        String zoneId = null;
        block6: while ((opt = cmd.getNextArg()) != null) {
            switch (opt) {
                case "--zone_id": {
                    zoneId = cmd.getNextArgRequired();
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        ManualTimeZoneSuggestion suggestion = new ManualTimeZoneSuggestion(zoneId);
        suggestion.addDebugInfo("Command line injection");
        return suggestion;
    }

    public static void printCommandLineOpts(PrintWriter pw) {
        pw.println("Manual suggestion options:");
        pw.println("  --zone_id <Olson ID>");
        pw.println();
        pw.println("See " + ManualTimeZoneSuggestion.class.getName() + " for more information");
    }
}

