/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.audio;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.nio.ByteBuffer;

@SystemApi
@SuppressLint(value={"NotCloseable"})
public class AudioCapture {
    private static final String TAG = "AudioCapture";
    private final AudioFormat mAudioFormat;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private AudioRecord mAudioRecord;
    @GuardedBy(value={"mLock"})
    private int mRecordingState = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAudioRecord(AudioRecord audioRecord) {
        Log.d(TAG, "set AudioRecord with " + audioRecord);
        Object object = this.mLock;
        synchronized (object) {
            if (audioRecord != null) {
                if (audioRecord.getState() != 1) {
                    throw new IllegalStateException("set an uninitialized AudioRecord.");
                }
                if (this.mRecordingState == 3 && audioRecord.getRecordingState() != 3) {
                    audioRecord.startRecording();
                }
                if (this.mRecordingState == 1 && audioRecord.getRecordingState() != 1) {
                    audioRecord.stop();
                }
            }
            if (this.mAudioRecord != null) {
                this.mAudioRecord.release();
            }
            this.mAudioRecord = audioRecord;
        }
    }

    AudioCapture(AudioFormat audioFormat) {
        this.mAudioFormat = audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAudioRecord != null) {
                this.mAudioRecord.release();
                this.mAudioRecord = null;
            }
        }
    }

    public AudioFormat getFormat() {
        return this.mAudioFormat;
    }

    public int read(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.read(audioData, offsetInBytes, sizeInBytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] audioData, int offsetInBytes, int sizeInBytes, int readMode) {
        int sizeRead;
        Object object = this.mLock;
        synchronized (object) {
            sizeRead = this.mAudioRecord != null ? this.mAudioRecord.read(audioData, offsetInBytes, sizeInBytes, readMode) : 0;
        }
        return sizeRead;
    }

    public int read(ByteBuffer audioBuffer, int sizeInBytes) {
        return this.read(audioBuffer, sizeInBytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer audioBuffer, int sizeInBytes, int readMode) {
        int sizeRead;
        Object object = this.mLock;
        synchronized (object) {
            sizeRead = this.mAudioRecord != null ? this.mAudioRecord.read(audioBuffer, sizeInBytes, readMode) : 0;
        }
        return sizeRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(float[] audioData, int offsetInFloats, int sizeInFloats, int readMode) {
        int sizeRead;
        Object object = this.mLock;
        synchronized (object) {
            sizeRead = this.mAudioRecord != null ? this.mAudioRecord.read(audioData, offsetInFloats, sizeInFloats, readMode) : 0;
        }
        return sizeRead;
    }

    public int read(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.read(audioData, offsetInShorts, sizeInShorts, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(short[] audioData, int offsetInShorts, int sizeInShorts, int readMode) {
        int sizeRead;
        Object object = this.mLock;
        synchronized (object) {
            sizeRead = this.mAudioRecord != null ? this.mAudioRecord.read(audioData, offsetInShorts, sizeInShorts, readMode) : 0;
        }
        return sizeRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRecordingState = 3;
            if (this.mAudioRecord != null && this.mAudioRecord.getRecordingState() != 3) {
                this.mAudioRecord.startRecording();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRecordingState = 1;
            if (this.mAudioRecord != null && this.mAudioRecord.getRecordingState() != 1) {
                this.mAudioRecord.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordingState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRecordingState;
        }
    }
}

