/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraInjectionSession;
import android.hardware.camera2.ICameraInjectionCallback;
import android.hardware.camera2.ICameraInjectionSession;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.concurrent.Executor;

public class CameraInjectionSessionImpl
extends CameraInjectionSession
implements IBinder.DeathRecipient {
    private static final String TAG = "CameraInjectionSessionImpl";
    private final CameraInjectionCallback mCallback = new CameraInjectionCallback();
    private final CameraInjectionSession.InjectionStatusCallback mInjectionStatusCallback;
    private final Executor mExecutor;
    private final Object mInterfaceLock = new Object();
    private ICameraInjectionSession mInjectionSession;

    public CameraInjectionSessionImpl(CameraInjectionSession.InjectionStatusCallback callback, Executor executor) {
        this.mInjectionStatusCallback = callback;
        this.mExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            try {
                if (this.mInjectionSession != null) {
                    this.mInjectionSession.stopInjection();
                    this.mInjectionSession.asBinder().unlinkToDeath(this, 0);
                    this.mInjectionSession = null;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            Log.w(TAG, "CameraInjectionSessionImpl died unexpectedly");
            if (this.mInjectionSession == null) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    CameraInjectionSessionImpl.this.mInjectionStatusCallback.onInjectionError(1);
                }
            };
            long ident = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(r);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    public CameraInjectionCallback getCallback() {
        return this.mCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteInjectionSession(ICameraInjectionSession injectionSession) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (injectionSession == null) {
                Log.e(TAG, "The camera injection session has encountered a serious error");
                this.scheduleNotifyError(0);
                return;
            }
            this.mInjectionSession = injectionSession;
            IBinder remoteSessionBinder = injectionSession.asBinder();
            if (remoteSessionBinder == null) {
                Log.e(TAG, "The camera injection session has encountered a serious error");
                this.scheduleNotifyError(0);
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                remoteSessionBinder.linkToDeath(this, 0);
                this.mExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        CameraInjectionSessionImpl.this.mInjectionStatusCallback.onInjectionSucceeded(CameraInjectionSessionImpl.this);
                    }
                });
            }
            catch (RemoteException e) {
                this.scheduleNotifyError(0);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInjectionError(int errorCode) {
        Log.v(TAG, String.format("Injection session error received, code %d", errorCode));
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInjectionSession == null) {
                return;
            }
            switch (errorCode) {
                case 0: {
                    this.scheduleNotifyError(0);
                    break;
                }
                case 1: {
                    this.scheduleNotifyError(1);
                    break;
                }
                case 2: {
                    this.scheduleNotifyError(2);
                    break;
                }
                default: {
                    Log.e(TAG, "Unknown error from injection session: " + errorCode);
                    this.scheduleNotifyError(1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNotifyError(int errorCode) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(PooledLambda.obtainRunnable(CameraInjectionSessionImpl::notifyError, this, errorCode).recycleOnUse());
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void notifyError(int errorCode) {
        if (this.mInjectionSession != null) {
            this.mInjectionStatusCallback.onInjectionError(errorCode);
        }
    }

    public class CameraInjectionCallback
    extends ICameraInjectionCallback.Stub {
        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public void onInjectionError(int errorCode) {
            CameraInjectionSessionImpl.this.onInjectionError(errorCode);
        }
    }
}

