/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.ArraySet;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class RecommendedStreamConfigurationMap {
    private static final String TAG = "RecommendedStreamConfigurationMap";
    private int mUsecase;
    private boolean mSupportsPrivate;
    private StreamConfigurationMap mRecommendedMap;
    public static final int MAX_USECASE_COUNT = 32;
    public static final int USECASE_PREVIEW = 0;
    public static final int USECASE_RECORD = 1;
    public static final int USECASE_VIDEO_SNAPSHOT = 2;
    public static final int USECASE_SNAPSHOT = 3;
    public static final int USECASE_ZSL = 4;
    public static final int USECASE_RAW = 5;
    public static final int USECASE_LOW_LATENCY_SNAPSHOT = 6;
    public static final int USECASE_10BIT_OUTPUT = 8;
    public static final int USECASE_VENDOR_START = 24;

    public RecommendedStreamConfigurationMap(StreamConfigurationMap recommendedMap, int usecase, boolean supportsPrivate) {
        this.mRecommendedMap = recommendedMap;
        this.mUsecase = usecase;
        this.mSupportsPrivate = supportsPrivate;
    }

    public int getRecommendedUseCase() {
        return this.mUsecase;
    }

    private Set<Integer> getUnmodifiableIntegerSet(int[] intArray) {
        if (intArray != null && intArray.length > 0) {
            ArraySet<Integer> integerSet = new ArraySet<Integer>();
            integerSet.ensureCapacity(intArray.length);
            for (int intEntry : intArray) {
                integerSet.add(intEntry);
            }
            return Collections.unmodifiableSet(integerSet);
        }
        return null;
    }

    public Set<Integer> getOutputFormats() {
        return this.getUnmodifiableIntegerSet(this.mRecommendedMap.getOutputFormats());
    }

    public Set<Integer> getValidOutputFormatsForInput(int inputFormat) {
        return this.getUnmodifiableIntegerSet(this.mRecommendedMap.getValidOutputFormatsForInput(inputFormat));
    }

    public Set<Integer> getInputFormats() {
        return this.getUnmodifiableIntegerSet(this.mRecommendedMap.getInputFormats());
    }

    private Set<Size> getUnmodifiableSizeSet(Size[] sizeArray) {
        if (sizeArray != null && sizeArray.length > 0) {
            ArraySet<Size> sizeSet = new ArraySet<Size>();
            sizeSet.addAll(Arrays.asList(sizeArray));
            return Collections.unmodifiableSet(sizeSet);
        }
        return null;
    }

    public Set<Size> getInputSizes(int format) {
        return this.getUnmodifiableSizeSet(this.mRecommendedMap.getInputSizes(format));
    }

    public boolean isOutputSupportedFor(int format) {
        return this.mRecommendedMap.isOutputSupportedFor(format);
    }

    public Set<Size> getOutputSizes(int format) {
        return this.getUnmodifiableSizeSet(this.mRecommendedMap.getOutputSizes(format));
    }

    public Set<Size> getHighSpeedVideoSizes() {
        return this.getUnmodifiableSizeSet(this.mRecommendedMap.getHighSpeedVideoSizes());
    }

    private Set<Range<Integer>> getUnmodifiableRangeSet(Range<Integer>[] rangeArray) {
        if (rangeArray != null && rangeArray.length > 0) {
            ArraySet<Range<Integer>> rangeSet = new ArraySet<Range<Integer>>();
            rangeSet.addAll(Arrays.asList(rangeArray));
            return Collections.unmodifiableSet(rangeSet);
        }
        return null;
    }

    public Set<Range<Integer>> getHighSpeedVideoFpsRangesFor(Size size) {
        return this.getUnmodifiableRangeSet(this.mRecommendedMap.getHighSpeedVideoFpsRangesFor(size));
    }

    public Set<Range<Integer>> getHighSpeedVideoFpsRanges() {
        return this.getUnmodifiableRangeSet(this.mRecommendedMap.getHighSpeedVideoFpsRanges());
    }

    public Set<Size> getHighSpeedVideoSizesFor(Range<Integer> fpsRange) {
        return this.getUnmodifiableSizeSet(this.mRecommendedMap.getHighSpeedVideoSizesFor(fpsRange));
    }

    public Set<Size> getHighResolutionOutputSizes(int format) {
        return this.getUnmodifiableSizeSet(this.mRecommendedMap.getHighResolutionOutputSizes(format));
    }

    public long getOutputMinFrameDuration(int format, Size size) {
        return this.mRecommendedMap.getOutputMinFrameDuration(format, size);
    }

    public long getOutputStallDuration(int format, Size size) {
        return this.mRecommendedMap.getOutputStallDuration(format, size);
    }

    public <T> Set<Size> getOutputSizes(Class<T> klass) {
        if (this.mSupportsPrivate) {
            return this.getUnmodifiableSizeSet(this.mRecommendedMap.getOutputSizes(klass));
        }
        return null;
    }

    public <T> long getOutputMinFrameDuration(Class<T> klass, Size size) {
        if (this.mSupportsPrivate) {
            return this.mRecommendedMap.getOutputMinFrameDuration(klass, size);
        }
        return 0L;
    }

    public <T> long getOutputStallDuration(Class<T> klass, Size size) {
        if (this.mSupportsPrivate) {
            return this.mRecommendedMap.getOutputStallDuration(klass, size);
        }
        return 0L;
    }

    public boolean isOutputSupportedFor(Surface surface) {
        return this.mRecommendedMap.isOutputSupportedFor(surface);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecommendedUsecase {
    }
}

