/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.annotation.NonNull;
import android.content.ComponentName;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;

public class AppLinkInfo
implements Parcelable {
    private ComponentName mComponentName;
    private Uri mUri;
    public static final Parcelable.Creator<AppLinkInfo> CREATOR = new Parcelable.Creator<AppLinkInfo>(){

        public AppLinkInfo[] newArray(int size) {
            return new AppLinkInfo[size];
        }

        @Override
        public AppLinkInfo createFromParcel(Parcel in) {
            return new AppLinkInfo(in);
        }
    };

    public AppLinkInfo(String packageName, String className, String uriString) {
        AnnotationValidations.validate(NonNull.class, null, (Object)packageName);
        AnnotationValidations.validate(NonNull.class, null, (Object)className);
        this.mComponentName = new ComponentName(packageName, className);
        this.mUri = Uri.parse(uriString);
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public String toString() {
        return "AppLinkInfo { packageName = " + this.mComponentName.getPackageName() + ", className = " + this.mComponentName.getClassName() + ", uri = " + this.mUri.toString() + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mComponentName.writeToParcel(dest, flags);
        String uriString = this.mUri == null ? null : this.mUri.toString();
        dest.writeString(uriString);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AppLinkInfo(Parcel in) {
        this.mComponentName = ComponentName.readFromParcel(in);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mComponentName.getPackageName());
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mComponentName.getClassName());
        String uriString = in.readString();
        this.mUri = uriString == null ? null : Uri.parse(uriString);
    }
}

