/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.lowpan.ILowpanInterface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILowpanManagerListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.lowpan.ILowpanManagerListener";

    public void onInterfaceAdded(ILowpanInterface var1) throws RemoteException;

    public void onInterfaceRemoved(ILowpanInterface var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILowpanManagerListener {
        static final int TRANSACTION_onInterfaceAdded = 1;
        static final int TRANSACTION_onInterfaceRemoved = 2;

        public Stub() {
            this.attachInterface(this, ILowpanManagerListener.DESCRIPTOR);
        }

        public static ILowpanManagerListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILowpanManagerListener.DESCRIPTOR);
            if (iin != null && iin instanceof ILowpanManagerListener) {
                return (ILowpanManagerListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onInterfaceAdded";
                }
                case 2: {
                    return "onInterfaceRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILowpanManagerListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ILowpanInterface _arg0 = ILowpanInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onInterfaceAdded(_arg0);
                    break;
                }
                case 2: {
                    ILowpanInterface _arg0 = ILowpanInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onInterfaceRemoved(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ILowpanManagerListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILowpanManagerListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInterfaceAdded(ILowpanInterface lowpanInterface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManagerListener.DESCRIPTOR);
                    _data.writeStrongInterface(lowpanInterface);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInterfaceRemoved(ILowpanInterface lowpanInterface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManagerListener.DESCRIPTOR);
                    _data.writeStrongInterface(lowpanInterface);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILowpanManagerListener {
        @Override
        public void onInterfaceAdded(ILowpanInterface lowpanInterface) throws RemoteException {
        }

        @Override
        public void onInterfaceRemoved(ILowpanInterface lowpanInterface) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

