/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.annotation.SuppressLint;
import android.net.vcn.VcnUnderlyingNetworkTemplate;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.vcn.repackaged.util.PersistableBundleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class VcnCellUnderlyingNetworkTemplate
extends VcnUnderlyingNetworkTemplate {
    private static final String ALLOWED_NETWORK_PLMN_IDS_KEY = "mAllowedNetworkPlmnIds";
    private final Set<String> mAllowedNetworkPlmnIds;
    private static final String ALLOWED_SPECIFIC_CARRIER_IDS_KEY = "mAllowedSpecificCarrierIds";
    private final Set<Integer> mAllowedSpecificCarrierIds;
    private static final String ROAMING_MATCH_KEY = "mRoamingMatchCriteria";
    private static final int DEFAULT_ROAMING_MATCH_CRITERIA = 0;
    private final int mRoamingMatchCriteria;
    private static final String OPPORTUNISTIC_MATCH_KEY = "mOpportunisticMatchCriteria";
    private static final int DEFAULT_OPPORTUNISTIC_MATCH_CRITERIA = 0;
    private final int mOpportunisticMatchCriteria;

    private VcnCellUnderlyingNetworkTemplate(int meteredMatchCriteria, int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps, int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps, Set<String> allowedNetworkPlmnIds, Set<Integer> allowedSpecificCarrierIds, int roamingMatchCriteria, int opportunisticMatchCriteria) {
        super(2, meteredMatchCriteria, minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps, minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps);
        this.mAllowedNetworkPlmnIds = new ArraySet<String>(allowedNetworkPlmnIds);
        this.mAllowedSpecificCarrierIds = new ArraySet<Integer>(allowedSpecificCarrierIds);
        this.mRoamingMatchCriteria = roamingMatchCriteria;
        this.mOpportunisticMatchCriteria = opportunisticMatchCriteria;
        this.validate();
    }

    @Override
    protected void validate() {
        super.validate();
        VcnCellUnderlyingNetworkTemplate.validatePlmnIds(this.mAllowedNetworkPlmnIds);
        Objects.requireNonNull(this.mAllowedSpecificCarrierIds, "matchingCarrierIds is null");
        VcnCellUnderlyingNetworkTemplate.validateMatchCriteria(this.mRoamingMatchCriteria, ROAMING_MATCH_KEY);
        VcnCellUnderlyingNetworkTemplate.validateMatchCriteria(this.mOpportunisticMatchCriteria, OPPORTUNISTIC_MATCH_KEY);
    }

    private static void validatePlmnIds(Set<String> matchingOperatorPlmnIds) {
        Objects.requireNonNull(matchingOperatorPlmnIds, "matchingOperatorPlmnIds is null");
        for (String id2 : matchingOperatorPlmnIds) {
            if ((id2.length() == 5 || id2.length() == 6) && id2.matches("[0-9]+")) continue;
            throw new IllegalArgumentException("Found invalid PLMN ID: " + id2);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public static VcnCellUnderlyingNetworkTemplate fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        int meteredMatchCriteria = in.getInt("mMeteredMatchCriteria");
        int minEntryUpstreamBandwidthKbps = in.getInt("mMinEntryUpstreamBandwidthKbps", 0);
        int minExitUpstreamBandwidthKbps = in.getInt("mMinExitUpstreamBandwidthKbps", 0);
        int minEntryDownstreamBandwidthKbps = in.getInt("mMinEntryDownstreamBandwidthKbps", 0);
        int minExitDownstreamBandwidthKbps = in.getInt("mMinExitDownstreamBandwidthKbps", 0);
        PersistableBundle plmnIdsBundle = in.getPersistableBundle(ALLOWED_NETWORK_PLMN_IDS_KEY);
        Objects.requireNonNull(plmnIdsBundle, "plmnIdsBundle is null");
        ArraySet<String> allowedNetworkPlmnIds = new ArraySet<String>(PersistableBundleUtils.toList(plmnIdsBundle, PersistableBundleUtils.STRING_DESERIALIZER));
        PersistableBundle specificCarrierIdsBundle = in.getPersistableBundle(ALLOWED_SPECIFIC_CARRIER_IDS_KEY);
        Objects.requireNonNull(specificCarrierIdsBundle, "specificCarrierIdsBundle is null");
        ArraySet<Integer> allowedSpecificCarrierIds = new ArraySet<Integer>(PersistableBundleUtils.toList(specificCarrierIdsBundle, PersistableBundleUtils.INTEGER_DESERIALIZER));
        int roamingMatchCriteria = in.getInt(ROAMING_MATCH_KEY);
        int opportunisticMatchCriteria = in.getInt(OPPORTUNISTIC_MATCH_KEY);
        return new VcnCellUnderlyingNetworkTemplate(meteredMatchCriteria, minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps, minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps, allowedNetworkPlmnIds, allowedSpecificCarrierIds, roamingMatchCriteria, opportunisticMatchCriteria);
    }

    @Override
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        PersistableBundle plmnIdsBundle = PersistableBundleUtils.fromList(new ArrayList<String>(this.mAllowedNetworkPlmnIds), PersistableBundleUtils.STRING_SERIALIZER);
        result.putPersistableBundle(ALLOWED_NETWORK_PLMN_IDS_KEY, plmnIdsBundle);
        PersistableBundle specificCarrierIdsBundle = PersistableBundleUtils.fromList(new ArrayList<Integer>(this.mAllowedSpecificCarrierIds), PersistableBundleUtils.INTEGER_SERIALIZER);
        result.putPersistableBundle(ALLOWED_SPECIFIC_CARRIER_IDS_KEY, specificCarrierIdsBundle);
        result.putInt(ROAMING_MATCH_KEY, this.mRoamingMatchCriteria);
        result.putInt(OPPORTUNISTIC_MATCH_KEY, this.mOpportunisticMatchCriteria);
        return result;
    }

    public Set<String> getOperatorPlmnIds() {
        return Collections.unmodifiableSet(this.mAllowedNetworkPlmnIds);
    }

    public Set<Integer> getSimSpecificCarrierIds() {
        return Collections.unmodifiableSet(this.mAllowedSpecificCarrierIds);
    }

    public int getRoaming() {
        return this.mRoamingMatchCriteria;
    }

    public int getOpportunistic() {
        return this.mOpportunisticMatchCriteria;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mAllowedNetworkPlmnIds, this.mAllowedSpecificCarrierIds, this.mRoamingMatchCriteria, this.mOpportunisticMatchCriteria);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof VcnCellUnderlyingNetworkTemplate)) {
            return false;
        }
        VcnCellUnderlyingNetworkTemplate rhs = (VcnCellUnderlyingNetworkTemplate)other;
        return Objects.equals(this.mAllowedNetworkPlmnIds, rhs.mAllowedNetworkPlmnIds) && Objects.equals(this.mAllowedSpecificCarrierIds, rhs.mAllowedSpecificCarrierIds) && this.mRoamingMatchCriteria == rhs.mRoamingMatchCriteria && this.mOpportunisticMatchCriteria == rhs.mOpportunisticMatchCriteria;
    }

    @Override
    void dumpTransportSpecificFields(IndentingPrintWriter pw) {
        if (!this.mAllowedNetworkPlmnIds.isEmpty()) {
            pw.println("mAllowedNetworkPlmnIds: " + this.mAllowedNetworkPlmnIds);
        }
        if (!this.mAllowedNetworkPlmnIds.isEmpty()) {
            pw.println("mAllowedSpecificCarrierIds: " + this.mAllowedSpecificCarrierIds);
        }
        if (this.mRoamingMatchCriteria != 0) {
            pw.println("mRoamingMatchCriteria: " + VcnCellUnderlyingNetworkTemplate.getMatchCriteriaString(this.mRoamingMatchCriteria));
        }
        if (this.mOpportunisticMatchCriteria != 0) {
            pw.println("mOpportunisticMatchCriteria: " + VcnCellUnderlyingNetworkTemplate.getMatchCriteriaString(this.mOpportunisticMatchCriteria));
        }
    }

    public static class Builder {
        private int mMeteredMatchCriteria = 0;
        private final Set<String> mAllowedNetworkPlmnIds = new ArraySet<String>();
        private final Set<Integer> mAllowedSpecificCarrierIds = new ArraySet<Integer>();
        private int mRoamingMatchCriteria = 0;
        private int mOpportunisticMatchCriteria = 0;
        private int mMinEntryUpstreamBandwidthKbps = 0;
        private int mMinExitUpstreamBandwidthKbps = 0;
        private int mMinEntryDownstreamBandwidthKbps = 0;
        private int mMinExitDownstreamBandwidthKbps = 0;

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMetered(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setMetered");
            this.mMeteredMatchCriteria = matchCriteria;
            return this;
        }

        public Builder setOperatorPlmnIds(Set<String> operatorPlmnIds) {
            VcnCellUnderlyingNetworkTemplate.validatePlmnIds(operatorPlmnIds);
            this.mAllowedNetworkPlmnIds.clear();
            this.mAllowedNetworkPlmnIds.addAll(operatorPlmnIds);
            return this;
        }

        public Builder setSimSpecificCarrierIds(Set<Integer> simSpecificCarrierIds) {
            Objects.requireNonNull(simSpecificCarrierIds, "simSpecificCarrierIds is null");
            this.mAllowedSpecificCarrierIds.clear();
            this.mAllowedSpecificCarrierIds.addAll(simSpecificCarrierIds);
            return this;
        }

        public Builder setRoaming(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setRoaming");
            this.mRoamingMatchCriteria = matchCriteria;
            return this;
        }

        public Builder setOpportunistic(int matchCriteria) {
            VcnUnderlyingNetworkTemplate.validateMatchCriteria(matchCriteria, "setOpportunistic");
            this.mOpportunisticMatchCriteria = matchCriteria;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMinUpstreamBandwidthKbps(int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps) {
            VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(minEntryUpstreamBandwidthKbps, minExitUpstreamBandwidthKbps);
            this.mMinEntryUpstreamBandwidthKbps = minEntryUpstreamBandwidthKbps;
            this.mMinExitUpstreamBandwidthKbps = minExitUpstreamBandwidthKbps;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMinDownstreamBandwidthKbps(int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps) {
            VcnUnderlyingNetworkTemplate.validateMinBandwidthKbps(minEntryDownstreamBandwidthKbps, minExitDownstreamBandwidthKbps);
            this.mMinEntryDownstreamBandwidthKbps = minEntryDownstreamBandwidthKbps;
            this.mMinExitDownstreamBandwidthKbps = minExitDownstreamBandwidthKbps;
            return this;
        }

        public VcnCellUnderlyingNetworkTemplate build() {
            return new VcnCellUnderlyingNetworkTemplate(this.mMeteredMatchCriteria, this.mMinEntryUpstreamBandwidthKbps, this.mMinExitUpstreamBandwidthKbps, this.mMinEntryDownstreamBandwidthKbps, this.mMinExitDownstreamBandwidthKbps, this.mAllowedNetworkPlmnIds, this.mAllowedSpecificCarrierIds, this.mRoamingMatchCriteria, this.mOpportunisticMatchCriteria);
        }
    }
}

