/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.MacAddress;
import android.net.NetworkInfo;
import android.net.TransportInfo;
import android.net.wifi.MloLink;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import com.android.wifi.x.com.android.net.module.util.Inet4AddressUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class WifiInfo
implements TransportInfo,
Parcelable {
    private static final String TAG = "WifiInfo";
    private static final EnumMap<SupplicantState, NetworkInfo.DetailedState> stateMap = new EnumMap(SupplicantState.class);
    @SystemApi
    public static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    private SupplicantState mSupplicantState;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private String mBSSID;
    @UnsupportedAppUsage
    private WifiSsid mWifiSsid;
    private boolean mIsHiddenSsid = false;
    private int mNetworkId;
    private int mSecurityType;
    private MacAddress mApMldMacAddress;
    private int mApMloLinkId;
    private List<MloLink> mAffiliatedMloLinks;
    @SystemApi
    public static final int INVALID_RSSI = -127;
    public static final int MIN_RSSI = -126;
    public static final int MAX_RSSI = 200;
    public static final int SECURITY_TYPE_UNKNOWN = -1;
    public static final int SECURITY_TYPE_OPEN = 0;
    public static final int SECURITY_TYPE_WEP = 1;
    public static final int SECURITY_TYPE_PSK = 2;
    public static final int SECURITY_TYPE_EAP = 3;
    public static final int SECURITY_TYPE_SAE = 4;
    public static final int SECURITY_TYPE_EAP_WPA3_ENTERPRISE_192_BIT = 5;
    public static final int SECURITY_TYPE_OWE = 6;
    public static final int SECURITY_TYPE_WAPI_PSK = 7;
    public static final int SECURITY_TYPE_WAPI_CERT = 8;
    public static final int SECURITY_TYPE_EAP_WPA3_ENTERPRISE = 9;
    public static final int SECURITY_TYPE_OSEN = 10;
    public static final int SECURITY_TYPE_PASSPOINT_R1_R2 = 11;
    public static final int SECURITY_TYPE_PASSPOINT_R3 = 12;
    public static final int SECURITY_TYPE_DPP = 13;
    public static final int DPM_SECURITY_TYPE_UNKNOWN = -1;
    private static final int IS_PRIMARY_NO_PERMISSION = -1;
    private static final int IS_PRIMARY_FALSE = 0;
    private static final int IS_PRIMARY_TRUE = 1;
    private int mRssi;
    private int mWifiStandard;
    public static final String LINK_SPEED_UNITS = "Mbps";
    private int mLinkSpeed;
    public static final int LINK_SPEED_UNKNOWN = -1;
    private int mTxLinkSpeed;
    private int mMaxSupportedTxLinkSpeed;
    private int mRxLinkSpeed;
    private int mMaxSupportedRxLinkSpeed;
    public static final String FREQUENCY_UNITS = "MHz";
    private int mFrequency;
    @UnsupportedAppUsage
    private InetAddress mIpAddress;
    @UnsupportedAppUsage
    private String mMacAddress = "02:00:00:00:00:00";
    private boolean mEphemeral;
    private boolean mTrusted;
    private boolean mRestricted;
    private boolean mOemPaid;
    private boolean mOemPrivate;
    private boolean mCarrierMerged;
    private boolean mOsuAp;
    private String mFqdn;
    private String mProviderFriendlyName;
    private String mRequestingPackageName;
    private int mSubscriptionId;
    public long txBad;
    public long txRetries;
    public long txSuccess;
    public long rxSuccess;
    private double mLostTxPacketsPerSecond;
    private double mTxRetriedTxPacketsPerSecond;
    private double mSuccessfulTxPacketsPerSecond;
    private double mSuccessfulRxPacketsPerSecond;
    @UnsupportedAppUsage
    public int score;
    private boolean mIsUsable = true;
    private boolean mMeteredHint;
    private String mPasspointUniqueId;
    private List<ScanResult.InformationElement> mInformationElements;
    private int mIsPrimary;
    private String mNetworkKey;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<WifiInfo> CREATOR;

    @SystemApi
    public double getLostTxPacketsPerSecond() {
        return this.mLostTxPacketsPerSecond;
    }

    public void setLostTxPacketsPerSecond(double lostTxPacketsPerSecond) {
        this.mLostTxPacketsPerSecond = lostTxPacketsPerSecond;
    }

    @SystemApi
    public double getRetriedTxPacketsPerSecond() {
        return this.mTxRetriedTxPacketsPerSecond;
    }

    public void setRetriedTxPacketsRate(double txRetriedTxPacketsPerSecond) {
        this.mTxRetriedTxPacketsPerSecond = txRetriedTxPacketsPerSecond;
    }

    @SystemApi
    public double getSuccessfulTxPacketsPerSecond() {
        return this.mSuccessfulTxPacketsPerSecond;
    }

    public void setSuccessfulTxPacketsPerSecond(double successfulTxPacketsPerSecond) {
        this.mSuccessfulTxPacketsPerSecond = successfulTxPacketsPerSecond;
    }

    @SystemApi
    public double getSuccessfulRxPacketsPerSecond() {
        return this.mSuccessfulRxPacketsPerSecond;
    }

    public void setSuccessfulRxPacketsPerSecond(double successfulRxPacketsPerSecond) {
        this.mSuccessfulRxPacketsPerSecond = successfulRxPacketsPerSecond;
    }

    @SystemApi
    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public boolean isUsable() {
        return this.mIsUsable;
    }

    public void setUsable(boolean isUsable) {
        this.mIsUsable = isUsable;
    }

    @UnsupportedAppUsage
    public WifiInfo() {
        this.mWifiSsid = null;
        this.mBSSID = null;
        this.mApMldMacAddress = null;
        this.mApMloLinkId = 0;
        this.mAffiliatedMloLinks = Collections.emptyList();
        this.mNetworkId = -1;
        this.mSupplicantState = SupplicantState.UNINITIALIZED;
        this.mRssi = -127;
        this.mLinkSpeed = -1;
        this.mFrequency = -1;
        this.mSubscriptionId = -1;
        this.mSecurityType = -1;
        this.mIsPrimary = 0;
        this.mNetworkKey = null;
        this.mApMloLinkId = -1;
    }

    public void reset() {
        this.setInetAddress(null);
        this.setBSSID(null);
        this.setSSID(null);
        this.setHiddenSSID(false);
        this.setNetworkId(-1);
        this.setRssi(-127);
        this.setLinkSpeed(-1);
        this.setTxLinkSpeedMbps(-1);
        this.setRxLinkSpeedMbps(-1);
        this.setMaxSupportedTxLinkSpeedMbps(-1);
        this.setMaxSupportedRxLinkSpeedMbps(-1);
        this.setFrequency(-1);
        this.setMeteredHint(false);
        this.setEphemeral(false);
        this.setTrusted(false);
        this.setOemPaid(false);
        this.setOemPrivate(false);
        this.setCarrierMerged(false);
        this.setOsuAp(false);
        this.setRequestingPackageName(null);
        this.setFQDN(null);
        this.setProviderFriendlyName(null);
        this.setPasspointUniqueId(null);
        this.setSubscriptionId(-1);
        this.setInformationElements(null);
        this.setIsPrimary(false);
        this.setRestricted(false);
        this.txBad = 0L;
        this.txSuccess = 0L;
        this.rxSuccess = 0L;
        this.txRetries = 0L;
        this.mLostTxPacketsPerSecond = 0.0;
        this.mSuccessfulTxPacketsPerSecond = 0.0;
        this.mSuccessfulRxPacketsPerSecond = 0.0;
        this.mTxRetriedTxPacketsPerSecond = 0.0;
        this.score = 0;
        this.mIsUsable = true;
        this.mSecurityType = -1;
        this.mNetworkKey = null;
        this.resetMultiLinkInfo();
    }

    public void resetMultiLinkInfo() {
        this.setApMldMacAddress(null);
        this.mApMloLinkId = -1;
        this.mAffiliatedMloLinks = Collections.emptyList();
    }

    public WifiInfo(WifiInfo source) {
        this(source, 0L);
    }

    private WifiInfo(WifiInfo source, long redactions) {
        if (source != null) {
            this.mSupplicantState = source.mSupplicantState;
            this.mBSSID = this.shouldRedactLocationSensitiveFields(redactions) ? DEFAULT_MAC_ADDRESS : source.mBSSID;
            this.mApMldMacAddress = this.shouldRedactLocationSensitiveFields(redactions) ? null : source.mApMldMacAddress;
            this.mApMloLinkId = source.mApMloLinkId;
            if (source.mApMldMacAddress != null) {
                this.mAffiliatedMloLinks = new ArrayList<MloLink>();
                for (MloLink link : source.mAffiliatedMloLinks) {
                    this.mAffiliatedMloLinks.add(new MloLink(link, redactions));
                }
            } else {
                this.mAffiliatedMloLinks = Collections.emptyList();
            }
            this.mWifiSsid = this.shouldRedactLocationSensitiveFields(redactions) ? null : source.mWifiSsid;
            this.mNetworkId = this.shouldRedactLocationSensitiveFields(redactions) ? -1 : source.mNetworkId;
            this.mRssi = source.mRssi;
            this.mLinkSpeed = source.mLinkSpeed;
            this.mTxLinkSpeed = source.mTxLinkSpeed;
            this.mRxLinkSpeed = source.mRxLinkSpeed;
            this.mFrequency = source.mFrequency;
            this.mIpAddress = source.mIpAddress;
            this.mMacAddress = this.shouldRedactLocalMacAddressFields(redactions) || this.shouldRedactLocationSensitiveFields(redactions) ? DEFAULT_MAC_ADDRESS : source.mMacAddress;
            this.mMeteredHint = source.mMeteredHint;
            this.mEphemeral = source.mEphemeral;
            this.mTrusted = source.mTrusted;
            this.mRestricted = source.mRestricted;
            this.mOemPaid = source.mOemPaid;
            this.mOemPrivate = source.mOemPrivate;
            this.mCarrierMerged = source.mCarrierMerged;
            this.mRequestingPackageName = source.mRequestingPackageName;
            this.mOsuAp = source.mOsuAp;
            this.mFqdn = this.shouldRedactLocationSensitiveFields(redactions) ? null : source.mFqdn;
            this.mProviderFriendlyName = this.shouldRedactLocationSensitiveFields(redactions) ? null : source.mProviderFriendlyName;
            this.mSubscriptionId = source.mSubscriptionId;
            this.txBad = source.txBad;
            this.txRetries = source.txRetries;
            this.txSuccess = source.txSuccess;
            this.rxSuccess = source.rxSuccess;
            this.mLostTxPacketsPerSecond = source.mLostTxPacketsPerSecond;
            this.mTxRetriedTxPacketsPerSecond = source.mTxRetriedTxPacketsPerSecond;
            this.mSuccessfulTxPacketsPerSecond = source.mSuccessfulTxPacketsPerSecond;
            this.mSuccessfulRxPacketsPerSecond = source.mSuccessfulRxPacketsPerSecond;
            this.score = source.score;
            this.mIsUsable = source.mIsUsable;
            this.mWifiStandard = source.mWifiStandard;
            this.mMaxSupportedTxLinkSpeed = source.mMaxSupportedTxLinkSpeed;
            this.mMaxSupportedRxLinkSpeed = source.mMaxSupportedRxLinkSpeed;
            String string2 = this.mPasspointUniqueId = this.shouldRedactLocationSensitiveFields(redactions) ? null : source.mPasspointUniqueId;
            if (source.mInformationElements != null && !this.shouldRedactLocationSensitiveFields(redactions)) {
                this.mInformationElements = new ArrayList<ScanResult.InformationElement>(source.mInformationElements);
            }
            this.mIsPrimary = this.shouldRedactNetworkSettingsFields(redactions) ? -1 : source.mIsPrimary;
            this.mSecurityType = source.mSecurityType;
            this.mNetworkKey = this.shouldRedactLocationSensitiveFields(redactions) ? null : source.mNetworkKey;
        }
    }

    public void setSSID(WifiSsid wifiSsid) {
        this.mWifiSsid = wifiSsid;
    }

    public String getSSID() {
        String ssidString;
        if (this.mWifiSsid != null && !TextUtils.isEmpty(ssidString = this.mWifiSsid.toString())) {
            return ssidString;
        }
        return "<unknown ssid>";
    }

    @UnsupportedAppUsage
    public WifiSsid getWifiSsid() {
        return this.mWifiSsid;
    }

    @UnsupportedAppUsage
    public void setBSSID(String BSSID) {
        this.mBSSID = BSSID;
    }

    public void setApMldMacAddress(MacAddress address) {
        this.mApMldMacAddress = address;
    }

    public void setApMloLinkId(int linkId) {
        this.mApMloLinkId = linkId;
    }

    public void setAffiliatedMloLinks(List<MloLink> links) {
        this.mAffiliatedMloLinks = new ArrayList<MloLink>(links);
    }

    public boolean updateMloLinkStaAddress(int linkId, MacAddress macAddress) {
        for (MloLink link : this.mAffiliatedMloLinks) {
            if (link.getLinkId() != linkId) continue;
            link.setStaMacAddress(macAddress);
            return true;
        }
        return false;
    }

    public boolean updateMloLinkState(int linkId, int state) {
        if (!MloLink.isValidState(state)) {
            return false;
        }
        for (MloLink link : this.mAffiliatedMloLinks) {
            if (link.getLinkId() != linkId) continue;
            link.setState(state);
            return true;
        }
        return false;
    }

    public String getBSSID() {
        return this.mBSSID;
    }

    public MacAddress getApMldMacAddress() {
        return this.mApMldMacAddress;
    }

    public int getApMloLinkId() {
        return this.mApMloLinkId;
    }

    public List<MloLink> getAffiliatedMloLinks() {
        return new ArrayList<MloLink>(this.mAffiliatedMloLinks);
    }

    public int getRssi() {
        return this.mRssi;
    }

    @UnsupportedAppUsage
    public void setRssi(int rssi) {
        if (rssi < -127) {
            rssi = -127;
        }
        if (rssi > 200) {
            rssi = 200;
        }
        this.mRssi = rssi;
    }

    public void setWifiStandard(int wifiStandard) {
        this.mWifiStandard = wifiStandard;
    }

    public int getWifiStandard() {
        return this.mWifiStandard;
    }

    public int getLinkSpeed() {
        return this.mLinkSpeed;
    }

    @UnsupportedAppUsage
    public void setLinkSpeed(int linkSpeed) {
        this.mLinkSpeed = linkSpeed;
    }

    public int getTxLinkSpeedMbps() {
        return this.mTxLinkSpeed;
    }

    public int getMaxSupportedTxLinkSpeedMbps() {
        return this.mMaxSupportedTxLinkSpeed;
    }

    public void setTxLinkSpeedMbps(int txLinkSpeed) {
        this.mTxLinkSpeed = txLinkSpeed;
    }

    public void setMaxSupportedTxLinkSpeedMbps(int maxSupportedTxLinkSpeed) {
        this.mMaxSupportedTxLinkSpeed = maxSupportedTxLinkSpeed;
    }

    public int getRxLinkSpeedMbps() {
        return this.mRxLinkSpeed;
    }

    public int getMaxSupportedRxLinkSpeedMbps() {
        return this.mMaxSupportedRxLinkSpeed;
    }

    public void setRxLinkSpeedMbps(int rxLinkSpeed) {
        this.mRxLinkSpeed = rxLinkSpeed;
    }

    public void setMaxSupportedRxLinkSpeedMbps(int maxSupportedRxLinkSpeed) {
        this.mMaxSupportedRxLinkSpeed = maxSupportedRxLinkSpeed;
    }

    public int getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(int frequency) {
        this.mFrequency = frequency;
    }

    public boolean is24GHz() {
        return ScanResult.is24GHz(this.mFrequency);
    }

    @UnsupportedAppUsage
    public boolean is5GHz() {
        return ScanResult.is5GHz(this.mFrequency);
    }

    public boolean is6GHz() {
        return ScanResult.is6GHz(this.mFrequency);
    }

    @UnsupportedAppUsage
    public void setMacAddress(String macAddress) {
        this.mMacAddress = macAddress;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    public boolean hasRealMacAddress() {
        return this.mMacAddress != null && !DEFAULT_MAC_ADDRESS.equals(this.mMacAddress);
    }

    public void setMeteredHint(boolean meteredHint) {
        this.mMeteredHint = meteredHint;
    }

    @UnsupportedAppUsage
    public boolean getMeteredHint() {
        return this.mMeteredHint;
    }

    public void setEphemeral(boolean ephemeral) {
        this.mEphemeral = ephemeral;
    }

    @SystemApi
    public boolean isEphemeral() {
        return this.mEphemeral;
    }

    public void setTrusted(boolean trusted) {
        this.mTrusted = trusted;
    }

    @SystemApi
    public boolean isTrusted() {
        return this.mTrusted;
    }

    public void setRestricted(boolean restricted) {
        this.mRestricted = restricted;
    }

    public boolean isRestricted() {
        return this.mRestricted;
    }

    public void setOemPaid(boolean oemPaid) {
        this.mOemPaid = oemPaid;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isOemPaid() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mOemPaid;
    }

    public void setOemPrivate(boolean oemPrivate) {
        this.mOemPrivate = oemPrivate;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isOemPrivate() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mOemPrivate;
    }

    public void setCarrierMerged(boolean carrierMerged) {
        this.mCarrierMerged = carrierMerged;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isCarrierMerged() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mCarrierMerged;
    }

    public void setOsuAp(boolean osuAp) {
        this.mOsuAp = osuAp;
    }

    @SystemApi
    public boolean isOsuAp() {
        return this.mOsuAp;
    }

    @SystemApi
    public boolean isPasspointAp() {
        return this.mFqdn != null && this.mProviderFriendlyName != null;
    }

    public void setFQDN(String fqdn) {
        this.mFqdn = fqdn;
    }

    public String getPasspointFqdn() {
        return this.mFqdn;
    }

    public void setProviderFriendlyName(String providerFriendlyName) {
        this.mProviderFriendlyName = providerFriendlyName;
    }

    public String getPasspointProviderFriendlyName() {
        return this.mProviderFriendlyName;
    }

    public void setRequestingPackageName(String packageName) {
        this.mRequestingPackageName = packageName;
    }

    @SystemApi
    public String getRequestingPackageName() {
        return this.mRequestingPackageName;
    }

    public void setSubscriptionId(int subId) {
        this.mSubscriptionId = subId;
    }

    @RequiresApi(value=31)
    public int getSubscriptionId() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mSubscriptionId;
    }

    @UnsupportedAppUsage
    public void setNetworkId(int id2) {
        this.mNetworkId = id2;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public SupplicantState getSupplicantState() {
        return this.mSupplicantState;
    }

    @UnsupportedAppUsage
    public void setSupplicantState(SupplicantState state) {
        this.mSupplicantState = state;
    }

    public void setInetAddress(InetAddress address) {
        this.mIpAddress = address;
    }

    @Deprecated
    public int getIpAddress() {
        int result = 0;
        if (this.mIpAddress instanceof Inet4Address) {
            result = Inet4AddressUtils.inet4AddressToIntHTL((Inet4Address)this.mIpAddress);
        }
        return result;
    }

    public boolean getHiddenSSID() {
        return this.mIsHiddenSsid;
    }

    public void setHiddenSSID(boolean isHiddenSsid) {
        this.mIsHiddenSsid = isHiddenSsid;
    }

    public static NetworkInfo.DetailedState getDetailedStateOf(SupplicantState suppState) {
        return stateMap.get(suppState);
    }

    @UnsupportedAppUsage
    void setSupplicantState(String stateName) {
        this.mSupplicantState = WifiInfo.valueOf(stateName);
    }

    static SupplicantState valueOf(String stateName) {
        if ("4WAY_HANDSHAKE".equalsIgnoreCase(stateName)) {
            return SupplicantState.FOUR_WAY_HANDSHAKE;
        }
        try {
            return SupplicantState.valueOf(stateName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return SupplicantState.INVALID;
        }
    }

    @SystemApi
    public static String sanitizeSsid(String string2) {
        return WifiInfo.removeDoubleQuotes(string2);
    }

    @UnsupportedAppUsage
    public static String removeDoubleQuotes(String string2) {
        if (string2 == null) {
            return null;
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("SSID: ").append(this.getSSID()).append(", BSSID: ").append(this.mBSSID == null ? none : this.mBSSID).append(", MAC: ").append(this.mMacAddress == null ? none : this.mMacAddress).append(", IP: ").append(this.mIpAddress).append(", Security type: ").append(this.mSecurityType).append(", Supplicant state: ").append(this.mSupplicantState == null ? none : this.mSupplicantState).append(", Wi-Fi standard: ").append(this.mWifiStandard).append(", RSSI: ").append(this.mRssi).append(", Link speed: ").append(this.mLinkSpeed).append(LINK_SPEED_UNITS).append(", Tx Link speed: ").append(this.mTxLinkSpeed).append(LINK_SPEED_UNITS).append(", Max Supported Tx Link speed: ").append(this.mMaxSupportedTxLinkSpeed).append(LINK_SPEED_UNITS).append(", Rx Link speed: ").append(this.mRxLinkSpeed).append(LINK_SPEED_UNITS).append(", Max Supported Rx Link speed: ").append(this.mMaxSupportedRxLinkSpeed).append(LINK_SPEED_UNITS).append(", Frequency: ").append(this.mFrequency).append(FREQUENCY_UNITS).append(", Net ID: ").append(this.mNetworkId).append(", Metered hint: ").append(this.mMeteredHint).append(", score: ").append(Integer.toString(this.score)).append(", isUsable: ").append(this.mIsUsable).append(", CarrierMerged: ").append(this.mCarrierMerged).append(", SubscriptionId: ").append(this.mSubscriptionId).append(", IsPrimary: ").append(this.mIsPrimary).append(", Trusted: ").append(this.mTrusted).append(", Restricted: ").append(this.mRestricted).append(", Ephemeral: ").append(this.mEphemeral).append(", OEM paid: ").append(this.mOemPaid).append(", OEM private: ").append(this.mOemPrivate).append(", OSU AP: ").append(this.mOsuAp).append(", FQDN: ").append(this.mFqdn == null ? none : this.mFqdn).append(", Provider friendly name: ").append(this.mProviderFriendlyName == null ? none : this.mProviderFriendlyName).append(", Requesting package name: ").append(this.mRequestingPackageName == null ? none : this.mRequestingPackageName).append(this.mNetworkKey == null ? none : this.mNetworkKey).append("MLO Information: ").append(", AP MLD Address: ").append(this.mApMldMacAddress == null ? none : this.mApMldMacAddress.toString()).append(", AP MLO Link Id: ").append(this.mApMldMacAddress == null ? none : Integer.valueOf(this.mApMloLinkId)).append(", AP MLO Affiliated links: ").append(this.mApMldMacAddress == null ? none : this.mAffiliatedMloLinks);
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private boolean shouldRedactLocationSensitiveFields(long redactions) {
        return (redactions & 1L) != 0L;
    }

    private boolean shouldRedactLocalMacAddressFields(long redactions) {
        return (redactions & 2L) != 0L;
    }

    private boolean shouldRedactNetworkSettingsFields(long redactions) {
        return (redactions & 4L) != 0L;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNetworkId);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mLinkSpeed);
        dest.writeInt(this.mTxLinkSpeed);
        dest.writeInt(this.mRxLinkSpeed);
        dest.writeInt(this.mFrequency);
        if (this.mIpAddress != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mIpAddress.getAddress());
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mWifiSsid != null) {
            dest.writeInt(1);
            this.mWifiSsid.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.mBSSID);
        dest.writeString(this.mMacAddress);
        dest.writeInt(this.mMeteredHint ? 1 : 0);
        dest.writeInt(this.mEphemeral ? 1 : 0);
        dest.writeInt(this.mTrusted ? 1 : 0);
        dest.writeInt(this.mOemPaid ? 1 : 0);
        dest.writeInt(this.mOemPrivate ? 1 : 0);
        dest.writeInt(this.mCarrierMerged ? 1 : 0);
        dest.writeInt(this.score);
        dest.writeBoolean(this.mIsUsable);
        dest.writeLong(this.txSuccess);
        dest.writeDouble(this.mSuccessfulTxPacketsPerSecond);
        dest.writeLong(this.txRetries);
        dest.writeDouble(this.mTxRetriedTxPacketsPerSecond);
        dest.writeLong(this.txBad);
        dest.writeDouble(this.mLostTxPacketsPerSecond);
        dest.writeLong(this.rxSuccess);
        dest.writeDouble(this.mSuccessfulRxPacketsPerSecond);
        this.mSupplicantState.writeToParcel(dest, flags);
        dest.writeInt(this.mOsuAp ? 1 : 0);
        dest.writeString(this.mRequestingPackageName);
        dest.writeString(this.mFqdn);
        dest.writeString(this.mProviderFriendlyName);
        dest.writeInt(this.mWifiStandard);
        dest.writeInt(this.mMaxSupportedTxLinkSpeed);
        dest.writeInt(this.mMaxSupportedRxLinkSpeed);
        dest.writeString(this.mPasspointUniqueId);
        dest.writeInt(this.mSubscriptionId);
        dest.writeTypedList(this.mInformationElements);
        if (SdkLevel.isAtLeastS()) {
            dest.writeInt(this.mIsPrimary);
        }
        dest.writeInt(this.mSecurityType);
        dest.writeInt(this.mRestricted ? 1 : 0);
        dest.writeString(this.mNetworkKey);
        dest.writeParcelable(this.mApMldMacAddress, flags);
        dest.writeInt(this.mApMloLinkId);
        dest.writeTypedList(this.mAffiliatedMloLinks);
    }

    public void setPasspointUniqueId(String passpointUniqueId) {
        this.mPasspointUniqueId = passpointUniqueId;
    }

    public String getPasspointUniqueId() {
        return this.mPasspointUniqueId;
    }

    public void setInformationElements(List<ScanResult.InformationElement> infoElements) {
        if (infoElements == null) {
            this.mInformationElements = null;
            return;
        }
        this.mInformationElements = new ArrayList<ScanResult.InformationElement>(infoElements);
    }

    public List<ScanResult.InformationElement> getInformationElements() {
        if (this.mInformationElements == null) {
            return null;
        }
        return new ArrayList<ScanResult.InformationElement>(this.mInformationElements);
    }

    public void setIsPrimary(boolean isPrimary) {
        this.mIsPrimary = isPrimary ? 1 : 0;
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public boolean isPrimary() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        if (this.mIsPrimary == -1) {
            throw new SecurityException("Not allowed to access this field");
        }
        return this.mIsPrimary == 1;
    }

    private List<MloLink> getSortedMloLinkList(List<MloLink> list) {
        ArrayList<MloLink> newList = new ArrayList<MloLink>(list);
        Collections.sort(newList, new Comparator<MloLink>(){

            @Override
            public int compare(MloLink lhs, MloLink rhs) {
                return lhs.getLinkId() - rhs.getLinkId();
            }
        });
        return newList;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!SdkLevel.isAtLeastS()) {
            return false;
        }
        if (!(that instanceof WifiInfo)) {
            return false;
        }
        WifiInfo thatWifiInfo = (WifiInfo)that;
        if (!Objects.equals(this.getSortedMloLinkList(this.mAffiliatedMloLinks), this.getSortedMloLinkList(thatWifiInfo.mAffiliatedMloLinks))) {
            return false;
        }
        return Objects.equals(this.mWifiSsid, thatWifiInfo.mWifiSsid) && Objects.equals(this.mBSSID, thatWifiInfo.mBSSID) && Objects.equals(this.mApMldMacAddress, thatWifiInfo.mApMldMacAddress) && this.mApMloLinkId == thatWifiInfo.mApMloLinkId && Objects.equals(this.mNetworkId, thatWifiInfo.mNetworkId) && Objects.equals(this.mRssi, thatWifiInfo.mRssi) && Objects.equals(this.mSupplicantState, thatWifiInfo.mSupplicantState) && Objects.equals(this.mLinkSpeed, thatWifiInfo.mLinkSpeed) && Objects.equals(this.mTxLinkSpeed, thatWifiInfo.mTxLinkSpeed) && Objects.equals(this.mRxLinkSpeed, thatWifiInfo.mRxLinkSpeed) && Objects.equals(this.mFrequency, thatWifiInfo.mFrequency) && Objects.equals(this.mIpAddress, thatWifiInfo.mIpAddress) && Objects.equals(this.mMacAddress, thatWifiInfo.mMacAddress) && Objects.equals(this.mMeteredHint, thatWifiInfo.mMeteredHint) && Objects.equals(this.mEphemeral, thatWifiInfo.mEphemeral) && Objects.equals(this.mTrusted, thatWifiInfo.mTrusted) && Objects.equals(this.mOemPaid, thatWifiInfo.mOemPaid) && Objects.equals(this.mOemPrivate, thatWifiInfo.mOemPrivate) && Objects.equals(this.mCarrierMerged, thatWifiInfo.mCarrierMerged) && Objects.equals(this.mRequestingPackageName, thatWifiInfo.mRequestingPackageName) && Objects.equals(this.mOsuAp, thatWifiInfo.mOsuAp) && Objects.equals(this.mFqdn, thatWifiInfo.mFqdn) && Objects.equals(this.mProviderFriendlyName, thatWifiInfo.mProviderFriendlyName) && Objects.equals(this.mSubscriptionId, thatWifiInfo.mSubscriptionId) && Objects.equals(this.txBad, thatWifiInfo.txBad) && Objects.equals(this.txRetries, thatWifiInfo.txRetries) && Objects.equals(this.txSuccess, thatWifiInfo.txSuccess) && Objects.equals(this.rxSuccess, thatWifiInfo.rxSuccess) && Objects.equals(this.mLostTxPacketsPerSecond, thatWifiInfo.mLostTxPacketsPerSecond) && Objects.equals(this.mTxRetriedTxPacketsPerSecond, thatWifiInfo.mTxRetriedTxPacketsPerSecond) && Objects.equals(this.mSuccessfulTxPacketsPerSecond, thatWifiInfo.mSuccessfulTxPacketsPerSecond) && Objects.equals(this.mSuccessfulRxPacketsPerSecond, thatWifiInfo.mSuccessfulRxPacketsPerSecond) && Objects.equals(this.score, thatWifiInfo.score) && Objects.equals(this.mIsUsable, thatWifiInfo.mIsUsable) && Objects.equals(this.mWifiStandard, thatWifiInfo.mWifiStandard) && Objects.equals(this.mMaxSupportedTxLinkSpeed, thatWifiInfo.mMaxSupportedTxLinkSpeed) && Objects.equals(this.mMaxSupportedRxLinkSpeed, thatWifiInfo.mMaxSupportedRxLinkSpeed) && Objects.equals(this.mPasspointUniqueId, thatWifiInfo.mPasspointUniqueId) && Objects.equals(this.mInformationElements, thatWifiInfo.mInformationElements) && this.mIsPrimary == thatWifiInfo.mIsPrimary && this.mSecurityType == thatWifiInfo.mSecurityType && this.mRestricted == thatWifiInfo.mRestricted && Objects.equals(this.mNetworkKey, thatWifiInfo.mNetworkKey);
    }

    public int hashCode() {
        if (!SdkLevel.isAtLeastS()) {
            return System.identityHashCode(this);
        }
        return Objects.hash(this.mWifiSsid, this.mBSSID, this.mApMldMacAddress, this.mApMloLinkId, this.mAffiliatedMloLinks, this.mNetworkId, this.mRssi, this.mSupplicantState, this.mLinkSpeed, this.mTxLinkSpeed, this.mRxLinkSpeed, this.mFrequency, this.mIpAddress, this.mMacAddress, this.mMeteredHint, this.mEphemeral, this.mTrusted, this.mOemPaid, this.mOemPrivate, this.mCarrierMerged, this.mRequestingPackageName, this.mOsuAp, this.mFqdn, this.mProviderFriendlyName, this.mSubscriptionId, this.txBad, this.txRetries, this.txSuccess, this.rxSuccess, this.mLostTxPacketsPerSecond, this.mTxRetriedTxPacketsPerSecond, this.mSuccessfulTxPacketsPerSecond, this.mSuccessfulRxPacketsPerSecond, this.score, this.mIsUsable, this.mWifiStandard, this.mMaxSupportedTxLinkSpeed, this.mMaxSupportedRxLinkSpeed, this.mPasspointUniqueId, this.mInformationElements, this.mIsPrimary, this.mSecurityType, this.mRestricted, this.mNetworkKey);
    }

    @Override
    public WifiInfo makeCopy(long redactions) {
        return new WifiInfo(this, redactions);
    }

    @Override
    public long getApplicableRedactions() {
        return 7L;
    }

    public void setCurrentSecurityType(int securityType) {
        this.mSecurityType = WifiInfo.convertWifiConfigurationSecurityType(securityType);
    }

    public void clearCurrentSecurityType() {
        this.mSecurityType = -1;
    }

    public int getCurrentSecurityType() {
        return this.mSecurityType;
    }

    public static int convertWifiConfigurationSecurityType(int wifiConfigSecurity) {
        switch (wifiConfigSecurity) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 5: {
                return 5;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
        }
        return -1;
    }

    public static int convertSecurityTypeToDpmWifiSecurity(int securityType) {
        switch (securityType) {
            case 0: 
            case 6: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                return 1;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return -1;
    }

    public void setNetworkKey(String currentNetworkKey) {
        this.mNetworkKey = currentNetworkKey;
    }

    @SystemApi
    public String getNetworkKey() {
        return this.mNetworkKey;
    }

    static {
        stateMap.put(SupplicantState.DISCONNECTED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INTERFACE_DISABLED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INACTIVE, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.SCANNING, NetworkInfo.DetailedState.SCANNING);
        stateMap.put(SupplicantState.AUTHENTICATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATED, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.FOUR_WAY_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.GROUP_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.COMPLETED, NetworkInfo.DetailedState.OBTAINING_IPADDR);
        stateMap.put(SupplicantState.DORMANT, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.UNINITIALIZED, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.INVALID, NetworkInfo.DetailedState.FAILED);
        CREATOR = new Parcelable.Creator<WifiInfo>(){

            @Override
            public WifiInfo createFromParcel(Parcel in) {
                WifiInfo info = new WifiInfo();
                info.setNetworkId(in.readInt());
                info.setRssi(in.readInt());
                info.setLinkSpeed(in.readInt());
                info.setTxLinkSpeedMbps(in.readInt());
                info.setRxLinkSpeedMbps(in.readInt());
                info.setFrequency(in.readInt());
                if (in.readByte() == 1) {
                    try {
                        info.setInetAddress(InetAddress.getByAddress(in.createByteArray()));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                if (in.readInt() == 1) {
                    info.mWifiSsid = WifiSsid.CREATOR.createFromParcel(in);
                }
                info.mBSSID = in.readString();
                info.mMacAddress = in.readString();
                info.mMeteredHint = in.readInt() != 0;
                info.mEphemeral = in.readInt() != 0;
                info.mTrusted = in.readInt() != 0;
                info.mOemPaid = in.readInt() != 0;
                info.mOemPrivate = in.readInt() != 0;
                info.mCarrierMerged = in.readInt() != 0;
                info.score = in.readInt();
                info.mIsUsable = in.readBoolean();
                info.txSuccess = in.readLong();
                info.mSuccessfulTxPacketsPerSecond = in.readDouble();
                info.txRetries = in.readLong();
                info.mTxRetriedTxPacketsPerSecond = in.readDouble();
                info.txBad = in.readLong();
                info.mLostTxPacketsPerSecond = in.readDouble();
                info.rxSuccess = in.readLong();
                info.mSuccessfulRxPacketsPerSecond = in.readDouble();
                info.mSupplicantState = SupplicantState.CREATOR.createFromParcel(in);
                info.mOsuAp = in.readInt() != 0;
                info.mRequestingPackageName = in.readString();
                info.mFqdn = in.readString();
                info.mProviderFriendlyName = in.readString();
                info.mWifiStandard = in.readInt();
                info.mMaxSupportedTxLinkSpeed = in.readInt();
                info.mMaxSupportedRxLinkSpeed = in.readInt();
                info.mPasspointUniqueId = in.readString();
                info.mSubscriptionId = in.readInt();
                info.mInformationElements = in.createTypedArrayList(ScanResult.InformationElement.CREATOR);
                if (SdkLevel.isAtLeastS()) {
                    info.mIsPrimary = in.readInt();
                }
                info.mSecurityType = in.readInt();
                info.mRestricted = in.readInt() != 0;
                info.mNetworkKey = in.readString();
                info.mApMldMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
                info.mApMloLinkId = in.readInt();
                info.mAffiliatedMloLinks = in.createTypedArrayList(MloLink.CREATOR);
                return info;
            }

            public WifiInfo[] newArray(int size) {
                return new WifiInfo[size];
            }
        };
    }

    public static class Builder {
        private final WifiInfo mWifiInfo = new WifiInfo();

        public Builder setSsid(byte[] ssid) {
            this.mWifiInfo.setSSID(WifiSsid.fromBytes(ssid));
            return this;
        }

        public Builder setBssid(String bssid) {
            this.mWifiInfo.setBSSID(bssid);
            return this;
        }

        public Builder setApMldMacAddress(MacAddress address) {
            this.mWifiInfo.setApMldMacAddress(address);
            return this;
        }

        public Builder setApMloLinkId(int linkId) {
            this.mWifiInfo.setApMloLinkId(linkId);
            return this;
        }

        public Builder setAffiliatedMloLinks(List<MloLink> links) {
            this.mWifiInfo.setAffiliatedMloLinks(links);
            return this;
        }

        public Builder setRssi(int rssi) {
            this.mWifiInfo.setRssi(rssi);
            return this;
        }

        public Builder setNetworkId(int networkId) {
            this.mWifiInfo.setNetworkId(networkId);
            return this;
        }

        public Builder setCurrentSecurityType(int securityType) {
            this.mWifiInfo.setCurrentSecurityType(securityType);
            return this;
        }

        public WifiInfo build() {
            return new WifiInfo(this.mWifiInfo);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IsPrimaryValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityType {
    }
}

