/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class AwareParams
implements Parcelable {
    public static final int UNSET_PARAMETER = -1;
    private int mDw24Ghz = -1;
    private int mDw5Ghz = -1;
    private int mDw6Ghz = -1;
    private int mDiscoveryBeaconIntervalMs = -1;
    private int mNumSpatialStreamsInDiscovery = -1;
    private boolean mIsDwEarlyTerminationEnabled = false;
    private int mMacRandomIntervalSec = -1;
    public static final Parcelable.Creator<AwareParams> CREATOR = new Parcelable.Creator<AwareParams>(){

        @Override
        public AwareParams createFromParcel(Parcel in) {
            return new AwareParams(in);
        }

        public AwareParams[] newArray(int size) {
            return new AwareParams[size];
        }
    };

    public AwareParams() {
    }

    private AwareParams(Parcel in) {
        this.mDw24Ghz = in.readInt();
        this.mDw5Ghz = in.readInt();
        this.mDw6Ghz = in.readInt();
        this.mDiscoveryBeaconIntervalMs = in.readInt();
        this.mNumSpatialStreamsInDiscovery = in.readInt();
        this.mIsDwEarlyTerminationEnabled = in.readBoolean();
        this.mMacRandomIntervalSec = in.readInt();
    }

    public void setDiscoveryWindowWakeInterval24Ghz(int dw) {
        if (dw > 5 || dw < 1) {
            throw new IllegalArgumentException("DW value for 2.4Ghz must be 1 to 5");
        }
        this.mDw24Ghz = dw;
    }

    public void setDiscoveryWindowWakeInterval5Ghz(int dw) {
        if (dw > 5 || dw < 0) {
            throw new IllegalArgumentException("DW value for 5Ghz must be 0 to 5");
        }
        this.mDw5Ghz = dw;
    }

    public void setDiscoveryWindow6Ghz(int dw) {
        this.mDw6Ghz = dw;
    }

    public void setDiscoveryBeaconIntervalMillis(int intervalInMs) {
        if (intervalInMs < 1) {
            throw new IllegalArgumentException("Discovery Beacon interval must >= 1");
        }
        this.mDiscoveryBeaconIntervalMs = intervalInMs;
    }

    public void setNumSpatialStreamsInDiscovery(int spatialStreamsNum) {
        if (spatialStreamsNum < 1) {
            throw new IllegalArgumentException("Number Spatial streams must >= 1");
        }
        this.mNumSpatialStreamsInDiscovery = spatialStreamsNum;
    }

    public void setMacRandomizationIntervalSeconds(int intervalSec) {
        if (intervalSec > 1800 || intervalSec < 1) {
            throw new IllegalArgumentException("Mac Randomization Interval must be between 1 to 1800 seconds");
        }
        this.mMacRandomIntervalSec = intervalSec;
    }

    public void setDwEarlyTerminationEnabled(boolean enable) {
        this.mIsDwEarlyTerminationEnabled = enable;
    }

    public int getDiscoveryWindowWakeInterval24Ghz() {
        return this.mDw24Ghz;
    }

    public int getDiscoveryWindowWakeInterval5Ghz() {
        return this.mDw5Ghz;
    }

    public int getDiscoveryWindowWakeInterval6Ghz() {
        return this.mDw24Ghz;
    }

    public int getDiscoveryBeaconIntervalMillis() {
        return this.mDiscoveryBeaconIntervalMs;
    }

    public int getNumSpatialStreamsInDiscovery() {
        return this.mNumSpatialStreamsInDiscovery;
    }

    public boolean isDwEarlyTerminationEnabled() {
        return this.mIsDwEarlyTerminationEnabled;
    }

    public int getMacRandomizationIntervalSeconds() {
        return this.mMacRandomIntervalSec;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDw24Ghz);
        dest.writeInt(this.mDw5Ghz);
        dest.writeInt(this.mDw6Ghz);
        dest.writeInt(this.mDiscoveryBeaconIntervalMs);
        dest.writeInt(this.mNumSpatialStreamsInDiscovery);
        dest.writeBoolean(this.mIsDwEarlyTerminationEnabled);
        dest.writeInt(this.mMacRandomIntervalSec);
    }

    public String toString() {
        StringBuffer sbf = new StringBuffer();
        sbf.append("AwareParams [").append("mDw24Ghz=").append(this.mDw24Ghz).append(", mDw5Ghz=").append(this.mDw5Ghz).append(", mDw6Ghz=").append(this.mDw6Ghz).append(", mDiscoveryBeaconIntervalMs=").append(this.mDiscoveryBeaconIntervalMs).append(", mNumSpatialStreamsInDiscovery=").append(this.mNumSpatialStreamsInDiscovery).append(", mIsDwEarlyTerminationEnabled=").append(this.mIsDwEarlyTerminationEnabled).append(", mMacRandomIntervalSec=").append(this.mMacRandomIntervalSec).append("]");
        return sbf.toString();
    }
}

