/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiAwareEventCallback
extends IInterface {
    public void onConnectSuccess(int var1) throws RemoteException;

    public void onConnectFail(int var1) throws RemoteException;

    public void onIdentityChanged(byte[] var1) throws RemoteException;

    public void onAttachTerminate() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiAwareEventCallback {
        public static final String DESCRIPTOR = "android.net.wifi.aware.IWifiAwareEventCallback";
        static final int TRANSACTION_onConnectSuccess = 1;
        static final int TRANSACTION_onConnectFail = 2;
        static final int TRANSACTION_onIdentityChanged = 3;
        static final int TRANSACTION_onAttachTerminate = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiAwareEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiAwareEventCallback) {
                return (IWifiAwareEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    this.onConnectSuccess(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.onConnectFail(_arg0);
                    break;
                }
                case 3: {
                    byte[] _arg0 = data.createByteArray();
                    this.onIdentityChanged(_arg0);
                    break;
                }
                case 4: {
                    this.onAttachTerminate();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IWifiAwareEventCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectSuccess(int clientId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectFail(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIdentityChanged(byte[] mac) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(mac);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAttachTerminate() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiAwareEventCallback {
        @Override
        public void onConnectSuccess(int clientId) throws RemoteException {
        }

        @Override
        public void onConnectFail(int reason) throws RemoteException {
        }

        @Override
        public void onIdentityChanged(byte[] mac) throws RemoteException {
        }

        @Override
        public void onAttachTerminate() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

