/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IIncidentDumpCallback;
import android.os.IIncidentReportStatusListener;
import android.os.IInterface;
import android.os.IncidentManager;
import android.os.IncidentReportArgs;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.List;

public interface IIncidentManager
extends IInterface {
    public void reportIncident(IncidentReportArgs var1) throws RemoteException;

    public void reportIncidentToStream(IncidentReportArgs var1, IIncidentReportStatusListener var2, FileDescriptor var3) throws RemoteException;

    public void reportIncidentToDumpstate(FileDescriptor var1, IIncidentReportStatusListener var2) throws RemoteException;

    public void registerSection(int var1, String var2, IIncidentDumpCallback var3) throws RemoteException;

    public void unregisterSection(int var1) throws RemoteException;

    public void systemRunning() throws RemoteException;

    public List<String> getIncidentReportList(String var1, String var2) throws RemoteException;

    public IncidentManager.IncidentReport getIncidentReport(String var1, String var2, String var3) throws RemoteException;

    public void deleteIncidentReports(String var1, String var2, String var3) throws RemoteException;

    public void deleteAllIncidentReports(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIncidentManager {
        public static final String DESCRIPTOR = "android.os.IIncidentManager";
        static final int TRANSACTION_reportIncident = 1;
        static final int TRANSACTION_reportIncidentToStream = 2;
        static final int TRANSACTION_reportIncidentToDumpstate = 3;
        static final int TRANSACTION_registerSection = 4;
        static final int TRANSACTION_unregisterSection = 5;
        static final int TRANSACTION_systemRunning = 6;
        static final int TRANSACTION_getIncidentReportList = 7;
        static final int TRANSACTION_getIncidentReport = 8;
        static final int TRANSACTION_deleteIncidentReports = 9;
        static final int TRANSACTION_deleteAllIncidentReports = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIncidentManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IIncidentManager) {
                return (IIncidentManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "reportIncident";
                }
                case 2: {
                    return "reportIncidentToStream";
                }
                case 3: {
                    return "reportIncidentToDumpstate";
                }
                case 4: {
                    return "registerSection";
                }
                case 5: {
                    return "unregisterSection";
                }
                case 6: {
                    return "systemRunning";
                }
                case 7: {
                    return "getIncidentReportList";
                }
                case 8: {
                    return "getIncidentReport";
                }
                case 9: {
                    return "deleteIncidentReports";
                }
                case 10: {
                    return "deleteAllIncidentReports";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IncidentReportArgs _arg0 = data.readTypedObject(IncidentReportArgs.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportIncident(_arg0);
                    break;
                }
                case 2: {
                    IncidentReportArgs _arg0 = data.readTypedObject(IncidentReportArgs.CREATOR);
                    IIncidentReportStatusListener _arg1 = IIncidentReportStatusListener.Stub.asInterface(data.readStrongBinder());
                    FileDescriptor _arg2 = data.readRawFileDescriptor();
                    data.enforceNoDataAvail();
                    this.reportIncidentToStream(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    FileDescriptor _arg0 = data.readRawFileDescriptor();
                    IIncidentReportStatusListener _arg1 = IIncidentReportStatusListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.reportIncidentToDumpstate(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IIncidentDumpCallback _arg2 = IIncidentDumpCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSection(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterSection(_arg0);
                    break;
                }
                case 6: {
                    this.systemRunning();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getIncidentReportList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    IncidentManager.IncidentReport _result = this.getIncidentReport(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteIncidentReports(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteAllIncidentReports(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IIncidentManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportIncident(IncidentReportArgs args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(args, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportIncidentToStream(IncidentReportArgs args, IIncidentReportStatusListener listener, FileDescriptor stream) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(args, 0);
                    _data.writeStrongInterface(listener);
                    _data.writeRawFileDescriptor(stream);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportIncidentToDumpstate(FileDescriptor stream, IIncidentReportStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeRawFileDescriptor(stream);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSection(int id2, String name, IIncidentDumpCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeString(name);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSection(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void systemRunning() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getIncidentReportList(String pkg, String cls) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(cls);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IncidentManager.IncidentReport getIncidentReport(String pkg, String cls, String id2) throws RemoteException {
                IncidentManager.IncidentReport _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(cls);
                    _data.writeString(id2);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IncidentManager.IncidentReport.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteIncidentReports(String pkg, String cls, String id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(cls);
                    _data.writeString(id2);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteAllIncidentReports(String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IIncidentManager {
        @Override
        public void reportIncident(IncidentReportArgs args) throws RemoteException {
        }

        @Override
        public void reportIncidentToStream(IncidentReportArgs args, IIncidentReportStatusListener listener, FileDescriptor stream) throws RemoteException {
        }

        @Override
        public void reportIncidentToDumpstate(FileDescriptor stream, IIncidentReportStatusListener listener) throws RemoteException {
        }

        @Override
        public void registerSection(int id2, String name, IIncidentDumpCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterSection(int id2) throws RemoteException {
        }

        @Override
        public void systemRunning() throws RemoteException {
        }

        @Override
        public List<String> getIncidentReportList(String pkg, String cls) throws RemoteException {
            return null;
        }

        @Override
        public IncidentManager.IncidentReport getIncidentReport(String pkg, String cls, String id2) throws RemoteException {
            return null;
        }

        @Override
        public void deleteIncidentReports(String pkg, String cls, String id2) throws RemoteException {
        }

        @Override
        public void deleteAllIncidentReports(String pkg) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

